# encoding: utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals
import re
import sys
import threading
from urllib.request import quote, unquote
import json

try:
    import Queue
except:

    from queue import Queue

from ..extractor.common import InfoExtractor
from ..utils import (
    urlencode_postdata,
    sanitized_Request,
    update_url_query,
    smuggle_url,
    unsmuggle_url
)
from ..compat import (
    compat_urllib_parse_urlparse,
    compat_b64decode,
    compat_parse_qs
)
from ..utilsEX import JSInterpreter, downloadWebPage_BYHeadlessBrowser_withJS, downloadWebPage_BYHeadlessBrowser, \
    downloadWebPage_BYHeadlessBrowser_localFile

class TlcIE(InfoExtractor):
    _VALID_URL = r'https?://(?:.+\.)?tlc\.com/'

    def _real_extract(self, url):
        print('SockShare begin')
        url_parma = ''
        webpage = self._download_webpage(url, 'embVideo_url')
        title = self._search_regex(r'<title>(.+)</title>', webpage, '', fatal=False) or 'title'
        config_json_str = self._search_regex(r'<script id="__EOS_DATA__" type="application/json">(.*?)</script>',webpage,'embed_video')
        config_json = json.loads(config_json_str)
        for obj in config_json["layout"]["__raw__"]["contentBlocks"]:
            if obj["type"]=='video' and obj["displayType"] == 'VideoPlayer':
                itemlist = obj['content']['items'];
                break;
        if itemlist:
            for item in itemlist:
                if item['isPlayable']:
                    linkList = item['links']
        if linkList:
            for link in linkList:
                if link['rel']=='ssdai_TLC':
                    url_parma = link['href']
        # https://api.discovery.com/v1/streaming/video/5dfc00e2f5b0ee76336c63c5?
        # adCustomerId={adCustomerId}&
        # adNetworkId={adNetworkId}&
        # adProfile={adProfile}&
        # adCsid={adCsid}&
        # adCaid={adCaid}{&adKeyValues}{&hlsVersion}{&adSssb}{&suspendBeaconing}{&sendPingf}
        # &product=tlc
        pass
        adCustomerId = config_json['application']['namedResources']['settings']['entries']['freewheel']['adCustomerId']
        adNetworkId = config_json['application']['namedResources']['settings']['entries']['freewheel']['adNetworkId']
        adProfile = config_json['application']['namedResources']['settings']['entries']['freewheel']['adProfile']
        adCsid = config_json['application']['namedResources']['settings']['entries']['freewheel']['adCsid'].replace('{type}','desktop/ondemand')

        m3u8json_url = url_parma.replace('{adCustomerId}',adCustomerId).replace('{adNetworkId}',adNetworkId).replace('{adProfile}',adProfile).replace('{adCsid}',adCsid).replace('adCaid={adCaid}{&adKeyValues}{&hlsVersion}{&adSssb}{&suspendBeaconing}{&sendPingf}','')
        # 从cookies获取 authorization
        authjson = self._get_cookies('https://www.tlc.com/').get('eosAn')
        if authjson:
            str = authjson.value
            authorization = json.loads(unquote(unquote(str)))
            headers = {"authorization": "Bearer " + authorization["access_token"]}

        webpage = self._download_webpage(m3u8json_url,'embVideo_url',headers= headers)
        m3u8_url_json = json.loads(webpage)
        m3u8url = m3u8_url_json['streamUrl']
        #获取M3u8列表
        # webpage = self._download_webpage(m3u8url, 'embVideo_url', headers=headers)
        m3u8list = self._extract_m3u8_formats_header(m3u8url,'embVideo_url', headers=headers)
        if len(m3u8list) >0:
            m3u8list.sort(key=lambda x: x['width'] * x['height'], reverse=True)
            real_m3u8url = m3u8list[0]

        return {
            'id': 'id',
            'formats': m3u8list,
            'title': title
        }

    def _extract_m3u8_formats_header(self, m3u8_url, video_id, ext=None,
                              entry_protocol='m3u8',headers={}, preference=None,
                              m3u8_id=None, note=None, errnote=None,
                              fatal=True, live=False):
        if len(headers) > 0:
            res = self._download_webpage_handle(
                m3u8_url, video_id,
                note=note or 'Downloading m3u8 information',
                errnote=errnote or 'Failed to download m3u8 information',
                fatal=fatal,headers=headers)

        if res is False:
            return []

        m3u8_doc, urlh = res
        m3u8_url = urlh.geturl()

        return self._parse_m3u8_formats(
            m3u8_doc, m3u8_url, ext=ext, entry_protocol=entry_protocol,
            preference=preference, m3u8_id=m3u8_id, live=live)