# coding: utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals

import re
import json
from ..extractor.common import InfoExtractor
from ..utils import (
    ExtractorError,
    int_or_none,
)


class usplIE(InfoExtractor):
    IE_NAME = 'eaulas.usp'
    _VALID_URL = r'https?://eaulas\.usp\.br.+idItem\=(?P<id>\d+)'

    def _real_extract(self, url):
        video_id = self._match_id(url)
        webpage = self._download_webpage(url, url)
        video_url = self._search_regex(r'url: \'([^\']+)', webpage, 'video_url')
        title = self._html_search_meta('og:title', webpage)
        thumbail = self._html_search_meta('og:image', webpage)
        
        return {
            '_type': 'video',
            'id': video_id,
            'title': title,
            'url': video_url,
            'thumbnail': thumbail
        }
