# coding: utf-8
#***********copyright********************
#*The source codes are sole and exclusive property of Wondershare.
#*The source codes are confidential information of Wondershare.
#*Unauthorised access, disclosure, use or copying of the source codes is strictly prohibited and may be #unlawful.
#************confidential*******************
from __future__ import unicode_literals
import binascii
from ..compat import (
    compat_cookies,
    compat_b64decode
)
import re
from ..aes import aes_cbc_decrypt

from ..utils import (
    sanitized_Request,
    bytes_to_intlist,
    intlist_to_bytes
)

from ..extractor.viki import (
    VikiIE as OldVikeIE,
    VikiChannelIE as OldVikiChannelIE,
)

def hex_to_bytes(hex):
    return binascii.a2b_hex(hex.encode('ascii'))

def decryptURL(txt, key, iv):
    try:
        a = hex_to_bytes(txt)
        decrypted_data = aes_cbc_decrypt(
            bytes_to_intlist(a), 
            bytes_to_intlist(key), 
            bytes_to_intlist(iv)
        )
        decrypted_data = intlist_to_bytes(decrypted_data).decode('ascii')
        decrypted_data = re.search(r'(.+sig=.{40})', decrypted_data).group(1)
        return decrypted_data
    except:
        decrypted_data = compat_b64decode(txt).decode('utf-8')
        return decrypted_data


class VikiIE(OldVikeIE):
    def _real_extract_Ex(self, url):
        api_url = 'https://www.viki.com/api/videos/%s' % self.video_id
        jsondata = self._download_json(api_url, '', headers={'accept': 'application/json, text/plain, */*',  'x-viki-app-ver': '4.0.57'})      
        key = jsondata.get('chabi', None)
        ecta = jsondata.get('ecta', None)
        formats = []
        for stream in jsondata['streams'].items():
            if stream:
                try:
                    encryURL = self._search_regex(r'e-stream-url\?stream=(.+)?', stream[1]['url'], '', fatal = False)
                    manifest_url = decryptURL(encryURL, key, ecta)
                    if stream[0] == 'hls':
                        formats.extend(self._extract_m3u8_formats(manifest_url, ''))
                    if stream[0] == 'dash':
                        formats.extend(self._extract_mpd_formats(manifest_url, ''))
                except:
                    pass

        subtitles = {}
        try:
            for item in (jsondata['streamSubtitles'].get('hls') or jsondata['streamSubtitles'].get('dash')):
                subtitles[item['srclang']] = [{
                    'ext': 'vtt' if item['src'].find('.vtt')>-1 else 'srt',
                    'url': item['src'],
                }]                
        except:
            pass
        return formats, subtitles     

    def _real_extract(self, url):    
        url = url.replace('http://', 'https://')    
        webpage = self._download_webpage(url, '')
        
        title = self._search_regex(r'"metadata":{"title":"([^"]+)?', webpage, '', fatal = False, default=None)
        if not title:
            title = self._html_search_regex(r'<title>(.+)</title>', webpage, '', fatal = False)
        self.video_id = self._match_id(url)     
        result = {}
        try:                            
            result = super(VikiIE, self)._real_extract(url)
            try:
                formats, subtitles = self._real_extract_Ex(url)    
                result['formats'].extend(formats)
            except:
                pass        
        except:
            formats, subtitles = self._real_extract_Ex(url)
            result = {
                'id': self.video_id,
                'title': title,
                'formats': formats,
                'subtitles': subtitles
            }   

        return result

    def _real_extract2(self, url):        
        
        self._extract_mpd_formats()

class VikiChannelIE(OldVikiChannelIE):
    def _real_extract(self, url):
        webpage = self._download_webpage(url, url)
        self._token = self._search_regex(r'session\.user_token\s*=\s*"([^"]+)', webpage, 'token', fatal=False)
        result = super(VikiChannelIE, self)._real_extract(url)        
        return result        