# -*- coding: utf-8 -*-
import sys
import os
import io
import re
import uuid
import time
import json
import random
import base64
import tempfile
import websocket
import urllib.request
from urllib.parse import *

import shutil
import subprocess
import threading
import traceback
from datetime import datetime

from .common import FileDownloader

from ..compat import compat_urlretrieve

from functools import partial


import re

mime_audio_types  = {
    "audio/mp4": "m4a",
    "audio/mpeg": "mp3",
    "audio/ogg": "ogg",
    "audio/vorbis": "vorbis",
    "audio/vnd.rn-realaudio": "rm",
    "audio/vnd.wave": "wav",
    "audio/webm": "webm",
    "audio/x-flac": "flac",
}

mime_video_types  = {
    "video/mpeg": "mpg",
    "video/mp4": "mp4",
    "video/ogg": "ogg",
    "video/quicktime": "mov",
    "video/webm": "webm",
    "video/x-matroska": "mkv",
    "video/x-ms-wmv": "wmv",
    "video/x-flv": "flv",
}

mime_m3u8_types = {
    'application/vnd.apple.mpegurl': 'm3u8',
    'application/mpegurl': 'm3u8',
    'application/x-mpegurl': 'm3u8',
    'audio/mpegurl':'m3u8',
    'audio/x-mpegurl':'m3u8',
}

mime_mpd_type = {
'application/dash+xml':'mpd',
}

def num(s):
    try:
        return int(s)
    except ValueError:
        return float(s)

def popErrorHeaderInfo(response):
    if 'requestHeaders' in response:
        for key, value in response['requestHeaders'].items():
            if key.find(':') == 0:
                response['requestHeaders'].pop(key)

def isMediaLink(response):
    try:
        url = response['url']
        mimeType = response['headers'].get('Content-Type', response['headers'].get('content-type', '')).lower()
        referer = ''
        if 'requestHeaders' in response:
            referer = response['requestHeaders'].get('Referer', response['requestHeaders'].get('referer', ''))


            if referer.find('ads')>-1:
                return False

        if (mimeType in mime_video_types) or (mimeType in mime_audio_types) or mimeType == 'binary/octet-stream':
            #print('xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx %s' % response_headers)
            try:
                #facebook
                if re.search(r'fbcdn\.net/.+mp4', url) or referer.find('facebook.com')>-1:
                    #https://video-lga3-1.xx.fbcdn.net/v/t42.1790-2/21749040_1276898649104618_3947947042428420096_n.mp4?efg=eyJ2ZW5jb2RlX3RhZyI6ImRhc2hfdjNfMzgwX2NyZl8yOF9iYXNlbGluZV8zLjBfYTIwdm5jZDJfb3RwMl9mcmFnXzJfdmlkZW8ifQ%3D%3D&oh=afc497f72263f7a0eb59e9cc7973200e&oe=59BFA309&bytestart=13869&byteend=26106
                    mobj = re.search(r'(.+)\&bytestart', url)
                    popErrorHeaderInfo(response)
                    if mobj:
                        response['url'] = mobj.group(1)
                        return True
                    else:
                        return True

                if re.search(r'/camwhores/gen/www.camwhores.tv/', url):
                    return False


                contentLength = response['headers']['content-length'] if 'content-length' in response['headers'] else response['headers']['Content-Length']
                minSize = 1024 * 1024 * 2 if mimeType in mime_audio_types else 1024 * 1024 * 8
                if referer.find('thumbzilla.com') > -1:
                    minSize = 1 * 1024 * 1024
                response['ext'] = 'mp4'
                if num(contentLength) >= minSize:
                    if mimeType in mime_video_types:
                        response['ext'] = mime_video_types[mimeType]
                    elif mimeType in mime_audio_types:
                        response['ext'] = mime_audio_types[mimeType]
                    popErrorHeaderInfo(response)
                    return True
                else:
                    return False
            except Exception as e:
                print(e)
                return False
        elif (mimeType in mime_m3u8_types) or (mimeType in mime_mpd_type) or (mimeType in ['text/html'] and re.search('playlist\.m3u8', url)):
            popErrorHeaderInfo(response)
            #print ('------------------------------------------------m3u8------------------------------------------')
            return True
        elif re.search(r'vimeocdn.+/master\.json', url):
            response['url'] = url.replace('master.json', 'master.mpd')
            popErrorHeaderInfo(response)
            return True
        return False
    except:
        return False


def getStartInfo():
    IS_WIN32 = 'win32' in str(sys.platform).lower()
    if IS_WIN32:
        startupinfo = subprocess.STARTUPINFO()
        startupinfo.dwFlags = subprocess.CREATE_NEW_CONSOLE | subprocess.STARTF_USESHOWWINDOW
        SW_MAXIMIZE = 3
        startupinfo.wShowWindow = subprocess.SW_HIDE | SW_MAXIMIZE

        return startupinfo
    else:
        return None


class tempStoreServer:
    def __init__(self, port, path, task_finish):
        self._port = port
        self._path = path 
        self._httpd = None       
        self._task_finish = task_finish

    def start(self):

        from http.server import(
            BaseHTTPRequestHandler,
            HTTPServer
        )
        import cgi

        class PostHandler(BaseHTTPRequestHandler):
            protocol_version = "HTTP/1.0"

            def __init__(self, *args, directory, task_finish, **kwargs):
                self._path = directory
                self._task_finish = task_finish
                super().__init__(*args, **kwargs)

            _task_finish = None
            def do_OPTIONS(self):
                self.send_response(200, "ok")
                self.send_header('Access-Control-Allow-Origin', '*')
                self.send_header('Access-Control-Allow-Methods', 'GET, POST, OPTIONS')
                self.send_header("Access-Control-Allow-Headers", "X-Requested-With")
                self.send_header("Access-Control-Allow-Headers", "Content-Type")
                self.end_headers()

            def do_POST(self):
                form = cgi.FieldStorage(
                    fp=self.rfile,
                    headers=self.headers,
                    environ={'REQUEST_METHOD':'POST',
                            'CONTENT_TYPE':self.headers['Content-Type'],
                            }
                )
                self.send_response(200)
                self.end_headers()
                self.wfile.write(b'OK')
                duration = form['duration']
                upload_file = form['file']
                #os.path.join(self._path, upload_file.filename)
                # with open(upload_file.filename,'wb') as f:
                with open(self._path,'wb') as f:                
                    f.write(upload_file.value)
                if self._task_finish:
                    self._task_finish(duration.value)
                return        

        server_address = ('127.0.0.1', self._port)
        
        PostHandler._task_finish = self._task_finish 
        self._httpd = HTTPServer(server_address, partial(PostHandler, directory =self._path, task_finish = self._task_finish))

        sa = self._httpd.socket.getsockname()
        print("Serving HTTP on", sa[0], "port", sa[1], "...")
        threading.Thread(target=lambda: self._httpd.serve_forever()).start()

    def stop(self):
        self._httpd.shutdown()


class chromeDownloader(FileDownloader):
    command_id = 0

    _capturedMediaLink = []
    _port = 8499
    _close = False

    def _initEnv(self):
        self.getProfile(self.target_url)

        self.chromeEXE = self.getChromeInstall()
        if not self.chromeEXE:
            raise Exception('not install Chrome')
        self.remote_debugging_port = str(random.randint(9222, 9222+5))
        self.remote_debugging_port='9227'
        print(self.remote_debugging_port)        
        basedir = os.path.join(tempfile.gettempdir(), self.remote_debugging_port)
        try:
            if os.path.exists(basedir):
                shutil.rmtree(basedir)
        except:
            pass
        self.extensionPath = os.path.join(basedir, 'extensionPath')
        try:
            os.makedirs(self.extensionPath)
        except Exception as ex:
            print(ex)
            pass
        self.user_data_dir = os.path.join(basedir, 'user_data_dir')
        self.loadJQuery()        


    def _run(self):
        try:
            response = self.head(self.target_url)
            response = {'url': self.target_url, 'headers':  response._headers}
            if isMediaLink(response):
                data = {'request.url': response['url'], 'request.headers': {}, 'response.headers': response._headers, 'resultID': self.resultID}
                self.post(data)
                return
        except:
            pass
        self.medias = []
        self._close = True
        t = threading.Thread(target=lambda: self.lanchChrome())
        t.start()
        t.join(20 if self._TestMode else 30)

        def click(x,y):
            _timeOut = False
            startTime = datetime.now()
            while not (self._close or _timeOut):
                time.sleep(1)
                _timeOut = (datetime.now() - startTime).seconds > 1 * 30
            if self._close:
                return
            for i in range(5):
                if self._close:
                    return
                print('-------------------------click----------------------')
                self.sendMouseMessage('mousePressed', x,y)
                self.sendMouseMessage('mouseReleased', x, y)
                time.sleep(10)
        if self.ClickArea:
            threading.Thread(target=lambda x, y: click(x,y), args=(self.ClickArea['x'], self.ClickArea['y'])).start()

        host = 'localhost'
        remoteHost = "http://%s:%s/json" % (host, self.remote_debugging_port)
        response = urllib.request.urlopen(remoteHost).read().decode()
        tablist = json.loads(response)
        self.debugging_url = tablist[0]['webSocketDebuggerUrl']
        self.mediaResponseList = []
        from websocket import create_connection
        ws = create_connection(self.debugging_url)

        self.ws = websocket.WebSocketApp(self.debugging_url, \
                                         on_message=self.on_message, \
                                         on_error=self.on_error, \
                                         on_close=self.on_close)
        self.ws.on_open = self.on_open
        self.ws.run_forever()  # start running this socket.        

    def real_download(self, filename, info_dict):
        self.fileSize = 1024*1024*100
        self.output_file = filename
        self.downloadedSize  = 0
        self.resultID = info_dict.get('resultID',0)
        self.autoPlay = info_dict.get('autoPlay', False)
        self.ClickArea = info_dict.get('autoPlay', False)

        self.target_url = info_dict['url']
        self._TestMode = info_dict.get('testMode', False)
        self.timeOut = info_dict.get('timeOut', 360)        
        self._initEnv()
        self._beforeRun()
        threading.Thread(target=lambda: self.simulation_progress()).start()
        self._run()
        self._afterRun()
        self._close = True
        return True

    def simulation_progress(self):
        self.start = time.time()
        count = 60 * 3
        for i in range(count):
            if self._close:
                break
            self.downloadedSize = int(i / count * self.fileSize)
            self.reprotProgress()
            time.sleep(1)


    def reprotProgress(self):
        now = time.time()
        self._hook_progress({
            'status': 'downloading',
            'downloaded_bytes': self.downloadedSize,
            'total_bytes': self.fileSize,
            'tmpfilename': '',
            'filename': self.output_file,
            'speed': self.calc_speed(self.start, now, self.downloadedSize),
            'elapsed': now - self.start,
        })

    @staticmethod
    def getChromeInstall():
        import winreg
        chromeUninstallKeys = [r'Software\Microsoft\Windows\CurrentVersion\Uninstall\Google Chrome', r'Software\WOW6432Node\Microsoft\Windows\CurrentVersion\Uninstall\Google Chrome']
        value = None
        for root in [winreg.HKEY_CURRENT_USER, winreg.HKEY_LOCAL_MACHINE]:
            try:
                for chromeUninstallKey in chromeUninstallKeys:
                    try:
                        key = winreg.OpenKey(root, chromeUninstallKey)
                        value, _ = winreg.QueryValueEx(key, 'InstallLocation')
                        if value and (value != ''):
                            value = os.path.join(value, 'chrome.exe')
                            break
                    except Exception as ex:
                        value = None
            except:
                pass

        if not value:
            PROGRAMDATA = os.getenv('PROGRAMDATA')
            superManChrome = os.path.join(PROGRAMDATA, r'SuperMan\Chrome\Chrome.exe')
            if os.path.exists(superManChrome):
                return superManChrome
        return value

    def getCookiePath(self):
        appdata = os.getenv('APPDATA')
        chromeDefaultPath = r'%s\..\Local\Google\Chrome\User Data\Default' % (appdata)
        cookie_file = '%s%s' % (chromeDefaultPath, '\cookies')
        if not os.path.isfile(cookie_file):
            appdata = os.getenv('USERPROFILE')
            chromeDefaultPath = r'%s\Local Settings\Application Data\Google\Chrome\User Data\Default' % (appdata)
            cookie_file = '%s%s' % (chromeDefaultPath, '\cookies')
        return cookie_file

    def num(self, s):
        try:
            return int(s)
        except ValueError:
            return float(s)

    def post(self, data):
        url = 'http://127.0.0.1:8499/response'
        req = urllib2.Request(url)
        data = base64.b64encode(json.dumps(data))
        #data = urllib.urlencode(data)
        #enable cookie
        opener = urllib2.build_opener(urllib2.HTTPCookieProcessor())
        response = opener.open(req, data)
        return response.read()

    def head(self, url, http_headers={}):
        request = urllib.request.Request(url, headers=http_headers)
        request.get_method = lambda : 'HEAD'
        #request.headers
        try:
            response = urllib.request.urlopen(request)
            return response.info()
        except:
            print(traceback.format_exc())
            return None

    def cancel(self):
        self.close_connection()

    def loadJQuery(self):
        self.jqueryCode = None
        try:
            fn = r'jquery.js'
            if not os.path.exists(fn):
                fn = r'.\youtube_dl\browserless\chrome\jquery.js'
            with io.open(fn, 'r', encoding='utf-8') as f:
                self.jqueryCode = f.read()
        except:
            print(traceback.format_exc())
            pass

    def get_top_host(self, url):

        topHostPostfix = (
                '.com',
                '.la',
                '.io',
                '.co',
                '.info',
                '.net',
                '.org',
                '.me',
                '.mobi',
                '.us',
                '.biz',
                '.xxx',
                '.ca',
                '.co.jp',
                '.com.cn',
                '.net.cn',
                '.org.cn',
                '.mx',
                '.tv',
                '.ws',
                '.ag',
                '.com.ag',
                '.net.ag',
                '.org.ag',
                '.am',
                '.asia',
                '.at',
                '.be',
                '.com.br',
                '.net.br',
                '.bz',
                '.com.bz',
                '.net.bz',
                '.cc',
                '.com.co',
                '.net.co',
                '.nom.co',
                '.de',
                '.es',
                '.com.es',
                '.nom.es',
                '.org.es',
                '.eu',
                '.fm',
                '.fr',
                '.gs',
                '.in',
                '.co.in',
                '.firm.in',
                '.gen.in',
                '.ind.in',
                '.net.in',
                '.org.in',
                '.it',
                '.jobs',
                '.jp',
                '.ms',
                '.com.mx',
                '.nl',
                '.nu',
                '.co.nz',
                '.net.nz',
                '.org.nz',
                '.se',
                '.tc',
                '.tk',
                '.tw',
                '.com.tw',
                '.idv.tw',
                '.org.tw',
                '.hk',
                '.co.uk',
                '.me.uk',
                '.org.uk',
                '.vg',
                '.ru')

        parts = urlparse(url)
        host = parts.netloc
        extractPattern = r'[^\.]+('+'|'.join([h.replace('.', r'\.') for h in topHostPostfix])+')$'
        pattern = re.compile(extractPattern, re.IGNORECASE)
        m = pattern.search(host)
        return m.group() if m else host

    def getProfile(self, url):
        return
        fn = r'profile.json'
        if not os.path.exists(fn):
            fn = r'.\youtube_dl\browserless\chrome\profile.json'
        self.autoPlay = None
        self.ClickArea = {}

    def getUserAgent(self):
        if self.target_url.find('pbs.org')>-1:
            return 'Mozilla/5.0 (Linux; Android 5.1.1; Nexus 6 Build/LYZ28E) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/60.0.3112.113 Mobile Safari/537.36'
        if self.target_url.find('facebook.com')>-1:
            return 'Mozilla/5.0 (iPad; CPU OS 9_1 like Mac OS X) AppleWebKit/601.1.46 (KHTML, like Gecko) Version/9.0 Mobile/13B143 Safari/601.1'
        else:
            return None

    def lanchChrome(self):
        try:
            from subprocess import DEVNULL
            compat_subprocess_get_DEVNULL = lambda: DEVNULL
        except ImportError:
            compat_subprocess_get_DEVNULL = lambda: open(os.path.devnull, 'w')

        try:
            #https://peter.sh/experiments/chromium-command-line-switches/
            cmd = '"%s"'
            cmd += ' "--user-data-dir=%s" '            
            cmd += ' "--remote-debugging-port=%s"'          
            # cmd += ' "--window-position=0,0"'                        
            # cmd += ' "--window-size=1,1"'            
            cmd += ' "--window-size=1280,1080"'
            # cmd += ' --load-component-extension="%s"' % self.extensionPath
            # cmd += ' "--disable-extensions"'
            cmd += ' --no-first-run'
            # cmd += ' "--always-authorize-plugins"'
            # cmd += ' "--allow-outdated-plugins"'
            # cmd += ' "--allow-running-insecure-content"'
            cmd += ' --mute-audio'
            cmd += ' --safebrowsing-disable-auto-update'
            cmd += ' --password-store=basic'
            cmd += ' --safebrowsing-disable-auto-update'
            cmd += ' --disable-default-apps'
            cmd += ' --gpu'
            cmd += ' --headless'

            # # cmd += ' --enable-automation'
            # # cmd += ' --disable-infobars'

            # # extDir = os.path.join(os.path.abspath(os.path.dirname(__file__)), 'blockAds')
            # # if os.path.exists(extDir):
            # #    cmd += ' --load-extension="%s"' % extDir
            
            # UserAgent = self.getUserAgent()
            # if UserAgent:
            #     cmd += ' --user-agent="%s"'% UserAgent
            #if not self._TestMode and not self.openInVirtualDesktop:
            #    cmd += ' --silent-launch'
            
            cmd += ' data:,'
            # cmd = cmd % (self.chromeEXE, self.remote_debugging_port)
            cmd = cmd % (self.chromeEXE, self.user_data_dir, self.remote_debugging_port)
            # cmd = cmd % (self.chromeEXE, self.user_data_dir)
            try:
                path_default = os.path.join(self.user_data_dir, 'Default')
                if not os.path.exists(path_default):
                    os.makedirs(path_default)
                fn = r'Preferences'
                if not os.path.exists(fn):
                    fn = r'.\youtube_dl\browserless\chrome\Preferences'
                shutil.copyfile(fn, os.path.join(path_default, 'Preferences'))
                shutil.copyfile(self.getCookiePath(), os.path.join(path_default, 'Cookies'))
            except:
                print(traceback.format_exc())
                pass
            print(cmd)
            handle = subprocess.Popen(cmd,
                                        #stderr=compat_subprocess_get_DEVNULL(), stdout=subprocess.PIPE, stdin=subprocess.PIPE,
                                        startupinfo=getStartInfo())
            self._close = False
            self._timeOut = False
            startTime = datetime.now()

            while handle.poll() is None and not self._close and not self._timeOut:
                time.sleep(1)
                self._timeOut = (datetime.now() - startTime).seconds > self.timeOut
            self._close = True
            handle.terminate()

            time.sleep(1)
            shutil.rmtree(os.path.dirname(self.user_data_dir))
        except (IOError, OSError):
            return None

    def load_url(self, url):
        index = 0
        self.navigate_to_page(url)

    def on_message(self, message):
        self.process_message(json.loads(message))

    def process_message(self, message):
        method = message['method']
        if method == 'Network.requestWillBeSent':
            pass
        elif method == 'Network.responseReceived':
            #print("## on Network.responseReceived")
            # print("## on Network.responseReceived", message, type(message))
            response = message['params']['response']
            #print("##find media link: ", response['url'])
            if isMediaLink(response):
                # if not re.search(r'fbcdn\.net/.+mp4', response['url']):
                print("##find media link: ", response['url'])
                try:
                    data = {'request.url': response['url'], 'response.headers': response['headers'], 'resultID': self.resultID}
                    if 'ext' in response:
                        data['ext'] = response['ext']
                    self._capturedMediaLink.append(data)                    
                    #self.close_connection()
                except Exception as ex:
                    print(ex)

                # self.post(data)
                # else:
                #     if (len(self.medias) == 0) or (len(self.medias) == 1 and self.medias[0]['request.url'] != response['url']):
                #         data = {'request.url': response['url'], 'request.headers': response['requestHeaders'], 'response.headers': response['headers']}
                #         infos = self.head(response['url'], data['request.headers'])
                #         data['response.headers'] = infos.dict
                #         self.medias.append(data)
                #         if len(self.medias) == 2:
                #             headers = self.medias[0]['response.headers']
                #             content_length1 = self.num(headers.get('content-length', headers.get('Content-length','')))
                #             headers = self.medias[1]['response.headers']
                #             content_length2 = self.num(headers.get('content-length', headers.get('Content-length','')))
                #             data = {'dash': True, 'video': self.medias[0], 'audio': self.medias[1], 'resultID': self.resultID}
                #             if content_length1 < content_length2:
                #                 data = {'dash': True, 'video': self.medias[1], 'audio': self.medias[0], 'resultID': self.resultID}
                #
                #             self.close_connection()
                #             self.post(data)

    def on_error(self, error):
        print(error)

    def on_close(self):
        print('Socket for {0} is closed.'.format(self.debugging_url))

    def getInjectJs(self):
        str = ''''''
        return str

    def on_open(self):
        self.navigate_to_page('about:blank')
        self.enable_network_tracking()
        self.enable_page_tracking()

        if self.autoPlay:
            if self.jqueryCode:
                self.addScript(self.jqueryCode)

        self.addScript(self.getInjectJs())


        self.load_url(self.target_url)

    def addScript(self, str):
        self.addScriptToEvaluateOnNewDocument(str)
        self.addScriptToEvaluateOnLoad(str)

    def close_connection(self):
        self._close = True
        if self.ws:
            self.ws.close()
        print('Connection closed')

    def clear_cache(self):
        self.enqueue_command(method='Network.clearBrowserCache')
        print('Cleared browser cache')

    def can_clear_cache(self):
        self.enqueue_command(method='Network.canClearBrowserCache')
        print('Cleared browser cache')

    def disable_network_tracking(self):
        self.enqueue_command(method='Network.disable')
        print('Disable network tracking.')

    def disable_page_tracking(self):
        self.enqueue_command(method='Page.disable')
        print('Disable page tracking.')

    def enable_network_tracking(self):
        self.enqueue_command(method='Network.enable')
        print('Enabled network tracking.')

        self.enqueue_command(method='Network.setCacheDisabled', params={"cacheDisabled": True})
        print('Disable debugging connection.')

    def enable_page_tracking(self):
        self.enqueue_command(method='Page.enable')
        print('Enabled page tracking.')

    def getIdentifier(self):
        return '%s' % uuid.uuid1()

    def addScriptToEvaluateOnNewDocument(self, source):
        self.enqueue_command(method='Page.addScriptToEvaluateOnNewDocument', params={"source": source, 'identifier': self.getIdentifier()})
        print('addScriptToEvaluateOnNewDocument')

    def addScriptToEvaluateOnLoad(self, source):
        self.enqueue_command(method='Page.addScriptToEvaluateOnLoad', params={"scriptSource": source, 'identifier': self.getIdentifier()})
        print('addScriptToEvaluateOnLoad')

    def enable_trace_collection(self):
        self.enqueue_command(method='Tracing.start')
        print('Enabled trace collection')

    def stop_trace_collection(self):
        self.enqueue_command(method='Tracing.end')
        print('Disables trace collection')

    def get_debugging_url(self):
        return self.debugging_url

    def navigate_to_page(self, url):
        self.enqueue_command(method='Page.navigate', params={"url": url})
        print('Navigating to url:', url)

    def reloadPage(self, ignoreCache=False):
        self.enqueue_command(method='Page.reload', params={"ignoreCache": ignoreCache})
        print('reloadPage')

    def sendMouseMessage(self, Mouse_type, x, y, button='left', clickCount=1):
        self.enqueue_command(method='Input.dispatchMouseEvent', params={"type": Mouse_type, 'x': x, 'y': y, 'button': button, 'clickCount': clickCount})
    
    @property
    def next_command_id(self):
        self.command_id += 1
        return self.command_id

    # Async
    def enqueue_command(self, method, params={}, callback=None):
        msg = {'id': self.next_command_id, 'method': method, 'params': params}
        self.ws.send(json.dumps(msg))
        time.sleep(0.3)
    

class powtoonDownloader(chromeDownloader):
    _port = 8499
    merge_WEBM = None
    def _beforeRun(self):     
        self._videoFile = self.output_file
        self._audioFile = self.output_file.replace('0.mp4', '1.mp3') 
        def task_finish(duration):
            self.totoal_duration = duration
            self.cancel()
        self._tempStoreServer = tempStoreServer(self._port, self._videoFile, task_finish)
        self._tempStoreServer.start()

    def _afterRun(self):
        self._tempStoreServer.stop()
        if (not os.path.exists(self._videoFile)):
            return
        #download audio         
        compat_urlretrieve(self._capturedMediaLink[0]['request.url'], self._audioFile)
        if (not os.path.exists(self._audioFile)):
            return        
        #download video
        self.merge_WEBM(self._videoFile, self._audioFile, None, self.totoal_duration)


    def getInjectJs(self):
        str = '''
var upload_url = "http://127.0.0.1:8499";

function uploadToPHPServer(blob, duration, callback) {
    // create FormData
    var formData = new FormData();
    //formData.append("video-filename", blob.name);
    formData.append("file", blob);
    formData.append("duration", duration);
    callback("Uploading recorded-file to server.");
    var upload_directory = upload_url;
    //alert('2');
    makeXMLHttpRequest(upload_url, formData, function(progress) {
        if (progress !== "upload-ended") {
            callback(progress);
            return;
        }
        var initialURL = upload_directory + blob.name;
        callback("ended", initialURL);
    });
}

function makeXMLHttpRequest(url, data, callback) {
    var request = new XMLHttpRequest();
    request.onreadystatechange = function() {
        if (request.readyState == 4 && request.status == 200) {
            if (request.responseText === "success") {
                callback("upload-ended");
                return;
            }
            //alert(request.responseText);
            return;
        }
    };
    request.upload.onloadstart = function() {
        callback("PHP upload started...");
    };
    request.upload.onprogress = function(event) {
        callback("PHP upload Progress " + Math.round(event.loaded / event.total * 100) + "%");
    };
    request.upload.onload = function() {
        callback("progress-about-to-end");
    };
    request.upload.onload = function() {
        callback("PHP upload ended. Getting file URL.");
    };
    request.upload.onerror = function(error) {
        callback("PHP upload failed.");
    };
    request.upload.onabort = function(error) {
        callback("PHP upload aborted.");
    };
    request.open("POST", url);
    request.send(data);
}
// this function is used to generate random file name
function getFileName(fileExtension) {
    var d = new Date();
    var year = d.getUTCFullYear();
    var month = d.getUTCMonth();
    var date = d.getUTCDate();
    return "RecordRTC-" + year + month + date + "-" + getRandomString() + "." + fileExtension;
}

function getRandomString() {
    if (window.crypto && window.crypto.getRandomValues && navigator.userAgent.indexOf("Safari") === -1) {
        var a = window.crypto.getRandomValues(new Uint32Array(3)),
            token = "";
        for (var i = 0, l = a.length; i < l; i++) {
            token += a[i].toString(36);
        }
        return token;
    } else {
        return (Math.random() * new Date().getTime()).toString(36).replace(/\./g, "");
    }
}
// CanvasRecorder.js - smusamashah
// To record canvas effitiently using MediaRecorder
// https://webrtc.github.io/samples/src/content/capture/canvas-record/

function CanvasRecorder(canvas, uploadMode, video_bits_per_sec) {
    this.start = startRecording;
    this.stop = stopRecording;
    this.save = uploadMode ? upload : download;
    this.working = false;
    var recordedBlobs = [];
    var supportedType = null;
    var mediaRecorder = null;

    var stream = canvas.captureStream();
    if (typeof stream == undefined || !stream) {
        return;
    }

    const video = document.createElement("video");
    video.style.display = "none";

    function startRecording() {
        if (this.working)
            return
        this.working = true;
        let types = [
            //"video/webm",
            //"video/webm,codecs=vp9",
            //"video/vp8",
            //"video/webm\;codecs=vp8",
            //"video/webm\;codecs=daala",
            "video/webm\;codecs=h264",
            //"video/mpeg"
        ];

        for (let i in types) {
            if (MediaRecorder.isTypeSupported(types[i])) {
                supportedType = types[i];
                break;
            }
        }
        if (supportedType == null) {
            console.log("No supported type found for MediaRecorder");
        }
        let options = { 
            mimeType: supportedType,
            videoBitsPerSecond: video_bits_per_sec || 2500000 // 2.5Mbps
        };

        recordedBlobs = [];
        try {
            mediaRecorder = new MediaRecorder(stream, options);
        } catch (e) {
            //alert("MediaRecorder is not supported by this browser.");
            console.error("Exception while creating MediaRecorder:", e);
            return;
        }

        console.log("Created MediaRecorder", mediaRecorder, "with options", options);
        mediaRecorder.onstop = handleStop;
        mediaRecorder.ondataavailable = handleDataAvailable;
        mediaRecorder.start(100); // collect 100ms of data blobs
        console.log("MediaRecorder started", mediaRecorder);
    }

    function handleDataAvailable(event) {
        if (event.data && event.data.size > 0) {
            recordedBlobs.push(event.data);
        }
    }

    function handleStop(event) {
        console.log("Recorder stopped: ", event);
        const superBuffer = new Blob(recordedBlobs, { type: supportedType });
        video.src = window.URL.createObjectURL(superBuffer);
    }

    function stopRecording() {
        mediaRecorder.stop();
        console.log("Recorded Blobs: ", recordedBlobs);
        video.controls = true;
    }

    function download(file_name) {
        const name = file_name || "recording.webm";
        const blob = new Blob(recordedBlobs, { type: supportedType });
        const url = window.URL.createObjectURL(blob);
        const a = document.createElement("a");
        a.style.display = "none";
        a.href = url;
        a.download = name;
        document.body.appendChild(a);
        a.click();
        setTimeout(() => {
            document.body.removeChild(a);
            window.URL.revokeObjectURL(url);
        }, 100);
    }


    function upload(file_name) {
        //alert('1');
        const name = file_name || "recording.webm";
        const blob = new Blob(recordedBlobs, { type: supportedType });    
        var fileName = getFileName("webm");
        var fileObject = new File([blob], fileName, {
            type: "video/webm"
        });
        duration = renderPlayer.playerRef.totalDuration;
        uploadToPHPServer(fileObject, duration, function(response, fileDownloadURL) {
            //alert(response);
        });        
    }    
}


function startRecoder(){
  canvasArr = document.getElementsByTagName("canvas")
  if (canvasArr){
    if (window.recoder){ 
      if (window.renderPlayer.playerRef.isEnd){
        window.clearInterval(recoderInterval);
        window.recoder.stop();
        window.recoder.save();
        window.recoder = NaN;        
      }
      return;
    }

    window.renderPlayer.playerRef.debugCorePlayerEventLog = function(e, t) {
        if (e =='onTotalTimeChanged '){
            window.recoder.start();                
        }
    }
    window.renderPlayer.playerRef.play();    
    window.recoder = new CanvasRecorder(canvasArr[0], true, NaN);
  }  
}
if (typeof recoderInterval == 'undefined'){
    window.recoderInterval = window.setInterval(startRecoder, 5000);                
}
        '''
        return str
