#!/usr/bin/env python
# -*- coding: utf-8 -*-

from __future__ import unicode_literals

import errno
import os
import sys
import socket
import time
import re
import traceback

from .common import FileDownloader
from ..compat import compat_urllib_error
from ..utils import (
    ContentTooShortError,
    encodeFilename,
    sanitize_open,
    sanitized_Request,
    write_xattr,
    XAttrMetadataError,
    XAttrUnavailableError,
)

try:
    import pycurl
except Exception as e:
    print('not surpot curl')

import threading
from .curlDownload import CurlDownloader

g_nodata_maxS = 60


class HttpCurl(FileDownloader):
    def __init__(self, ydl, params):
        # type: (object, object, object) -> object
        FileDownloader.__init__(self, ydl, params)
        self.resume = True
        self.chunk = 5 * 1024 * 1024  # Define the chunk size to be downloaded at once
        self.thread_list = []
        self.curlDownload_list = []
        self.fileSize = 0
        self.num_thread = 2
        self.dir_name = ''
        self.downloaded_size = 0
        self.last_total_size = 0
        self.info_dict = {}
        self.cancle = False
        self.is_need_test = True
        self.mutiThreadFailed = False
        self.downloadError = ''
        self.noDataSecond = 0
        self.downloadTimeout = False
        self.effectiveUrl = ''
        self.eff = 0
        self.lim_l = 0
        self.lim_u = 0

    def getFileSize(self, url):

        tmp_curl_obj = pycurl.Curl()
        tmp_curl_obj.setopt(tmp_curl_obj.URL, url)  # Setting the target
        # Set NO-body download to true  , REDIRS have proprom
        tmp_curl_obj.setopt(tmp_curl_obj.NOBODY, True)
        tmp_curl_obj.setopt(pycurl.FOLLOWLOCATION, 1)
        tmp_curl_obj.setopt(pycurl.MAXREDIRS, 5)
        tmp_curl_obj.setopt(pycurl.SSL_VERIFYPEER, 0)
        tmp_curl_obj.setopt(pycurl.SSL_VERIFYHOST, 2)
        tmp_curl_obj.setopt(pycurl.VERBOSE, 1)  # verbose 详细
        tmp_curl_obj.setopt(pycurl.DEBUGFUNCTION, self.curlDebugtest)
        self.fileSize = 0
        # Send request
        is_getfilesize = False
        self.setCUrlOption(tmp_curl_obj)
        try:
            print('Trying to get size of the file')
            tmp_curl_obj.perform()
            # get the size
            status = tmp_curl_obj.getinfo(pycurl.HTTP_CODE)
            # tmpURL = tmp_curl_obj.getinfo(pycurl.EFFECTIVE_URL)
            if status == 301 or status == 302:
                self.effectiveUrl = tmp_curl_obj.getinfo(pycurl.EFFECTIVE_URL)
            else:
                self.fileSize = tmp_curl_obj.getinfo(tmp_curl_obj.CONTENT_LENGTH_DOWNLOAD)

                if status > 399:
                    print('error:status > 399')
                elif self.fileSize < 512:
                    print('self.fileSize < 512')
                else:
                    is_getfilesize = True
                    print('fileSize:%d' % self.fileSize)

            tmp_curl_obj.close()

        except Exception as e:
            print(e)
            return False

        return is_getfilesize

    def testUrl(self, info_dict):

        try:
            import pycurl
        except Exception as e:
            print('not surpot curl')
            return False

        self.is_need_test = False
        self.info_dict = info_dict
        pycurl.global_init(pycurl.GLOBAL_DEFAULT)
        self.getFileSize(info_dict['url'])
        #
        if self.fileSize < 1024 and len(self.effectiveUrl) > 6:
            if len(info_dict['url']) != len(self.effectiveUrl):
                print('self.effectiveUrl:%s' % self.effectiveUrl)
                self.getFileSize(self.effectiveUrl)
        if self.fileSize < 1024:
            return False
        return True

    def isSuprortResume(self, info_dict):
        tmp_curl_obj = pycurl.Curl()
        if len(self.effectiveUrl) < 6:
            tmp_curl_obj.setopt(tmp_curl_obj.URL, info_dict['url'])  # Setting the target
        else:
            tmp_curl_obj.setopt(tmp_curl_obj.URL, self.effectiveUrl)  # Setting the target

        # Set NO-body download to true  , REDIRS have proprom
        tmp_curl_obj.setopt(tmp_curl_obj.NOBODY, True)
        tmp_curl_obj.setopt(pycurl.FOLLOWLOCATION, 1)
        tmp_curl_obj.setopt(pycurl.MAXREDIRS, 5)
        tmp_curl_obj.setopt(pycurl.SSL_VERIFYPEER, 0)
        tmp_curl_obj.setopt(pycurl.SSL_VERIFYHOST, 2)
        tmp_curl_obj.setopt(pycurl.VERBOSE, 1)  # verbose 详细
        tmp_curl_obj.setopt(pycurl.DEBUGFUNCTION, self.curlDebugtest)
        # Send request
        self.setCUrlOption(tmp_curl_obj)
        # 判断是否支持断点下载
        tmp_curl_obj.setopt(pycurl.RANGE, '100-199')
        try:
            print('Trying to get size of the file')
            tmp_curl_obj.perform()
            # get the size
            self.resume = tmp_curl_obj.getinfo(pycurl.CONTENT_LENGTH_DOWNLOAD) == 100
        except Exception as e:
            print('resum error:')
            print(e)
            return False
        tmp_curl_obj.close()
        return self.resume

    def openSpeedup(self):
        if self.resume is False:
            return

        if self.fileSize < 5 * 1024 * 1024:
            return

        if len(self.thread_list) > 1:
            return

        if len(self.thread_list) == 0:
            self.num_thread = 5
            return
            # 计算剩余大小及 片段大小 停止下载  分割文件
            # self.num_thread = 5

    def closeSpeedup(self):
        # 关闭加速也会等待线程下载完成在关闭
        self.num_thread = 1

    def cancleDownload(self):
        # 关闭加速也会等待线程下载完成在关闭
        for curldl in self.curlDownload_list:
            curldl.cancelDownload()

    def setCUrlOption(self, curl):
        try:
            add_headers = self.info_dict.get('http_headers')
            # curl.setopt(pycurl.TIMEOUT, 120)
            curl.setopt(pycurl.CONNECTTIMEOUT, 120)
            if add_headers:
                hdrs = [('%s: %s') % (k, v) for k, v in add_headers.items()]
                print(hdrs)
                curl.setopt(pycurl.HTTPHEADER, hdrs)
                # curl.setopt(pycurl.USERAGENT, '')
                # curl.setopt(pycurl.HTTPHEADER, ['Accept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.7', 'Accept-Language: en-us,en;q=0.5', 'Accept-Encoding: gzip, deflate', 'Accept: text/html,application/xhtml+xml,application/xml;q=0.9,*/*;q=0.8', 'User-Agent: Mozilla/5.0 (X11; Linux x86_64; rv:10.0) Gecko/20150101 Firefox/47.0 (Chrome)'])
                # if 'proxy_host' in self.proxy:
                #     curl.setopt(pycurl.PROXY, self.proxy['proxy_host'])
                # if 'proxy_port' in self.proxy:
                #     curl.setopt(pycurl.PROXYPORT, self.proxy['proxy_port'])
                # if 'proxy_user' in self.proxy:
                #     curl.setopt(pycurl.PROXYUSERPWD, '%(proxy_user)s:%(proxy_pass)s' % self.proxy)
        except Exception as e:
            print(e.message)
            pass

    def downloadThread(self, filepath, start, end):
        try:
            if end - self.fileSize > 1:
                end = -1
            tryCount = 1

            while True:
                curlDownload = CurlDownloader(self.targetURL)
                self.setCUrlOption(curlDownload.curl_obj)
                self.curlDownload_list.append(curlDownload)
                print('append curlDownload:%d' % id(curlDownload))
                curlDownload.startDownload(filepath, start, end, self.resume)
                # 重新下载 再失败 就直接返回下载失败 curlDownload.clientError 为 httpcode ：400 - 499
                if curlDownload.isFinish is False:
                    if self.cancle:
                        print('fileName: %s is cancel' % curlDownload.fileName)
                        break

                    if curlDownload.errorCode == pycurl.E_OPERATION_TIMEDOUT or curlDownload.errorCode == pycurl.E_COULDNT_CONNECT:
                        self.downloadError = 'connect time out'
                        break

                    if curlDownload.clientError is True and self.num_thread > 1:
                        self.num_thread = 1
                        self.mutiThreadFailed = True
                        print('mutiThread download failed')
                        break
                    else:
                        tryCount += 1
                        print('try to download: %d' % tryCount)
                        if tryCount > 3:
                            self.num_thread = 1
                            self.mutiThreadFailed = True
                            break

                    print('remove curlDownload:%d' % id(curlDownload))
                    self.curlDownload_list.remove(curlDownload)
                    time.sleep(2)
                else:
                    break

        except:
            self.num_thread = 1
            self.mutiThreadFailed = True
            curlDownload.isFinish = False
            print(traceback.format_exc())

        if threading.currentThread() in self.thread_list:
            self.thread_list.remove(threading.currentThread())

    def curlDebugtest(self, debug_type, debug_msg):
        # INFOTYPE_DATA_IN = 3
        # INFOTYPE_DATA_OUT = 4
        #
        # INFOTYPE_HEADER_IN = 1
        # INFOTYPE_HEADER_OUT = 2
        #
        # INFOTYPE_SSL_DATA_IN = 5
        # INFOTYPE_SSL_DATA_OUT = 6
        #
        # INFOTYPE_TEXT = 0
        # print(self.fp
        if debug_type == pycurl.INFOTYPE_TEXT:
            print(' debug(TEXT): %s' % debug_msg)
        elif debug_type == pycurl.INFOTYPE_HEADER_IN:
            print(' debug(HEADER_IN): %s' % debug_msg)
        elif debug_type == pycurl.INFOTYPE_HEADER_OUT:
            print(' debug(HEADER_OUT): %s' % debug_msg)

    def downloadFile(self):
        print('downloadFile:Start download with only thread')
        self.last_total_size = 0
        self.lim_l = 0  # lower limit of the byte-range for download
        downloadedSize = 0
        start = time.time()
        before = start  # start measuring
        temp_output = os.path.join(self.dir_name, 'outputpart')
        thread = threading.Thread(target=self.downloadThread, args=(temp_output, self.lim_l, 0))
        self.thread_list.append(thread)
        thread.start()
        time.sleep(1)
        while len(self.thread_list) > 0:
            # This ensures that only the required number (num_thread) of child processes run at once
            time.sleep(1)
            now = time.time()
            after = now
            self.httpCurlProgress(start, now)
            if self.cancle is True:
                break

        curlDownload = self.curlDownload_list[0]

        if self.downloadTimeout is True:
            raise Exception('cant read data in 60s, need retry download')

        if self.cancle is True:
            return

        if curlDownload.isFinish is False:
            raise Exception('downloaded failed')

        renameFailed = False
        try:
            os.rename(temp_output, self.output_file)
        except:
            print('rename file failed')
            print(traceback.format_exc())
            renameFailed = True

        if renameFailed is True:
            try:
                print('start copy file to output_file')
                # Open file to copy
                fp = open(self.output_file, 'wb')
                # Open the temporary file to read from
                tp = open(temp_output, 'rb')
                fp.write(tp.read())
                # Close files
                tp.close()
                fp.close()
            except:
                print('copy file except')
                print(traceback.format_exc())
                raise Exception('copy file except')

        # wait for all download thread to exit
        now = time.time()
        self.httpCurlProgress(start, now)
        return True

    def isDownloadFailed(self):
        if self.downloadTimeout is True:
            print('cant read data in 60s, need retry download')
            raise Exception('cant read data in 60s, need retry download')

        if self.cancle is True:
            print('download is cancle by task')
            return True

        if self.mutiThreadFailed is True:
            print('mutiThread download Failed')
            # 拼接已下载完整的片段，防止网络异常删除所有下载片段
            self.cancleDownload()
            # self.concatenate()
            self.delete_temp()
            self.curlDownload_list = []
            raise Exception('mutiThreadFailed is False')

        return False

    def isMutiThreadFailed(self):
        if self.downloadTimeout is True:
            return True

        if self.cancle is True:
            return True

        if self.mutiThreadFailed is True:
            return True

        return False

    def downloadMutiThreadFile(self):

        self.last_total_size = 0
        self.lim_l = 0  # lower limit of the byte-range for download
        i = 1
        downloadedSize = 0
        start = time.time()
        before = start  # start measuring
        while self.lim_l <= self.fileSize:
            # Create a temporary filename
            temp_output = os.path.join(self.dir_name, 'output' + str(i))
            # print(temp_output
            # Ensure that it doesn't already exists
            # If it exists and its size is the same as that of the chunk downloaded each time, then go to the next chunk
            if os.path.exists(temp_output) and os.path.getsize(temp_output) == self.chunk:
                print(str(i) + ' MB already downloaded')
                i += 1
                # print(r
                self.lim_l += self.chunk
                self.lim_u += self.chunk
                self.downloaded_size += self.chunk
                continue

            thread = threading.Thread(target=self.downloadThread, args=(temp_output, self.lim_l, self.lim_u - 1))
            thread.start()
            self.thread_list.append(thread)
            time.sleep(2)
            print('>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>' , self.num_thread)
            while len(self.thread_list) > self.num_thread - 1:
                # This ensures that only the required number (num_thread) of child processes run at once
                time.sleep(1)

                self.httpCurlProgress(start, time.time())

                if self.isMutiThreadFailed() is True:
                    break

            if self.isMutiThreadFailed() is True:
                break

            if len(self.downloadError) > 2:
                break

            # Define lower and upper limit of the next range.
            self.lim_l += self.chunk
            self.lim_u += self.chunk
            # self.print_percentage(i)
            i += 1

        if self.isDownloadFailed() is True:
            return

        # wait for all download thread to exit
        while len(self.thread_list) > 0:
            time.sleep(1)
            now = time.time()
            after = now
            self.httpCurlProgress(start, now)
            if self.isMutiThreadFailed() is True:
                break

        if self.isDownloadFailed() is True:
            return

        if len(self.downloadError) > 2:
            raise Exception('self.downloadError')

        if self.cancle is False:
            self.concatenate()
            self.delete_temp()

        print('downloadMutiThreadFile download finisg')

    def real_download(self, filename, info_dict):
        try:
            import pycurl
        except Exception as e:
            print('not surpot curl')
            return False

        self.info_dict = info_dict
        self.thread_list = []
        self.curlDownload_list = []
        self.output_file = filename
        self.targetURL = info_dict['url']
        self.last_total_size = 0
        self.cancle = False

        if self.is_need_test is True:
            if self.testUrl(info_dict) is False:
                return False

        if self.fileSize > 0:
            print('Starting download. Total size: ' + str(self.fileSize) + ' bytes or ' + str(
                self.fileSize / 1024 / 1024) + ' MB')
        else:
            print('fileSize < 0 download')
            return False
        # Download straight-away if the size is less than the limit

        # kan shi fou zhi chi jia su
        if self.num_thread > 1 and (self.isSuprortResume(self.info_dict) is False):
            print('not suporrt resume download')
            self.num_thread = 1

        # 不支持断点续传就直接下载
        # if self.fileSize <= self.chunk or self.fileSize < 0 or self.resume is False:
        #     # Set the output file
        #     self.downloadThread(self.output_file, 0, self.fileSize)
        #     return True

        ################################################
        try:
            self.dir_name = self.output_file + 'tmp'
            os.makedirs(self.dir_name)
        except OSError:
            pass
        # thread_list = []  # This stores the list of PIDs of the children (processes)


        if self.num_thread == 1:
            self.chunk = self.fileSize
            self.lim_u = 0
            self.num_thread = 1
        # 小于 10 M 就单线程下载
        elif self.fileSize < 50 * 1024 * 1024:
            self.chunk = 1 * 1024 * 1024
            self.lim_u = self.chunk
            # self.num_thread = 5
        # 小于 250 M 就动态计算，大于 最大值 50 M
        elif self.fileSize < 10 * 50 * 1024 * 1024:
            # self.chunk = int(self.fileSize / 5) + 1
            self.chunk = 5 * 1024 * 1024
            self.lim_u = self.chunk  # upper limit of the byte-range for download
        else:
            self.chunk = 30 * 1024 * 1024
            self.lim_u = self.chunk  # upper limit of the byte-range for download

        if self.num_thread == 1:
            return self.downloadFile()
        else:
            self.downloadMutiThreadFile()
            if self.mutiThreadFailed is True:
                self.num_thread = 1
                self.lim_u = 0
                return self.downloadFile()

        return True

    def httpCurlCancel(self):
        print('cancel all download task')
        for curlDl in self.curlDownload_list:
            curlDl.cancelDownload()

    def httpCurlCancelTimeout(self):
        print('cancel all time out download task')
        for curlDl in self.curlDownload_list:
            curlDl.cancelTimeoutDownload()

    def httpCurlProgress(self, start, now):
        totalsize = 0
        downloadSize = 0
        for curldl in self.curlDownload_list:
            downloadSize += curldl.downloadbyte
            totalsize += curldl.getDownloadedSize()
        speed = self.calc_speed(start, now, downloadSize)
        totalsize += self.downloaded_size
        if totalsize > self.last_total_size:
            self.last_total_size = totalsize
            self.noDataSecond = 0
        else:
            self.noDataSecond += 1
            if self.noDataSecond > g_nodata_maxS:
                self.downloadTimeout = True
                print('cant download data in 60s ,need retry to download')
                self.cancle = True
                self.httpCurlCancelTimeout()
                return

        try:
            self._hook_progress({
                'status': 'downloading',
                'downloaded_bytes': totalsize,
                'total_bytes': self.fileSize,
                'tmpfilename': self.output_file,
                'filename': self.output_file,
                'speed': speed,
                'elapsed': now - start,
            })
        except:
            print('hook_progress except need cancel task')
            self.cancle = True
            self.httpCurlCancel()

    def concatenate(self):

        # Concatenate the files to finally create the desired output

        # TODO : Check that the file doesn't already exist

        # Open file in write mode (and close) to over-write any existing file
        # with same name

        fp = open(self.output_file, 'w')
        fp.close()

        i = 1
        totalsize = 0
        while True:
            output_name = 'output' + str(i)
            temp_output = os.path.join(self.dir_name, 'output' + str(i))
            # print(temp_output
            if os.path.exists(temp_output):

                # Open file to append to
                fp = open(self.output_file, 'ab')

                # Open the temporary file to read from
                tp = open(temp_output, 'rb')
                filesize = os.path.getsize(temp_output)
                totalsize += filesize
                print(output_name + ' size:' + str(filesize) + 'totale size:' + str(totalsize))
                # tp.truncate(self.chunk)

                # Append to the output_file
                fp.write(tp.read())

                # Close files
                tp.close()
                fp.close()

                if filesize == self.chunk:
                    i += 1  # Increase only if the file size is equal to the chunk size
                else:
                    break  # this takes care of redundant files downloaded
            else:
                break

        confilesize = os.path.getsize(self.output_file)
        print('download finish filesize : %d' % confilesize)
        if (confilesize * 10) / self.fileSize < 9:
            print('conFilesize:%s  self.fileSize:' % (confilesize, self.fileSize))
            raise Exception('download file small source file')
        fp.close()

    def delete_temp(self):
        # Remove the temporary files created
        i = 1
        while True:
            temp_output = os.path.join(self.dir_name, 'output' + str(i))
            # print(temp_output
            if os.path.exists(temp_output):
                os.remove(temp_output)
            else:
                break
            i += 1

        try:
            os.rmdir(self.dir_name)
        except Exception as e:
            print(e)

# class HttpCurl(FileDownloader):
#     def real_download(self, filename, info_dict):
#         url = info_dict['url']
#         tmpfilename = self.temp_name(filename)
#         stream = None
#
#         # Do not include the Accept-Encoding header
#         headers = {'Youtubedl-no-compression': 'True'}
#         add_headers = info_dict.get('http_headers')
#         if add_headers:
#             headers.update(add_headers)
#         basic_request = sanitized_Request(url, None, headers)
#         request = sanitized_Request(url, None, headers)
#
#         is_test = self.params.get('test', False)
#
#         if is_test:
#             request.add_header('Range', 'bytes=0-%s' % str(self._TEST_FILE_SIZE - 1))
#
#         # Establish possible resume length
#         if os.path.isfile(encodeFilename(tmpfilename)):
#             resume_len = os.path.getsize(encodeFilename(tmpfilename))
#         else:
#             resume_len = 0
#
#         open_mode = 'wb'
#         if resume_len != 0:
#             if self.params.get('continuedl', True):
#                 self.report_resuming_byte(resume_len)
#                 request.add_header('Range', 'bytes=%d-' % resume_len)
#                 open_mode = 'ab'
#             else:
#                 resume_len = 0
#
#         count = 0
#         retries = self.params.get('retries', 0)
#         while count <= retries:
#             # Establish connection
#             try:
#                 data = self.ydl.urlopen(request)
#                 # When trying to resume, Content-Range HTTP header of response has to be checked
#                 # to match the value of requested Range HTTP header. This is due to a webservers
#                 # that don't support resuming and serve a whole file with no Content-Range
#                 # set in response despite of requested Range (see
#                 # https://github.com/rg3/youtube-dl/issues/6057#issuecomment-126129799)
#                 if resume_len > 0:
#                     content_range = data.headers.get('Content-Range')
#                     if content_range:
#                         content_range_m = re.search(r'bytes (\d+)-', content_range)
#                         # Content-Range is present and matches requested Range, resume is possible
#                         if content_range_m and resume_len == int(content_range_m.group(1)):
#                             break
#                     # Content-Range is either not present or invalid. Assuming remote webserver is
#                     # trying to send the whole file, resume is not possible, so wiping the local file
#                     # and performing entire redownload
#                     self.report_unable_to_resume()
#                     resume_len = 0
#                     open_mode = 'wb'
#                 break
#             except (compat_urllib_error.HTTPError,) as err:
#                 if (err.code < 500 or err.code >= 600) and err.code != 416:
#                     # Unexpected HTTP error
#                     raise
#                 elif err.code == 416:
#                     # Unable to resume (requested range not satisfiable)
#                     try:
#                         # Open the connection again without the range header
#                         data = self.ydl.urlopen(basic_request)
#                         content_length = data.info()['Content-Length']
#                     except (compat_urllib_error.HTTPError,) as err:
#                         if err.code < 500 or err.code >= 600:
#                             raise
#                     else:
#                         # Examine the reported length
#                         if (content_length is not None and
#                                 (resume_len - 100 < int(content_length) < resume_len + 100)):
#                             # The file had already been fully downloaded.
#                             # Explanation to the above condition: in issue #175 it was revealed that
#                             # YouTube sometimes adds or removes a few bytes from the end of the file,
#                             # changing the file size slightly and causing problems for some users. So
#                             # I decided to implement a suggested change and consider the file
#                             # completely downloaded if the file size differs less than 100 bytes from
#                             # the one in the hard drive.
#                             self.report_file_already_downloaded(filename)
#                             self.try_rename(tmpfilename, filename)
#                             self._hook_progress({
#                                 'filename': filename,
#                                 'status': 'finished',
#                                 'downloaded_bytes': resume_len,
#                                 'total_bytes': resume_len,
#                             })
#                             return True
#                         else:
#                             # The length does not match, we start the download over
#                             self.report_unable_to_resume()
#                             resume_len = 0
#                             open_mode = 'wb'
#                             break
#             except socket.error as e:
#                 if e.errno != errno.ECONNRESET:
#                     # Connection reset is no problem, just retry
#                     raise
#
#             # Retry
#             count += 1
#             if count <= retries:
#                 self.report_retry(count, retries)
#
#         if count > retries:
#             self.report_error('giving up after %s retries' % retries)
#             return False
#
#         data_len = data.info().get('Content-length', None)
#
#         # Range HTTP header may be ignored/unsupported by a webserver
#         # (e.g. extractor/scivee.py, extractor/bambuser.py).
#         # However, for a test we still would like to download just a piece of a file.
#         # To achieve this we limit data_len to _TEST_FILE_SIZE and manually control
#         # block size when downloading a file.
#         if is_test and (data_len is None or int(data_len) > self._TEST_FILE_SIZE):
#             data_len = self._TEST_FILE_SIZE
#
#         if data_len is not None:
#             data_len = int(data_len) + resume_len
#             min_data_len = self.params.get('min_filesize')
#             max_data_len = self.params.get('max_filesize')
#             if min_data_len is not None and data_len < min_data_len:
#                 self.to_screen('\r[download] File is smaller than min-filesize (%s bytes < %s bytes). Aborting.' % (
#                 data_len, min_data_len))
#                 return False
#             if max_data_len is not None and data_len > max_data_len:
#                 self.to_screen('\r[download] File is larger than max-filesize (%s bytes > %s bytes). Aborting.' % (
#                 data_len, max_data_len))
#                 return False
#
#         byte_counter = 0 + resume_len
#         block_size = self.params.get('buffersize', 1024)
#         start = time.time()
#
#         # measure time over whole while-loop, so slow_down() and best_block_size() work together properly
#         now = None  # needed for slow_down() in the first loop run
#         before = start  # start measuring
#         while True:
#
#             # Download and write
#             data_block = data.read(block_size if not is_test else min(block_size, data_len - byte_counter))
#             byte_counter += len(data_block)
#
#             # exit loop when download is finished
#             if len(data_block) == 0:
#                 break
#
#             # Open destination file just in time
#             if stream is None:
#                 try:
#                     (stream, tmpfilename) = sanitize_open(tmpfilename, open_mode)
#                     assert stream is not None
#                     filename = self.undo_temp_name(tmpfilename)
#                     self.report_destination(filename)
#                 except (OSError, IOError) as err:
#                     self.report_error('unable to open for writing: %s' % str(err))
#                     return False
#
#                 if self.params.get('xattr_set_filesize', False) and data_len is not None:
#                     try:
#                         write_xattr(tmpfilename, 'user.ytdl.filesize', str(data_len).encode('utf-8'))
#                     except (XAttrUnavailableError, XAttrMetadataError) as err:
#                         self.report_error('unable to set filesize xattr: %s' % str(err))
#
#             try:
#                 stream.write(data_block)
#             except (IOError, OSError) as err:
#                 self.to_stderr('\n')
#                 self.report_error('unable to write data: %s' % str(err))
#                 return False
#
#             # Apply rate limit
#             self.slow_down(start, now, byte_counter - resume_len)
#
#             # end measuring of one loop run
#             now = time.time()
#             after = now
#
#             # Adjust block size
#             if not self.params.get('noresizebuffer', False):
#                 block_size = self.best_block_size(after - before, len(data_block))
#
#             before = after
#
#             # Progress message
#             speed = self.calc_speed(start, now, byte_counter - resume_len)
#             if data_len is None:
#                 eta = None
#             else:
#                 eta = self.calc_eta(start, time.time(), data_len - resume_len, byte_counter - resume_len)
#
#             self._hook_progress({
#                 'status': 'downloading',
#                 'downloaded_bytes': byte_counter,
#                 'total_bytes': data_len,
#                 'tmpfilename': tmpfilename,
#                 'filename': filename,
#                 'eta': eta,
#                 'speed': speed,
#                 'elapsed': now - start,
#             })
#
#             if is_test and byte_counter == data_len:
#                 break
#
#         if stream is None:
#             self.to_stderr('\n')
#             self.report_error('Did not get any data blocks')
#             return False
#         if tmpfilename != '-':
#             stream.close()
#
#         if data_len is not None and byte_counter != data_len:
#             raise ContentTooShortError(byte_counter, int(data_len))
#         self.try_rename(tmpfilename, filename)
#
#         # Update file modification time
#         if self.params.get('updatetime', True):
#             info_dict['filetime'] = self.try_utime(filename, data.info().get('last-modified', None))
#
#         self._hook_progress({
#             'downloaded_bytes': byte_counter,
#             'total_bytes': byte_counter,
#             'filename': filename,
#             'status': 'finished',
#             'elapsed': time.time() - start,
#         })
#
#         return True
