# encoding: utf-8
# 支持心跳

from __future__ import unicode_literals

import sys
import threading
if sys.version_info >= (3, 0):
    from urllib.request import urlopen
else:
    from urllib2 import urlopen
from ..utilsEX import debug
from .http import HttpFD

class HttpHB(HttpFD):
    def real_download(self, filename, info_dict):
        result = False
        if 'heartbeat_url'in info_dict:
            def heart_beat():
                try:
                    urlopen(url=info_dict['heartbeat_url'], data=info_dict['heartbeat_data'])
                    debug('........................................heart beat!')
                except Exception as ex:
                    debug('........................................heart beat fail: ' + ex.message)
                    pass

                if not result:
                    timer = threading.Timer(25, heart_beat)
                    timer.start()

            heart_beat()

        result = super(HttpHB, self).real_download(filename, info_dict)
        return result