import json

def extreactSessionCookieFromFirefox(sessionFile, domain):
  import lz4.block
  in_file = open(sessionFile, "rb")
  data = lz4.block.decompress(in_file.read()) if in_file.read(8) == b"mozLz40\0" else b'{}'
  in_file.close()
  jsonData = json.loads(data.decode('utf-8'))
  cookies = jsonData.get('cookies', {})
  return [{'name': cookie['name'], 'value': cookie['value']} for cookie in cookies if cookie['host'] == domain]

if __name__ == "__main__":
    print(extreactSessionCookieFromFirefox(r'c:\recovery.jsonlz4', '.vimeo.com'))