


//--------------------------------------------------------------------------------------
// Global variables
//--------------------------------------------------------------------------------------
int rotateType; //0:clockwise 90;1:clockwise 180;2:clockwise 270;3:flip Y; 4:flip X
Texture2D overlay;        
float    g_fTime;                   
int overlay_Width;
int overlay_Height;



//--------------------------------------------------------------------------------------
// Texture samplers
//--------------------------------------------------------------------------------------
SamplerState TextureSampler
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};

struct VS_INPUT
{
    float4 Position   : POSITION; // vertex position 
    float2 TextureUV  : TEXCOORD0;   // vertex texture coords 
};

struct VS_OUTPUT
{
    float4 Position   : SV_POSITION; // vertex position 
    float2 TextureUV  : TEXCOORD1;   // vertex texture coords 
};

//--------------------------------------------------------------------------------------
// Pixel shader output structure
//--------------------------------------------------------------------------------------
struct PS_OUTPUT
{
    float4 RGBColor : SV_Target;  // Pixel color
};


//--------------------------------------------------------------------------------------
// This shader outputs the pixel's color by modulating the texture's
//       color with diffuse material color
//--------------------------------------------------------------------------------------


PS_OUTPUT PS_2D( VS_OUTPUT In)
{ 
    PS_OUTPUT Output;
    float ow = float(overlay_Width);
    float oh = float(overlay_Height);
   
    float2 tc = In.TextureUV;
    float2 temCoord = tc;
    float4 color = float4(0.0,0.0,0.0,0.0); 
        //PROTATE_90_CLOCKWISE  = 0,
        //PROTATE_180 = 1,
        //PROTATE_270_CLOCKWISE = 2, 
        //PMIRROR_VERT = 3,
        //PMIRROR_HORZ = 4
    switch(rotateType )
    {
        case(0):
                temCoord = float2(temCoord.y,1.0 - temCoord.x);
                break;
        case(1):
                temCoord = 1.0 - temCoord;
                break;
        case(2):
                temCoord =  float2(1.0 - temCoord.y,temCoord.x);
                break;
        case(3):
                temCoord =  float2(1.0 - temCoord.x,temCoord.y); 
                break;
        case(4):
                temCoord =  float2(temCoord.x,1.0 - temCoord.y); 
                break;
        default:
                temCoord = float2(temCoord.y,1.0 - temCoord.x);
				break;
    }
 
	color = overlay.Sample(TextureSampler, temCoord);
	
	Output.RGBColor = color;
    return Output;
}

// 
VS_OUTPUT VS_2D(VS_INPUT vin)
{
	VS_OUTPUT vOut;
	vOut.Position = vin.Position;
	vOut.TextureUV = vin.TextureUV;
	return vOut;
}

//--------------------------------------------------------------------------------------
// Renders scene to render target using D3D11 Techniques
//--------------------------------------------------------------------------------------
technique11 ColorTech
{
	pass P0
	{
		SetVertexShader(CompileShader(vs_4_0, VS_2D()));
		SetPixelShader(CompileShader(ps_4_0, PS_2D()));

	}
}

