


//--------------------------------------------------------------------------------------
// Global variables
//--------------------------------------------------------------------------------------
int blendMode;
float kRender_Alpha;
int ovlAlphaPreMul;
Texture2D overlay;            // Color texture for mesh
Texture2D background ;
float    g_fTime;                   // App's time in seconds
int overlay_Width;
int overlay_Height;
int back_Width;
int back_Height;
float blend_x;
float blend_y;

//--------------------------------------------------------------------------------------
// Texture samplers
//--------------------------------------------------------------------------------------
SamplerState TextureSampler
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};

struct VS_INPUT
{
    float4 Position   : POSITION; // vertex position 
    float2 TextureUV  : TEXCOORD0;   // vertex texture coords 
};

struct VS_OUTPUT
{
    float4 Position   : SV_POSITION; // vertex position 
    float2 TextureUV  : TEXCOORD1;   // vertex texture coords 
};

//--------------------------------------------------------------------------------------
// Pixel shader output structure
//--------------------------------------------------------------------------------------
struct PS_OUTPUT
{
    float4 RGBColor : SV_Target;  // Pixel color
};


//--------------------------------------------------------------------------------------
// This shader outputs the pixel's color by modulating the texture's
//       color with diffuse material color
//--------------------------------------------------------------------------------------
float4 colorDodge(float4 bgCol, float4 overlay)
{
	float4 outputColor = bgCol / (1.0 - overlay);

	if (overlay.x > 0.99999)
		outputColor.x = 1.0;
	if (overlay.y > 0.99999)
		outputColor.y = 1.0;
	if (overlay.z > 0.99999)
		outputColor.z = 1.0;

	return outputColor;
}

float4 colorBurn(float4 bgCol, float4 overlay)
{

	float4 outputColor = 1.0 - (1.0 - bgCol) / overlay;

	if (overlay.x < 0.000001)
		outputColor.x = 0.0;
	if (overlay.y < 0.000001)
		outputColor.y = 0.0;
	if (overlay.z < 0.000001)
		outputColor.z = 0.0;
	return outputColor;
}

float4 colorDodgeForHardMix(float4 bgCol, float4 overlay)
{
	float4 outputColor = bgCol / (1.0 - overlay);

	if (bgCol.x < 0.000001)
		outputColor.x = 0.0;
	if (bgCol.y < 0.000001)
		outputColor.y = 0.0;
	if (bgCol.z < 0.000001)
		outputColor.z = 0.0;

	return outputColor;
}

float4 colorBurnForHardMix(float4 bgCol, float4 overlay)
{

	float4 outputColor = 1.0 - (1.0 - bgCol) / overlay;

	if (bgCol.x > 0.9999999)
		outputColor.x = 1.0;
	if (bgCol.y > 0.9999999)
		outputColor.y = 1.0;
	if (bgCol.z > 0.9999999)
		outputColor.z = 1.0;
	return outputColor;
}

//tempMatt: matt without alpha
//matt: matt with altph.

float4 blending(float4 backGround, float4 ovl, float matt, float tempMatt, float exeMatt, int blendingMode, float opacity, int ovlAlphaPreMul)
{
	float3 a = float3(0.0, 0.0, 0.0);
	float3 b = float3(0.0, 0.0, 0.0);
	float4 outputColor = float4(0.0, 0.0, 0.0, 0.0);
	float4 overlay = ovl * tempMatt;
	float4 bgCol = backGround;
	float tempOpacity = opacity * matt * exeMatt;
	float invTemOpacity = 1.0 - tempOpacity;
	switch (blendingMode)
	{
	case 0:// normal,
	//bgCol = float4(bgCol.xyz*bgCol.w, bgCol.w);

		outputColor = overlay;
		if (ovlAlphaPreMul == 0)
		{
			outputColor.w = tempOpacity + invTemOpacity * bgCol.w;
			outputColor.xyz = outputColor.xyz*tempOpacity + invTemOpacity * bgCol.xyz;
			return outputColor;
		}
		else {
			outputColor.w = tempOpacity + invTemOpacity * bgCol.w;
			float fOpacity = opacity * tempMatt;
			outputColor.xyz = outputColor.xyz*fOpacity + invTemOpacity * bgCol.xyz;
			return outputColor;
		}
	case 1: // Darken
		outputColor = min(overlay, bgCol);
		break;
	case 2: //multiply
		outputColor = bgCol * overlay;
		break;
	case 3: //  color burn // 1 - (1-Target) / Blend
	{
		float4 temp = (1.0 - bgCol) / overlay;
		if (bgCol.x > 0.99999)
			temp.x = 0.0;
		if (bgCol.y > 0.99999)
			temp.y = 0.0;
		if (bgCol.z > 0.99999)
			temp.z = 0.0;
		outputColor = 1.0 - temp;
	}
	break;
	case 4: // Linear burn
		outputColor = overlay + bgCol - 1.0;
		break;
	case 5: //screen
		outputColor = 1.0 - (1.0 - bgCol)*(1.0 - overlay);
		break;
	case 6: //color dodge
	{
		outputColor = bgCol / (1.0 - overlay);
		if (bgCol.x < 0.00001)
			outputColor.x = 0.0;
		if (bgCol.y < 0.00001)
			outputColor.y = 0.0;
		if (bgCol.z < 0.00001)
			outputColor.z = 0.0;
	}
	break;
	case 7://Linear Dodge
		outputColor = overlay + bgCol;
		break;
	case 8: //overlay // (Target > 0.5) * (1 - (1-2*(Target-0.5)) * (1-Blend)) + (Target <= 0.5) * ((2*Target) * Blend)
	{
		a = float3((bgCol.x > 0.5 ? 1.0 : 0.0), (bgCol.y > 0.5 ? 1.0 : 0.0), (bgCol.z > 0.5 ? 1.0 : 0.0));
		b = float3((bgCol.x <= 0.5 ? 1.0 : 0.0), (bgCol.y <= 0.5 ? 1.0 : 0.0), (bgCol.z <= 0.5 ? 1.0 : 0.0));
		outputColor.xyz = a * (1.0 - (1.0 - 2.0*(bgCol.xyz - 0.5)) * (1.0 - overlay.xyz)) + b * ((2.0*bgCol.xyz) * overlay.xyz);
	}
	break;
	case 9: //Soft Light // 
	{
		a = float3((overlay.x > 0.5 ? 1.0 : 0.0), (overlay.y > 0.5 ? 1.0 : 0.0), (overlay.z > 0.5 ? 1.0 : 0.0));
		b = float3((overlay.x <= 0.5 ? 1.0 : 0.0), (overlay.y <= 0.5 ? 1.0 : 0.0), (overlay.z <= 0.5 ? 1.0 : 0.0));
		outputColor.xyz = a * (2.0*bgCol.xyz*(1.0 - overlay.xyz) + sqrt(bgCol.xyz)*(2.0*overlay.xyz - 1.0)) + b * (2.0*bgCol.xyz*overlay.xyz + bgCol.xyz*bgCol.xyz*(1.0 - 2.0*overlay.xyz));
	}
	break;
	case 10://Hard Light //(Blend > 0.5) * (1 - (1-Target) * (1-2*(Blend-0.5))) + (Blend <= 0.5) * (Target * (2*Blend))
	{
		a = float3(float(overlay.x > 0.5 ? 1.0 : 0.0), float(overlay.y > 0.5 ? 1.0 : 0.0), float(overlay.z > 0.5 ? 1.0 : 0.0));
		b = float3(float(overlay.x <= 0.5 ? 1.0 : 0.0), float(overlay.y <= 0.5 ? 1.0 : 0.0), float(overlay.z <= 0.5 ? 1.0 : 0.0));
		outputColor.xyz = a * (1.0 - (1.0 - bgCol.xyz) * (1.0 - 2.0*(overlay.xyz - 0.5))) + b * (bgCol.xyz * (2.0*overlay.xyz));
	}
	break;
	case 11://vivid light //// (Blend > 0.5) * (1 - (1-Target) / (2*(Blend-0.5))) + (Blend <= 0.5) * (Target / (1-2*Blend))
	{
		a = float3(float(overlay.x > 0.5 ? 1.0 : 0.0), float(overlay.y > 0.5 ? 1.0 : 0.0), float(overlay.z > 0.5 ? 1.0 : 0.0));
		b = float3(float(overlay.x <= 0.5 ? 1.0 : 0.0), float(overlay.y <= 0.5 ? 1.0 : 0.0), float(overlay.z <= 0.5 ? 1.0 : 0.0));
		outputColor.xyz = b * colorBurn(bgCol, (2.0*overlay)).xyz + a * colorDodge(bgCol, (2.0*(overlay - 0.5))).xyz;
	}
	break;
	case 12:// Linear Light//  (Blend > 0.5) * (Target + 2*(Blend-0.5)) + (Blend <= 0.5) * (Target + 2*Blend - 1)
	{
		a = float3(float(overlay.x > 0.5 ? 1.0 : 0.0), float(overlay.y > 0.5 ? 1.0 : 0.0), float(overlay.z > 0.5 ? 1.0 : 0.0));
		b = float3(float(overlay.x <= 0.5 ? 1.0 : 0.0), float(overlay.y <= 0.5 ? 1.0 : 0.0), float(overlay.z <= 0.5 ? 1.0 : 0.0));
		outputColor.xyz = a * (bgCol.xyz + 2.0*(overlay.xyz - 0.5)) + b * (bgCol.xyz + 2.0*overlay.xyz - 1.0);
	}
	break;
	case 13: //PIN Light// (Blend > 0.5) * (max(Target,2*(Blend-0.5))) + (Blend <= 0.5) * (min(Target,2*Blend)))
	{
		a = float3(float(overlay.x > 0.5 ? 1.0 : 0.0), float(overlay.y > 0.5 ? 1.0 : 0.0), float(overlay.z > 0.5 ? 1.0 : 0.0));
		b = float3(float(overlay.x <= 0.5 ? 1.0 : 0.0), float(overlay.y <= 0.5 ? 1.0 : 0.0), float(overlay.z <= 0.5 ? 1.0 : 0.0));
		outputColor.xyz = a * (max(bgCol.xyz, 2.0*(overlay.xyz - 0.5))) + b * (min(bgCol.xyz, 2.0*overlay.xyz));
	}
	break;
	case 14: // hardmix  (VividLight(A,B) < 128) ? 0 : 255
	{
		a = float3(float(overlay.x > 0.5 ? 1.0 : 0.0), float(overlay.y > 0.5 ? 1.0 : 0.0), float(overlay.z > 0.5 ? 1.0 : 0.0));
		b = float3(float(overlay.x <= 0.5 ? 1.0 : 0.0), float(overlay.y <= 0.5 ? 1.0 : 0.0), float(overlay.z <= 0.5 ? 1.0 : 0.0));
		outputColor.xyz = b * colorBurnForHardMix(bgCol, (2.0*overlay)).xyz + a * colorDodgeForHardMix(bgCol, (2.0*(overlay - 0.5))).xyz;
		outputColor.xyz = float3(float(outputColor.x >= 0.5 ? 1.0 : 0.0), float(outputColor.y >= 0.5 ? 1.0 : 0.0), float(outputColor.z >= 0.5 ? 1.0 : 0.0));
		//outputColor.xyz = float3( float(overlay.x + bgCol.x >= 1.0?1.0:0.0), float(overlay.y + bgCol.y >= 1.0?1.0:0.0),float(overlay.z + bgCol.z >= 1.0?1.0:0.0));
	}
	break;
	case 15://Difference
		outputColor = abs(overlay - bgCol);
		break;
	case 16://exclusion // 0.5 - 2*(Target-0.5)*(Blend-0.5)
		outputColor = 0.5 - 2.0*(overlay - 0.5)*(bgCol - 0.5);
		break;
	case 17://Lighten // max(Target,Blend)   
		outputColor = max(overlay, bgCol);
		break;
	case 19: // hollow in 
		outputColor = bgCol * overlay.w;
		outputColor = clamp(outputColor, float4(0.0, 0.0, 0.0, 0.0), float4(1.0, 1.0, 1.0, 1.0));
		break;
	case 20: // hollow out      
		outputColor = bgCol;
		if (bgCol.w < 0.000001)
			outputColor = overlay;
		else
			outputColor = bgCol * (1.0 - overlay.w);
		outputColor = clamp(outputColor, float4(0.0, 0.0, 0.0, 0.0), float4(1.0, 1.0, 1.0, 1.0));
		break;
	case 21: // backGround hollow in 
		outputColor = overlay * bgCol.w;
		outputColor = clamp(outputColor, float4(0.0, 0.0, 0.0, 0.0), float4(1.0, 1.0, 1.0, 1.0));
		break;
	case 22: // replace
		if (tempMatt * exeMatt > 0.0001)
			return float4(overlay.xyz, overlay.w);
		else
			return bgCol;
	case 23://add
		outputColor = bgCol + overlay;
		break;
	default:
		bgCol = float4(bgCol.xyz*bgCol.w, bgCol.w);
		outputColor = overlay;

		if (ovlAlphaPreMul == 0)
		{
			tempOpacity = opacity * matt * exeMatt;
		}
		else {
			tempOpacity = opacity * tempMatt * exeMatt;
		}
		outputColor = clamp(outputColor, float4(0.0, 0.0, 0.0, 0.0), float4(1.0, 1.0, 1.0, 1.0));
		outputColor.w = overlay.w + (1.0 - overlay.w)* bgCol.w;
		outputColor.xyz = outputColor.xyz*tempOpacity + invTemOpacity * bgCol.xyz;
		//outputColor.xyz = clamp( outputColor.xyz / outputColor.w, float3(0.0), float3(1.0) );

		return outputColor;
	}

	outputColor = clamp(outputColor, float4(0.0, 0.0, 0.0, 0.0), float4(1.0, 1.0, 1.0, 1.0));
	outputColor.w = overlay.w + (1.0 - overlay.w)* bgCol.w;
	outputColor.xyz = outputColor.xyz*tempOpacity + invTemOpacity * bgCol.xyz;
	outputColor.xyz = clamp(outputColor.xyz, float3(0.0, 0.0, 0.0), float3(1.0, 1.0, 1.0));

	return outputColor;

}

#define EQN_EPS 1e-9f

static bool isZero(float x) {
	return (x > -EQN_EPS && x < EQN_EPS);
}

PS_OUTPUT PS_2D( VS_OUTPUT In)
{ 
    PS_OUTPUT Output;
    float ow = float(overlay_Width);
    float oh = float(overlay_Height);
    float bw = float(back_Width);
    float bh = float(back_Height);
    float roi_x0 = blend_x  * bw;
    float roi_y0 = blend_y  * bh;
    float roi_x1 = roi_x0 + ow;
    float roi_y1 = roi_y0 + oh;
    roi_x1 = clamp(roi_x1,0.0,bw);
    roi_y1 = clamp(roi_y1,0.0,bh);
    float roi_width = roi_x1 - roi_x0;
    float roi_height = roi_y1 - roi_y0;
    roi_x0 = roi_x0 / bw;
    roi_y0 = roi_y0 / bh;
    roi_x1 = roi_x1 / bw;
    roi_y1 = roi_y1 / bh;

    float over_x0 = 0.0;
    float over_y0 = 0.0;
    float over_x1 = roi_width / ow;
    float over_y1 = roi_height / oh;
    float2 tc = In.TextureUV;
    float matt_b = step(roi_x0,tc.x) * step(tc.x,roi_x1) * step(roi_y0,tc.y) * step(tc.y,roi_y1);
	
    float4 bgCol = background.Sample(TextureSampler, tc) ;
    if(isZero(matt_b)){
        Output.RGBColor = bgCol;
        return Output;
    }
	
	float resizeCoord_x = (tc.x - roi_x0 ) * bw / ow;
	float resizeCoord_y = (tc.y - roi_y0 ) * bh / oh;
	
	float2 resizeCoord = float2(resizeCoord_x,resizeCoord_y);
    float4 ovlCol = overlay.Sample(TextureSampler, resizeCoord) ;
    
	float grid = ovlCol.w;
	float roiMat = matt_b;

	float4 FragColor = blending(bgCol, ovlCol, grid, roiMat, 1.0, blendMode, kRender_Alpha, ovlAlphaPreMul);

	Output.RGBColor = FragColor;
    return Output;
}

// 
VS_OUTPUT VS_2D(VS_INPUT vin)
{
	VS_OUTPUT vOut;
	vOut.Position = vin.Position;
	vOut.TextureUV = vin.TextureUV;
	return vOut;
}

//--------------------------------------------------------------------------------------
// Renders scene to render target using D3D11 Techniques
//--------------------------------------------------------------------------------------
technique11 ColorTech
{
	pass P0
	{
		SetVertexShader(CompileShader(vs_4_0, VS_2D()));
		SetPixelShader(CompileShader(ps_4_0, PS_2D()));

	}
}

