


//--------------------------------------------------------------------------------------
// Global variables
//--------------------------------------------------------------------------------------
Texture2D overlay;        
float    g_fTime;                   
int overlay_Width;
int overlay_Height;
int dst_Width;
int dst_Height;
int resize_type;
//resize_type = 0;//IRM_FULLSCREEN
//resize_type = 1;//IRM_ORIGINAL_SCALE
//resize_type = 2;//IRM_16_9
//resize_type = 3;//IRM_4_3

#define WS_PI 3.14159265358979323846

//--------------------------------------------------------------------------------------
// Texture samplers
//--------------------------------------------------------------------------------------
SamplerState TextureSampler
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};

struct VS_INPUT
{
    float4 Position   : POSITION; // vertex position 
    float2 TextureUV  : TEXCOORD0;   // vertex texture coords 
};

struct VS_OUTPUT
{
    float4 Position   : SV_POSITION; // vertex position 
    float2 TextureUV  : TEXCOORD1;   // vertex texture coords 
};

//--------------------------------------------------------------------------------------
// Pixel shader output structure
//--------------------------------------------------------------------------------------
struct PS_OUTPUT
{
    float4 RGBColor : SV_Target;  // Pixel color
};


//--------------------------------------------------------------------------------------
// This shader outputs the pixel's color by modulating the texture's
//       color with diffuse material color
//--------------------------------------------------------------------------------------


PS_OUTPUT PS_2D( VS_OUTPUT In)
{ 
    PS_OUTPUT Output;
    float f_srcWidth = float(overlay_Width);
    float f_srcHeight = float(overlay_Height);
    float f_dstWidth = float(dst_Width);
    float f_dstHeight = float(dst_Height);
   
    float2 tc = In.TextureUV;

    float scalFactorX = f_dstWidth / f_srcWidth;
	float scalFactorY = f_dstHeight / f_srcHeight;
    float resizeCoord_x = tc.x;
	float resizeCoord_y = tc.y;
    float matt = 1.0;
    if(resize_type == 1){
        float src_ratio = f_srcWidth / f_srcHeight;
        float dst_ratio = f_dstWidth / f_dstHeight;
        float tmpDstH = ceil(f_dstWidth * f_srcHeight / f_srcWidth);
        if(f_dstHeight >= tmpDstH) {
            float dstH = tmpDstH / f_dstHeight ;
            float roiY0 = (1.0 - dstH) * 0.5;
            float roiY1 = roiY0 + dstH;
            matt = step(roiY0 ,tc.y) * step(tc.y , roiY1);
            resizeCoord_y = (tc.y - roiY0 ) / dstH;
        }else{
            float tmpDstW = ceil(f_dstHeight * src_ratio);
            float dstW =  tmpDstW / f_dstWidth;
            float roiX0 = (1.0 - dstW) * 0.5;
            float roiX1 = roiX0 + dstW;
            matt = step(roiX0 ,tc.x) * step(tc.x , roiX1);
            resizeCoord_x = (tc.x - roiX0) / dstW;
        }
    }
    float2 uv = float2(resizeCoord_x,resizeCoord_y);
	float4 ovlCol = overlay.Sample(TextureSampler, uv) * matt;
	
	Output.RGBColor = ovlCol;
    return Output;
}

// 
VS_OUTPUT VS_2D(VS_INPUT vin)
{
	VS_OUTPUT vOut;
	vOut.Position = vin.Position;
	vOut.TextureUV = vin.TextureUV;
	return vOut;
}

//--------------------------------------------------------------------------------------
// Renders scene to render target using D3D11 Techniques
//--------------------------------------------------------------------------------------
technique11 ColorTech
{
	pass P0
	{
		SetVertexShader(CompileShader(vs_4_0, VS_2D()));
		SetPixelShader(CompileShader(ps_4_0, PS_2D()));

	}
}

