#import json
import httplib2
from apiclient import discovery
from oauth2client import client
from oauth2client import file
from youtube_upload import main
import os
from apiclient.discovery import build
import base64
import urllib.parse
from baseau import *

class GoogleAU(BaseAU):
    def __init__(self):
        BaseAU.__init__(self)
        self.scope = 'https://www.googleapis.com/auth/userinfo.profile ' \
                 'https://www.googleapis.com/auth/youtube.upload https://www.googleapis.com/auth/youtube.readonly'
        self.code = ''
        self.credentials = None
        self.flow = None
        home = os.getenv('TEMP')#os.path.abspath(os.path.dirname(__file__))
        self.credentialsfile = os.path.join(home, "youtube-upload-credentials.json")

    def SetBrand(self, brand):
        if brand == 'wondershare':
            self.appId = '621564820214-k0o42pkl0qigve8d52ukta8mk3nak1nn.apps.googleusercontent.com'
            self.appSecret = 'm6zY3OoOKwQByynxOkvGJrYB'
            self.redirectURL = 'http://pop.wondershare.com/filmora/sns-authorization.html'
        elif brand == 'iskysoft':
            self.appId = '621564820214-3d5qugfltf2525tcu1t80hb80n0lehfi.apps.googleusercontent.com'
            self.appSecret = 'AWwiRtrUxvJ8jx0veE6ke5Vb'
            self.redirectURL = 'http://pop.iskysoft.com/filmora/sns-authorization.html'
        elif brand == 'aimersoft':
            self.appId = '621564820214-prt94n2bdk1b51ko0dm17ph8gc4te9og.apps.googleusercontent.com'
            self.appSecret = 'If57cHzw4DI989xhYRG_GKhP'
            self.redirectURL = 'http://pop.aimersoft.com/filmora/sns-authorization.html'

    def GetLoginURL(self):
        if self.flow == None:
            self.flow = client.OAuth2WebServerFlow(
                client_id =self.appId,
                client_secret=self.appSecret,
                scope=self.scope,
                redirect_uri=self.redirectURL)
        authURI = self.flow.step1_get_authorize_url()
        if type(authURI) == str:
            authURI = authURI.encode("utf-8")
        return authURI
    
    def Logout(self):
        if self.credentials != None:
            self.credentials.revoke(httplib2.Http())
        return
    
    def VerifyRedirectURL(self, url):
        if url.find(self.redirectURL) == 0:
            uri = urllib.parse.urlparse(url)
            paramlist = urllib.parse.parse_qs(uri.query)
            if 'code' in paramlist:
                try:
                    self.credentials = self.flow.step2_exchange(paramlist['code'][0])
                    if  self.UpdateInfo() == True:
                        storage = file.Storage(self.credentialsfile)
                        storage.put(self.credentials)
                        return BaseAU.VerifyCode.S_OK
                except client.FlowExchangeError as e:
                    self.accessError = e
            if 'error' in paramlist:
                self.accessError = paramlist['error'][0]
            return BaseAU.VerifyCode.E_FAILED
        return BaseAU.VerifyCode.E_INVALIDARG

    def SetAccessToken(self, tokeninfo):
        try:
            token = base64.b64decode(tokeninfo)
            if type(token) == bytes:
                token = token.decode()
            self.credentials = client.Credentials.new_from_json(token)
            if  self.UpdateInfo() == True:
                storage = file.Storage(self.credentialsfile)
                storage.put(self.credentials)
                return True
        except:
            self.accessError = 'invalid token.'
        return False

    def UpdateInfo(self):
        try:
            users_service = build("oauth2", "v2", http=self.credentials.authorize(httplib2.Http()))
            user_document = users_service.userinfo().get().execute()
            self.userName = user_document['name']
            youtube = build("youtube", "v3", http=self.credentials.authorize(httplib2.Http()))
            cat = youtube.videoCategories().list(part="snippet",regionCode="us").execute()
            all = cat['items']
            cats = []
            for it in all:
                if it['snippet']['assignable'] == True:
                    cats.append(it['snippet']['title'])
            self.videoCategories = '|'.join(cats)
            return True
        except Exception as e:
            self.accessError = str(e)
            return False

    def GetAccessToken(self):
        jsStr = self.credentials.to_json()
        jsStr = base64.b64encode(jsStr.encode('utf-8'))
        if type(jsStr) == bytes:
            jsStr = jsStr.decode()
        return jsStr
    
    def start_upload(self):
        arguments = []
        arguments.append('--credentials-file=%s' % self.credentialsfile)
        arguments.append('--title=%s' % self.title)
        if len(self.desc) > 0:
            arguments.append('--description=%s' % self.desc)
        if len(self.category) > 0:
            arguments.append('--category=%s' % self.category)
        if len(self.tags) > 0:
            arguments.append('--tags=%s' % self.tags)
        if len(self.privacy) > 0:
            arguments.append('--privacy=%s' % self.privacy)
        arguments.append(self.filepath)

        try:
            self.video_url = main.main(arguments, self.SendMessage)
            main.notifyEvent('VIDEOURL='+self.video_url)
        except client.AccessTokenRefreshError as e:
            debug('upload except1: ' + str(e))
            main.notifyEvent('ERROR=type1:' + str(e))
            #self.SendMessage(4, e)
        except main.AuthenticationError as e:
            debug('upload except2: ' + str(e))
            main.notifyEvent('ERROR=type2:' + str(e))
            #self.SendMessage(3, e)
        except Exception as e:
            debug('upload except3: ' + str(e))
            main.notifyEvent('ERROR=type3:' + str(e))
            #self.SendMessage(3,str(e))
        print('youtube upload video success: ', self.video_url)

def CreateGoogleInstance():
    return GoogleAU()

if __name__ == '__main__':
    pass
    #ytb = CreateGoogleInstance()
    #ytb.SetBrand('wondershare')
    #print(ytb.GetLoginURL())
    #c = input('input :')
    #ytb.VerifyRedirectURL(c)
    #print(ytb.GetUserName())
    #ytb.StartUpload(r'E:\MySource\python\py3_2\v\1.mp4', title='hello xbx2', desc= 'hello desc2', privacy='public', tags='home2', category='Film & Animation')
    #ytb.Logout()
    # ytb.SetAccessToken('aaa')
    # ytb.StartUpload('D:/My Document/Videos/TubeDigger/nnngoedl.mp4', 'Happy Lulu','my baby', 'private', 'Film & Animation')

