import vimeo
import base64
import random
import traceback
import json
import urllib.parse
from youtube_upload import main

from baseau import *
import vimeo.auth

class VimeoAU(BaseAU):
    def __init__(self):
        BaseAU.__init__(self)
        self.state = ''
        self.scope = ['public', 'private', 'upload', 'edit']
        self.userInfo = ''
        self.vimeo = None

    def SetBrand(self,brand):
        if brand == 'wondershare':
            self.appId = 'dcf47773388172c7ce784a591986f26a1334519a'
            self.appSecret = 'vl4Gwt9GCGvfaNywyZpZTpYP9zautJWdfLPdKKWyVkYX6OSLs0cKLR98/Ma2mTXgg26TS0Vyi/LAPna/1XE5yOxIKeQGOCcLrFbxzzgbdDOwvieabV9Emyykut3Z7JBu'
            self.redirectURL = 'http://pop.wondershare.com/filmora/sns-authorization.html'
        elif brand == 'iskysoft':
            self.appId = 'b4f300a58bdaabc9062f72b0401095a491654fb0'
            self.appSecret = 'kzNjqvO5VQ1JjrE+vHS/GpbEm3sxus/c48MLhYouMSJWmvjLS91EhZohwBSIIKvwP2oMpcFxZ224Qs0BByJbYfxqJjbImyzgYMefUEnAwIy/breUkh2httNVw7aMGKgf'
            self.redirectURL = 'http://pop.iskysoft.com/filmora/sns-authorization.html'
        elif brand == 'aimersoft':
            self.appId = 'e47ecbbef75533ceb2d045b2b707d19295ec5fd2'
            self.appSecret = 'zmLg04JjS4Dy2/k4xQ+hwiN6CAvxVAu7XJ+y5rwyEptyxhcuE9jqV3c27T+y1sgtpGqdanmUPv1sqlefHSlNYlQCv2TiTfKwVAC+/cJl0c3j8HRVlG5hzeoWdAtUgG2F'
            self.redirectURL = 'http://pop.aimersoft.com/filmora/sns-authorization.html'

    def GetLoginURL(self):
        vimeo_authorization_url = ''
        try:
            v = vimeo.VimeoClient(key=self.appId, secret=self.appSecret)
            s = str(random.uniform(1, 100))
            data = s.encode(encoding='utf-8')
            self.state = base64.b64encode(data)
            vimeo_authorization_url = v.auth_url(self.scope, self.redirectURL, self.state)
        except Exception as e:
            vimeo_authorization_url = '%s' % traceback.format_exc()

        return vimeo_authorization_url

    def Logout(self):
        return

    def VerifyRedirectURL(self,url):
        if url.find(self.redirectURL) == 0:
            uri = urllib.parse.urlparse(url)
            paramlist = urllib.parse.parse_qs(uri.query)
            if 'code' in paramlist:
                try:
                    v = vimeo.VimeoClient(key=self.appId, secret=self.appSecret)
                    self.accessToken, self.userInfo, self.scope = v.exchange_code(paramlist['code'][0], self.redirectURL)
                    self.vimeo = v
                    self.UpdateInfo()
                    return BaseAU.VerifyCode.S_OK
                except vimeo.auth.GrantFailed as e:
                    self.accessError = 'Vimeo Auth GrantFailed'
            if 'error' in paramlist:
                self.accessError = paramlist['error'][0]
            return BaseAU.VerifyCode.E_FAILED
        return BaseAU.VerifyCode.E_INVALIDARG

    def UpdateInfo(self):
        if self.vimeo:
            about_me = self.vimeo.get('/me')
            if about_me.status_code != 200:
                self.accessError = about_me.reason
                return False
            try:
                self.userInfo = about_me.json()
                self.userName = self.userInfo['name']
                self.limit_file_size = int(self.userInfo['upload_quota']['space']['free'])
                self.video_hd = bool(self.userInfo['upload_quota']['quota']['hd'])
                self.video_sd = bool(self.userInfo['upload_quota']['quota']['sd'])
                return True
            except AttributeError as e:
                self.accessError = str(e)
            except KeyError as e:
                self.accessError = 'KeyError:'+ str(e)
        return False

    def SetAccessToken(self, token):
        self.accessToken = token
        self.vimeo = vimeo.VimeoClient(token=self.accessToken, key=self.appId, secret=self.appSecret)
        return self.UpdateInfo()

    def start_upload(self):
        if self.vimeo == None:
            main.notifyEvent(self.accessError)
            #self.SendMessage(4, self.accessError)
            return
        try:
            debug("Start upload: {0}".format(self.filepath))
            video_uri = self.vimeo.upload(self.filepath, uploadparam=self)
            if video_uri:
                response = self.vimeo.patch(video_uri, data={'name': self.title, 'description': self.desc, 'privacy.view': self.privacy})
                print(response)
                content = json.loads(response.content.decode())
                self.vimeo.put(video_uri + '/tags/' + self.tags)
                print(response)
                main.notifyEvent('VIDEOURL='+ content['link'])
                #self.SendMessage(2, content['link'])
                return
        except AssertionError as e:
            self.accessError = str(e)
        except Exception as e:
            self.accessError = str(e)
        #self.SendMessage(3, self.accessError)
        main.notifyEvent(self.accessError)

def CreateVimeoInstance():
    return VimeoAU()

if __name__ == '__main__':
    v = CreateVimeoInstance()
    v.SetBrand('wondershare')
    print(v.GetLoginURL())
    c = input('input :')
    v.VerifyRedirectURL(c)
    # v.SetAccessToken('13ab38dbe79ce80b61f833cc939feda4')
    print('AccessToken=', v.GetAccessToken())
    print('UserName=', v.GetUserName())
    v.StartUpload(r'E:\MySource\python\py3\v\3.mp4', 'hello','vimeo','nobody','first,wondershare filmora','other')
    # v.Wait()