﻿Option Explicit On

' Vocabulary Trainer between 2 Languages of 12
'
' MP Nov / Dez 2011: Program 3.0
' MP Mar / Apr 2012: Vocabulary Trainer
' MP Mar / Apr 2014: Program 4.0
' MP Mar / Dez 2015: Extra Vocabulary

' Functions:
' - generateTrainFile           Generate new Training File
' - appendToTrainFile           Append to Training File
' - writeTrainFile              Write Training File
' - readTrainFile               Read Training File to Use
' - searchTrainFile             Search for Training File
' - takeWords                   Take Words from Selection
' - takeNextWord                Take next Word from Unit
' - registerResults             Register Results of Learning Unit
' - markRightAlternative        Mark the right Alternative Label
' - calculateScore              Calculation of the new Score


Imports System.Xml
Imports System.Threading


Public Class FTrainer

    Dim exercise As Boolean
    Dim trainFile As String
    Dim niveaus(7) As Boolean
    Dim languages(2) As Integer
    Dim techsubj As String
    Dim wordlstcount As Integer
    Dim exniveaus(7) As Boolean
    Dim exlanguages(2) As Integer
    Dim exWordFrom As New List(Of String)
    Dim exWordTo As New List(Of String)
    Dim exWordCon As New List(Of String)
    Dim exWordSyn As New List(Of String)
    Dim exWordType As New List(Of String)
    Dim exWordTheme As New List(Of String)
    Dim exWordTime As New List(Of Long)
    Dim exWordCount As New List(Of Integer)
    Dim exWordScore As New List(Of Integer)
    Dim exSelected, exDone As Integer
    Dim exScore As Integer
    Dim unitWordsFrom(20) As String
    Dim unitWordsTo(20) As String
    Dim unitWordsCon(20) As String
    Dim unitWordsSyn(20) As String
    Dim unitWordsType(20) As String
    Dim unitWordsTheme(20) As String
    Dim unitWordsTime(20) As Long
    Dim unitWordsCount(20) As Integer
    Dim unitWordsScore(20) As Integer
    Dim unitWordsIndex(20) As Integer
    Dim unitWordsCount0(20) As Integer
    Dim unitWordsScore0(20) As Integer
    Dim unitWordsReakt0(20) As Integer
    Dim nextWordFrom As String
    Dim nextWordTo(5) As String
    Dim nextWordCon As String
    Dim nextWordSyn As String
    Dim nextWordType As String
    Dim nextWordTheme As String
    Dim nextWordTime As Long
    Dim nextWordCount As Integer
    Dim nextWordScore As Integer
    Dim nextWordCount0 As Integer
    Dim takeIndex(5) As Integer
    Dim pubNumWords As Integer
    Dim pubNumTimes As Integer
    Dim pubTimeMeas As Long
    Dim pubPause As Boolean
    Dim optionAutomatic As Boolean
    Const maxSleep As Integer = 5
    Const minScore As Integer = 0
    Const maxScore As Integer = 100
    Const facScore As Double = 2.0


    Private Sub FTrainer_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        ' Defaults

        ' Auswahl

        ' Texte von Labels and Buttons
        frmTrainer.GroupBoxSelection.Text = "Selection"
        '
        frmTrainer.GroupBoxChoice.Text = "Choice"
        frmTrainer.RadioButtonNewChoice.Text = "New Choice"
        frmTrainer.RadioButtonAppendChoice.Text = "Append Choice"
        frmTrainer.RadioButtonUseChoice.Text = "Use Choice"
        frmTrainer.ButtonApply.Text = "Apply"
        '
        frmTrainer.GroupBoxLanguages.Text = "Languages"
        frmTrainer.ComboBoxToLang.Text = "Please select!"
        frmTrainer.LabelFromLang.Text = "from"
        frmTrainer.LabelToLang.Text = "to"
        '
        frmTrainer.GroupBoxResults.Text = "Results"
        frmTrainer.LabelStaticSelected.Text = "selected"
        frmTrainer.LabelStaticDone.Text = "done"
        frmTrainer.LabelStaticScore.Text = "Score"


        ' Sprachen-Auswahl from
        frmTrainer.ComboBoxFromLang.Items.Clear()
        frmTrainer.ComboBoxFromLang.Items.Add("Esperanto")
        frmTrainer.ComboBoxFromLang.Items.Add("Deutsch")
        frmTrainer.ComboBoxFromLang.Items.Add("English")
        frmTrainer.ComboBoxFromLang.Items.Add("Français")
        frmTrainer.ComboBoxFromLang.Items.Add("Español")
        frmTrainer.ComboBoxFromLang.Items.Add("Italiano")
        frmTrainer.ComboBoxFromLang.Items.Add("Português")
        frmTrainer.ComboBoxFromLang.Items.Add("Dansk")
        frmTrainer.ComboBoxFromLang.Items.Add("Svenska")
        frmTrainer.ComboBoxFromLang.Items.Add("Ελληνικά")
        frmTrainer.ComboBoxFromLang.Items.Add("Русский")
        frmTrainer.ComboBoxFromLang.Items.Add("Polski")
        frmTrainer.ComboBoxFromLang.Items.Add("Hrvatski")
        frmTrainer.ComboBoxFromLang.Items.Add("Any Language")
        frmTrainer.ComboBoxFromLang.SelectedIndex = pubFromLanguage

        ' Sprachen-Auswahl to
        frmTrainer.ComboBoxToLang.Items.Clear()
        frmTrainer.ComboBoxToLang.Items.Add("Esperanto")
        frmTrainer.ComboBoxToLang.Items.Add("Deutsch")
        frmTrainer.ComboBoxToLang.Items.Add("English")
        frmTrainer.ComboBoxToLang.Items.Add("Français")
        frmTrainer.ComboBoxToLang.Items.Add("Español")
        frmTrainer.ComboBoxToLang.Items.Add("Italiano")
        frmTrainer.ComboBoxToLang.Items.Add("Português")
        frmTrainer.ComboBoxToLang.Items.Add("Dansk")
        frmTrainer.ComboBoxToLang.Items.Add("Svenska")
        frmTrainer.ComboBoxToLang.Items.Add("Ελληνικά")
        frmTrainer.ComboBoxToLang.Items.Add("Русский")
        frmTrainer.ComboBoxToLang.Items.Add("Polski")
        frmTrainer.ComboBoxToLang.Items.Add("Hrvatski")
        frmTrainer.ComboBoxToLang.Items.Add("Any Language")
        frmTrainer.ComboBoxToLang.SelectedIndex = -1


        ' Auswahl / Choice
        exercise = searchTrainFile(0)
        exSelected = 0
        exDone = 0
        exScore = 0

        If (exercise = False) Then
            frmTrainer.RadioButtonNewChoice.Checked = True
            ' Sichtbarkeit
            frmTrainer.GroupBoxNiveaus.Enabled = True
            frmTrainer.GroupBoxLanguages.Enabled = True
        Else
            frmTrainer.GroupBoxSelection.Text = "Selection"
            frmTrainer.RadioButtonUseChoice.Checked = True
            ' Sichtbarkeit
            frmTrainer.GroupBoxNiveaus.Enabled = False
            frmTrainer.GroupBoxLanguages.Enabled = False
        End If

        ' Ergebnisse
        frmTrainer.LabelSelected.Text = exSelected
        frmTrainer.LabelDone.Text = exDone
        frmTrainer.LabelScore.Text = exScore


        ' Uebung

        ' Sichtbarkeit
        frmTrainer.GroupBoxTraining.Enabled = False
        frmTrainer.ButtonGoOn.Enabled = False
        frmTrainer.ButtonCorrect.Enabled = False

        ' Texte von Labels and Buttons
        frmTrainer.GroupBoxTraining.Text = "Training"
        '
        frmTrainer.GroupBoxModus.Text = "Training Mode"
        frmTrainer.RadioButtonNewWords.Text = "New Words"
        frmTrainer.RadioButtonOldWords.Text = "Known Words"
        frmTrainer.RadioButtonMixed.Text = "Mixed"
        frmTrainer.LabelNumberOfWords.Text = "Number of Words"
        frmTrainer.LabelNumberOfTimes.Text = "Number of Times"
        '
        frmTrainer.GroupBoxUnit.Text = "Learning Unit"
        '
        frmTrainer.ButtonGoOn.Text = "Go on"
        frmTrainer.ButtonCorrect.Text = "right"
        frmTrainer.LabelNumWords.Text = "Words:"
        frmTrainer.LabelHint.Text = "Please pick on the right pendant of the word on top!"
        frmTrainer.RichTextBoxWordInfo.Text = "Word Info"
        frmTrainer.LabelWordState.Text = "State:"
        frmTrainer.LabelWordTimestamp.Text = "Time Stamp:"
        frmTrainer.LabelWordGiven.Text = "Word given"



        ' Modus
        ' Anzahl Woerter
        frmTrainer.RadioButtonNewWords.Checked = True
        frmTrainer.ComboBoxNumberOfWords.Items.Clear()
        frmTrainer.ComboBoxNumberOfWords.Items.Add("6")     ' minimal 6
        frmTrainer.ComboBoxNumberOfWords.Items.Add("8")
        frmTrainer.ComboBoxNumberOfWords.Items.Add("10")
        frmTrainer.ComboBoxNumberOfWords.Items.Add("12")
        frmTrainer.ComboBoxNumberOfWords.Items.Add("14")
        frmTrainer.ComboBoxNumberOfWords.Items.Add("16")
        frmTrainer.ComboBoxNumberOfWords.SelectedIndex = 3
        ' Anzahl Durchlaeufe
        frmTrainer.ComboBoxNumberOfTimes.Items.Clear()
        frmTrainer.ComboBoxNumberOfTimes.Items.Add("2")
        frmTrainer.ComboBoxNumberOfTimes.Items.Add("3")
        frmTrainer.ComboBoxNumberOfTimes.Items.Add("4")
        frmTrainer.ComboBoxNumberOfTimes.Items.Add("5")
        frmTrainer.ComboBoxNumberOfTimes.SelectedIndex = 2


    End Sub

    Private Sub ButtonApply_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonApply.Click
        ' Apply Selection
        Dim selIndex As Integer
        Dim selString As String
        Dim tmpString As String
        Dim i As Integer

        ' Check: Niveaus
        If (CheckBoxA1.Checked = False And CheckBoxA2.Checked = False And
            CheckBoxB1.Checked = False And CheckBoxB2.Checked = False And
            CheckBoxC1.Checked = False And CheckBoxC2.Checked = False And
            CheckBoxEX.Checked = False) Then
            MsgBox("No Niveau selected!", MsgBoxStyle.Information)
            Exit Sub

        End If
        ' Check: Sprachen
        If (ComboBoxFromLang.SelectedIndex = -1 Or ComboBoxToLang.SelectedIndex = -1) Then
            MsgBox("No From or To Language selected!", MsgBoxStyle.Information)
            Exit Sub

        End If

        ' Auswahl: Niveaus
        niveaus(1) = CheckBoxA1.Checked
        niveaus(2) = CheckBoxA2.Checked
        niveaus(3) = CheckBoxB1.Checked
        niveaus(4) = CheckBoxB2.Checked
        niveaus(5) = CheckBoxC1.Checked
        niveaus(6) = CheckBoxC2.Checked
        niveaus(7) = CheckBoxEX.Checked

        ' Auswahl: Sprachen
        languages(1) = ComboBoxFromLang.SelectedIndex
        languages(2) = ComboBoxToLang.SelectedIndex

        ' Extra-Vokabular: Fachbereich
        If (niveaus(7) = True) Then
            ' Auswahl anzeigen
            tmpString = ""
            For i = 1 To 20
                tmpString = tmpString & formatPretty(i, 2) & " " & pubVocExtNames(i) & vbCrLf
            Next
            tmpString = tmpString & " " & vbCrLf
            selIndex = -1
            While (selIndex < 1 Or selIndex > 20)
                selString = InputBox(tmpString, "Choose Technical Subject")
                If (selString = "") Then
                    selIndex = 1
                    Exit While
                End If
                selIndex = Int(Val(selString))
            End While
            ' gewaehlter Fachbereich
            If selIndex = 1 Then techsubj = "EA"
            If selIndex = 2 Then techsubj = "EB"
            If selIndex = 3 Then techsubj = "EC"
            If selIndex = 4 Then techsubj = "ED"
            If selIndex = 5 Then techsubj = "EE"
            If selIndex = 6 Then techsubj = "EG"
            If selIndex = 7 Then techsubj = "EH"
            If selIndex = 8 Then techsubj = "EI"
            If selIndex = 9 Then techsubj = "EJ"
            If selIndex = 10 Then techsubj = "EK"
            If selIndex = 11 Then techsubj = "EL"
            If selIndex = 12 Then techsubj = "EM"
            If selIndex = 13 Then techsubj = "EP"
            If selIndex = 14 Then techsubj = "ER"
            If selIndex = 15 Then techsubj = "ES"
            If selIndex = 16 Then techsubj = "ET"
            If selIndex = 17 Then techsubj = "EU"
            If selIndex = 18 Then techsubj = "EW"
            If selIndex = 19 Then techsubj = "EY"
            If selIndex = 20 Then techsubj = "EZ"
        End If

        ' TrainFile erzeugen bzw. erweitern
        If (RadioButtonNewChoice.Checked = True) Then
            ' Zuruecksetzen
            exniveaus(1) = False
            exniveaus(2) = False
            exniveaus(3) = False
            exniveaus(4) = False
            exniveaus(5) = False
            exniveaus(6) = False
            exniveaus(7) = False
            exWordFrom.Clear()
            exWordTo.Clear()
            exWordCon.Clear()
            exWordSyn.Clear()
            exWordType.Clear()
            exWordTheme.Clear()
            exWordTime.Clear()
            exWordCount.Clear()
            exWordScore.Clear()
            exSelected = 0
            exDone = 0
            exScore = 0
            ' Erzeugen
            Cursor.Current = Cursors.WaitCursor
            generateTrainFile(niveaus, languages, True)
            Cursor.Current = Cursors.Default
            frmTrainer.GroupBoxSelection.Text = "Selection: " & trainFile.Substring(trainFile.LastIndexOf("\") + 1, trainFile.Length - trainFile.LastIndexOf("\") - 1)
            ' Meldung
            MsgBox(exSelected & " Words selected!", MsgBoxStyle.Information, "New Training File")
        ElseIf (RadioButtonAppendChoice.Checked = True) Then
            ' Anhaengen
            Cursor.Current = Cursors.WaitCursor
            appendToTrainFile(niveaus, languages)
            Cursor.Current = Cursors.Default
            ' Meldung
            MsgBox(exSelected & " Words selected!", MsgBoxStyle.Information, "Appended Training File")
        End If

        ' Ergebnisse
        frmTrainer.LabelSelected.Text = exSelected
        frmTrainer.LabelDone.Text = exDone
        frmTrainer.LabelScore.Text = exScore

    End Sub

    Private Sub LabelStaticScore_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles LabelStaticScore.Click
        ' Score of all selected Words
        Dim mediumScore As Integer
        Dim ageStr As String
        Dim infStr As String
        Dim tmpStr As String
        Dim lenFrom, lenTo As Integer
        Dim i As Integer


        ' Bewertung-Mittelwert: bearbeitet
        mediumScore = 0
        For i = 1 To exDone
            mediumScore = mediumScore + exWordScore(i - 1)
        Next
        If (exDone > 0) Then mediumScore = mediumScore / exDone Else mediumScore = 0

        ' Meldung
        infStr = exDone.ToString & " / " & exSelected.ToString & " done"
        tmpStr = vbCrLf & "No.".PadLeft(5, " ") & " " & "From".PadRight(FResults.maxWordLength, " ") & " " & "To".PadRight(FResults.maxWordLength, " ") & " " & "Times".PadLeft(5, " ") & " " & "Score".PadLeft(5, " ") & " " & "Age".PadLeft(5, " ")
        tmpStr = tmpStr & vbCrLf & "-----------------------------------------------------------------------------------------"
        For i = 1 To exSelected
            If (exWordFrom(i - 1).Length < FResults.maxWordLength) Then
                lenFrom = exWordFrom(i - 1).Length
            Else
                lenFrom = FResults.maxWordLength - 1
            End If
            If (exWordTo(i - 1).Length < FResults.maxWordLength) Then
                lenTo = exWordTo(i - 1).Length
            Else
                lenTo = FResults.maxWordLength - 1
            End If
            ' Zeitstempel gegen Jetzt: Alter in Tagen
            If (exWordTime(i - 1) > 0) Then
                ageStr = Math.Round((DateTime.Now.Ticks - exWordTime(i - 1)) / (24 * 60 * 60) / (10000 * 1000)).ToString
            Else
                ageStr = "---"
            End If
            ' i-te Zeile
            tmpStr = tmpStr & vbCrLf & i.ToString.PadLeft(5, " ") & " " & exWordFrom(i - 1).Substring(0, lenFrom).PadRight(FResults.maxWordLength, " ") & " " & exWordTo(i - 1).Substring(0, lenTo).PadRight(FResults.maxWordLength, " ") & " " & _
                                        exWordCount(i - 1).ToString.PadLeft(5, " ") & " " & exWordScore(i - 1).ToString.PadLeft(5, " ") & " " & ageStr.PadLeft(5, " ")
        Next

        ' Anzeige-Fenster
        frmResults = New FResults
        frmResults.Text = "Overall Results"
        frmResults.RichTextBoxResults.Text = "Medium Score: " & mediumScore & "   " & infStr & vbCrLf & tmpStr
        frmResults.Show()

    End Sub

    Private Sub ButtonStart_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonStart.Click
        ' Start Exercise

        ' Check
        If (exSelected = 0) Then
            MsgBox("No Words selected. Load or create a Training File!", MsgBoxStyle.Information, "Training not possible")
            Exit Sub

        End If

        ' Speichern bei Closing
        pubTrainerStart = True

        ' Sichtbarkeit
        frmTrainer.GroupBoxTraining.Enabled = True
        ' Beschraenkung: am Anfang nur neue Woerter
        If (exDone < 16) Then
            RadioButtonNewWords.Enabled = True
            RadioButtonOldWords.Enabled = False
            RadioButtonMixed.Enabled = False
            RadioButtonNewWords.Checked = True
        End If
        ' Beschraenkung: am Ende nur bekannte Woerter
        If (exDone = exSelected) Then
            RadioButtonNewWords.Enabled = False
            RadioButtonOldWords.Enabled = True
            RadioButtonMixed.Enabled = False
            RadioButtonOldWords.Checked = True
        End If

    End Sub

    Private Sub ButtonOK_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonOK.Click
        ' Zustand Speichern
        writeTrainFile(trainFile, niveaus, languages)
        ' Close Window
        Close()

    End Sub

    Private Sub FTrainer_FormClosing(ByVal sender As Object, ByVal e As System.Windows.Forms.FormClosingEventArgs) Handles Me.FormClosing
        ' Zustand Speichern
        If (pubTrainerStart = True) Then
            Cursor.Current = Cursors.WaitCursor
            writeTrainFile(trainFile, niveaus, languages)
            Cursor.Current = Cursors.Default
        End If

    End Sub

    Private Sub RadioButtonNewChoice_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButtonNewChoice.CheckedChanged
        ' Apply Selection New
        Dim reti As Integer
        If (RadioButtonNewChoice.Checked = True) Then
            ' Sichtbarkeit
            frmTrainer.GroupBoxNiveaus.Enabled = True
            frmTrainer.GroupBoxLanguages.Enabled = True
            frmTrainer.ButtonApply.Enabled = True
            ' Datei-Auswahl
            frmEsperanto.SaveFileDialog1.InitialDirectory = Application.StartupPath
            frmEsperanto.SaveFileDialog1.Filter = "*.tml" & "|*.tml"
            frmEsperanto.SaveFileDialog1.Title = "Create New Training"
            frmEsperanto.SaveFileDialog1.FileName = ""
            reti = frmEsperanto.SaveFileDialog1.ShowDialog()
            If (reti = vbCancel) Then
                pubTrainerStart = False
                Exit Sub
            End If
            trainFile = frmEsperanto.SaveFileDialog1.FileName

        End If

    End Sub

    Private Sub RadioButtonAppendChoice_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButtonAppendChoice.CheckedChanged
        ' Apply Selection Append
        Dim reti As Integer
        If (RadioButtonAppendChoice.Checked = True) Then
            ' Sichtbarkeit
            frmTrainer.GroupBoxNiveaus.Enabled = True
            frmTrainer.GroupBoxLanguages.Enabled = False
            frmTrainer.ButtonApply.Enabled = True
            ' Datei-Auswahl
            frmEsperanto.OpenFileDialog1.InitialDirectory = Application.StartupPath
            frmEsperanto.OpenFileDialog1.Filter = "*.tml" & "|*.tml"
            frmEsperanto.OpenFileDialog1.Title = "Open Training to Append"
            frmEsperanto.OpenFileDialog1.FileName = ""
            reti = frmEsperanto.OpenFileDialog1.ShowDialog()
            If (reti = vbCancel) Then
                pubTrainerStart = False
                Exit Sub
            End If
            trainFile = frmEsperanto.OpenFileDialog1.FileName
            ' Zustand Einlesen
            readTrainFile(trainFile)
            frmTrainer.GroupBoxSelection.Text = "Selection: " & trainFile.Substring(trainFile.LastIndexOf("\") + 1, trainFile.Length - trainFile.LastIndexOf("\") - 1)
            ' Niveaus
            niveaus(1) = exniveaus(1)
            niveaus(2) = exniveaus(2)
            niveaus(3) = exniveaus(3)
            niveaus(4) = exniveaus(4)
            niveaus(5) = exniveaus(5)
            niveaus(6) = exniveaus(6)
            niveaus(7) = exniveaus(7)
            frmTrainer.CheckBoxA1.Checked = niveaus(1)
            frmTrainer.CheckBoxA2.Checked = niveaus(2)
            frmTrainer.CheckBoxB1.Checked = niveaus(3)
            frmTrainer.CheckBoxB2.Checked = niveaus(4)
            frmTrainer.CheckBoxC1.Checked = niveaus(5)
            frmTrainer.CheckBoxC2.Checked = niveaus(6)
            frmTrainer.CheckBoxEX.Checked = niveaus(7)
            ' Sprachen
            languages(1) = exlanguages(1)
            languages(2) = exlanguages(2)
            frmTrainer.ComboBoxFromLang.SelectedIndex = languages(1)
            frmTrainer.ComboBoxToLang.SelectedIndex = languages(2)
            ' Ergebnisse
            frmTrainer.LabelSelected.Text = exSelected
            frmTrainer.LabelDone.Text = exDone
            frmTrainer.LabelScore.Text = exScore

        End If

    End Sub

    Private Sub RadioButtonUseChoice_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RadioButtonUseChoice.CheckedChanged
        ' Apply Selection Use
        Dim reti As Integer
        If (RadioButtonUseChoice.Checked = True) Then
            ' Sichtbarkeit
            frmTrainer.GroupBoxNiveaus.Enabled = False
            frmTrainer.GroupBoxLanguages.Enabled = False
            frmTrainer.ButtonApply.Enabled = False
            ' Datei-Auswahl
            frmEsperanto.OpenFileDialog1.InitialDirectory = Application.StartupPath
            frmEsperanto.OpenFileDialog1.Filter = "*.tml" & "|*.tml"
            frmEsperanto.OpenFileDialog1.Title = "Open Training to Use"
            frmEsperanto.OpenFileDialog1.FileName = ""
            reti = frmEsperanto.OpenFileDialog1.ShowDialog()
            pubTrainerStart = True
            If (reti = vbCancel) Then
                pubTrainerStart = False
                Exit Sub
            End If
            trainFile = frmEsperanto.OpenFileDialog1.FileName
            ' Zustand Einlesen
            readTrainFile(trainFile)
            frmTrainer.GroupBoxSelection.Text = "Selection: " & trainFile.Substring(trainFile.LastIndexOf("\") + 1, trainFile.Length - trainFile.LastIndexOf("\") - 1)
            ' Niveaus
            niveaus(1) = exniveaus(1)
            niveaus(2) = exniveaus(2)
            niveaus(3) = exniveaus(3)
            niveaus(4) = exniveaus(4)
            niveaus(5) = exniveaus(5)
            niveaus(6) = exniveaus(6)
            niveaus(7) = exniveaus(7)
            frmTrainer.CheckBoxA1.Checked = niveaus(1)
            frmTrainer.CheckBoxA2.Checked = niveaus(2)
            frmTrainer.CheckBoxB1.Checked = niveaus(3)
            frmTrainer.CheckBoxB2.Checked = niveaus(4)
            frmTrainer.CheckBoxC1.Checked = niveaus(5)
            frmTrainer.CheckBoxC2.Checked = niveaus(6)
            frmTrainer.CheckBoxEX.Checked = niveaus(7)
            ' Sprachen
            languages(1) = exlanguages(1)
            languages(2) = exlanguages(2)
            frmTrainer.ComboBoxFromLang.SelectedIndex = languages(1)
            frmTrainer.ComboBoxToLang.SelectedIndex = languages(2)
            ' Ergebnisse
            frmTrainer.LabelSelected.Text = exSelected
            frmTrainer.LabelDone.Text = exDone
            frmTrainer.LabelScore.Text = exScore

        End If

    End Sub

    Private Function searchTrainFile(ByVal par As Integer) As Boolean
        ' Search for Training File
        Dim searchPath = Application.StartupPath
        Dim dirContents() As String

        ' Training Files suchen
        dirContents = System.IO.Directory.GetFiles(Application.StartupPath)
        searchTrainFile = False
        For i = 1 To dirContents.Count
            If dirContents(i - 1).EndsWith(".tml") Then
                searchTrainFile = True
                Exit For
            End If
        Next

    End Function

    Private Function generateTrainFile(ByVal niveaus() As Boolean, ByVal languages() As Integer, ByVal create As Boolean) As Boolean
        ' Generate new Training File
        Dim nivString As String
        Dim fromString As String
        Dim toString As String
        Dim conString As String
        Dim synString As String
        Dim thmString As String
        Dim tmpString As String
        Dim perString(6) As String
        Dim per1index, per2index As Integer
        Dim i As Integer
        Dim j As Integer

        ' Auswahl
        wordlstcount = exSelected

        ' Pronomen
        For i = 1 To countVocPronomen
            nivString = pubVocabularyPro(i)._NivPronomen.Substring(0, 2)
            'MsgBox((nivString = "A1" And niveaus(1) = True And exniveaus(1) = False).ToString & " " & (nivString = "A2" And niveaus(2) = True And exniveaus(2) = False).ToString & " " & (nivString = "B1" And niveaus(3) = True And exniveaus(3) = False).ToString & " " & (nivString = "B2" And niveaus(4) = True And exniveaus(4) = False).ToString)
            If ((nivString = "A1" And niveaus(1) = True And exniveaus(1) = False) Or _
                (nivString = "A2" And niveaus(2) = True And exniveaus(2) = False) Or _
                (nivString = "B1" And niveaus(3) = True And exniveaus(3) = False) Or _
                (nivString = "B2" And niveaus(4) = True And exniveaus(4) = False) Or _
                (nivString = "C1" And niveaus(5) = True And exniveaus(5) = False) Or _
                (nivString = "C2" And niveaus(6) = True And exniveaus(6) = False) Or _
                (nivString = techsubj And niveaus(7) = True And exniveaus(7) = False)) Then
                ' From and to Word
                fromString = ""
                toString = ""
                tmpString = ""
                For j = 1 To 2
                    If (languages(j) = LangName.Esperanto) Then tmpString = pubVocabularyPro(i)._EspPronomen
                    If (languages(j) = LangName.Deutsch) Then tmpString = pubVocabularyPro(i)._GerPronomen
                    If (languages(j) = LangName.English) Then tmpString = pubVocabularyPro(i)._EngPronomen
                    If (languages(j) = LangName.Francais) Then tmpString = pubVocabularyPro(i)._FraPronomen
                    If (languages(j) = LangName.Espanol) Then tmpString = pubVocabularyPro(i)._SpaPronomen
                    If (languages(j) = LangName.Italiano) Then tmpString = pubVocabularyPro(i)._ItaPronomen
                    If (languages(j) = LangName.Dansk) Then tmpString = pubVocabularyPro(i)._DanPronomen
                    If (languages(j) = LangName.Svenska) Then tmpString = pubVocabularyPro(i)._SwePronomen
                    If (languages(j) = LangName.Portoguese) Then tmpString = pubVocabularyPro(i)._PorPronomen
                    If (languages(j) = LangName.Ellenika) Then tmpString = pubVocabularyPro(i)._GrePronomen
                    If (languages(j) = LangName.Russkij) Then tmpString = pubVocabularyPro(i)._RusPronomen
                    If (languages(j) = LangName.Polski) Then tmpString = pubVocabularyPro(i)._PolPronomen
                    If (languages(j) = LangName.Hrvatski) Then tmpString = pubVocabularyPro(i)._CroPronomen
                    If (languages(j) = LangName.AnyLang) Then tmpString = pubVocabularyPro(i)._AnyPronomen
                    If (j = 1) Then
                        fromString = tmpString
                    ElseIf (j = 2) Then
                        toString = tmpString
                    End If
                Next
                conString = pubVocabularyPro(i)._KonPronomen
                synString = pubVocabularyPro(i)._SynPronomen
                thmString = pubVocabularyPro(i)._ThmPronomen
                ' Leereintraege abweisen
                If (fromString <> "***" And fromString <> "###" And fromString <> "" And toString <> "***" And toString <> "###" And toString <> "") Then
                    ' Word Counter
                    wordlstcount = wordlstcount + 1
                    ' Daten erfassen
                    exWordFrom.Add(fromString)
                    exWordTo.Add(toString)
                    exWordCon.Add(conString)
                    exWordSyn.Add(synString)
                    exWordType.Add("Pronoun")
                    exWordTheme.Add(thmString)
                    exWordTime.Add(0)
                    exWordCount.Add(0)
                    exWordScore.Add(0)
                End If
            End If

        Next

        ' Nomen
        For i = 1 To countVocNomen
            nivString = pubVocabularyNom(i)._NivNomen.Substring(0, 2)
            If ((nivString = "A1" And niveaus(1) = True And exniveaus(1) = False) Or _
                (nivString = "A2" And niveaus(2) = True And exniveaus(2) = False) Or _
                (nivString = "B1" And niveaus(3) = True And exniveaus(3) = False) Or _
                (nivString = "B2" And niveaus(4) = True And exniveaus(4) = False) Or _
                (nivString = "C1" And niveaus(5) = True And exniveaus(5) = False) Or _
                (nivString = "C2" And niveaus(6) = True And exniveaus(6) = False) Or _
                (nivString = techsubj And niveaus(7) = True And exniveaus(7) = False)) Then
                ' From and to Word
                fromString = ""
                toString = ""
                tmpString = ""
                For j = 1 To 2
                    If (languages(j) = LangName.Esperanto) Then tmpString = pubVocabularyNom(i)._EspNomen
                    If (languages(j) = LangName.Deutsch) Then tmpString = pubVocabularyNom(i)._GerNomen
                    If (languages(j) = LangName.English) Then tmpString = pubVocabularyNom(i)._EngNomen
                    If (languages(j) = LangName.Francais) Then tmpString = pubVocabularyNom(i)._FraNomen
                    If (languages(j) = LangName.Espanol) Then tmpString = pubVocabularyNom(i)._SpaNomen
                    If (languages(j) = LangName.Italiano) Then tmpString = pubVocabularyNom(i)._ItaNomen
                    If (languages(j) = LangName.Dansk) Then tmpString = pubVocabularyNom(i)._DanNomen
                    If (languages(j) = LangName.Svenska) Then tmpString = pubVocabularyNom(i)._SweNomen
                    If (languages(j) = LangName.Portoguese) Then tmpString = pubVocabularyNom(i)._PorNomen
                    If (languages(j) = LangName.Ellenika) Then tmpString = pubVocabularyNom(i)._GreNomen
                    If (languages(j) = LangName.Russkij) Then tmpString = pubVocabularyNom(i)._RusNomen
                    If (languages(j) = LangName.Polski) Then tmpString = pubVocabularyNom(i)._PolNomen
                    If (languages(j) = LangName.Hrvatski) Then tmpString = pubVocabularyNom(i)._CroNomen
                    If (languages(j) = LangName.AnyLang) Then tmpString = pubVocabularyNom(i)._AnyNomen
                    If (j = 1) Then
                        fromString = tmpString
                    ElseIf (j = 2) Then
                        toString = tmpString
                    End If
                Next
                conString = pubVocabularyNom(i)._KonNomen
                synString = pubVocabularyNom(i)._SynNomen
                thmString = pubVocabularyNom(i)._ThmNomen
                ' Leereintraege abweisen
                If (fromString <> "***" And fromString <> "###" And fromString <> "" And toString <> "***" And toString <> "###" And toString <> "") Then
                    ' Word Counter
                    wordlstcount = wordlstcount + 1
                    ' Daten erfassen
                    exWordFrom.Add(fromString)
                    exWordTo.Add(toString)
                    exWordCon.Add(conString)
                    exWordSyn.Add(synString)
                    exWordType.Add("Noun")
                    exWordTheme.Add(thmString)
                    exWordTime.Add(0)
                    exWordCount.Add(0)
                    exWordScore.Add(0)
                End If
            End If

        Next

        ' Verben
        For i = 1 To countVocVerb
            nivString = pubVocabularyVer(i)._NivVerb.Substring(0, 2)
            If ((nivString = "A1" And niveaus(1) = True And exniveaus(1) = False) Or _
                (nivString = "A2" And niveaus(2) = True And exniveaus(2) = False) Or _
                (nivString = "B1" And niveaus(3) = True And exniveaus(3) = False) Or _
                (nivString = "B2" And niveaus(4) = True And exniveaus(4) = False) Or _
                (nivString = "C1" And niveaus(5) = True And exniveaus(5) = False) Or _
                (nivString = "C2" And niveaus(6) = True And exniveaus(6) = False) Or _
                (nivString = techsubj And niveaus(7) = True And exniveaus(7) = False)) Then
                ' From and to Word
                fromString = ""
                toString = ""
                tmpString = ""
                For j = 1 To 2
                    If (languages(j) = LangName.Esperanto) Then tmpString = pubVocabularyVer(i)._EspVerb
                    If (languages(j) = LangName.Deutsch) Then tmpString = pubVocabularyVer(i)._GerVerb
                    If (languages(j) = LangName.English) Then tmpString = pubVocabularyVer(i)._EngVerb
                    If (languages(j) = LangName.Francais) Then tmpString = pubVocabularyVer(i)._FraVerb
                    If (languages(j) = LangName.Espanol) Then tmpString = pubVocabularyVer(i)._SpaVerb
                    If (languages(j) = LangName.Italiano) Then tmpString = pubVocabularyVer(i)._ItaVerb
                    If (languages(j) = LangName.Dansk) Then tmpString = pubVocabularyVer(i)._DanVerb
                    If (languages(j) = LangName.Svenska) Then tmpString = pubVocabularyVer(i)._SweVerb
                    If (languages(j) = LangName.Portoguese) Then tmpString = pubVocabularyVer(i)._PorVerb
                    If (languages(j) = LangName.Ellenika) Then tmpString = pubVocabularyVer(i)._GreVerb
                    If (languages(j) = LangName.Russkij) Then tmpString = pubVocabularyVer(i)._RusVerb
                    If (languages(j) = LangName.Polski) Then tmpString = pubVocabularyVer(i)._PolVerb
                    If (languages(j) = LangName.Hrvatski) Then tmpString = pubVocabularyVer(i)._CroVerb
                    If (languages(j) = LangName.AnyLang) Then tmpString = pubVocabularyVer(i)._AnyVerb
                    If (j = 1) Then
                        fromString = tmpString
                    ElseIf (j = 2) Then
                        toString = tmpString
                    End If
                Next
                conString = pubVocabularyVer(i)._KonVerb
                synString = pubVocabularyVer(i)._SynVerb
                thmString = pubVocabularyVer(i)._ThmVerb
                ' Leereintraege abweisen
                If (fromString <> "***" And fromString <> "###" And fromString <> "" And toString <> "***" And toString <> "###" And toString <> "") Then
                    ' Word Counter
                    wordlstcount = wordlstcount + 1
                    ' Daten erfassen
                    exWordFrom.Add(fromString)
                    exWordTo.Add(toString)
                    exWordCon.Add(conString)
                    exWordSyn.Add(synString)
                    exWordType.Add("Verb")
                    exWordTheme.Add(thmString)
                    exWordTime.Add(0)
                    exWordCount.Add(0)
                    exWordScore.Add(0)
                End If
            End If

        Next

        ' Adverben
        For i = 1 To countVocAdverb
            nivString = pubVocabularyAdv(i)._NivAdverb.Substring(0, 2)
            If ((nivString = "A1" And niveaus(1) = True And exniveaus(1) = False) Or _
                (nivString = "A2" And niveaus(2) = True And exniveaus(2) = False) Or _
                (nivString = "B1" And niveaus(3) = True And exniveaus(3) = False) Or _
                (nivString = "B2" And niveaus(4) = True And exniveaus(4) = False) Or _
                (nivString = "C1" And niveaus(5) = True And exniveaus(5) = False) Or _
                (nivString = "C2" And niveaus(6) = True And exniveaus(6) = False) Or _
                (nivString = techsubj And niveaus(7) = True And exniveaus(7) = False)) Then
                ' From and to Word
                fromString = ""
                toString = ""
                tmpString = ""
                For j = 1 To 2
                    If (languages(j) = LangName.Esperanto) Then tmpString = pubVocabularyAdv(i)._EspAdverb
                    If (languages(j) = LangName.Deutsch) Then tmpString = pubVocabularyAdv(i)._GerAdverb
                    If (languages(j) = LangName.English) Then tmpString = pubVocabularyAdv(i)._EngAdverb
                    If (languages(j) = LangName.Francais) Then tmpString = pubVocabularyAdv(i)._FraAdverb
                    If (languages(j) = LangName.Espanol) Then tmpString = pubVocabularyAdv(i)._SpaAdverb
                    If (languages(j) = LangName.Italiano) Then tmpString = pubVocabularyAdv(i)._ItaAdverb
                    If (languages(j) = LangName.Dansk) Then tmpString = pubVocabularyAdv(i)._DanAdverb
                    If (languages(j) = LangName.Svenska) Then tmpString = pubVocabularyAdv(i)._SweAdverb
                    If (languages(j) = LangName.Portoguese) Then tmpString = pubVocabularyAdv(i)._PorAdverb
                    If (languages(j) = LangName.Ellenika) Then tmpString = pubVocabularyAdv(i)._GreAdverb
                    If (languages(j) = LangName.Russkij) Then tmpString = pubVocabularyAdv(i)._RusAdverb
                    If (languages(j) = LangName.Polski) Then tmpString = pubVocabularyAdv(i)._PolAdverb
                    If (languages(j) = LangName.Hrvatski) Then tmpString = pubVocabularyAdv(i)._CroAdverb
                    If (languages(j) = LangName.AnyLang) Then tmpString = pubVocabularyAdv(i)._AnyAdverb
                    If (j = 1) Then
                        fromString = tmpString
                    ElseIf (j = 2) Then
                        toString = tmpString
                    End If
                Next
                conString = pubVocabularyAdv(i)._KonAdverb
                synString = pubVocabularyAdv(i)._SynAdverb
                thmString = pubVocabularyAdv(i)._ThmAdverb
                ' Leereintraege abweisen
                If (fromString <> "***" And fromString <> "###" And fromString <> "" And toString <> "***" And toString <> "###" And toString <> "") Then
                    ' Word Counter
                    wordlstcount = wordlstcount + 1
                    ' Daten erfassen
                    exWordFrom.Add(fromString)
                    exWordTo.Add(toString)
                    exWordCon.Add(conString)
                    exWordSyn.Add(synString)
                    exWordType.Add("Adverb")
                    exWordTheme.Add(thmString)
                    exWordTime.Add(0)
                    exWordCount.Add(0)
                    exWordScore.Add(0)
                End If
            End If

        Next

        ' Adjektive
        For i = 1 To countVocAdjective
            nivString = pubVocabularyAdj(i)._NivAdjective.Substring(0, 2)
            If ((nivString = "A1" And niveaus(1) = True And exniveaus(1) = False) Or _
                (nivString = "A2" And niveaus(2) = True And exniveaus(2) = False) Or _
                (nivString = "B1" And niveaus(3) = True And exniveaus(3) = False) Or _
                (nivString = "B2" And niveaus(4) = True And exniveaus(4) = False) Or _
                (nivString = "C1" And niveaus(5) = True And exniveaus(5) = False) Or _
                (nivString = "C2" And niveaus(6) = True And exniveaus(6) = False) Or _
                (nivString = techsubj And niveaus(7) = True And exniveaus(7) = False)) Then
                ' From and to Word
                fromString = ""
                toString = ""
                tmpString = ""
                For j = 1 To 2
                    If (languages(j) = LangName.Esperanto) Then tmpString = pubVocabularyAdj(i)._EspAdjective
                    If (languages(j) = LangName.Deutsch) Then tmpString = pubVocabularyAdj(i)._GerAdjective
                    If (languages(j) = LangName.English) Then tmpString = pubVocabularyAdj(i)._EngAdjective
                    If (languages(j) = LangName.Francais) Then tmpString = pubVocabularyAdj(i)._FraAdjective
                    If (languages(j) = LangName.Espanol) Then tmpString = pubVocabularyAdj(i)._SpaAdjective
                    If (languages(j) = LangName.Italiano) Then tmpString = pubVocabularyAdj(i)._ItaAdjective
                    If (languages(j) = LangName.Dansk) Then tmpString = pubVocabularyAdj(i)._DanAdjective
                    If (languages(j) = LangName.Svenska) Then tmpString = pubVocabularyAdj(i)._SweAdjective
                    If (languages(j) = LangName.Portoguese) Then tmpString = pubVocabularyAdj(i)._PorAdjective
                    If (languages(j) = LangName.Ellenika) Then tmpString = pubVocabularyAdj(i)._GreAdjective
                    If (languages(j) = LangName.Russkij) Then tmpString = pubVocabularyAdj(i)._RusAdjective
                    If (languages(j) = LangName.Polski) Then tmpString = pubVocabularyAdj(i)._PolAdjective
                    If (languages(j) = LangName.Hrvatski) Then tmpString = pubVocabularyAdj(i)._CroAdjective
                    If (languages(j) = LangName.AnyLang) Then tmpString = pubVocabularyAdj(i)._AnyAdjective
                    If (j = 1) Then
                        fromString = tmpString
                    ElseIf (j = 2) Then
                        toString = tmpString
                    End If
                Next
                conString = pubVocabularyAdj(i)._KonAdjective
                synString = pubVocabularyAdj(i)._SynAdjective
                thmString = pubVocabularyAdj(i)._ThmAdjective
                ' Leereintraege abweisen
                If (fromString <> "***" And fromString <> "###" And fromString <> "" And toString <> "***" And toString <> "###" And toString <> "") Then
                    ' Word Counter
                    wordlstcount = wordlstcount + 1
                    ' Daten erfassen
                    exWordFrom.Add(fromString)
                    exWordTo.Add(toString)
                    exWordCon.Add(conString)
                    exWordSyn.Add(synString)
                    exWordType.Add("Adjective")
                    exWordTheme.Add(thmString)
                    exWordTime.Add(0)
                    exWordCount.Add(0)
                    exWordScore.Add(0)
                End If
            End If

        Next

        ' Preapositionen
        For i = 1 To countVocPreposition
            nivString = pubVocabularyPre(i)._NivPreposition.Substring(0, 2)
            If ((nivString = "A1" And niveaus(1) = True And exniveaus(1) = False) Or _
                (nivString = "A2" And niveaus(2) = True And exniveaus(2) = False) Or _
                (nivString = "B1" And niveaus(3) = True And exniveaus(3) = False) Or _
                (nivString = "B2" And niveaus(4) = True And exniveaus(4) = False) Or _
                (nivString = "C1" And niveaus(5) = True And exniveaus(5) = False) Or _
                (nivString = "C2" And niveaus(6) = True And exniveaus(6) = False) Or _
                (nivString = techsubj And niveaus(7) = True And exniveaus(7) = False)) Then
                ' From and to Word
                fromString = ""
                toString = ""
                tmpString = ""
                For j = 1 To 2
                    If (languages(j) = LangName.Esperanto) Then tmpString = pubVocabularyPre(i)._EspPreposition
                    If (languages(j) = LangName.Deutsch) Then tmpString = pubVocabularyPre(i)._GerPreposition
                    If (languages(j) = LangName.English) Then tmpString = pubVocabularyPre(i)._EngPreposition
                    If (languages(j) = LangName.Francais) Then tmpString = pubVocabularyPre(i)._FraPreposition
                    If (languages(j) = LangName.Espanol) Then tmpString = pubVocabularyPre(i)._SpaPreposition
                    If (languages(j) = LangName.Italiano) Then tmpString = pubVocabularyPre(i)._ItaPreposition
                    If (languages(j) = LangName.Dansk) Then tmpString = pubVocabularyPre(i)._DanPreposition
                    If (languages(j) = LangName.Svenska) Then tmpString = pubVocabularyPre(i)._SwePreposition
                    If (languages(j) = LangName.Portoguese) Then tmpString = pubVocabularyPre(i)._PorPreposition
                    If (languages(j) = LangName.Ellenika) Then tmpString = pubVocabularyPre(i)._GrePreposition
                    If (languages(j) = LangName.Russkij) Then tmpString = pubVocabularyPre(i)._RusPreposition
                    If (languages(j) = LangName.Polski) Then tmpString = pubVocabularyPre(i)._PolPreposition
                    If (languages(j) = LangName.Hrvatski) Then tmpString = pubVocabularyPre(i)._CroPreposition
                    If (languages(j) = LangName.AnyLang) Then tmpString = pubVocabularyPre(i)._AnyPreposition
                    If (j = 1) Then
                        fromString = tmpString
                    ElseIf (j = 2) Then
                        toString = tmpString
                    End If
                Next
                conString = pubVocabularyPre(i)._KonPreposition
                synString = pubVocabularyPre(i)._SynPreposition
                thmString = pubVocabularyPre(i)._ThmPreposition
                ' Leereintraege abweisen
                If (fromString <> "***" And fromString <> "###" And fromString <> "" And toString <> "***" And toString <> "###" And toString <> "") Then
                    ' Word Counter
                    wordlstcount = wordlstcount + 1
                    ' Daten erfassen
                    exWordFrom.Add(fromString)
                    exWordTo.Add(toString)
                    exWordCon.Add(conString)
                    exWordSyn.Add(synString)
                    exWordType.Add("Preposition")
                    exWordTheme.Add(thmString)
                    exWordTime.Add(0)
                    exWordCount.Add(0)
                    exWordScore.Add(0)
                End If
            End If

        Next

        ' Partikel
        For i = 1 To countVocParticle
            nivString = pubVocabularyPar(i)._NivParticle.Substring(0, 2)
            If ((nivString = "A1" And niveaus(1) = True And exniveaus(1) = False) Or _
                (nivString = "A2" And niveaus(2) = True And exniveaus(2) = False) Or _
                (nivString = "B1" And niveaus(3) = True And exniveaus(3) = False) Or _
                (nivString = "B2" And niveaus(4) = True And exniveaus(4) = False) Or _
                (nivString = "C1" And niveaus(5) = True And exniveaus(5) = False) Or _
                (nivString = "C2" And niveaus(6) = True And exniveaus(6) = False) Or _
                (nivString = techsubj And niveaus(7) = True And exniveaus(7) = False)) Then
                ' From and to Word
                fromString = ""
                toString = ""
                tmpString = ""
                For j = 1 To 2
                    If (languages(j) = LangName.Esperanto) Then tmpString = pubVocabularyPar(i)._EspParticle
                    If (languages(j) = LangName.Deutsch) Then tmpString = pubVocabularyPar(i)._GerParticle
                    If (languages(j) = LangName.English) Then tmpString = pubVocabularyPar(i)._EngParticle
                    If (languages(j) = LangName.Francais) Then tmpString = pubVocabularyPar(i)._FraParticle
                    If (languages(j) = LangName.Espanol) Then tmpString = pubVocabularyPar(i)._SpaParticle
                    If (languages(j) = LangName.Italiano) Then tmpString = pubVocabularyPar(i)._ItaParticle
                    If (languages(j) = LangName.Dansk) Then tmpString = pubVocabularyPar(i)._DanParticle
                    If (languages(j) = LangName.Svenska) Then tmpString = pubVocabularyPar(i)._SweParticle
                    If (languages(j) = LangName.Portoguese) Then tmpString = pubVocabularyPar(i)._PorParticle
                    If (languages(j) = LangName.Ellenika) Then tmpString = pubVocabularyPar(i)._GreParticle
                    If (languages(j) = LangName.Russkij) Then tmpString = pubVocabularyPar(i)._RusParticle
                    If (languages(j) = LangName.Polski) Then tmpString = pubVocabularyPar(i)._PolParticle
                    If (languages(j) = LangName.Hrvatski) Then tmpString = pubVocabularyPar(i)._CroParticle
                    If (languages(j) = LangName.AnyLang) Then tmpString = pubVocabularyPar(i)._AnyParticle
                    If (j = 1) Then
                        fromString = tmpString
                    ElseIf (j = 2) Then
                        toString = tmpString
                    End If
                Next
                conString = pubVocabularyPar(i)._KonParticle
                synString = pubVocabularyPar(i)._SynParticle
                thmString = pubVocabularyPar(i)._ThmParticle
                ' Leereintraege abweisen
                If (fromString <> "***" And fromString <> "###" And fromString <> "" And toString <> "***" And toString <> "###" And toString <> "") Then
                    ' Word Counter
                    wordlstcount = wordlstcount + 1
                    ' Daten erfassen
                    exWordFrom.Add(fromString)
                    exWordTo.Add(toString)
                    exWordCon.Add(conString)
                    exWordSyn.Add(synString)
                    exWordType.Add("Particle")
                    exWordTheme.Add(thmString)
                    exWordTime.Add(0)
                    exWordCount.Add(0)
                    exWordScore.Add(0)
                End If
            End If

        Next

        ' Konjunktionen
        For i = 1 To countVocJunction
            nivString = pubVocabularyJun(i)._NivJunction.Substring(0, 2)
            If ((nivString = "A1" And niveaus(1) = True And exniveaus(1) = False) Or _
                (nivString = "A2" And niveaus(2) = True And exniveaus(2) = False) Or _
                (nivString = "B1" And niveaus(3) = True And exniveaus(3) = False) Or _
                (nivString = "B2" And niveaus(4) = True And exniveaus(4) = False) Or _
                (nivString = "C1" And niveaus(5) = True And exniveaus(5) = False) Or _
                (nivString = "C2" And niveaus(6) = True And exniveaus(6) = False) Or _
                (nivString = techsubj And niveaus(7) = True And exniveaus(7) = False)) Then
                ' From and to Word
                fromString = ""
                toString = ""
                tmpString = ""
                For j = 1 To 2
                    If (languages(j) = LangName.Esperanto) Then tmpString = pubVocabularyJun(i)._EspJunction
                    If (languages(j) = LangName.Deutsch) Then tmpString = pubVocabularyJun(i)._GerJunction
                    If (languages(j) = LangName.English) Then tmpString = pubVocabularyJun(i)._EngJunction
                    If (languages(j) = LangName.Francais) Then tmpString = pubVocabularyJun(i)._FraJunction
                    If (languages(j) = LangName.Espanol) Then tmpString = pubVocabularyJun(i)._SpaJunction
                    If (languages(j) = LangName.Italiano) Then tmpString = pubVocabularyJun(i)._ItaJunction
                    If (languages(j) = LangName.Dansk) Then tmpString = pubVocabularyJun(i)._DanJunction
                    If (languages(j) = LangName.Svenska) Then tmpString = pubVocabularyJun(i)._SweJunction
                    If (languages(j) = LangName.Portoguese) Then tmpString = pubVocabularyJun(i)._PorJunction
                    If (languages(j) = LangName.Ellenika) Then tmpString = pubVocabularyJun(i)._GreJunction
                    If (languages(j) = LangName.Russkij) Then tmpString = pubVocabularyJun(i)._RusJunction
                    If (languages(j) = LangName.Polski) Then tmpString = pubVocabularyJun(i)._PolJunction
                    If (languages(j) = LangName.Hrvatski) Then tmpString = pubVocabularyJun(i)._CroJunction
                    If (languages(j) = LangName.AnyLang) Then tmpString = pubVocabularyJun(i)._AnyJunction
                    If (j = 1) Then
                        fromString = tmpString
                    ElseIf (j = 2) Then
                        toString = tmpString
                    End If
                Next
                conString = pubVocabularyJun(i)._KonJunction
                synString = pubVocabularyJun(i)._SynJunction
                thmString = pubVocabularyJun(i)._ThmJunction
                ' Leereintraege abweisen
                If (fromString <> "***" And fromString <> "###" And fromString <> "" And toString <> "***" And toString <> "###" And toString <> "") Then
                    ' Word Counter
                    wordlstcount = wordlstcount + 1
                    ' Daten erfassen
                    exWordFrom.Add(fromString)
                    exWordTo.Add(toString)
                    exWordCon.Add(conString)
                    exWordSyn.Add(synString)
                    exWordType.Add("Junction")
                    exWordTheme.Add(thmString)
                    exWordTime.Add(0)
                    exWordCount.Add(0)
                    exWordScore.Add(0)
                End If
            End If

        Next

        ' Permutation ggf. nur fuer zusaetzliche Woerter (ohne 0-Werte)
        For i = 1 To (wordlstcount - exSelected) * 2
            ' Auslosen der Tauschpartner
            per1index = exSelected + Math.Floor(Rnd() * (wordlstcount - exSelected)) + 1
            per2index = exSelected + Math.Floor(Rnd() * (wordlstcount - exSelected)) + 1
            ' 2er-Tausch
            perString(1) = exWordFrom(per1index - 1)
            perString(2) = exWordTo(per1index - 1)
            perString(3) = exWordCon(per1index - 1)
            perString(4) = exWordSyn(per1index - 1)
            perString(5) = exWordType(per1index - 1)
            perString(6) = exWordTheme(per1index - 1)
            exWordFrom(per1index - 1) = exWordFrom(per2index - 1)
            exWordTo(per1index - 1) = exWordTo(per2index - 1)
            exWordCon(per1index - 1) = exWordCon(per2index - 1)
            exWordSyn(per1index - 1) = exWordSyn(per2index - 1)
            exWordType(per1index - 1) = exWordType(per2index - 1)
            exWordTheme(per1index - 1) = exWordTheme(per2index - 1)
            exWordFrom(per2index - 1) = perString(1)
            exWordTo(per2index - 1) = perString(2)
            exWordCon(per2index - 1) = perString(3)
            exWordSyn(per2index - 1) = perString(4)
            exWordType(per2index - 1) = perString(5)
            exWordTheme(per2index - 1) = perString(6)
        Next

        ' Anzahl selektierter Worte
        exSelected = wordlstcount

        ' Schreiben
        writeTrainFile(trainFile, niveaus, languages)


        ' Rueckgabe
        generateTrainFile = True

    End Function

    Private Function appendToTrainFile(ByVal niveaus() As Boolean, ByVal languages() As Integer) As Boolean
        ' Append to Training File

        ' Lesen
        readTrainFile(trainFile)

        ' Auswahl
        generateTrainFile(niveaus, languages, False)

        ' Vereinigung
        niveaus(1) = niveaus(1) Or exniveaus(1)
        niveaus(2) = niveaus(2) Or exniveaus(2)
        niveaus(3) = niveaus(3) Or exniveaus(3)
        niveaus(4) = niveaus(4) Or exniveaus(4)
        niveaus(5) = niveaus(5) Or exniveaus(5)
        niveaus(6) = niveaus(6) Or exniveaus(6)
        niveaus(7) = niveaus(7) Or exniveaus(7)

        ' Schreiben
        writeTrainFile(trainFile, niveaus, languages)


        ' Rueckgabe
        appendToTrainFile = True

    End Function

    Private Function readTrainFile(ByVal trainFile As String) As Boolean
        ' Read Training File to Use
        Dim trainDOM As New XmlDocument
        Dim data00DOM As XmlNodeList
        Dim data01DOM As XmlNodeList
        Dim data02DOM As XmlNodeList
        Dim data03DOM As XmlNodeList
        Dim data04DOM As XmlNodeList
        Dim data05DOM As XmlNodeList
        Dim data06DOM As XmlNodeList
        Dim data07DOM As XmlNodeList
        Dim data08DOM As XmlNodeList
        Dim data09DOM As XmlNodeList
        Dim results As String
        Dim selects As String
        Dim wordlst As String

        Dim i As Integer

        ' Init Rueckgabe
        readTrainFile = False


        ' Datei-Zugriff
        Try
            trainDOM.Load(trainFile)
        Catch
            MsgBox("File " & trainFile & " could not be read (XML Syntax: " & Err.Description & ")!", vbCritical, "Grammar Parser")
            Exit Function

        End Try


        ' Zuruecksetzen
        exWordFrom.Clear()
        exWordTo.Clear()
        exWordCon.Clear()
        exWordSyn.Clear()
        exWordType.Clear()
        exWordTheme.Clear()
        exWordTime.Clear()
        exWordCount.Clear()
        exWordScore.Clear()
        'Application.DoEvents()


        ' Parsen
        Try

            ' Ergebnisse
            data00DOM = trainDOM.GetElementsByTagName("Results")
            results = data00DOM.Item(0).InnerText
            data01DOM = trainDOM.GetElementsByTagName("Selected")
            exSelected = data01DOM.Item(0).InnerText
            data02DOM = trainDOM.GetElementsByTagName("Done")
            exDone = data02DOM.Item(0).InnerText
            data03DOM = trainDOM.GetElementsByTagName("Score")
            exScore = data03DOM.Item(0).InnerText

            data00DOM = Nothing
            data01DOM = Nothing
            data02DOM = Nothing
            data03DOM = Nothing

            ' Auswahl
            data00DOM = trainDOM.GetElementsByTagName("Selections")
            selects = data00DOM.Item(0).InnerText
            data01DOM = trainDOM.GetElementsByTagName("NiveauA1")
            exniveaus(1) = data01DOM.Item(0).InnerText
            data02DOM = trainDOM.GetElementsByTagName("NiveauA2")
            exniveaus(2) = data02DOM.Item(0).InnerText
            data03DOM = trainDOM.GetElementsByTagName("NiveauB1")
            exniveaus(3) = data03DOM.Item(0).InnerText
            data04DOM = trainDOM.GetElementsByTagName("NiveauB2")
            exniveaus(4) = data04DOM.Item(0).InnerText
            data07DOM = trainDOM.GetElementsByTagName("NiveauC1")
            exniveaus(5) = data07DOM.Item(0).InnerText
            data08DOM = trainDOM.GetElementsByTagName("NiveauC2")
            exniveaus(6) = data08DOM.Item(0).InnerText
            data09DOM = trainDOM.GetElementsByTagName("NiveauEX")
            exniveaus(7) = data09DOM.Item(0).InnerText
            data05DOM = trainDOM.GetElementsByTagName("FromLang")
            exlanguages(1) = data05DOM.Item(0).InnerText
            data06DOM = trainDOM.GetElementsByTagName("ToLang")
            exlanguages(2) = data06DOM.Item(0).InnerText

            data00DOM = Nothing
            data01DOM = Nothing
            data02DOM = Nothing
            data03DOM = Nothing
            data04DOM = Nothing
            data05DOM = Nothing
            data06DOM = Nothing
            data07DOM = Nothing
            data08DOM = Nothing
            data09DOM = Nothing

            ' Wortliste
            data00DOM = trainDOM.GetElementsByTagName("Wordlist")
            wordlst = data00DOM.Item(0).InnerText
            data01DOM = trainDOM.GetElementsByTagName("WordFrom")
            wordlstcount = data01DOM.Count
            data02DOM = trainDOM.GetElementsByTagName("WordTo")
            wordlstcount = data02DOM.Count
            data03DOM = trainDOM.GetElementsByTagName("WordCon")
            wordlstcount = data03DOM.Count
            data04DOM = trainDOM.GetElementsByTagName("WordSyn")
            wordlstcount = data04DOM.Count
            data05DOM = trainDOM.GetElementsByTagName("WordType")
            wordlstcount = data05DOM.Count
            data09DOM = trainDOM.GetElementsByTagName("WordTheme")
            wordlstcount = data09DOM.Count
            data06DOM = trainDOM.GetElementsByTagName("WordTime")
            wordlstcount = data06DOM.Count
            data07DOM = trainDOM.GetElementsByTagName("WordCount")
            wordlstcount = data07DOM.Count
            data08DOM = trainDOM.GetElementsByTagName("WordScore")
            wordlstcount = data08DOM.Count
            For i = 1 To wordlstcount
                exWordFrom.Add(data01DOM.Item(i - 1).InnerText)
                exWordTo.Add(data02DOM.Item(i - 1).InnerText)
                exWordCon.Add(data03DOM.Item(i - 1).InnerText)
                exWordSyn.Add(data04DOM.Item(i - 1).InnerText)
                exWordType.Add(data05DOM.Item(i - 1).InnerText)
                exWordTheme.Add(data09DOM.Item(i - 1).InnerText)
                exWordTime.Add(Val(data06DOM.Item(i - 1).InnerText))
                exWordCount.Add(Val(data07DOM.Item(i - 1).InnerText))
                exWordScore.Add(Val(data08DOM.Item(i - 1).InnerText))
            Next

            data00DOM = Nothing
            data01DOM = Nothing
            data02DOM = Nothing
            data03DOM = Nothing
            data04DOM = Nothing
            data05DOM = Nothing
            data06DOM = Nothing
            data07DOM = Nothing
            data08DOM = Nothing
            data09DOM = Nothing

        Catch
            MsgBox("File " & trainFile & " could not be read (Grammatic Elements: " & Err.Description & ")!", vbCritical, "Grammar Parser")
            Exit Function

        End Try

        ' Rueckgabe
        readTrainFile = True

    End Function

    Private Function writeTrainFile(ByVal trainFile As String, ByVal niveaus() As Boolean, ByVal languages() As Integer) As Boolean
        ' Write Training File
        Dim trainDOM As New XmlDocument
        Dim data00DOM
        Dim data01DOM
        Dim data02DOM
        Dim root
        Dim node
        Dim node0
        Dim frag
        Dim elem
        Dim attr
        'Dim fid As Integer
        Dim i As Integer

        ' DOM-Baum Training File erzeugen
        ' Header - wichtig: UTF-8
        data00DOM = trainDOM.CreateXmlDeclaration("1.0", "UTF-8", "yes")
        trainDOM.AppendChild(data00DOM)
        data01DOM = trainDOM.CreateComment("Esperanto: Training")
        data02DOM = trainDOM.CreateComment("Esperanto: exercise")
        trainDOM.AppendChild(data01DOM)
        trainDOM.AppendChild(data02DOM)
        ' Wurzel-Element
        root = trainDOM.CreateElement("Esperanto")
        attr = trainDOM.CreateAttribute("xmlns:esp")
        attr.Value = "http://www.esperanto.de"
        root.setAttributeNode(attr)
        trainDOM.AppendChild(root)
        ' Ergebnisse
        root.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab))
        node = trainDOM.CreateElement("Results")
        ' ... gewaehlt
        frag = trainDOM.CreateDocumentFragment
        frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
        elem = trainDOM.CreateElement("Selected")
        elem.appendChild(trainDOM.CreateTextNode(exSelected))
        frag.appendChild(elem)
        node.appendChild(frag)
        ' ... bearbeitet
        frag = trainDOM.CreateDocumentFragment
        frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
        elem = trainDOM.CreateElement("Done")
        elem.appendChild(trainDOM.CreateTextNode(exDone))
        frag.appendChild(elem)
        node.appendChild(frag)
        ' ... Wertung
        frag = trainDOM.CreateDocumentFragment
        frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
        elem = trainDOM.CreateElement("Score")
        elem.appendChild(trainDOM.CreateTextNode(exScore))
        frag.appendChild(elem)
        node.appendChild(frag)
        ' ... Ende Ergebnisse
        node.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab))
        root.appendChild(node)
        ' Auswahl
        root.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab))
        node = trainDOM.CreateElement("Selections")
        ' ... Niveau A1
        frag = trainDOM.CreateDocumentFragment
        frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
        elem = trainDOM.CreateElement("NiveauA1")
        elem.appendChild(trainDOM.CreateTextNode(niveaus(1)))
        frag.appendChild(elem)
        node.appendChild(frag)
        ' ... Niveau A2
        frag = trainDOM.CreateDocumentFragment
        frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
        elem = trainDOM.CreateElement("NiveauA2")
        elem.appendChild(trainDOM.CreateTextNode(niveaus(2)))
        frag.appendChild(elem)
        node.appendChild(frag)
        ' ... Niveau B1
        frag = trainDOM.CreateDocumentFragment
        frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
        elem = trainDOM.CreateElement("NiveauB1")
        elem.appendChild(trainDOM.CreateTextNode(niveaus(3)))
        frag.appendChild(elem)
        node.appendChild(frag)
        ' ... Niveau B2
        frag = trainDOM.CreateDocumentFragment
        frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
        elem = trainDOM.CreateElement("NiveauB2")
        elem.appendChild(trainDOM.CreateTextNode(niveaus(4)))
        frag.appendChild(elem)
        node.appendChild(frag)
        ' ... Niveau C1
        frag = trainDOM.CreateDocumentFragment
        frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
        elem = trainDOM.CreateElement("NiveauC1")
        elem.appendChild(trainDOM.CreateTextNode(niveaus(5)))
        frag.appendChild(elem)
        node.appendChild(frag)
        ' ... Niveau C2
        frag = trainDOM.CreateDocumentFragment
        frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
        elem = trainDOM.CreateElement("NiveauC2")
        elem.appendChild(trainDOM.CreateTextNode(niveaus(6)))
        frag.appendChild(elem)
        node.appendChild(frag)
        ' ... Niveau EX
        frag = trainDOM.CreateDocumentFragment
        frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
        elem = trainDOM.CreateElement("NiveauEX")
        elem.appendChild(trainDOM.CreateTextNode(niveaus(7)))
        frag.appendChild(elem)
        node.appendChild(frag)
        ' ... Sprache von
        frag = trainDOM.CreateDocumentFragment
        frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
        elem = trainDOM.CreateElement("FromLang")
        elem.appendChild(trainDOM.CreateTextNode(languages(1)))
        frag.appendChild(elem)
        node.appendChild(frag)
        ' ... Sprache nach
        frag = trainDOM.CreateDocumentFragment
        frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
        elem = trainDOM.CreateElement("ToLang")
        elem.appendChild(trainDOM.CreateTextNode(languages(2)))
        frag.appendChild(elem)
        node.appendChild(frag)
        ' ... Ende Auswahl
        node.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab))
        root.appendChild(node)
        ' Wortliste
        node = trainDOM.CreateElement("Wordlist")
        root.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab))
        ' Woerter
        For i = 1 To wordlstcount
            ' Wort
            node.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            node0 = trainDOM.CreateElement("Word")
            ' ... Wort-von
            frag = trainDOM.CreateDocumentFragment
            frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab + vbTab))
            elem = trainDOM.CreateElement("WordFrom")
            elem.appendChild(trainDOM.CreateTextNode(exWordFrom(i - 1)))
            frag.appendChild(elem)
            node0.appendChild(frag)
            ' ... Wort-nach
            frag = trainDOM.CreateDocumentFragment
            frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab + vbTab))
            elem = trainDOM.CreateElement("WordTo")
            elem.appendChild(trainDOM.CreateTextNode(exWordTo(i - 1)))
            frag.appendChild(elem)
            node0.appendChild(frag)
            ' ... Wort-Kontext
            frag = trainDOM.CreateDocumentFragment
            frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab + vbTab))
            elem = trainDOM.CreateElement("WordCon")
            elem.appendChild(trainDOM.CreateTextNode(exWordCon(i - 1)))
            frag.appendChild(elem)
            node0.appendChild(frag)
            ' ... Wort-Synonym
            frag = trainDOM.CreateDocumentFragment
            frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab + vbTab))
            elem = trainDOM.CreateElement("WordSyn")
            elem.appendChild(trainDOM.CreateTextNode(exWordSyn(i - 1)))
            frag.appendChild(elem)
            node0.appendChild(frag)
            ' ... Wort-Typ
            frag = trainDOM.CreateDocumentFragment
            frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab + vbTab))
            elem = trainDOM.CreateElement("WordType")
            elem.appendChild(trainDOM.CreateTextNode(exWordType(i - 1)))
            frag.appendChild(elem)
            node0.appendChild(frag)
            ' ... Wort-Thema
            frag = trainDOM.CreateDocumentFragment
            frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab + vbTab))
            elem = trainDOM.CreateElement("WordTheme")
            elem.appendChild(trainDOM.CreateTextNode(exWordTheme(i - 1)))
            frag.appendChild(elem)
            node0.appendChild(frag)
            ' ... Wort-Zeitstempel
            frag = trainDOM.CreateDocumentFragment
            frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab + vbTab))
            elem = trainDOM.CreateElement("WordTime")
            elem.appendChild(trainDOM.CreateTextNode(exWordTime(i - 1)))
            frag.appendChild(elem)
            node0.appendChild(frag)
            ' ... Wort-Benutzung
            frag = trainDOM.CreateDocumentFragment
            frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab + vbTab))
            elem = trainDOM.CreateElement("WordCount")
            elem.appendChild(trainDOM.CreateTextNode(exWordCount(i - 1)))
            frag.appendChild(elem)
            node0.appendChild(frag)
            ' ... Wort-Bewertung
            frag = trainDOM.CreateDocumentFragment
            frag.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab + vbTab))
            elem = trainDOM.CreateElement("WordScore")
            elem.appendChild(trainDOM.CreateTextNode(exWordScore(i - 1)))
            frag.appendChild(elem)
            node0.appendChild(frag)
            ' ... Ende Wort
            node0.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab + vbTab))
            node.appendChild(node0)
        Next
        ' Ende Wortliste
        node.appendChild(trainDOM.CreateTextNode(vbNewLine + vbTab))
        root.appendChild(node)
        ' Ende Wurzel-Element
        root.appendChild(trainDOM.CreateTextNode(vbNewLine))

        ' Freigeben
        attr = Nothing
        elem = Nothing
        frag = Nothing
        node0 = Nothing
        node = Nothing
        root = Nothing
        data00DOM = Nothing
        data01DOM = Nothing
        data02DOM = Nothing

        ' Zugriff: DOM-Baum speichern
        trainDOM.Save(trainFile)


        'fid = FreeFile()
        'FileOpen(fid, trainFile, OpenMode.Output)
        'PrintLine(fid, "<?xml version='1.0'?>")
        'PrintLine(fid, "<!--Esperanto: Training-->")
        'PrintLine(fid, "<!--Esperanto: exercise-->")
        'PrintLine(fid, "<Esperanto xmlns:esp='http://www.esperanto.de'>")
        'PrintLine(fid, "	<Results>")
        'PrintLine(fid, "	    <Selected>" & exSelected & "</Selected>")
        'PrintLine(fid, "	    <Done>" & exDone & "</Done>")
        'PrintLine(fid, "	    <Score>" & exScore & "</Score>")
        'PrintLine(fid, "	</Results>")
        'PrintLine(fid, "	<Selections>")
        'PrintLine(fid, "	    <NiveauA1>" & niveaus(1) & "</NiveauA1>")
        'PrintLine(fid, "	    <NiveauA2>" & niveaus(2) & "</NiveauA2>")
        'PrintLine(fid, "	    <NiveauB1>" & niveaus(3) & "</NiveauB1>")
        'PrintLine(fid, "	    <NiveauB2>" & niveaus(4) & "</NiveauB2>")
        'PrintLine(fid, "	    <NiveauC1>" & niveaus(5) & "</NiveauC1>")
        'PrintLine(fid, "	    <NiveauC2>" & niveaus(6) & "</NiveauC2>")
        'PrintLine(fid, "	    <NiveauEX>" & niveaus(7) & "</NiveauEX>")
        'PrintLine(fid, "	    <FromLang>" & languages(1) & "</FromLang>")
        'PrintLine(fid, "	    <ToLang>" & languages(2) & "</ToLang>")
        'PrintLine(fid, "	</Selections>")
        'PrintLine(fid, "	<Wordlist>")
        'For i = 1 To wordlstcount
        '    PrintLine(fid, "	    <Word>")
        '    PrintLine(fid, "	        <WordFrom>" & exWordFrom(i - 1) & "</WordFrom>")
        '    PrintLine(fid, "	        <WordTo>" & exWordTo(i - 1) & "</WordTo>")
        '    PrintLine(fid, "	        <WordCon>" & exWordCon(i - 1) & "</WordCon>")
        '    PrintLine(fid, "	        <WordSyn>" & exWordSyn(i - 1) & "</WordSyn>")
        '    PrintLine(fid, "	        <WordType>" & exWordType(i - 1) & "</WordType>")
        '    PrintLine(fid, "	        <WordTheme>" & exWordTheme(i - 1) & "</WordTheme>")
        '    PrintLine(fid, "	        <WordTime>" & exWordTime(i - 1) & "</WordTime>")
        '    PrintLine(fid, "	        <WordCount>" & exWordCount(i - 1) & "</WordCount>")
        '    PrintLine(fid, "	        <WordScore>" & exWordScore(i - 1) & "</WordScore>")
        '    PrintLine(fid, "	    </Word>")
        'Next
        'PrintLine(fid, "	</Wordlist>")
        'PrintLine(fid, "</Esperanto>")

        'FileClose(fid)

        ' Rueckgabe
        writeTrainFile = True

    End Function

    Private Sub ButtonStartUnit_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonStartUnit.Click
        ' Start Learning Unit
        Dim trainMode As Integer
        Dim numWords As Integer
        Dim numTimes As Integer
        Dim takenWords As Integer
        Dim currIndex As Integer
        Dim objDate As Date
        Dim i, j As Integer

        ' Check: Pause
        If (pubPause = True) Then
            MsgBox("Please click on the red TextLabel to end Pause and continue the current Learning Unit!", MsgBoxStyle.Information, "Pause On")
        End If

        ' Modus
        If (RadioButtonNewWords.Checked = True) Then
            trainMode = 1
        ElseIf (RadioButtonOldWords.Checked = True) Then
            trainMode = 2
        ElseIf (RadioButtonMixed.Checked = True) Then
            trainMode = 3
        End If
        ' Number of Words / Number of Times
        Try
            numWords = ComboBoxNumberOfWords.SelectedItem.ToString
        Catch
            numWords = -1
        End Try
        Try
            numTimes = ComboBoxNumberOfTimes.SelectedItem.ToString
        Catch
            numTimes = -1
        End Try
        ' Option Learning
        optionAutomatic = CheckBoxAutomatic.Checked

        ' Check: Selections
        If (numWords = -1) Then
            MsgBox("Please select Number of Words!", MsgBoxStyle.Information, "Selection: Words")
            Exit Sub
        End If
        If (numTimes = -1) Then
            MsgBox("Please select Number of Times!", MsgBoxStyle.Information, "Selection: Times")
            Exit Sub
        End If

        ' Starte Lerneinheit
        frmTrainer.ButtonGoOn.Enabled = True

        ' Woerter entnehmen
        takenWords = takeWords(trainMode, numWords, numTimes)
        numWords = takenWords

        ' fuer Ereignisse
        pubNumWords = takenWords
        pubNumTimes = numTimes

        ' Anzeige
        LabelNumWords.Text = "Words:" & takenWords

        ' Option Automatic
        If (optionAutomatic = True) Then

            ' Meldung
            MsgBox("Don't click! Just read, guess, wait and read the answer!", MsgBoxStyle.Information, "Automatic Unit/Read Only")

            ' keine Korrektur notwendig
            frmTrainer.ButtonCorrect.Enabled = False
            LabelHint.Text = "You have " & maxSleep.ToString & " seconds to guess and then to memorize!"

            For i = 1 To numWords * numTimes

                ' naechstes Wort nehmen
                currIndex = takeNextWord(pubNumWords, pubNumTimes)

                ' Anzeige
                RichTextBoxWordInfo.Text = "Thm: " & pubVocThemes(CInt(Val(nextWordTheme))) & vbNewLine & _
                                            "Typ: " & nextWordType & vbNewLine & "Con: " & nextWordCon & vbNewLine & "Syn: " & nextWordSyn
                objDate = DateTime.FromBinary(unitWordsTime(currIndex))
                LabelWordState.Text = "Times: " & unitWordsCount(currIndex) & "  Score: " & unitWordsScore(currIndex)
                LabelWordTimestamp.Text = "Date: " & FormatDateTime(objDate, DateFormat.GeneralDate)
                LabelWordGiven.Text = nextWordFrom
                LabelWordToCheck1.Text = nextWordTo(1)
                LabelWordToCheck2.Text = nextWordTo(2)
                LabelWordToCheck3.Text = nextWordTo(3)
                LabelWordToCheck4.Text = nextWordTo(4)
                LabelWordToCheck5.Text = nextWordTo(5)
                LabelWordToCheck1.BackColor = Color.LightSkyBlue
                LabelWordToCheck2.BackColor = Color.LightSkyBlue
                LabelWordToCheck3.BackColor = Color.LightSkyBlue
                LabelWordToCheck4.BackColor = Color.LightSkyBlue
                LabelWordToCheck5.BackColor = Color.LightSkyBlue
                Application.DoEvents()

                ' warten
                For j = 0 To 4
                    ButtonGoOn.Text = (maxSleep - maxSleep / 5 * j).ToString & " s / " & (numWords * numTimes - i + 1).ToString & " W"
                    Application.DoEvents()
                    Thread.Sleep(maxSleep / 5 * 1000)
                Next

                ' richtige Alternative anzeigen
                If (takeIndex(1) = takeIndex(0)) Then
                    LabelWordToCheck1.BackColor = Color.LightGreen
                ElseIf (takeIndex(2) = takeIndex(0)) Then
                    LabelWordToCheck2.BackColor = Color.LightGreen
                ElseIf (takeIndex(3) = takeIndex(0)) Then
                    LabelWordToCheck3.BackColor = Color.LightGreen
                ElseIf (takeIndex(4) = takeIndex(0)) Then
                    LabelWordToCheck4.BackColor = Color.LightGreen
                ElseIf (takeIndex(5) = takeIndex(0)) Then
                    LabelWordToCheck5.BackColor = Color.LightGreen
                End If

                ' richtig
                unitWordsScore(takeIndex(0)) = calculateScore(unitWordsScore(takeIndex(0)), True, 1.5)

                ' Durchlaeufe
                unitWordsCount(takeIndex(0)) = unitWordsCount(takeIndex(0)) + 1
                unitWordsCount0(takeIndex(0)) = unitWordsCount0(takeIndex(0)) + 1

                ' Zeitnahme
                unitWordsReakt0(takeIndex(0)) = unitWordsReakt0(takeIndex(0)) + maxSleep
                Application.DoEvents()

                ' warten
                For j = 0 To 4
                    ButtonGoOn.Text = (maxSleep - maxSleep / 5 * j).ToString & " s / " & (numWords * numTimes - i + 1).ToString & " W"
                    Application.DoEvents()
                    Thread.Sleep(maxSleep / 5 * 1000)
                Next

            Next

            ' Ende der Lerneinheit erreicht
            registerResults(pubNumWords, pubNumTimes)
            ' Anzeige
            LabelNumWords.Text = "Words:"
            RichTextBoxWordInfo.Text = "Word Info"
            LabelWordState.Text = "State:"
            LabelWordTimestamp.Text = "Time Stamp:"
            LabelWordGiven.Text = "Word given"
            LabelWordToCheck1.Text = "Alternative1"
            LabelWordToCheck2.Text = "Alternative2"
            LabelWordToCheck3.Text = "Alternative3"
            LabelWordToCheck4.Text = "Alternative4"
            LabelWordToCheck5.Text = "Alternative5"
            LabelWordToCheck1.BackColor = Color.LightSkyBlue
            LabelWordToCheck2.BackColor = Color.LightSkyBlue
            LabelWordToCheck3.BackColor = Color.LightSkyBlue
            LabelWordToCheck4.BackColor = Color.LightSkyBlue
            LabelWordToCheck5.BackColor = Color.LightSkyBlue
            ' Sichtbarkeit
            ' Freigabe: evtl. auch neue Woerter
            If (exDone >= 16) Then
                RadioButtonNewWords.Enabled = True
                RadioButtonOldWords.Enabled = True
                RadioButtonMixed.Enabled = True
            End If
            ' Beschraenkung: am Ende nur bekannte Woerter
            If (exDone = exSelected) Then
                RadioButtonNewWords.Enabled = False
                RadioButtonOldWords.Enabled = True
                RadioButtonMixed.Enabled = False
                RadioButtonOldWords.Checked = True
            End If
            Exit Sub

            ' Meldung
            MsgBox("Automatic Unit has finished!", MsgBoxStyle.Information, "Automatic Unit/Read Only")

            ' wiederherstellen
            ButtonGoOn.Text = "Go on"
            LabelHint.Text = "Please pick on the right pendant of the word on top!"

        End If

    End Sub

    Private Sub ButtonGoOn_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonGoOn.Click
        ' Start next Trial
        Dim objDate As Date
        Dim currIndex As Integer

        ' Option Automatic
        If (optionAutomatic = True) Then
            Exit Sub
        End If

        ' noch keine Korrektur
        frmTrainer.ButtonCorrect.Enabled = False

        ' naechstes Wort nehmen
        currIndex = takeNextWord(pubNumWords, pubNumTimes)

        If (currIndex = -1) Then
            ' Ende der Lerneinheit erreicht
            registerResults(pubNumWords, pubNumTimes)
            ' Anzeige
            LabelNumWords.Text = "Words:"
            RichTextBoxWordInfo.Text = "Word Info"
            LabelWordState.Text = "State:"
            LabelWordTimestamp.Text = "Time Stamp:"
            LabelWordGiven.Text = "Word given"
            LabelWordToCheck1.Text = "Check1"
            LabelWordToCheck2.Text = "Check2"
            LabelWordToCheck3.Text = "Check3"
            LabelWordToCheck4.Text = "Check4"
            LabelWordToCheck5.Text = "Check5"
            LabelWordToCheck1.BackColor = Color.LightSkyBlue
            LabelWordToCheck2.BackColor = Color.LightSkyBlue
            LabelWordToCheck3.BackColor = Color.LightSkyBlue
            LabelWordToCheck4.BackColor = Color.LightSkyBlue
            LabelWordToCheck5.BackColor = Color.LightSkyBlue
            ' Sichtbarkeit
            ' Freigabe: evtl. auch neue Woerter
            If (exDone >= 16) Then
                RadioButtonNewWords.Enabled = True
                RadioButtonOldWords.Enabled = True
                RadioButtonMixed.Enabled = True
            End If
            ' Beschraenkung: am Ende nur bekannte Woerter
            If (exDone = exSelected) Then
                RadioButtonNewWords.Enabled = False
                RadioButtonOldWords.Enabled = True
                RadioButtonMixed.Enabled = False
                RadioButtonOldWords.Checked = True
            End If
            Exit Sub

        End If


        ' Anzeige
        RichTextBoxWordInfo.Text = "Thm: " & pubVocThemes(CInt(Val(nextWordTheme))) & vbNewLine & _
                                    "Typ: " & nextWordType & vbNewLine & "Con: " & nextWordCon & vbNewLine & "Syn: " & nextWordSyn
        objDate = DateTime.FromBinary(unitWordsTime(currIndex))
        LabelWordState.Text = "Times: " & unitWordsCount(currIndex) & "  Score: " & unitWordsScore(currIndex)
        LabelWordTimestamp.Text = "Date: " & FormatDateTime(objDate, DateFormat.GeneralDate)
        LabelWordGiven.Text = nextWordFrom
        LabelWordToCheck1.Text = nextWordTo(1)
        LabelWordToCheck2.Text = nextWordTo(2)
        LabelWordToCheck3.Text = nextWordTo(3)
        LabelWordToCheck4.Text = nextWordTo(4)
        LabelWordToCheck5.Text = nextWordTo(5)
        LabelWordToCheck1.BackColor = Color.LightSkyBlue
        LabelWordToCheck2.BackColor = Color.LightSkyBlue
        LabelWordToCheck3.BackColor = Color.LightSkyBlue
        LabelWordToCheck4.BackColor = Color.LightSkyBlue
        LabelWordToCheck5.BackColor = Color.LightSkyBlue

        ' Zeitnahme
        pubTimeMeas = System.DateTime.Now.Ticks

        ' Pause
        pubPause = False

    End Sub

    Private Function takeWords(ByVal trainMode As Integer, ByVal numWords As Integer, ByVal numTimes As Integer) As Integer
        ' Take Words from Selection
        Dim numPart1, numPart2 As Integer
        Dim numberDone As Integer
        Dim mediumScore As Integer
        Dim counter As Integer
        Dim i As Integer

        ' Bearbeitung
        numberDone = 0
        For i = 1 To exSelected
            If (exWordCount(i - 1) > 0) Then
                numberDone = numberDone + 1
            End If
        Next

        ' Modus: Lerneinheit zusammenstellen
        If (trainMode = 1) Then
            ' New Words

            ' Check: Beschränkung am Ende
            If (exSelected - numberDone < numWords) Then
                numWords = exSelected - numberDone
            End If

            ' Lerneinheit: neu
            For i = 1 To numWords
                unitWordsIndex(i) = numberDone + i - 1
                unitWordsFrom(i) = exWordFrom(unitWordsIndex(i))
                unitWordsTo(i) = exWordTo(unitWordsIndex(i))
                unitWordsCon(i) = exWordCon(unitWordsIndex(i))
                unitWordsSyn(i) = exWordSyn(unitWordsIndex(i))
                unitWordsType(i) = exWordType(unitWordsIndex(i))
                unitWordsTheme(i) = exWordTheme(unitWordsIndex(i))
                unitWordsTime(i) = exWordTime(unitWordsIndex(i))
                unitWordsCount(i) = exWordCount(unitWordsIndex(i))
                unitWordsScore(i) = exWordScore(unitWordsIndex(i))
                unitWordsCount0(i) = 0
                unitWordsScore0(i) = exWordScore(unitWordsIndex(i))
                unitWordsReakt0(i) = 0
            Next

            ' Rueckgabe
            takeWords = numWords

        ElseIf (trainMode = 2) Then
            ' Known Words

            ' Suche (alte und) schlecht bewertete
            ' Bewertung-Mittelwert: bearbeitet
            mediumScore = 0
            For i = 1 To numberDone
                mediumScore = mediumScore + exWordScore(i - 1)
            Next
            If (numberDone > 0) Then mediumScore = mediumScore / numberDone Else mediumScore = 0
            counter = 0
            ' sehr schlecht bewertete zuerst
            For i = 1 To numberDone
                If (exWordScore(i - 1) <= 0.5 * mediumScore And counter < numWords) Then
                    counter = counter + 1
                    unitWordsIndex(counter) = i - 1
                End If
            Next
            For i = 1 To numberDone
                If (exWordScore(i - 1) <= mediumScore And counter < numWords) Then
                    counter = counter + 1
                    unitWordsIndex(counter) = i - 1
                End If
            Next
            numWords = counter

            ' Lerneinheit: bekannt
            For i = 1 To numWords
                'unitWordsIndex(i) bereits oben
                unitWordsFrom(i) = exWordFrom(unitWordsIndex(i))
                unitWordsTo(i) = exWordTo(unitWordsIndex(i))
                unitWordsCon(i) = exWordCon(unitWordsIndex(i))
                unitWordsSyn(i) = exWordSyn(unitWordsIndex(i))
                unitWordsType(i) = exWordType(unitWordsIndex(i))
                unitWordsTheme(i) = exWordTheme(unitWordsIndex(i))
                unitWordsTime(i) = exWordTime(unitWordsIndex(i))
                unitWordsCount(i) = exWordCount(unitWordsIndex(i))
                unitWordsScore(i) = exWordScore(unitWordsIndex(i))
                unitWordsCount0(i) = 0
                unitWordsScore0(i) = exWordScore(unitWordsIndex(i))
                unitWordsReakt0(i) = 0
            Next

            ' Rueckgabe
            takeWords = numWords

        ElseIf (trainMode = 3) Then
            ' Mixed Mode

            ' Lerneinheit: neu und bekannt
            numPart1 = Math.Floor(Rnd() * numWords) + 1
            numPart2 = numWords - numPart1

            ' Check: Beschränkung am Ende
            If (exSelected - numberDone < numPart1) Then
                numPart1 = exSelected - numberDone
                numPart2 = numWords - numPart1
            End If

            ' neu
            For i = 1 To numPart1
                unitWordsIndex(i) = numberDone + i - 1
                unitWordsFrom(i) = exWordFrom(unitWordsIndex(i))
                unitWordsTo(i) = exWordTo(unitWordsIndex(i))
                unitWordsCon(i) = exWordCon(unitWordsIndex(i))
                unitWordsSyn(i) = exWordSyn(unitWordsIndex(i))
                unitWordsType(i) = exWordType(unitWordsIndex(i))
                unitWordsTheme(i) = exWordTheme(unitWordsIndex(i))
                unitWordsTime(i) = exWordTime(unitWordsIndex(i))
                unitWordsCount(i) = exWordCount(unitWordsIndex(i))
                unitWordsScore(i) = exWordScore(unitWordsIndex(i))
                unitWordsCount0(i) = 0
                unitWordsScore0(i) = exWordScore(unitWordsIndex(i))
                unitWordsReakt0(i) = 0
            Next

            ' Suche (alte und) schlecht bewertete
            ' Bewertung-Mittelwert: bearbeitet
            mediumScore = 0
            For i = 1 To numberDone
                mediumScore = mediumScore + exWordScore(i - 1)
            Next
            If (numberDone > 0) Then mediumScore = mediumScore / numberDone Else mediumScore = 0
            counter = numPart1
            ' sehr schlecht bewertete zuerst
            For i = 1 To numberDone
                If (exWordScore(i - 1) <= 0.5 * mediumScore And counter < numWords) Then
                    counter = counter + 1
                    unitWordsIndex(counter) = i - 1
                End If
            Next
            For i = 1 To numberDone
                If (exWordScore(i - 1) <= mediumScore And counter < numWords) Then
                    counter = counter + 1
                    unitWordsIndex(counter) = i - 1
                End If
            Next
            numPart2 = counter - numPart1

            ' bekannt
            For i = numPart1 + 1 To numPart1 + numPart2
                'unitWordsIndex(i) bereits oben
                unitWordsFrom(i) = exWordFrom(unitWordsIndex(i))
                unitWordsTo(i) = exWordTo(unitWordsIndex(i))
                unitWordsCon(i) = exWordCon(unitWordsIndex(i))
                unitWordsSyn(i) = exWordSyn(unitWordsIndex(i))
                unitWordsType(i) = exWordType(unitWordsIndex(i))
                unitWordsTheme(i) = exWordTheme(unitWordsIndex(i))
                unitWordsTime(i) = exWordTime(unitWordsIndex(i))
                unitWordsCount(i) = exWordCount(unitWordsIndex(i))
                unitWordsScore(i) = exWordScore(unitWordsIndex(i))
                unitWordsCount0(i) = 0
                unitWordsScore0(i) = exWordScore(unitWordsIndex(i))
                unitWordsReakt0(i) = 0
            Next

            ' Rueckgabe
            takeWords = numPart1 + numPart2

        End If


    End Function

    Private Function takeNextWord(ByVal numWords As Integer, ByVal numTimes As Integer) As Integer
        ' Take next Word from Unit
        Dim furtherWord As Boolean
        Dim tmpIndex(4) As Integer
        Dim chkIndex(5) As Integer
        Dim pasteTo As Integer
        Dim maxIter As Integer
        Dim currIter As Integer
        Dim counter As Integer
        Dim chkDouble As Boolean
        Dim i As Integer
        Dim j As Integer

        ' Check: alle bearbeitet?
        furtherWord = False
        For i = 1 To numWords
            If (unitWordsCount0(i) < numTimes) Then
                furtherWord = True
                Exit For
            End If
        Next
        If (furtherWord = False) Then
            ' alle Woerter der Lerneinheit oft genug bearbeitet
            ' Rueckgabe
            takeNextWord = -1
            Exit Function

        End If


        ' Sicherheit
        maxIter = 100

        ' Loesung-Index auslosen
        currIter = 0
        takeIndex(0) = Math.Floor(Rnd() * numWords) + 1
        While (unitWordsCount0(takeIndex(0)) = numTimes And currIter < maxIter)
            currIter = currIter + 1
            takeIndex(0) = Math.Floor(Rnd() * numWords) + 1
        End While

        ' Alternativen auslosen
        currIter = 0
        tmpIndex(1) = Math.Floor(Rnd() * numWords) + 1
        While (tmpIndex(1) = takeIndex(0) And currIter < maxIter)
            currIter = currIter + 1
            tmpIndex(1) = Math.Floor(Rnd() * numWords) + 1
        End While
        currIter = 0
        tmpIndex(2) = Math.Floor(Rnd() * numWords) + 1
        While ((tmpIndex(2) = takeIndex(0) Or tmpIndex(2) = tmpIndex(1)) And currIter < maxIter)
            currIter = currIter + 1
            tmpIndex(2) = Math.Floor(Rnd() * numWords) + 1
        End While
        currIter = 0
        tmpIndex(3) = Math.Floor(Rnd() * numWords) + 1
        While ((tmpIndex(3) = takeIndex(0) Or tmpIndex(3) = tmpIndex(1) Or tmpIndex(3) = tmpIndex(2)) And currIter < maxIter)
            currIter = currIter + 1
            tmpIndex(3) = Math.Floor(Rnd() * numWords) + 1
        End While
        currIter = 0
        tmpIndex(4) = Math.Floor(Rnd() * numWords) + 1
        While ((tmpIndex(4) = takeIndex(0) Or tmpIndex(4) = tmpIndex(1) Or tmpIndex(4) = tmpIndex(2) Or tmpIndex(4) = tmpIndex(3)) And currIter < maxIter)
            currIter = currIter + 1
            tmpIndex(4) = Math.Floor(Rnd() * numWords) + 1
        End While
        currIter = 0

        ' richtige Loesung
        pasteTo = Math.Floor(Rnd() * 5) + 1
        takeIndex(pasteTo) = takeIndex(0)

        ' Alternativen
        counter = 0
        For i = 1 To 5
            If (i <> pasteTo) Then
                counter = counter + 1
                takeIndex(i) = tmpIndex(counter)
            End If
        Next

        ' aktuelles Wort 
        nextWordFrom = unitWordsFrom(takeIndex(0))
        nextWordTo(0) = unitWordsTo(takeIndex(0))
        nextWordCon = unitWordsCon(takeIndex(0))
        nextWordSyn = unitWordsSyn(takeIndex(0))
        nextWordType = unitWordsType(takeIndex(0))
        nextWordTheme = unitWordsTheme(takeIndex(0))
        nextWordTime = unitWordsTime(takeIndex(0))
        nextWordCount = unitWordsCount(takeIndex(0))
        nextWordScore = unitWordsScore(takeIndex(0))
        nextWordCount0 = unitWordsCount0(takeIndex(0))

        ' Alternativen
        For i = 1 To 5
            ' wenn weniger als 5 Woerter
            chkDouble = False
            For j = 1 To i - 1
                If (takeIndex(i) = chkIndex(j)) Then
                    chkDouble = True
                    Exit For
                End If
            Next
            If (chkDouble = False) Then
                nextWordTo(i) = unitWordsTo(takeIndex(i))
                chkIndex(i) = takeIndex(i)
            Else
                nextWordTo(i) = ""
            End If
        Next


        ' Rueckgabe
        takeNextWord = takeIndex(0)

    End Function

    Private Function registerResults(ByVal numWords As Integer, ByVal pubNumTimes As Integer) As Boolean
        ' Register Results of Learning Unit
        Dim mediumScore As Integer
        Dim numberDone As Integer
        Dim reaktSum As Long
        Dim infStr As String
        Dim tmpStr As String
        'Dim tabStr1, tabStr2, tabStrx As String
        Dim lenFrom, lenTo As Integer
        Dim i As Integer

        ' Einzel-Wertungen und Durchlaeufe bereits in LabelWordToCheckX_Click
        '  Zeitstempel Learning Unit
        For i = 1 To numWords
            unitWordsTime(i) = System.DateTime.Now.Ticks
        Next

        ' Zeitnahme auswerten
        reaktSum = 0
        For i = 1 To numWords
            reaktSum = reaktSum + unitWordsReakt0(i)
        Next
        For i = 1 To numWords
            If ((unitWordsReakt0(i) / reaktSum) > (1 / numWords)) Then
                ' Abwertung
                unitWordsScore(i) = calculateScore(unitWordsScore(i), False, 2.0)
            Else
                ' Aufwertung
                unitWordsScore(i) = calculateScore(unitWordsScore(i), True, 2.0)
            End If
        Next

        ' Bewertung-Mittelwert: Unit Words
        mediumScore = 0
        For i = 1 To numWords
            mediumScore = mediumScore + unitWordsScore(i)
        Next
        If (numWords > 0) Then mediumScore = mediumScore / numWords Else mediumScore = 0

        ' Meldung
        infStr = ""
        If (mediumScore > 0.75 * maxScore) Then
            infStr = "Very good!"
        ElseIf (mediumScore > 0.5 * maxScore) Then
            infStr = "Good!"
        ElseIf (mediumScore <= 0.5 * maxScore) Then
            infStr = "Work harder!"
        End If
        tmpStr = vbCrLf & "No.".PadLeft(5, " ") & " " & "From".PadRight(FResults.maxWordLength, " ") & " " & "To".PadRight(FResults.maxWordLength, " ") & " " & "Reakt".PadLeft(5, " ") & " " & "Score".PadLeft(5, " ") & " " & "Change".PadLeft(5, " ")
        'tabStrx = vbTab
        'tabStr1 = vbTab & vbTab & vbTab
        'tabStr2 = vbTab & vbTab & vbTab
        'tmpStr = vbCrLf & "From" & tabStr1 & "To" & tabStr2 & "Times" & tabStrx & "Score"
        tmpStr = tmpStr & vbCrLf & "-----------------------------------------------------------------------------------------"
        For i = 1 To numWords
            If (unitWordsFrom(i).Length < FResults.maxWordLength) Then
                lenFrom = unitWordsFrom(i).Length
            Else
                lenFrom = FResults.maxWordLength - 1
            End If
            If (unitWordsTo(i).Length < FResults.maxWordLength) Then
                lenTo = unitWordsTo(i).Length
            Else
                lenTo = FResults.maxWordLength - 1
            End If
            ' i-te Zeile
            tmpStr = tmpStr & vbCrLf & i.ToString.PadLeft(5, " ") & " " & unitWordsFrom(i).Substring(0, lenFrom).PadRight(FResults.maxWordLength, " ") & " " & unitWordsTo(i).Substring(0, lenTo).PadRight(FResults.maxWordLength, " ") & " " & _
                                        Math.Round((unitWordsReakt0(i) / reaktSum) * 100).ToString.PadLeft(5, " ") & " " & unitWordsScore(i).ToString.PadLeft(5, " ") & " " & (unitWordsScore(i) - unitWordsScore0(i)).ToString.PadLeft(5, " ")
            'tabStrx = vbTab
            'If (unitWordsFrom(i).Length <= 8) Then
            '    tabStr1 = vbTab & vbTab & vbTab
            'ElseIf (unitWordsFrom(i).Length <= 16) Then
            '    tabStr1 = vbTab & vbTab
            'Else
            '    tabStr1 = vbTab
            'End If
            'If (unitWordsTo(i).Length <= 8) Then
            '    tabStr2 = vbTab & vbTab & vbTab
            'ElseIf (unitWordsTo(i).Length <= 16) Then
            '    tabStr2 = vbTab & vbTab
            'Else
            '    tabStr2 = vbTab
            'End If
            'tmpStr = tmpStr & vbCrLf & unitWordsFrom(i) & tabStr1 & unitWordsTo(i) & tabStr2 & unitWordsCount(i).ToString & tabStrx & unitWordsScore(i).ToString.PadLeft(5, " ")
        Next

        ' Anzeige-Fenster
        frmResults = New FResults
        frmResults.Text = "Unit Results"
        frmResults.RichTextBoxResults.Text = "Medium Score: " & mediumScore & "   " & infStr & vbCrLf & tmpStr
        frmResults.Show()
        'MsgBox("Medium Score: " & mediumScore & "   " & infStr & vbCrLf & tmpStr, MsgBoxStyle.Information, "Score")

        ' Training Status zurueckuebergeben
        ' Einzel-Wertungen
        For i = 1 To numWords
            exWordScore(unitWordsIndex(i)) = unitWordsScore(i)
        Next
        ' Durchlaeufe und Zeitstempel
        For i = 1 To numWords
            exWordCount(unitWordsIndex(i)) = unitWordsCount(i)
            exWordTime(unitWordsIndex(i)) = unitWordsTime(i)
        Next

        ' Bearbeitung
        numberDone = 0
        For i = 1 To exSelected
            If (exWordCount(i - 1) > 0) Then
                numberDone = numberDone + 1
            End If
        Next

        ' Bewertung-Mittelwert: bearbeitet
        mediumScore = 0
        For i = 1 To numberDone
            mediumScore = mediumScore + exWordScore(i - 1)
        Next
        If (numberDone > 0) Then mediumScore = mediumScore / numberDone Else mediumScore = 0

        ' Gesamt Status
        exDone = numberDone
        exScore = mediumScore

        ' Anzeige Ergebnisse
        frmTrainer.LabelDone.Text = exDone
        frmTrainer.LabelScore.Text = exScore

        ' Sichtbarkeit
        ButtonGoOn.Enabled = False

        ' Rueckgabe
        registerResults = True

    End Function

    Private Function calculateScore(ByVal oldScore As Integer, ByVal success As Boolean, ByVal facReakt As Double) As Integer
        ' Calculation of the new Score
        Dim newScore As Integer

        ' new Score
        If (success = True) Then
            newScore = oldScore + (maxScore - oldScore) / (facScore * facReakt)
        Else
            newScore = oldScore - (oldScore - minScore) / (facScore * facReakt)
        End If

        ' Rueckgabe
        calculateScore = newScore

    End Function

    Private Sub LabelWordGiven_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles LabelWordGiven.Click
        ' Pause and Continue

        If (pubPause = False) Then
            ' Sperren
            pubPause = True
            LabelWordGiven.BackColor = Color.Red
            ButtonGoOn.Enabled = False
            LabelWordToCheck1.Enabled = False
            LabelWordToCheck2.Enabled = False
            LabelWordToCheck3.Enabled = False
            LabelWordToCheck4.Enabled = False
            LabelWordToCheck5.Enabled = False

        ElseIf (pubPause = True) Then
            ' Freigeben
            pubPause = False
            LabelWordGiven.BackColor = Color.LightYellow
            ButtonGoOn.Enabled = True
            LabelWordToCheck1.Enabled = True
            LabelWordToCheck2.Enabled = True
            LabelWordToCheck3.Enabled = True
            LabelWordToCheck4.Enabled = True
            LabelWordToCheck5.Enabled = True
            ' Zeitnahme
            pubTimeMeas = System.DateTime.Now.Ticks

        End If


    End Sub

    Private Sub LabelWordToCheck1_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles LabelWordToCheck1.Click
        ' Lerneinheit: Wort Alternative 1

        ' Option Automatic
        If (optionAutomatic = True) Then
            Exit Sub
        End If

        ' Check Treffer
        If (takeIndex(1) = takeIndex(0)) Then
            ' richtig
            unitWordsScore(takeIndex(0)) = calculateScore(unitWordsScore(takeIndex(0)), True, 1.0)
            LabelWordToCheck1.BackColor = Color.LightGreen
            frmTrainer.ButtonCorrect.Enabled = False
        Else
            ' falsch
            unitWordsScore(takeIndex(0)) = calculateScore(unitWordsScore(takeIndex(0)), False, 1.0)
            LabelWordToCheck1.BackColor = Color.LightPink
            markRightAlternative(takeIndex(0))
            frmTrainer.ButtonCorrect.Enabled = True
        End If
        ' Durchlaeufe
        unitWordsCount(takeIndex(0)) = unitWordsCount(takeIndex(0)) + 1
        unitWordsCount0(takeIndex(0)) = unitWordsCount0(takeIndex(0)) + 1
        ' Zeitnahme
        unitWordsReakt0(takeIndex(0)) = unitWordsReakt0(takeIndex(0)) + System.DateTime.Now.Ticks - pubTimeMeas

    End Sub

    Private Sub LabelWordToCheck2_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles LabelWordToCheck2.Click
        ' Lerneinheit: Wort Alternative 2

        ' Option Automatic
        If (optionAutomatic = True) Then
            Exit Sub
        End If

        ' Check Treffer
        If (takeIndex(2) = takeIndex(0)) Then
            ' richtig
            unitWordsScore(takeIndex(0)) = calculateScore(unitWordsScore(takeIndex(0)), True, 1.0)
            LabelWordToCheck2.BackColor = Color.LightGreen
            frmTrainer.ButtonCorrect.Enabled = False
        Else
            ' falsch
            unitWordsScore(takeIndex(0)) = calculateScore(unitWordsScore(takeIndex(0)), False, 1.0)
            LabelWordToCheck2.BackColor = Color.LightPink
            markRightAlternative(takeIndex(0))
            frmTrainer.ButtonCorrect.Enabled = True
        End If
        ' Durchlaeufe
        unitWordsCount(takeIndex(0)) = unitWordsCount(takeIndex(0)) + 1
        unitWordsCount0(takeIndex(0)) = unitWordsCount0(takeIndex(0)) + 1
        ' Zeitnahme
        unitWordsReakt0(takeIndex(0)) = unitWordsReakt0(takeIndex(0)) + System.DateTime.Now.Ticks - pubTimeMeas

    End Sub

    Private Sub LabelWordToCheck3_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles LabelWordToCheck3.Click
        ' Lerneinheit: Wort Alternative 3

        ' Option Automatic
        If (optionAutomatic = True) Then
            Exit Sub
        End If

        ' Check Treffer
        If (takeIndex(3) = takeIndex(0)) Then
            ' richtig
            unitWordsScore(takeIndex(0)) = calculateScore(unitWordsScore(takeIndex(0)), True, 1.0)
            LabelWordToCheck3.BackColor = Color.LightGreen
            frmTrainer.ButtonCorrect.Enabled = False
        Else
            ' falsch
            unitWordsScore(takeIndex(0)) = calculateScore(unitWordsScore(takeIndex(0)), False, 1.0)
            LabelWordToCheck3.BackColor = Color.LightPink
            markRightAlternative(takeIndex(0))
            frmTrainer.ButtonCorrect.Enabled = True
        End If
        ' Durchlaeufe
        unitWordsCount(takeIndex(0)) = unitWordsCount(takeIndex(0)) + 1
        unitWordsCount0(takeIndex(0)) = unitWordsCount0(takeIndex(0)) + 1
        ' Zeitnahme
        unitWordsReakt0(takeIndex(0)) = unitWordsReakt0(takeIndex(0)) + System.DateTime.Now.Ticks - pubTimeMeas

    End Sub

    Private Sub LabelWordToCheck4_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles LabelWordToCheck4.Click
        ' Lerneinheit: Wort Alternative 4

        ' Option Automatic
        If (optionAutomatic = True) Then
            Exit Sub
        End If

        ' Check Treffer
        If (takeIndex(4) = takeIndex(0)) Then
            ' richtig
            unitWordsScore(takeIndex(0)) = calculateScore(unitWordsScore(takeIndex(0)), True, 1.0)
            LabelWordToCheck4.BackColor = Color.LightGreen
            frmTrainer.ButtonCorrect.Enabled = False
        Else
            ' falsch
            unitWordsScore(takeIndex(0)) = calculateScore(unitWordsScore(takeIndex(0)), False, 1.0)
            LabelWordToCheck4.BackColor = Color.LightPink
            markRightAlternative(takeIndex(0))
            frmTrainer.ButtonCorrect.Enabled = True
        End If
        ' Durchlaeufe
        unitWordsCount(takeIndex(0)) = unitWordsCount(takeIndex(0)) + 1
        unitWordsCount0(takeIndex(0)) = unitWordsCount0(takeIndex(0)) + 1
        ' Zeitnahme
        unitWordsReakt0(takeIndex(0)) = unitWordsReakt0(takeIndex(0)) + System.DateTime.Now.Ticks - pubTimeMeas

    End Sub

    Private Sub LabelWordToCheck5_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles LabelWordToCheck5.Click
        ' Lerneinheit: Wort Alternative 5

        ' Option Automatic
        If (optionAutomatic = True) Then
            Exit Sub
        End If

        ' Check Treffer
        If (takeIndex(5) = takeIndex(0)) Then
            ' richtig
            unitWordsScore(takeIndex(0)) = calculateScore(unitWordsScore(takeIndex(0)), True, 1.0)
            LabelWordToCheck5.BackColor = Color.LightGreen
            frmTrainer.ButtonCorrect.Enabled = False
        Else
            ' falsch
            unitWordsScore(takeIndex(0)) = calculateScore(unitWordsScore(takeIndex(0)), False, 1.0)
            LabelWordToCheck5.BackColor = Color.LightPink
            markRightAlternative(takeIndex(0))
            frmTrainer.ButtonCorrect.Enabled = True
        End If
        ' Durchlaeufe
        unitWordsCount(takeIndex(0)) = unitWordsCount(takeIndex(0)) + 1
        unitWordsCount0(takeIndex(0)) = unitWordsCount0(takeIndex(0)) + 1
        ' Zeitnahme
        unitWordsReakt0(takeIndex(0)) = unitWordsReakt0(takeIndex(0)) + System.DateTime.Now.Ticks - pubTimeMeas

    End Sub

    Private Function markRightAlternative(ByVal index As Integer) As Boolean
        ' Mark the right Alternative Label

        If (takeIndex(1) = takeIndex(0)) Then
            LabelWordToCheck1.BackColor = Color.LightGreen
        ElseIf (takeIndex(2) = takeIndex(0)) Then
            LabelWordToCheck2.BackColor = Color.LightGreen
        ElseIf (takeIndex(3) = takeIndex(0)) Then
            LabelWordToCheck3.BackColor = Color.LightGreen
        ElseIf (takeIndex(4) = takeIndex(0)) Then
            LabelWordToCheck4.BackColor = Color.LightGreen
        ElseIf (takeIndex(5) = takeIndex(0)) Then
            LabelWordToCheck5.BackColor = Color.LightGreen
        End If

        ' Rueckgabe
        markRightAlternative = True

    End Function

    Private Sub ButtonCorrect_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ButtonCorrect.Click
        ' Allow Correct once if duplicate Labels
        Dim oldscore As Integer

        ' Wiederherstellung
        oldscore = (unitWordsScore(takeIndex(0)) - minScore / facScore) / (1 - 1 / facScore)
        ' Bewertung als richtig
        unitWordsScore(takeIndex(0)) = calculateScore(oldscore, True, 1.0)
        ' sperren
        frmTrainer.ButtonCorrect.Enabled = False

    End Sub

End Class