--[[
Interface: 1.5.1.0 b6732

Copyright (C) GtX (Andy), 2018

Author: GtX | Andy
Date: 10.10.2018
Version: 1.0.0.0

History:
V 0.9.0.0 @ 10.10.2018 - FS17 Version (Not Released)
V 1.0.0.0 @ 31.07.2019 - Beta Version

Contact:
https://forum.giants-software.com
https://github.com/GtX-Andy

Important:
Not to be added to any mods / maps or modified from its current release form.
No changes are to be made to this script without permission from GtX | Andy

Darf nicht zu Mods / Maps hinzugefügt oder von der aktuellen Release-Form geändert werden.
An diesem Skript dürfen ohne Genehmigung von GtX | Andy keine Änderungen vorgenommen werden
]]


UniversalPassengerRequestEnterEvent = {}
UniversalPassengerRequestEnterEvent_mt = Class(UniversalPassengerRequestEnterEvent, Event)
InitEventClass(UniversalPassengerRequestEnterEvent, "UniversalPassengerRequestEnterEvent")

function UniversalPassengerRequestEnterEvent:emptyNew()
    local self = Event:new(UniversalPassengerRequestEnterEvent_mt)
    return self
end

function UniversalPassengerRequestEnterEvent:new(object)
    local self = UniversalPassengerRequestEnterEvent:emptyNew()
    self.object = object
    self.objectId = NetworkUtil.getObjectId(self.object)
    return self
end

function UniversalPassengerRequestEnterEvent:readStream(streamId, connection)
    self.objectId = NetworkUtil.readNodeObjectId(streamId)
    self.object = NetworkUtil.getObject(self.objectId)
    self:run(connection)
end

function UniversalPassengerRequestEnterEvent:writeStream(streamId, connection)
    NetworkUtil.writeNodeObjectId(streamId, self.objectId)
end

function UniversalPassengerRequestEnterEvent:run(connection)
    if self.object ~= nil then
        if self.object:getAvailableSeats() > 0 then
            local player = g_currentMission.connectionsToPlayer[connection]
            local seatId = self.object:getNextSeat()
            if player ~= nil and seatId > 0 then
                self.object:setConnectionToSeatId(connection, seatId)
                g_server:broadcastEvent(UniversalPassengerEnterEvent:new(self.objectId, player, seatId), true, connection, self.object)
                connection:sendEvent(UniversalPassengerEnterEvent:new(self.objectId, player, seatId))
            end
        end
    end
end
