-- Register functionality by: Ian898 
-- Date: 26/11/2018
-- THANK YOU IAN!

-- "by" modelleicher
-- used to remove locked steering axle when front loaders are attached


g_specializationManager:addSpecialization("variableSprayUsage", "variableSprayUsage", g_currentModDirectory.."variableSprayUsage.lua")

addSpezialisatzion = {}

function addSpezialisatzion:register(name)
    
    for k, vehicle in pairs(g_vehicleTypeManager:getVehicleTypes()) do
        
        local sprayer 			 = false
        local variableSprayUsage = false
        local extendedSprayer    = false
        
        for _, spec in pairs(vehicle.specializationNames) do
        
            if spec == "sprayer" then -- check for sprayer, only insert into sprayer
                sprayer = true;
            end
            
            if spec == "variableSprayUsage" then -- don't insert if already inserted
                variableSprayUsage = true;
            end
        end    
        if sprayer and not variableSprayUsage then
			print("  adding variableSprayUsage to vehicleType '"..tostring(k).."'")		
            g_vehicleTypeManager:addSpecialization(vehicle.name, "FS19_Variable_Spray_Usage.variableSprayUsage")
        end
    end
    
end

VehicleTypeManager.finalizeVehicleTypes = Utils.prependedFunction(VehicleTypeManager.finalizeVehicleTypes, addSpezialisatzion.register)

function addSpezialisatzion:onDraw(isActiveForInput, isSelected)
    local spec = self.spec_attacherJoints
    if self == g_currentMission.controlledVehicle then
        --recursive call draw on implements attached to implements
        local function allImplements(localSpec)
            for _, implement in ipairs(localSpec.attachedImplements) do
                local object = implement.object
                if object ~= nil then
                    if object.draw ~= nil then
                        object.draw(object, isActiveForInput, isSelected)
                    end
                end
                if object.spec_attacherJoints ~= nil then
                    allImplements(object.spec_attacherJoints)                
                end
            end
        end
        -- call draw on all attached implements, selection check is done in the implement
        allImplements(spec)
    end
end

AttacherJoints.onDraw = addSpezialisatzion.onDraw 

addModEventListener(addSpezialisatzion);

