--
-- variableSprayUsage
--
--
-- @author monteur1
-- @date 30/12/2018
--

variableSprayUsage = {};
variableSprayUsage.g_currentModDirectory = g_currentModDirectory

function variableSprayUsage.prerequisitesPresent(specializations)
    return true
end

function variableSprayUsage.registerEventListeners(vehicleType)
    EL = vehicleType.eventListeners
    table.insert(EL.onPreLoad, variableSprayUsage)		
    table.insert(EL.onLoad, variableSprayUsage)
    table.insert(EL.onPostLoad, variableSprayUsage)	
    table.insert(EL.onUpdate, variableSprayUsage)
    table.insert(EL.onUpdateTick, variableSprayUsage)
    table.insert(EL.onDraw, variableSprayUsage)
    table.insert(EL.onRegisterActionEvents, variableSprayUsage)
    table.insert(EL.onReadStream, variableSprayUsage)
    table.insert(EL.onWriteStream, variableSprayUsage)
end

function variableSprayUsage:onPreLoad(savegame)
end

function variableSprayUsage:onLoad(savegame)
	self.variableSprayUsage = {}

	self.variableSprayUsage.CurrentActiveWorkarea  = nil
	self.variableSprayUsage.HasWorkarea            = false
	self.variableSprayUsage.HasNoCapacity          = false
											       
	self.variableSprayUsageHasWorkarea             = false
	self.variableSprayUsageAllowScript             = false
	self.variableSprayUsageCaluclatedWorkingWidth  = 9999
	self.variableSprayUsageSprayRate               = 300
	self.variableSprayUsageAcitveFillUnitIndex     = 1
end

function variableSprayUsage:onPostLoad(savegame)
	local spec = self.spec_fillUnit
	
	self.fillTypeIDX_LIQUIDFERTILIZER    = g_fillTypeManager:getFillTypeIndexByName("LIQUIDFERTILIZER")
	self.fillTypeIDX_HERBICIDE           = g_fillTypeManager:getFillTypeIndexByName("HERBICIDE")
	self.fillTypeIDX_LIQUIDMANURE        = g_fillTypeManager:getFillTypeIndexByName("LIQUIDMANURE")
	self.fillTypeIDX_DIGESTATE           = g_fillTypeManager:getFillTypeIndexByName("DIGESTATE")
	self.fillTypeIDX_FERTILIZER          = g_fillTypeManager:getFillTypeIndexByName("FERTILIZER")
	self.fillTypeIDX_LIME                = g_fillTypeManager:getFillTypeIndexByName("LIME")
	self.fillTypeIDX_MANURE              = g_fillTypeManager:getFillTypeIndexByName("MANURE")
		
	for fillUnitIndex, fillUnit in pairs(spec.fillUnits) do			
		self.allowFillType_LIQUIDFERTILIZER   = self:getFillUnitSupportsFillType(fillUnitIndex, self.fillTypeIDX_LIQUIDFERTILIZER)
		self.allowFillType_HERBICIDE          = self:getFillUnitSupportsFillType(fillUnitIndex, self.fillTypeIDX_HERBICIDE)
		self.allowFillType_LIQUIDMANURE       = self:getFillUnitSupportsFillType(fillUnitIndex, self.fillTypeIDX_LIQUIDMANURE)
		self.allowFillType_DIGESTATE          = self:getFillUnitSupportsFillType(fillUnitIndex, self.fillTypeIDX_DIGESTATE)
		self.allowFillType_FERTILIZER         = self:getFillUnitSupportsFillType(fillUnitIndex, self.fillTypeIDX_FERTILIZER)
		self.allowFillType_LIME               = self:getFillUnitSupportsFillType(fillUnitIndex, self.fillTypeIDX_LIME)
		self.allowFillType_MANURE             = self:getFillUnitSupportsFillType(fillUnitIndex, self.fillTypeIDX_MANURE)
		
		if self.allowFillType_LIQUIDFERTILIZER == true or self.allowFillType_HERBICIDE == true or self.allowFillType_LIQUIDMANURE == true or self.allowFillType_DIGESTATE == true or self.allowFillType_FERTILIZER == true or self.allowFillType_LIME == true or self.allowFillType_MANURE == true then 
			self.variableSprayUsageAcitveFillUnitIndex = fillUnitIndex
		end
	end		
		
	local allowScript = false
	if self:getFillUnitCapacity(self.variableSprayUsageAcitveFillUnitIndex) > 20 or self.allowFillType_LIQUIDMANURE == true or self.allowFillType_DIGESTATE == true then
		allowScript = true
	end

	-- Abfrage, ob extendedSprayer von FS19_precisionFarming aktiv ist --
	for i=1, table.getn(self.specializations) do
		local specEntryName = self.specializationNames[i]
		if specEntryName == "FS19_precisionFarming.extendedSprayer" then
			allowScript = false
		end
	end
	
	if allowScript == true and self:getFillUnitCapacity(self.variableSprayUsageAcitveFillUnitIndex) == 0 then
		self.variableSprayUsage.HasNoCapacity = true
	end
	
	local hasWorkarea = false
	local key = string.format("vehicle.workAreas.workArea");
	if hasXMLProperty(self.xmlFile, key) then
		hasWorkarea = true
	end
	
	if allowScript == true and hasWorkarea == true then
		self.variableSprayUsageAllowScript = true
		
		self.variableSprayUsage.Hud                = {}
		self.variableSprayUsage.Hud.offset_X       = 0.07
		self.variableSprayUsage.Hud.offset_Y       = 0.06 --0.03
	
		self.variableSprayUsage.minLimitManure     = 12000
		self.variableSprayUsage.maxLimitManure     = 30000
		self.variableSprayUsage.stepManure         = 1000
	
		self.variableSprayUsage.minLimitDigestate  = 10000
		self.variableSprayUsage.maxLimitDigestate  = 40000
		self.variableSprayUsage.stepDigestate      = 1000
	
		self.variableSprayUsage.minLimitFertilizer = 100
		self.variableSprayUsage.maxLimitFertilizer = 800
		self.variableSprayUsage.stepFertilizer     = 50
	
		self.variableSprayUsage.minLimitLime       = 1000
		self.variableSprayUsage.maxLimitLime       = 9000
		self.variableSprayUsage.stepLime           = 200
		
		self.variableSprayUsage.currentMinLimit    = 100
		self.variableSprayUsage.currentMaxLimit    = 40000
		self.variableSprayUsage.currentStep        = 200
				
		if savegame ~= nil and not savegame.resetVehicles then
			local key2 = savegame.key ..".variableSprayUsage"		
			local sprayRate = getXMLInt(savegame.xmlFile, key2.."#sprayRate")
			if sprayRate ~= nil then
				self.variableSprayUsageSprayRate = sprayRate
			else
				self.variableSprayUsageSprayRate = 0	
			end
		end			
	end
	
	-- print("Used Specs")
	-- for i=1, table.getn(self.specializations) do
		-- local specEntryName = self.specializationNames[i]

		-- print(specEntryName)		
	-- end
end

function variableSprayUsage:loadFromXMLFile(xmlFile, key)
end

function variableSprayUsage:saveToXMLFile(xmlFile, key, usedModNames)
	local keySplit = StringUtil.splitString(".", key);
	local newKey = keySplit[1]
	for i=2,#keySplit-2 do
		newKey = newKey..'.'..keySplit[i]
	end
	newKey = newKey..'.variableSprayUsage'

	if self.variableSprayUsageAllowScript == true then
		setXMLInt(xmlFile, newKey.."#sprayRate", self.variableSprayUsageSprayRate)
	end
end

function variableSprayUsage:onUpdateTick(dt, isActiveForInput, isSelected)
end

function variableSprayUsage:onUpdate(dt, isActiveForInput, isSelected)
	if self:getIsActive() then	
		if self.variableSprayUsageAllowScript == true then 			
			-- set Limits on Filltypechange --
			local fillUnitIndex    = self.variableSprayUsageAcitveFillUnitIndex
			local currentFillType  = self:getFillUnitFillType(fillUnitIndex);		
			local currentFillLevel = self:getFillUnitFillLevel(fillUnitIndex)	
			
			if currentFillType == self.fillTypeIDX_LIQUIDMANURE or currentFillType == self.fillTypeIDX_DIGESTATE or (self.variableSprayUsage.HasNoCapacity == true and (self.allowFillType_LIQUIDMANURE == true or self.allowFillType_DIGESTATE == true)) then
				self.variableSprayUsage.currentMinLimit  = self.variableSprayUsage.minLimitDigestate
				self.variableSprayUsage.currentMaxLimit  = self.variableSprayUsage.maxLimitDigestate
				self.variableSprayUsage.currentStep      = self.variableSprayUsage.stepDigestate
			else			
				if (currentFillType == self.fillTypeIDX_LIQUIDFERTILIZER or currentFillType == self.fillTypeIDX_HERBICIDE or currentFillType == self.fillTypeIDX_FERTILIZER) or (currentFillLevel == 0 and (self.allowFillType_FERTILIZER == true or self.allowFillType_HERBICIDE == true)) then
					self.variableSprayUsage.currentMinLimit  = self.variableSprayUsage.minLimitFertilizer
					self.variableSprayUsage.currentMaxLimit  = self.variableSprayUsage.maxLimitFertilizer
					self.variableSprayUsage.currentStep      = self.variableSprayUsage.stepFertilizer
				else			
					if currentFillType == self.fillTypeIDX_MANURE then
						self.variableSprayUsage.currentMinLimit  = self.variableSprayUsage.minLimitManure
						self.variableSprayUsage.currentMaxLimit  = self.variableSprayUsage.maxLimitManure
						self.variableSprayUsage.currentStep      = self.variableSprayUsage.stepManure
					else
						if currentFillType == self.fillTypeIDX_LIME then
							self.variableSprayUsage.currentMinLimit  = self.variableSprayUsage.minLimitLime
							self.variableSprayUsage.currentMaxLimit  = self.variableSprayUsage.maxLimitLime
							self.variableSprayUsage.currentStep      = self.variableSprayUsage.stepLime
						end
					end
				end
			end
						
			if self.variableSprayUsageSprayRate < self.variableSprayUsage.currentMinLimit then
				self.variableSprayUsageSprayRate = self.variableSprayUsage.currentMinLimit
			else
				if self.variableSprayUsageSprayRate > self.variableSprayUsage.currentMaxLimit then
					self.variableSprayUsageSprayRate = self.variableSprayUsage.currentMaxLimit
				end
			end			

			if self:getIsTurnedOn() then
				-- calculating Workingwidth with active Workareas --
				local spec              = self.spec_workArea
				local xmin              = 200
				local xmax              = -200
		
				for _,workArea in ipairs(spec.workAreas) do	
					local isWorkareaActive = self:getIsWorkAreaActive(workArea)
					if isWorkareaActive == true and workArea.type ~= WorkAreaType.RIDGEMARKER then
						local x1,y1,z1 = getWorldTranslation(workArea.start)
						local x2,y2,z2 = getWorldTranslation(workArea.width)
						local x3,y3,z3 = getWorldTranslation(workArea.height)
						local lx1,ly1,lz1 = worldToLocal(self.rootNode,x1,y1,z1)
						local lx2,ly2,lz2 = worldToLocal(self.rootNode,x2,y2,z2)
						local lx3,ly3,lz3 = worldToLocal(self.rootNode,x3,y3,z3)
														
						if lx1 < xmin then
							xmin = lx1
						end
						if lx1 > xmax then
							xmax = lx1
						end
						if lx2 < xmin then
							xmin = lx2
						end
						if lx2 > xmax then
							xmax = lx2
						end
						if lx3 < xmin then
							xmin = lx3
						end
						if lx3 > xmax then
							xmax = lx3
						end
					end			
				end
				self.variableSprayUsageCaluclatedWorkingWidth = math.floor((xmax - xmin)*100)/100								
			end
		end
	end
end

function variableSprayUsage:onDraw(isActiveForInput, isSelected)
	if self.isClient and self.variableSprayUsageAllowScript == true and not self:getIsTurnedOn() then	
		if isActiveForInput then	
			if self.variableSprayUsageSprayRate ~= nil then		
				local aktPrintText     = self.variableSprayUsageSprayRate
				local unit             = {}		
				local massFac          = 1.2 -- Faktor für Kunstdünger --
				local fillUnitIndex    = self.variableSprayUsageAcitveFillUnitIndex
			    local currentFillType  = self:getFillUnitFillType(fillUnitIndex);		
				local currentFillLevel = self:getFillUnitFillLevel(fillUnitIndex)	
				
				if currentFillType == self.fillTypeIDX_LIQUIDMANURE or currentFillType == self.fillTypeIDX_DIGESTATE or currentFillType == self.fillTypeIDX_MANURE or currentFillType == self.fillTypeIDX_LIME  or (self.variableSprayUsage.HasNoCapacity == true and (self.allowFillType_LIQUIDMANURE == true or self.allowFillType_DIGESTATE == true)) then
					unit = "立方米/公顷"
					aktPrintText = aktPrintText/1000
				else
					if currentFillType == self.fillTypeIDX_FERTILIZER or (currentFillLevel == 0 and self.allowFillType_FERTILIZER) then
						unit = "千克/公顷"	
						aktPrintText = aktPrintText*massFac
					else
						unit = "升/公顷"		
					end						
				end
				g_currentMission:addExtraPrintText(g_i18n:getText("current_Sprayrate") .." : ".. aktPrintText .." ".. unit)		
				
				unit = "米"
				aktPrintText = self.variableSprayUsageCaluclatedWorkingWidth
				aktPrintText = math.floor(aktPrintText*10)/10
				if aktPrintText ~= -400 then	
					-- Show Workinwidth --
					-- g_currentMission:addExtraPrintText(g_i18n:getText("current_Workingwidth") .." : ".. aktPrintText .." ".. unit)	
				end				
			end
		end
	end		
end

function variableSprayUsage:onReadStream(streamId, connection)
	if self.variableSprayUsageAllowScript == true then
		self.variableSprayUsageCaluclatedWorkingWidth  = streamReadFloat32(streamId)	
		self.variableSprayUsageSprayRate               = streamReadFloat32(streamId)	
		self.variableSprayUsageHasWorkarea             = streamReadBool(streamId)			
	end
end

function variableSprayUsage:onWriteStream(streamId, connection)
	if self.variableSprayUsageAllowScript == true then
		streamWriteFloat32(streamId, self.variableSprayUsageCaluclatedWorkingWidth )	
		streamWriteFloat32(streamId, self.variableSprayUsageSprayRate )	
		streamWriteBool(streamId, self.variableSprayUsageHasWorkarea )	
	end
end

function variableSprayUsage:onDelete()
end;

function variableSprayUsage:onRegisterActionEvents(isSelected, isOnActiveVehicle)
    if isOnActiveVehicle and isSelected and self.variableSprayUsageAllowScript == true then		
		if self.variableSprayUsageActionEvents == nil then 
			self.variableSprayUsageActionEvents = {}
		else	
			self:clearActionEventsTable( self.variableSprayUsageActionEvents )
		end 

		for _,actionName in pairs({ "INCREASE_SPRAYRATE", "DECREASE_SPRAYRATE" }) do
			local _, eventName = self:addActionEvent(self.variableSprayUsageActionEvents, InputAction[actionName], self, variableSprayUsage.actionCallback, false, true, false, true, nil);			
			g_inputBinding.events[eventName].displayPriority = 1
		end
    end
end

function variableSprayUsage:actionCallback(actionName, keyStatus, arg4, arg5, arg6)	
	if self.variableSprayUsageAllowScript == true and not self:getIsTurnedOn() then 
		if actionName == "INCREASE_SPRAYRATE" or actionName == "DECREASE_SPRAYRATE" then	
			if actionName == "INCREASE_SPRAYRATE" then					
				--Ausbringmenge erhöhen--
				local currentSprayrate = self.variableSprayUsageSprayRate	
				currentSprayrate = currentSprayrate + self.variableSprayUsage.currentStep
				if currentSprayrate <= self.variableSprayUsage.currentMaxLimit then 
					self.variableSprayUsageSprayRate = currentSprayrate
				end				
			end
			
			if actionName == "DECREASE_SPRAYRATE" then
				--Ausbringmenge reduzieren--				
				local currentSprayrate = self.variableSprayUsageSprayRate	
				currentSprayrate = currentSprayrate - self.variableSprayUsage.currentStep
				if currentSprayrate >= self.variableSprayUsage.currentMinLimit then 
					self.variableSprayUsageSprayRate = currentSprayrate
				end		
			end
			
			if g_server ~= nil then
				g_server:broadcastEvent(variableSprayUsageChangeSprayrate_Event:new(self, self.variableSprayUsageSprayRate), nil, nil, self);
			else
				g_client:getServerConnection():sendEvent(variableSprayUsageChangeSprayrate_Event:new(self, self.variableSprayUsageSprayRate));
			end;				
		end
	end
end

-- Overwrite Sprayerspec --
function variableSprayUsage:getSprayerUsage(superFunc, usage, dt)	
	--local usage = superFunc( self, ... )	
	
	if self:getIsActive()then
		if self.variableSprayUsageAllowScript == true then
			local currentSpraywidth = 0 
			local oneHectar         = 10000                            -- 10000m x 1m
			local currentSpeed      = self.lastSpeedReal*1000          -- m/sec
			local currentSprayRate  = self.variableSprayUsageSprayRate -- l/ha
				
			if self.newSectionShiftAktWorkingWidth ~= nil then							
				-- get actual Workingwith from Sectionshift --
				currentSpraywidth = self.newSectionShiftAktWorkingWidth
			else
				-- get actual Workingwith from Workarea --
				currentSpraywidth = self.variableSprayUsageCaluclatedWorkingWidth
			end
								
			usage = currentSprayRate/oneHectar*currentSpraywidth*currentSpeed*dt*0.001
			
		else
			usage = 0
		end
	end
	
	return usage
end

Sprayer.getSprayerUsage = Utils.overwrittenFunction( Sprayer.getSprayerUsage, variableSprayUsage.getSprayerUsage )
addModEventListener(variableSprayUsage);

-- For Server Event --
variableSprayUsageChangeSprayrate_Event = {};
variableSprayUsageChangeSprayrate_Event_mt = Class(variableSprayUsageChangeSprayrate_Event, Event);

InitEventClass(variableSprayUsageChangeSprayrate_Event, "variableSprayUsageChangeSprayrate_Event");					
					
function variableSprayUsageChangeSprayrate_Event:emptyNew()
    local self = Event:new(variableSprayUsageChangeSprayrate_Event_mt);
    return self;
end;

function variableSprayUsageChangeSprayrate_Event:new(object, data)
    local self = variableSprayUsageChangeSprayrate_Event:emptyNew()
    self.object = object;
    self.data = data;
    return self;
end;

function variableSprayUsageChangeSprayrate_Event:readStream(streamId, connection)
    self.object = NetworkUtil.readNodeObject(streamId);
    self.data = streamReadFloat32(streamId);
    self:run(connection);
end;

function variableSprayUsageChangeSprayrate_Event:writeStream(streamId, connection)
    NetworkUtil.writeNodeObject(streamId, self.object);
    streamWriteFloat32(streamId, self.data);
end;

function variableSprayUsageChangeSprayrate_Event:run(connection)
    self.object.variableSprayUsage.SprayRate = self.data;
	
    if not connection:getIsServer() then
        g_server:broadcastEvent(variableSprayUsageChangeSprayrate_Event:new(self.object, self.data), nil, connection, self.object);
    end;
end;