
local Get = Object.GetProperty
local Set = Object.SetProperty
local Find = Object.GetNearbyObjects
local LotteryJackpotNr = 0
local prisonerCount = 0

local ContrabandList = {
    2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 25, 28, 29, 30, 32, 33, 37, 42, 43, 44, 45, 46, 47
}

function Create()
	FindSafe()
end

function FindSafe()
	local nearbySafes = Find(this,"VendingLotterySafe",10000)
	if next(nearbySafes) then
		for thatSafe, dist in pairs(nearbySafes) do
			MySafe = thatSafe
			Set(this,"Outcome",Get(thatSafe,"Outcome"))
			if thatSafe.WeeklyLottery == true then Set(this,"WeeklyLottery",true) end
			if thatSafe.MusicFxDisabled ~= nil then Set(this,"MusicFxDisabled",true) end
		end
	end
end

function FindMyWinner()
	if Get(this,"Winner") == "Prisoner" then
		local nearbyPrisoners = Find(this,"Prisoner",5)
		if next(nearbyPrisoners) then
			for thatPrisoner, dist in pairs(nearbyPrisoners) do
				if thatPrisoner.Id.i == this.WinnerID then
					MyPrisoner = thatPrisoner
					break
				end
			end
		end
		nearbyPrisoners = nil
	else
		local nearbyWardens = Find(this,"Warden",5)
		if next(nearbyWardens) then
			for thatWarden, dist in pairs(nearbyWardens) do
				if thatWarden.Id.i == this.WinnerID then
					MyWarden = thatWarden
					break
				end
			end
		end
		nearbyWardens = nil
	end
end

function CheckIfAlone()													-- check if prisoners can see that you want to assassinate
	prisonerCount = 0
	local nearbyPrisoners = Find(MyPrisoner,"Prisoner",5)
	if next(nearbyPrisoners) then
		for thatPrisoner, dist in pairs(nearbyPrisoners) do
			if thatPrisoner.Id.i ~= this.WinnerID then
				prisonerCount = prisonerCount + 1
			end
		end
	end
	nearbyPrisoners = nil
	if prisonerCount > 0 then
		Interface.RemoveComponent(this,"toggleAssassinate", "Button", "tooltip_button_VM2AssassinateWinner")
		Interface.AddComponent(this,"CaptionAssassinateAreYouSure", "Caption", "tooltip_caption_VM2AssassinateAreYouSure")
		Interface.AddComponent(this,"toggleAreYouSureNo", "Button", "tooltip_button_VM2AssassinateAreYouSureNo")
		Interface.AddComponent(this,"toggleAreYouSureYes", "Button", "tooltip_button_VM2AssassinateAreYouSureYes")
	else
		KillMyWinner()
	end
end

function KillMyWinner()
	FindStackNumbers()
	lotteryJackpot = Object.Spawn("Stack",MyPrisoner.Pos.x+math.random(),MyPrisoner.Pos.y+math.random())
	lotteryJackpot.Contents = LotteryJackpotNr
	lotteryJackpot.Quantity = MyPrisoner.AvailableMoney
	if Get(this,"Outcome") == "reportTooltip_SylvesterLotteryOutcome5" then
		if not this.WeeklyLottery then
			lotteryJackpot.Quantity = MyPrisoner.AvailableMoney - 1000000
			Object.Spawn("SylvesterLotterySuperJackpot",MyPrisoner.Pos.x+math.random(),MyPrisoner.Pos.y+math.random())
		else
			lotteryJackpot.Quantity = MyPrisoner.AvailableMoney - 10000
			Object.Spawn("PrisonLotterySuperJackpot",MyPrisoner.Pos.x+math.random(),MyPrisoner.Pos.y+math.random())
		end
	elseif Get(this,"Outcome") == "reportTooltip_SylvesterLotteryOutcome6" then
		if not this.WeeklyLottery then
			lotteryJackpot.Quantity = MyPrisoner.AvailableMoney - 4500000
			Object.Spawn("SylvesterLotteryMegaJackpot",MyPrisoner.Pos.x+math.random(),MyPrisoner.Pos.y+math.random())
		else
			lotteryJackpot.Quantity = MyPrisoner.AvailableMoney - 100000
			Object.Spawn("PrisonLotteryMegaJackpot",MyPrisoner.Pos.x+math.random(),MyPrisoner.Pos.y+math.random())
		end
	end
	MyPrisoner.AvailableMoney = 0
	prisonerCount = 0													-- check if prisoners can see that you want to assassinate
	local nearbyPrisoners = Find(MyPrisoner,"Prisoner",5)
	if next(nearbyPrisoners) then
		for thatPrisoner, dist in pairs(nearbyPrisoners) do
			if thatPrisoner.Id.i ~= this.WinnerID then
				prisonerCount = prisonerCount + 1
			end
		end
	end
	nearbyPrisoners = nil
	if prisonerCount > 0 then
		StartRiot()
		Set(MySafe,"Outcome","reportTooltip_VM2LotteryOutcome13")
		Set(MySafe,"DecideFirst",nil)
		Set(MySafe,"UpdateFromMarker",true)
	else
		Set(MySafe,"Outcome","reportTooltip_VM2LotteryOutcome15")
		Set(MySafe,"DecideFirst",nil)
		Set(MySafe,"UpdateFromMarker",true)
	end
	if not this.MusicFxDisabled then MyPrisoner.Sound("__FoodFeud","FamilySuccession3") end
	MyPrisoner.Damage = 1
	MyPrisoner = nil
end

function toggleAreYouSureYesClicked()
	KillMyWinner()
end

function toggleAreYouSureNoClicked()
	Interface.RemoveComponent(this,"CaptionAssassinateAreYouSure", "Caption", "tooltip_caption_AreYouSure")
	Interface.RemoveComponent(this,"toggleAreYouSureNo", "Button", "tooltip_button_AreYouSureNo")
	Interface.RemoveComponent(this,"toggleAreYouSureYes", "Button", "tooltip_button_AreYouSureYes")
	Interface.AddComponent(this,"toggleAssassinate", "Button", "tooltip_button_VM2AssassinateWinner")
end

function StartRiot()
	if prisonerCount > 0 then
		nearbyPrisoners = Find(this,"Prisoner",10000)
		if next(nearbyPrisoners) then									-- prisoners notice they got screwed...
			for thatPrisoner, dist in pairs(nearbyPrisoners) do
				if Get(thatPrisoner,"TicketsBought") ~= nil or Get(this,"Outcome") == "reportTooltip_VM2LotteryOutcome5" or Get(this,"Outcome") == "reportTooltip_VM2LotteryOutcome6" then
					thatPrisoner.StatusEffects.angst = 2500
					thatPrisoner.StatusEffects.suppressed  = 0
					thatPrisoner.Needs.Bowels = 200
					thatPrisoner.Needs.Bladder = 200
					thatPrisoner.Needs.Clothing = 200
					thatPrisoner.Needs.Comfort = 200
					thatPrisoner.Needs.Enviroment = 200
					thatPrisoner.Needs.Exercise = 200
					thatPrisoner.Needs.Family = 200
					thatPrisoner.Needs.Food = 200
					thatPrisoner.Needs.Freedom = 200
					thatPrisoner.Needs.Hygiene = 200
					thatPrisoner.Needs.Literacy = 200
					thatPrisoner.Needs.Privacy = 200
					thatPrisoner.Needs.Recreation = 200
					thatPrisoner.Needs.Safety = 200
					thatPrisoner.Needs.Spirituality = 200
					thatPrisoner.Needs.Warmth = 200
					thatPrisoner.Needs.Luxuries = 200
					thatPrisoner.Needs.Drugs = 200
					thatPrisoner.Needs.Alcohol = 200
					thatPrisoner.Needs.Barbery = 200
					thatPrisoner.BoilingPoint = 100
					thatPrisoner.Equipment = ContrabandList[math.random(#ContrabandList)]
					thatPrisoner.Misbehavior = 6
					if math.random() > 0.85 then
						local newFire = Object.Spawn("Fire",thatPrisoner.Pos.x-3+math.random()+math.random()+math.random(),thatPrisoner.Pos.y-3+math.random()+math.random()+math.random())
					end
				end
			end
		end
		nearbyPrisoners = nil
	end
end

function FindStackNumbers()
	local newStack = Object.Spawn("Stack", this.Pos.x, this.Pos.y)
	for i = 1,2000 do
		Set(newStack,"Quantity",2)
		Set(newStack,"Contents",i)
		if newStack.Contents == "LotteryJackpot" then
			LotteryJackpotNr = i
		end
		if LotteryJackpotNr > 1 then
			newStack.Delete()
			break
		end
	end
end

function toggleAssassinateClicked()
	CheckIfAlone()
end

function toggleDeleteClicked()
	Set(MySafe,"Outcome","reportTooltip_VM2LotteryOutcome14")
	Set(MySafe,"DecideFirst",nil)
	Set(MySafe,"UpdateFromMarker",true)
	if not this.MusicFxDisabled then MyPrisoner.Sound("__FoodFeud","FamilySuccession7") end
	ResetPrisonerNeeds(MyPrisoner)
	MyPrisoner.Misbehavior = 0
	MyPrisoner = nil
end



function Update(timePassed)
	if timePerUpdate == nil then
		FindSafe()
		FindMyWinner()
		timePerUpdate = 0
		if this.Winner == "Prisoner" then
			Interface.AddComponent(this,"toggleDelete", "Button", "tooltip_button_VM2GrantTheCash")
			Interface.AddComponent(this,"CaptionLotterySeparatorLine", "Caption", "tooltip_caption_VM2SeparatorLine")
			Interface.AddComponent(this,"toggleAssassinate", "Button", "tooltip_button_VM2AssassinateWinner")
		else
			if not this.BodyGuardsSpawned then
				SpawnBodyGuards()
				SpawnTheHounds()
				this.BodyGuardsSpawned = true
			else
				FindTheHounds()
				FindBodyGuards()
			end
			if not this.WardenKeepsCash then
				Interface.AddComponent(this,"toggleWardenReturn", "Button", "tooltip_button_VM2WardenReturnTheJackpot")
				Interface.AddComponent(this,"toggleWardenDonate", "Button", "tooltip_button_VM2WardenDonateTheJackpot")
				Interface.AddComponent(this,"CaptionLotterySeparatorLine", "Caption", "tooltip_caption_VM2SeparatorLine")
				Interface.AddComponent(this,"toggleWardenKeep", "Button", "tooltip_button_VM2WardenKeepTheJackpot")
			else
				if not this.HoundsReleased then
					Interface.AddComponent(this,"toggleWardenReleaseTheHounds", "Button", "tooltip_button_VM2WardenReleaseTheHounds")
				end
				Interface.AddComponent(this,"toggleWardenReleaseBodyGuards", "Button", "tooltip_button_VM2WardenReleaseBodyGuards")
			end
		end
	end
	
	if this.Winner == "Prisoner" and MyPrisoner ~= nil and MyPrisoner.SubType ~= nil then
		this.Pos.x = MyPrisoner.Pos.x
		this.Pos.y = MyPrisoner.Pos.y
		this.Or.x = MyPrisoner.Or.x
		this.Or.y = MyPrisoner.Or.y
	elseif this.Winner == "Warden" and MyWarden ~= nil and MyWarden.SubType ~= nil then
		this.Pos.x = MyWarden.Pos.x
		this.Pos.y = MyWarden.Pos.y
		this.Or.x = MyWarden.Or.x
		this.Or.y = MyWarden.Or.y
		KeepTheHoundsNearWarden()
		KeepBodyGuardsNearWarden()
		CheckIfWardenIsDead()
	end
	
	if this.Winner == "Prisoner" and MyPrisoner == nil then
		this.Delete()
	end
	if this.Winner == "Warden" and MyWarden == nil then
		this.Delete()
	end
end


function toggleWardenKeepClicked()
	Interface.RemoveComponent(this,"toggleWardenKeep", "Button", "tooltip_button_VM2WardenKeepTheJackpot")
	Interface.AddComponent(this,"CaptionWardenKeepAreYouSure", "Caption", "tooltip_caption_VM2WardenKeepAreYouSure")
	Interface.AddComponent(this,"toggleWardenAreYouSureYes", "Button", "tooltip_button_VM2WardenKeepAreYouSureYes")
	Interface.AddComponent(this,"toggleWardenAreYouSureNo", "Button", "tooltip_button_VM2WardenKeepAreYouSureNo")
end

function toggleWardenAreYouSureYesClicked()
	Interface.RemoveComponent(this,"toggleWardenReturn", "Button", "tooltip_button_VM2WardenReturnTheJackpot")
	Interface.RemoveComponent(this,"toggleWardenDonate", "Button", "tooltip_button_VM2WardenDonateTheJackpot")
	Interface.RemoveComponent(this,"CaptionLotterySeparatorLine", "Caption", "tooltip_caption_VM2SeparatorLine")
	Interface.RemoveComponent(this,"CaptionWardenKeepAreYouSure", "Caption", "tooltip_caption_VM2WardenKeepAreYouSure")
	Interface.RemoveComponent(this,"toggleWardenAreYouSureYes", "Button", "tooltip_button_VM2WardenKeepAreYouSureYes")
	Interface.RemoveComponent(this,"toggleWardenAreYouSureNo", "Button", "tooltip_button_VM2WardenKeepAreYouSureNo")
	Interface.AddComponent(this,"toggleWardenReleaseTheHounds", "Button", "tooltip_button_VM2WardenReleaseTheHounds")
	Interface.AddComponent(this,"toggleWardenReleaseBodyGuards", "Button", "tooltip_button_VM2WardenReleaseBodyGuards")
	KeepTheCash()
end

function toggleWardenAreYouSureNoClicked()
	Interface.RemoveComponent(this,"CaptionWardenKeepAreYouSure", "Caption", "tooltip_caption_VM2WardenKeepAreYouSure")
	Interface.RemoveComponent(this,"toggleWardenAreYouSureYes", "Button", "tooltip_button_VM2WardenKeepAreYouSureYes")
	Interface.RemoveComponent(this,"toggleWardenAreYouSureNo", "Button", "tooltip_button_VM2WardenKeepAreYouSureNo")
	Interface.AddComponent(this,"toggleWardenKeep", "Button", "tooltip_button_VM2WardenKeepTheJackpot")
end

function KeepTheCash()
	FindStackNumbers()
	lotteryJackpot = Object.Spawn("Stack",MyWarden.Pos.x+math.random(),MyWarden.Pos.y+math.random())
	lotteryJackpot.Contents = LotteryJackpotNr
	lotteryJackpot.Quantity = this.Jackpot
	MyWarden.Tooltip = ""
	if not this.MusicFxDisabled then MySafe.Sound("__FoodFeud","FamilySuccession3") end
	Set(MySafe,"Outcome","reportTooltip_VM2LotteryOutcome12")
	Set(MySafe,"JackpotUnfair",true)
	Set(MySafe,"JackpotDonated",true)
	Set(MySafe,"PrisonersMad",true)
	Set(MySafe,"GuardGunsUpgraded",true)
	Set(MySafe,"DecideFirst",nil)
	Set(MySafe,"UpdateFromMarker",true)
	prisonerCount = 1
	StartRiot()
	Set(MyWarden,"Carrying.i",-1)
	Set(MyWarden,"Carrying.u",-1)
	Set(this,"WardenKeepsCash",true)
end

function toggleWardenReleaseTheHoundsClicked()
	Interface.RemoveComponent(this,"toggleWardenReleaseTheHounds", "Button", "tooltip_button_VM2WardenReleaseTheHounds")
	TheHoundsLeaveMap("tooltip_VM2BodyGuardReleased")
	this.HoundsReleased = true
	Set(MySafe,"Outcome","reportTooltip_VM2LotteryOutcome21")
	Set(MySafe,"UpdateFromMarker",true)
end

function toggleWardenReleaseBodyGuardsClicked()
	Set(MySafe,"DecideFirst",nil)
	Set(MySafe,"Outcome","reportTooltip_VM2LotteryOutcome22")
	Set(MySafe,"UpdateFromMarker",true)
	BodyGuardsLeaveMap("tooltip_VM2BodyGuardReleased")
	MyWarden = nil
end

function toggleWardenDonateClicked()
	FindSafe()
	FindTheJackpot()
	if LotteryReturns > 0 then
		prisonerCount = 0
		if nearbyPrisoners == nil then nearbyPrisoners = Find(this,"Prisoner",10000) end
		if next(nearbyPrisoners) then
			for thatPrisoner, dist in pairs(nearbyPrisoners) do
				if Get(thatPrisoner,"TicketsBought") ~= nil then
					prisonerCount = prisonerCount + 1
				end
			end
		end
		if prisonerCount > 0 then
			for thatPrisoner, dist in pairs(nearbyPrisoners) do
				if Get(this,"JackpotUnfair") == false then
					ResetPrisonerNeeds(thatPrisoner)
					Set(MySafe,"Outcome","reportTooltip_VM2LotteryOutcome8")
				else
					Set(MySafe,"Outcome","reportTooltip_VM2LotteryOutcome11")
				end
				if Get(thatPrisoner,"TicketsBought") ~= nil then
					thatPrisoner.AvailableMoney = thatPrisoner.AvailableMoney+(LotteryReturns / prisonerCount)
					for i=1,thatPrisoner.TicketsBought do
						Set(thatPrisoner,"T"..i,nil)
					end
					Set(thatPrisoner,"TicketsBought",nil)
				end
			end
		else
			MySafe.NotSpread = true
			Set(MySafe,"Outcome","reportTooltip_VM2LotteryOutcome10")
		end
		nearbyPrisoners = nil
	else
		Set(MySafe,"Outcome","reportTooltip_VM2LotteryOutcome9")
		Set(MySafe,"JackpotUnavailable",true)
	end
	if not MySafe.JackpotUnavailable then
		if MySafe.NotSpread then
			if not this.MusicFxDisabled then MySafe.Sound("__ConvictionSuicide","SuicideMusic1") end
		else
			if MySafe.JackpotUnfair == true then
				if not this.MusicFxDisabled then MySafe.Sound("__ConvictionSuicide","SuicideMusic1") end
			else
				if not this.MusicFxDisabled then MySafe.Sound("__ConvictionHeist","HeistMusic12") end
				if not this.MusicFxDisabled then MySafe.Sound("__FoodFeud","FamilySuccession7") end
			end
		end
	else
		if not this.MusicFxDisabled then MySafe.Sound("__ConvictionSuicide","SuicideMusic1") end
	end
	Set(MySafe,"JackpotDonated",true)
	Set(MySafe,"DecideFirst",nil)
	Set(MySafe,"UpdateFromMarker",true)
	TheHoundsLeaveMap("tooltip_VM2BodyGuardSacked")
	BodyGuardsLeaveMap("tooltip_VM2BodyGuardSacked")
	MyWarden = nil
end

function toggleWardenReturnClicked()
	FindSafe()
	FindTheJackpot()
	if LotteryReturns > 0 then
		if nearbyPrisoners == nil then nearbyPrisoners = Find(this,"Prisoner",10000) end
		if next(nearbyPrisoners) then
			for thatPrisoner, dist in pairs(nearbyPrisoners) do
				if Get(thatPrisoner,"TicketsBought") ~= nil then
					prisonerCount = prisonerCount + 1
				end
			end
		end
		if prisonerCount > 0 then
			for thatPrisoner, dist in pairs(nearbyPrisoners) do
				if Get(this,"JackpotUnfair") == false then
					ResetPrisonerNeeds(thatPrisoner)
					Set(MySafe,"Outcome","reportTooltip_VM2LotteryOutcome20")
				else
					Set(MySafe,"Outcome","reportTooltip_VM2LotteryOutcome11")
				end
				if Get(thatPrisoner,"TicketsBought") ~= nil then
					for i=1,thatPrisoner.TicketsBought do
						Set(thatPrisoner,"T"..i,nil)
					end
					Set(thatPrisoner,"TicketsBought",nil)
				end
			end
			Set(MySafe,"WardenReturns",LotteryReturns)
		else
			MySafe.NotSpread = true
			Set(MySafe,"Outcome","reportTooltip_VM2LotteryOutcome10")
		end
		nearbyPrisoners = nil
	else
		Set(MySafe,"Outcome","reportTooltip_VM2LotteryOutcome9")
		Set(MySafe,"JackpotUnavailable",true)
	end
	if not MySafe.JackpotUnavailable then
		if MySafe.NotSpread then
			if not this.MusicFxDisabled then MySafe.Sound("__ConvictionSuicide","SuicideMusic1") end
		else
			if MySafe.JackpotUnfair == true then
				if not this.MusicFxDisabled then MySafe.Sound("__ConvictionSuicide","SuicideMusic1") end
			else
				if not this.MusicFxDisabled then MySafe.Sound("__ConvictionHeist","HeistMusic12") end
				if not this.MusicFxDisabled then MySafe.Sound("__FoodFeud","FamilySuccession7") end
			end
		end
	else
		if not this.MusicFxDisabled then MySafe.Sound("__ConvictionSuicide","SuicideMusic1") end
	end
	Set(MySafe,"JackpotDonated",true)
	Set(MySafe,"DecideFirst",nil)
	Set(MySafe,"UpdateFromMarker",true)
	TheHoundsLeaveMap("tooltip_VM2BodyGuardSacked")
	BodyGuardsLeaveMap("tooltip_VM2BodyGuardSacked")
	MyWarden = nil
end

function FindTheJackpot()
	LotteryReturns = 0
	Set(this,"JackpotUnfair",true)
	if Get(MyWarden,"Jackpot") ~= nil then
		LotteryReturns = MyWarden.Jackpot
		Set(this,"JackpotUnfair",false)
		MyWarden.Tooltip = ""
	end
	if this.Outcome == "reportTooltip_VM2LotteryOutcome2" then Set(this,"JackpotUnfair",true) end
	if not this.WeeklyLottery then
		local nearbySuperJackpot = Find(this,"SylvesterLotterySuperJackpot",10000)
		if next(nearbySuperJackpot) then
			for thatSuperJackpot, dist in pairs(nearbySuperJackpot) do
				if thatSuperJackpot.Tooltip == "tooltip_SylvesterLotterySuperJackpot" then
					Set(this,"JackpotUnfair",false)
					LotteryReturns = LotteryReturns + 1000000
					thatSuperJackpot.Delete()
					break
				end
			end
		end
	else
		local nearbySuperJackpot = Find(this,"PrisonLotterySuperJackpot",10000)
		if next(nearbySuperJackpot) then
			for thatSuperJackpot, dist in pairs(nearbySuperJackpot) do
				if thatSuperJackpot.Tooltip == "tooltip_PrisonLotterySuperJackpot" then
					Set(this,"JackpotUnfair",false)
					LotteryReturns = LotteryReturns + 1000000
					thatSuperJackpot.Delete()
					break
				end
			end
		end
	end
	if this.Outcome == "reportTooltip_VM2LotteryOutcome3" then Set(this,"JackpotUnfair",true) end
	if not this.WeeklyLottery then
		local nearbyMegaJackpot = Find(this,"SylvesterPrisonLotteryMegaJackpot",10000)
		if next(nearbyMegaJackpot) then
			for thatMegaJackpot, dist in pairs(nearbyMegaJackpot) do
				if thatMegaJackpot.Tooltip == "tooltip_SylvesterLotteryMegaJackpot" then
					Set(this,"JackpotUnfair",false)
					LotteryReturns = LotteryReturns + 4500000
					thatMegaJackpot.Delete()
					break
				end
			end
		end
	else
		local nearbyMegaJackpot = Find(this,"PrisonLotteryMegaJackpot",10000)
		if next(nearbyMegaJackpot) then
			for thatMegaJackpot, dist in pairs(nearbyMegaJackpot) do
				if thatMegaJackpot.Tooltip == "tooltip_PrisonLotteryMegaJackpot" then
					Set(this,"JackpotUnfair",false)
					LotteryReturns = LotteryReturns + 4500000
					thatMegaJackpot.Delete()
					break
				end
			end
		end
	end
	nearbyLotteryJackpot = nil
	nearbySuperJackpot = nil
	nearbyMegaJackpot = nil
end

function FindTheHounds()
	local nearbyHounds = Find(this,"Dog",10000)
	if next(nearbyHounds) then
		for thatHound, dist in pairs(nearbyHounds) do
			if thatHound.IsBodyGuard == true then
				if thatHound.BodyGuardNr == 1 then
					MyHound1 = thatHound
				elseif thatHound.BodyGuardNr == 2 then
					MyHound2 = thatHound
				elseif thatHound.BodyGuardNr == 3 then
					MyHound3 = thatHound
				elseif thatHound.BodyGuardNr == 4 then
					MyHound4 = thatHound
				end
			end
		end
	end
	nearbyHounds = nil
end

function SpawnTheHounds()
	MyHound1 = Object.Spawn("Dog",MyWarden.Pos.x,MyWarden.Pos.y)
	Set(MyHound1,"IsBodyGuard",true)
	MyHound2 = Object.Spawn("Dog",MyWarden.Pos.x,MyWarden.Pos.y)
	Set(MyHound2,"IsBodyGuard",true)
	MyHound3 = Object.Spawn("Dog",MyWarden.Pos.x,MyWarden.Pos.y)
	Set(MyHound3,"IsBodyGuard",true)
	MyHound4 = Object.Spawn("Dog",MyWarden.Pos.x,MyWarden.Pos.y)
	Set(MyHound4,"IsBodyGuard",true)
end

function FindBodyGuards()
	local nearbyBodyGuards = Find(this,"Soldier",10000)
	if next(nearbyBodyGuards) then
		for thatBodyGuard, dist in pairs(nearbyBodyGuards) do
			if thatBodyGuard.IsBodyGuard == true then
				if thatBodyGuard.BodyGuardNr == 1 then
					MyBodyGuard1 = thatBodyGuard
				elseif thatBodyGuard.BodyGuardNr == 2 then
					MyBodyGuard2 = thatBodyGuard
				elseif thatBodyGuard.BodyGuardNr == 3 then
					MyBodyGuard3 = thatBodyGuard
				elseif thatBodyGuard.BodyGuardNr == 4 then
					MyBodyGuard4 = thatBodyGuard
				end
			end
		end
	end
	nearbyBodyGuards = nil
end

function SpawnBodyGuards()
	MyBodyGuard1 = Object.Spawn("Soldier",MyWarden.Pos.x,MyWarden.Pos.y)
	Set(MyBodyGuard1,"IsBodyGuard",true)
	Set(MyBodyGuard1,"BodyGuardNr",1)
	Set(MyBodyGuard1,"Tooltip","tooltip_VM2BodyGuard1")
	MyBodyGuard2 = Object.Spawn("Soldier",MyWarden.Pos.x,MyWarden.Pos.y)
	Set(MyBodyGuard2,"IsBodyGuard",true)
	Set(MyBodyGuard2,"BodyGuardNr",2)
	Set(MyBodyGuard2,"Tooltip","tooltip_VM2BodyGuard2")
	MyBodyGuard3 = Object.Spawn("Soldier",MyWarden.Pos.x,MyWarden.Pos.y)
	Set(MyBodyGuard3,"IsBodyGuard",true)
	Set(MyBodyGuard3,"BodyGuardNr",3)
	Set(MyBodyGuard3,"Tooltip","tooltip_VM2BodyGuard3")
	MyBodyGuard4 = Object.Spawn("Soldier",MyWarden.Pos.x,MyWarden.Pos.y)
	Set(MyBodyGuard4,"IsBodyGuard",true)
	Set(MyBodyGuard4,"BodyGuardNr",4)
	Set(MyBodyGuard4,"Tooltip","tooltip_VM2BodyGuard4")
end

function CheckIfWardenIsDead()
	if MyWarden ~= nil and MyWarden.SubType ~= nil and MyWarden.Damage == 1 then
		if not this.WardenKeepsCash then
			FindStackNumbers()
			lotteryJackpot = Object.Spawn("Stack",MyWarden.Pos.x+math.random(),MyWarden.Pos.y+math.random())
			lotteryJackpot.Contents = LotteryJackpotNr
			lotteryJackpot.Quantity = this.Jackpot
		end
		if Get(MyWarden,"DeathType") == "Fight" then
			if Get(MyWarden,"MurdererType") == "Prisoner" then
				--print("warden killed by prisoner")
				if Get(MyWarden,"MurderWeapon") == "None" then
					--print("The warden was murdered by a prisoner")
					Set(MySafe,"Outcome","reportTooltip_VM2LotteryOutcome19a")
				else
					--print("The warden was murdered by prisoner with "..MyWarden.MurderWeapon)
					Set(MySafe,"Outcome","The warden was murdered by a prisoner with "..MyWarden.MurderWeapon)
				end
			end
		elseif Get(MyWarden,"DeathType") == "Fire" then
			Set(MySafe,"Outcome","reportTooltip_VM2LotteryOutcome19b")
		elseif Get(MyWarden,"DeathType") == "Riot" then
			Set(MySafe,"Outcome","reportTooltip_VM2LotteryOutcome19c")
		elseif Get(MyWarden,"DeathType") == "Explosion" then
			Set(MySafe,"Outcome","reportTooltip_VM2LotteryOutcome19d")
		end
		Set(MySafe,"WardenWasKilled",true)
		Set(MySafe,"DecideFirst",nil)
		Set(MySafe,"UpdateFromMarker",true)
		TheHoundsLeaveMap("tooltip_VM2BodyGuardGoingNuts")
		BodyGuardsLeaveMap("tooltip_VM2BodyGuardGoingNuts")
		MyWarden = nil
	end
end

function KeepTheHoundsNearWarden()
	
	if MyHound1 ~= nil and MyHound1.SubType ~= nil and MyHound1.Damage >= 0.85 then
		Set(MyHound1,"Tooltip","tooltip_VM2BodyGuardDismissed")
		MyHound1 = nil
	end
	if MyHound2 ~= nil and MyHound2.SubType ~= nil and MyHound2.Damage >= 0.85 then
		Set(MyHound2,"Tooltip","tooltip_VM2BodyGuardDismissed")
		MyHound2 = nil
	end
	if MyHound3 ~= nil and MyHound3.SubType ~= nil and MyHound3.Damage >= 0.85 then
		Set(MyHound3,"Tooltip","tooltip_VM2BodyGuardDismissed")
		MyHound3 = nil
	end
	if MyHound4 ~= nil and MyHound4.SubType ~= nil and MyHound4.Damage >= 0.85 then
		Set(MyHound4,"Tooltip","tooltip_VM2BodyGuardDismissed")
		MyHound4 = nil
	end
	
	if MyHound1 ~= nil and MyHound1.SubType ~= nil then
		if MyWarden ~= nil and MyWarden.SubType ~= nil then
			MyHound1.Pos.x = MyWarden.Pos.x+0.75
			MyHound1.Pos.y = MyWarden.Pos.y-0.75
			MyHound1.Or.x = MyWarden.Or.x
			MyHound1.Or.y = MyWarden.Or.y
		end
	end
	if MyHound2 ~= nil and MyHound2.SubType ~= nil then
		if MyWarden ~= nil and MyWarden.SubType ~= nil then
			MyHound2.Pos.x = MyWarden.Pos.x+0.75
			MyHound2.Pos.y = MyWarden.Pos.y+0.75
			MyHound2.Or.x = MyWarden.Or.x
			MyHound2.Or.y = MyWarden.Or.y
		end
	end
	if MyHound3 ~= nil and MyHound3.SubType ~= nil then
		if MyWarden ~= nil and MyWarden.SubType ~= nil then
			MyHound3.Pos.x = MyWarden.Pos.x-0.75
			MyHound3.Pos.y = MyWarden.Pos.y+0.75
			MyHound3.Or.x = MyWarden.Or.x
			MyHound3.Or.y = MyWarden.Or.y
		end
	end
	if MyHound4 ~= nil and MyHound4.SubType ~= nil then
		if MyWarden ~= nil and MyWarden.SubType ~= nil then
			MyHound4.Pos.x = MyWarden.Pos.x-0.75
			MyHound4.Pos.y = MyWarden.Pos.y-0.75
			MyHound4.Or.x = MyWarden.Or.x
			MyHound4.Or.y = MyWarden.Or.y
		end
	end
end

function TheHoundsLeaveMap(theTooltip)
	if MyHound1 ~= nil and MyHound1.SubType ~= nil and MyHound1.Damage < 0.85 then
		Set(MyHound1,"Tooltip",theTooltip)
		MyHound1.Energy = 100
		MyHound1.Damage = 0
		MyHound1.NavigateTo(MyWarden.Pos.x + 1.75,MyWarden.Pos.y - 1.75)
		MyHound1 = nil
	end
	if MyHound2 ~= nil and MyHound2.SubType ~= nil and MyHound2.Damage < 0.85 then
		Set(MyHound2,"Tooltip",theTooltip)
		MyHound2.Energy = 100
		MyHound2.Damage = 0
		MyHound2.NavigateTo(MyWarden.Pos.x + 1.75,MyWarden.Pos.y + 1.75)
		MyHound2 = nil
	end
	if MyHound3 ~= nil and MyHound3.SubType ~= nil and MyHound3.Damage < 0.85 then
		Set(MyHound3,"Tooltip",theTooltip)
		MyHound3.Energy = 100
		MyHound3.Damage = 0
		MyHound3.NavigateTo(MyWarden.Pos.x - 1.75,MyWarden.Pos.y + 1.75)
		MyHound3 = nil
	end
	if MyHound4 ~= nil and MyHound4.SubType ~= nil and MyHound4.Damage < 0.85 then
		Set(MyHound4,"Tooltip",theTooltip)
		MyHound4.Energy = 100
		MyHound4.Damage = 0
		MyHound4.NavigateTo(MyWarden.Pos.x + 1.75,MyWarden.Pos.y - 1.75)
		MyHound4 = nil
	end
end

function KeepBodyGuardsNearWarden()
	
	if MyBodyGuard1 ~= nil and MyBodyGuard1.SubType ~= nil and MyBodyGuard1.Damage >= 0.85 then
		Set(MyBodyGuard1,"Tooltip","tooltip_VM2BodyGuardDismissed")
		MyBodyGuard1 = nil
	end
	if MyBodyGuard2 ~= nil and MyBodyGuard2.SubType ~= nil and MyBodyGuard2.Damage >= 0.85 then
		Set(MyBodyGuard2,"Tooltip","tooltip_VM2BodyGuardDismissed")
		MyBodyGuard2 = nil
	end
	if MyBodyGuard3 ~= nil and MyBodyGuard3.SubType ~= nil and MyBodyGuard3.Damage >= 0.85 then
		Set(MyBodyGuard3,"Tooltip","tooltip_VM2BodyGuardDismissed")
		MyBodyGuard3 = nil
	end
	if MyBodyGuard4 ~= nil and MyBodyGuard4.SubType ~= nil and MyBodyGuard4.Damage >= 0.85 then
		Set(MyBodyGuard4,"Tooltip","tooltip_VM2BodyGuardDismissed")
		MyBodyGuard4 = nil
	end
	
	if MyBodyGuard1 ~= nil and MyBodyGuard1.SubType ~= nil then
		if MyWarden ~= nil and MyWarden.SubType ~= nil then
			MyBodyGuard1.Pos.x = MyWarden.Pos.x-0.85
			MyBodyGuard1.Pos.y = MyWarden.Pos.y
			MyBodyGuard1.Or.x = MyWarden.Or.x
			MyBodyGuard1.Or.y = MyWarden.Or.y
		end
	end
	if MyBodyGuard2 ~= nil and MyBodyGuard2.SubType ~= nil then
		if MyWarden ~= nil and MyWarden.SubType ~= nil then
			MyBodyGuard2.Pos.x = MyWarden.Pos.x+0.85
			MyBodyGuard2.Pos.y = MyWarden.Pos.y
			MyBodyGuard2.Or.x = MyWarden.Or.x
			MyBodyGuard2.Or.y = MyWarden.Or.y
		end
	end
	if MyBodyGuard3 ~= nil and MyBodyGuard3.SubType ~= nil then
		if MyWarden ~= nil and MyWarden.SubType ~= nil then
			MyBodyGuard3.Pos.x = MyWarden.Pos.x
			MyBodyGuard3.Pos.y = MyWarden.Pos.y+0.85
			MyBodyGuard3.Or.x = MyWarden.Or.x
			MyBodyGuard3.Or.y = MyWarden.Or.y
		end
	end
	if MyBodyGuard4 ~= nil and MyBodyGuard4.SubType ~= nil then
		if MyWarden ~= nil and MyWarden.SubType ~= nil then
			MyBodyGuard4.Pos.x = MyWarden.Pos.x
			MyBodyGuard4.Pos.y = MyWarden.Pos.y-0.85
			MyBodyGuard4.Or.x = MyWarden.Or.x
			MyBodyGuard4.Or.y = MyWarden.Or.y
		end
	end
end

function BodyGuardsLeaveMap(theTooltip)
	if MyBodyGuard1 ~= nil and MyBodyGuard1.SubType ~= nil and MyBodyGuard1.Damage < 0.85 then
		Set(MyBodyGuard1,"Tooltip",theTooltip)
		MyBodyGuard1.Energy = 100
		MyBodyGuard1.Damage = 0
		MyBodyGuard1 = nil
	end
	if MyBodyGuard2 ~= nil and MyBodyGuard2.SubType ~= nil and MyBodyGuard2.Damage < 0.85 then
		Set(MyBodyGuard2,"Tooltip",theTooltip)
		MyBodyGuard2.Energy = 100
		MyBodyGuard2.Damage = 0
		MyBodyGuard2 = nil
	end
	if MyBodyGuard3 ~= nil and MyBodyGuard3.SubType ~= nil and MyBodyGuard3.Damage < 0.85 then
		Set(MyBodyGuard3,"Tooltip",theTooltip)
		MyBodyGuard3.Energy = 100
		MyBodyGuard3.Damage = 0
		MyBodyGuard3 = nil
	end
	if MyBodyGuard4 ~= nil and MyBodyGuard4.SubType ~= nil and MyBodyGuard4.Damage < 0.85 then
		Set(MyBodyGuard4,"Tooltip",theTooltip)
		MyBodyGuard4.Energy = 100
		MyBodyGuard4.Damage = 0
		MyBodyGuard4 = nil
	end
end

function ResetPrisonerNeeds(thePrisoner)
	thePrisoner.StatusEffects.angst = 0
	thePrisoner.StatusEffects.suppressed  = 0
	thePrisoner.Needs.Bowels = 0
	thePrisoner.Needs.Bladder = 0
	thePrisoner.Needs.Clothing = 0
	thePrisoner.Needs.Comfort = 0
	thePrisoner.Needs.Enviroment = 0
	thePrisoner.Needs.Exercise = 0
	thePrisoner.Needs.Family = 0
	thePrisoner.Needs.Food = 0
	thePrisoner.Needs.Freedom = 0
	thePrisoner.Needs.Hygiene = 0
	thePrisoner.Needs.Literacy = 0
	thePrisoner.Needs.Privacy = 0
	thePrisoner.Needs.Recreation = 0
	thePrisoner.Needs.Safety = 0
	thePrisoner.Needs.Spirituality = 0
	thePrisoner.Needs.Warmth = 0
	thePrisoner.Needs.Luxuries = 0
	thePrisoner.Needs.Drugs = 0
	thePrisoner.Needs.Alcohol = 0
	thePrisoner.Needs.Barbery = 0
	thePrisoner.BoilingPoint = 0
	thePrisoner.Misbehavior = 0
end

