
local LotteryType = 0
local LotteryCashNr = 0
local timeTot = 0
local timePerUpdate = 0.5
local Get = Object.GetProperty
local Set = Object.SetProperty
local Find = Object.GetNearbyObjects

function FindMySafe()
	MySafe = nil
	local nearbySafes = Find(this,"VendingLotterySafe",10000)
	if next(nearbySafes) then
		for thatSafe, dist in pairs(nearbySafes) do
			MySafe = thatSafe
			break
		end
	end
end

function CreateStake()
	MyStake = Object.Spawn("Stack", this.Pos.x+this.Or.x, this.Pos.y+this.Or.y)
	MyStake.Quantity = 1000
	if LotteryCashNr == 0 then
		for i = 1,2000 do
			Set(MyStake,"Contents",i)
			if MyStake.Contents == "VendingLotteryCash" then
				LotteryCashNr = i
			end
			if LotteryCashNr > 1 then
				break
			end
		end
	else
		MyStake.Contents = LotteryCashNr
	end	
end

function MatchVendingWithSafe()
	if not Exists(MySafe) then
		FindMySafe()
	else
		if not MySafe.WeeklyLottery then this.SubType = 1 else this.SubType = 0 end	-- determines SubType of this vending machine:
																					-- Sylvester Lottery starts at SubType 1, normal Lottery starts at 0
	end
end

function getObject(type,id,dist)
	objs = Find(type,dist or 1)
	for o,d in pairs(objs) do
		 if o.Id.i == id then
		 	return o
		 end
	end
end

function getEntity(id,dist)
	print("trying to find entity")
	local entityGroup = { "Prisoner", "Workman", "Guard", "ArmedGuard",
				"Orderly", "Cook", "Gardener", "Janitor",
				"DogHandler", "Sniper", "Chief",
				"Foreman", "Psychologist", "Psychiatrist", "Accountant",
				"Lawyer", "SystemAdministrator", "ComputerNerd",
				"SimulationOfficeManager", "YogaMaster",
				"GraveDigger", "VendingManager",
				"ForestryWorker", "BarberChief",
				"Barber",
				"CarMechanic2", "CraneOperator2",
				"GardenWorker", "GreenhouseWorker", "PlantationWorker", "Tailor",
				"SmartPhoneGenius", "R4_GardenWorker", "R4_GreenhouseWorker",
				"R4_RecyclingWorker", "M4_PlantationWorker", "M4_Tailor",
				"TeslaMaticExpert", "ShadyTeslaDude",
				"TeslaMaticExpert3", "ShadyTeslaDude3",
				"PrisonFireman2Chief",
				"PrisonFiremanT1M1","PrisonFiremanT1M2","PrisonFiremanT1M3","PrisonFiremanT1M4",
				"PrisonFiremanT2M1","PrisonFiremanT2M2","PrisonFiremanT2M3","PrisonFiremanT2M4",
				"PrisonFiremanT3M1","PrisonFiremanT3M2","PrisonFiremanT3M3","PrisonFiremanT3M4",
				"PrisonFiremanT4M1","PrisonFiremanT4M2","PrisonFiremanT4M3","PrisonFiremanT4M4",
				"PrisonFiremanT5M1","PrisonFiremanT5M2","PrisonFiremanT5M3","PrisonFiremanT5M4",
				"PrisonFiremanT6M1","PrisonFiremanT6M2","PrisonFiremanT6M3","PrisonFiremanT6M4",
				"PrisonFiremanT7M1","PrisonFiremanT7M2","PrisonFiremanT7M3","PrisonFiremanT7M4",
				"PrisonFiremanT8M1","PrisonFiremanT8M2","PrisonFiremanT8M3","PrisonFiremanT8M4",
				"PrisonFiremanT9M1","PrisonFiremanT9M2","PrisonFiremanT9M3","PrisonFiremanT9M4",
				"PrisonFiremanT10M1","PrisonFiremanT10M2","PrisonFiremanT10M3","PrisonFiremanT10M4",
				"PrisonFiremanT11M1","PrisonFiremanT11M2","PrisonFiremanT11M3","PrisonFiremanT11M4",
				"PrisonFiremanT12M1","PrisonFiremanT12M2","PrisonFiremanT12M3","PrisonFiremanT12M4",
				"PrisonFiremanT13M1","PrisonFiremanT13M2","PrisonFiremanT13M3","PrisonFiremanT13M4",
				"PrisonFiremanT14M1","PrisonFiremanT14M2","PrisonFiremanT14M3","PrisonFiremanT14M4",
				"PrisonFiremanT15M1","PrisonFiremanT15M2","PrisonFiremanT15M3","PrisonFiremanT15M4",
				"PrisonFiremanT16M1","PrisonFiremanT16M2","PrisonFiremanT16M3","PrisonFiremanT16M4",
				"PrisonFiremanT17M1","PrisonFiremanT17M2","PrisonFiremanT17M3","PrisonFiremanT17M4",
				"PrisonFiremanT18M1","PrisonFiremanT18M2","PrisonFiremanT18M3","PrisonFiremanT18M4",
				"PrisonFiremanT19M1","PrisonFiremanT19M2","PrisonFiremanT19M3","PrisonFiremanT19M4",
				"PrisonFiremanT20M1","PrisonFiremanT20M2","PrisonFiremanT20M3","PrisonFiremanT20M4",
				"PrisonFiremanT21M1","PrisonFiremanT21M2","PrisonFiremanT21M3","PrisonFiremanT21M4",
				"PrisonFiremanT22M1","PrisonFiremanT22M2","PrisonFiremanT22M3","PrisonFiremanT22M4",
				"PrisonFiremanT23M1","PrisonFiremanT23M2","PrisonFiremanT23M3","PrisonFiremanT23M4",
				"PrisonFiremanT24M1","PrisonFiremanT24M2","PrisonFiremanT24M3","PrisonFiremanT24M4",
				"PrisonFiremanT25M1","PrisonFiremanT25M2","PrisonFiremanT25M3","PrisonFiremanT25M4",
				"PrisonFiremanT26M1","PrisonFiremanT26M2","PrisonFiremanT26M3","PrisonFiremanT26M4",
				"PrisonFiremanA0", "PrisonFiremanA1", "PrisonFiremanA2", "PrisonFiremanA3", "PrisonFiremanB0", "PrisonFiremanB1", "PrisonFiremanB2", "PrisonFiremanB3",
				"PrisonFiremanC0", "PrisonFiremanC1", "PrisonFiremanC2", "PrisonFiremanC3", "PrisonFiremanD0", "PrisonFiremanD1", "PrisonFiremanD2", "PrisonFiremanD3"
				 }

	for _, typ in pairs(entityGroup) do
		local entityType = Find(typ,dist or 1)
		for thatEntity, _ in pairs(entityType) do
			if thatEntity.Id.i == id then
				print("found entity "..thatEntity.Type)
				return thatEntity
			end
		end
		entityType = nil
	end
	entityGroup = nil
end

function Create()
	this.WeeklyLottery = true
	this.inUse = false
	this.OutOfOrder = false
	this.VendingStock = 0
	this.StoredStake = 0
	this.Tooltip = "Available: "..this.VendingStock.." items\nStored Stake: "..this.StoredStake
	this.ItemToSell = "VendingSold"..string.sub(this.Type,15,-1)
	this.ItemToStack = "VendingStack"..string.sub(this.Type,15,-1)
	this.ItemToEquip0 = 0
	this.ItemToEquip1 = 0
end

function Update(timePassed)
	timeTot = timeTot + timePassed
	if timeTot > timePerUpdate then
		timeTot = 0
		MatchVendingWithSafe()
		if this.VendingStock > 0 then
			if not this.OutOfOrder then
				if this.Slot0.i > -1 then
					if not this.inUse then
						theEntity = getEntity(this.Slot0.i,2)
						if theEntity ~= nil and this.VendingStock >= 1 then
							this.inUse = true
							if not EquipmentFound then FindEquipmentNumbers() end
							theEntity.Sound("VendingMachine2","CoinDrop")
							myTicket = Object.Spawn(this.ItemToSell,theEntity.Pos.x,theEntity.Pos.y+0.1)
							myTicket.SubType = this.SubType
							Set(myTicket,"ItemToEquip0",this.ItemToEquip0)
							Set(myTicket,"ItemToEquip1",this.ItemToEquip1)
							Set(myTicket,"FindEntity",theEntity.Id.i)
							myTicket.Sound("VendingMachine2","VendingActive")
							this.VendingStock = this.VendingStock - 1
							if this.VendingStock <= 0 then
								this.VendingStock = 0
								this.Tooltip = "This vending machine is empty\nIt should be refilled soon"
								myEarnings = Object.Spawn("VendingEarnings",this.Pos.x+this.Or.x,this.Pos.y+this.Or.y)
							end
							
							local theStake = math.random(10,100)		-- determines how much cash the entity will bet.
						
							if Get(theEntity,"TicketsBought") == nil then
								Set(theEntity,"TicketsBought",1)
								Set(theEntity,"T1",math.floor(World.TimeIndex))
							else
								Set(theEntity,"TicketsBought",Get(theEntity,"TicketsBought")+1)
								Set(theEntity,"T"..theEntity.TicketsBought,math.floor(World.TimeIndex))
							end
							
							if theEntity.Type == "Prisoner" then		-- prisoners don't have such great amounts of money, so adjust if prisoner
								if theEntity.AvailableMoney > 2 then
									theStake = math.random(1,theEntity.AvailableMoney)
									theEntity.AvailableMoney = theEntity.AvailableMoney - theStake
								else
									theStake = 2						-- must be 2 because a new stack of MyStake must have at least quantity 2
									theEntity.AvailableMoney = 0
								end
								if Get(theEntity,"Stake") == nil then
									Set(theEntity,"Stake",theStake)
								else
									Set(theEntity,"Stake",Get(theEntity,"Stake")+theStake)
								end
							end
								
							if not Exists(MySafe) then FindMySafe() end
							if Exists(MySafe) then
								Set(MySafe,"TicketsSold",MySafe.TicketsSold + 1)
								Set(MySafe,"LastStake",theStake)
								this.StoredStake = this.StoredStake + theStake
								if this.StoredStake > 1000 then
									this.StoredStake = this.StoredStake - 1000
									CreateStake()
								end
							end
							theStake = nil
							
							if math.random(0,1000) == 666 then
								this.OutOfOrder = true
								this.Tooltip = "This vending machine is out of order\nA service mechanic should repair it soon"
							else
								this.Tooltip = "Available: "..this.VendingStock.." items\nStored Stake: $"..this.StoredStake
							end
						end
					end
				else
					if this.inUse == true then
						this.Sound("VendingMachine2","VendingDone")
						this.inUse = false
					end
				end
			else
				if this.Or.x == 0 and this.Or.y == 1 then
					if this.WeeklyLottery == true then this.SubType = 2 else this.SubType = 3 end
				end
				Object.CreateJob(this,"RepairVendingMachine")
			end
		else
			if this.Or.x == 0 and this.Or.y == 1 then
				if this.WeeklyLottery == true then this.SubType = 2 else this.SubType = 3 end
			end
			Object.CreateJob(this,"Refill"..this.ItemToStack)
		end
		if this.OutOfOrder == true then PlaceSign("OutOfOrder") elseif this.VendingStock == 0 then PlaceSign("OutOfStock") end
	end
end

function JobComplete_RepairVendingMachine()
	RemoveSign("OutOfOrder")
	this.Tooltip = "Available: "..this.VendingStock.." items\nStored Stake: $"..this.StoredStake
	if this.Or.x == 0 and this.Or.y == 1 then
		if this.WeeklyLottery == true then this.SubType = 0 else this.SubType = 1 end
	end
	this.OutOfOrder = false
	this.inUse = false
end

function MachineRefilled()
	FindEquipmentNumbers()
	RemoveSign("OutOfStock")
	this.VendingStock = 40
	this.Tooltip = "Available: "..this.VendingStock.." items\nStored Stake: $"..this.StoredStake
	if this.Or.x == 0 and this.Or.y == 1 then
		if this.WeeklyLottery == true then this.SubType = 0 else this.SubType = 1 end
	end
	this.inUse = false
end

function FindEquipmentNumbers()
	local Equipment0 = "VendingSpawned"..string.sub(this.Type,15,-1).."0"
	local TestPerson = Object.Spawn("VendingTestEntity",this.Pos.x,this.Pos.y)
	for i = 57,1000 do
		TestPerson.Equipment = i
		if TestPerson.Equipment == Equipment0 then
			this.ItemToEquip0 = i
			this.ItemToEquip1 = i+1
			break
		end
	end
	TestPerson.Delete()
	EquipmentFound = true
end

function JobComplete_RefillVendingStackLottery()
	MachineRefilled()
end

function PlaceSign(theSign)
	if this.Slot0.i == -1 then
		mySign = Object.Spawn("Vending"..theSign.."Sign",this.Pos.x,this.Pos.y)
		this.Slot0.i = mySign.Id.i
		this.Slot0.u = mySign.Id.u
		mySign.CarrierId.i = this.Id.i
		mySign.CarrierId.u = this.Id.u
		mySign.Loaded = true
		if this.Or.x == 0 and this.Or.y == 1 then
			-- do nothing
		else
			mySign.Hidden = true
		end
	end
end

function RemoveSign(theSign)
	if this.Slot0.i > -1 then
		local mySign = getObject("Vending"..theSign.."Sign",this.Slot0.i,2)
		if Exists(mySign) then
			this.Slot0.i = -1
			this.Slot0.u = -1
			mySign.Delete()
			mySign = nil
		end
	end
end

function Exists(theObject)
	if theObject ~= nil and theObject.SubType ~= nil then
		return true
	else
		return false
	end
end