
local timeTot = 1
local timePerUpdate = 0.25

local Get = Object.GetProperty
local Set = Object.SetProperty

function getEntity(id,dist)
	local entityGroup = { "Prisoner", "Workman", "Guard", "ArmedGuard",
				"Orderly", "Cook", "Gardener", "Janitor",
				"DogHandler", "Sniper", "Chief",
				"Foreman", "Psychologist", "Psychiatrist", "Accountant",
				"Lawyer", "Farmer", "SystemAdministrator", "ComputerNerd",
				"SimulationOfficeManager", "YogaMaster",
				"GraveDigger", "VendingManager",
				"LotteryOfficial",
				"ForestryWorker", "BarberChief",
				"Barber",
				"CarMechanic2", "CraneOperator2",
				"GardenWorker", "GreenhouseWorker", "PlantationWorker", "Tailor",
				"SmartPhoneGenius", "R4_GardenWorker", "R4_GreenhouseWorker",
				"R4_RecyclingWorker", "M4_PlantationWorker", "M4_Tailor",
				"TeslaMaticExpert", "ShadyTeslaDude",
				"TeslaMaticExpert3", "ShadyTeslaDude3",
				"PrisonFireman2Chief",
				"PrisonFiremanT1M1","PrisonFiremanT1M2","PrisonFiremanT1M3","PrisonFiremanT1M4",
				"PrisonFiremanT2M1","PrisonFiremanT2M2","PrisonFiremanT2M3","PrisonFiremanT2M4",
				"PrisonFiremanT3M1","PrisonFiremanT3M2","PrisonFiremanT3M3","PrisonFiremanT3M4",
				"PrisonFiremanT4M1","PrisonFiremanT4M2","PrisonFiremanT4M3","PrisonFiremanT4M4",
				"PrisonFiremanT5M1","PrisonFiremanT5M2","PrisonFiremanT5M3","PrisonFiremanT5M4",
				"PrisonFiremanT6M1","PrisonFiremanT6M2","PrisonFiremanT6M3","PrisonFiremanT6M4",
				"PrisonFiremanT7M1","PrisonFiremanT7M2","PrisonFiremanT7M3","PrisonFiremanT7M4",
				"PrisonFiremanT8M1","PrisonFiremanT8M2","PrisonFiremanT8M3","PrisonFiremanT8M4",
				"PrisonFiremanT9M1","PrisonFiremanT9M2","PrisonFiremanT9M3","PrisonFiremanT9M4",
				"PrisonFiremanT10M1","PrisonFiremanT10M2","PrisonFiremanT10M3","PrisonFiremanT10M4",
				"PrisonFiremanT11M1","PrisonFiremanT11M2","PrisonFiremanT11M3","PrisonFiremanT11M4",
				"PrisonFiremanT12M1","PrisonFiremanT12M2","PrisonFiremanT12M3","PrisonFiremanT12M4",
				"PrisonFiremanT13M1","PrisonFiremanT13M2","PrisonFiremanT13M3","PrisonFiremanT13M4",
				"PrisonFiremanT14M1","PrisonFiremanT14M2","PrisonFiremanT14M3","PrisonFiremanT14M4",
				"PrisonFiremanT15M1","PrisonFiremanT15M2","PrisonFiremanT15M3","PrisonFiremanT15M4",
				"PrisonFiremanT16M1","PrisonFiremanT16M2","PrisonFiremanT16M3","PrisonFiremanT16M4",
				"PrisonFiremanT17M1","PrisonFiremanT17M2","PrisonFiremanT17M3","PrisonFiremanT17M4",
				"PrisonFiremanT18M1","PrisonFiremanT18M2","PrisonFiremanT18M3","PrisonFiremanT18M4",
				"PrisonFiremanT19M1","PrisonFiremanT19M2","PrisonFiremanT19M3","PrisonFiremanT19M4",
				"PrisonFiremanT20M1","PrisonFiremanT20M2","PrisonFiremanT20M3","PrisonFiremanT20M4",
				"PrisonFiremanT21M1","PrisonFiremanT21M2","PrisonFiremanT21M3","PrisonFiremanT21M4",
				"PrisonFiremanT22M1","PrisonFiremanT22M2","PrisonFiremanT22M3","PrisonFiremanT22M4",
				"PrisonFiremanT23M1","PrisonFiremanT23M2","PrisonFiremanT23M3","PrisonFiremanT23M4",
				"PrisonFiremanT24M1","PrisonFiremanT24M2","PrisonFiremanT24M3","PrisonFiremanT24M4",
				"PrisonFiremanT25M1","PrisonFiremanT25M2","PrisonFiremanT25M3","PrisonFiremanT25M4",
				"PrisonFiremanT26M1","PrisonFiremanT26M2","PrisonFiremanT26M3","PrisonFiremanT26M4",
				"PrisonFiremanA0", "PrisonFiremanA1", "PrisonFiremanA2", "PrisonFiremanA3", "PrisonFiremanB0", "PrisonFiremanB1", "PrisonFiremanB2", "PrisonFiremanB3",
				"PrisonFiremanC0", "PrisonFiremanC1", "PrisonFiremanC2", "PrisonFiremanC3", "PrisonFiremanD0", "PrisonFiremanD1", "PrisonFiremanD2", "PrisonFiremanD3"
				 }

	for _, typ in pairs(entityGroup) do
		local entityType = Object.GetNearbyObjects(typ,dist or 1)
		for thatEntity, _ in pairs(entityType) do
			if thatEntity.Id.i == id then
				print("Found "..thatEntity.Type)
				this.UseActiveFlag = EntityCanUseActiveFlag(thatEntity.Type)
				return thatEntity
			end
		end
		entityType = nil
	end
	entityGroup = nil
end

function EntityCanUseActiveFlag(CurrentEntity)
	local entityGroup = { "Prisoner", "Workman", "Guard", "Gardener", "Janitor", "DogHandler", "Sniper", "Farmer" }
	local ActiveFlag = false
	for _, typ in pairs(entityGroup) do
		if typ == CurrentEntity then
			ActiveFlag = true
			break
		end
	end
	entityGroup = nil
	return ActiveFlag
end

function Create()
	this.SubType = math.random(0,2)
	this.ItemToSpawn = "VendingSpawned"..string.sub(this.Type,12,-1)..this.SubType
	this.VendingActivated = false
	this.ItemToEquip0 = 0
	this.ItemToEquip1 = 0
	this.ItemToEquip2 = 0
end

function Update(timePassed)
	if this.FindEntity == nil then return end
	timeTot = timeTot + timePassed
	if timeTot > timePerUpdate then
		timeTot = 0
		timePerUpdate = 3
		if not Exists(theEntity) then
			theEntity = getEntity(this.FindEntity,2)
			if Exists(theEntity) then
				if this.VendingActivated == false then
					ActivateVendingEquipment()
				else													-- delete after loadgame
					DeactivateVendingEquipment()
					this.Delete()
				end
			else
				this.Delete()
			end
		else
			DeactivateVendingEquipment()
			this.Delete()
		end
	end
	if Exists(theEntity) then
		this.Pos.x,this.Pos.y = theEntity.Pos.x,theEntity.Pos.y+0.1
	end
end

function ActivateVendingEquipment()
	if this.UseActiveFlag == true then
		if theEntity.Equipment ~= nil then
			this.TmpEquipment = theEntity.Equipment						-- temp store entities equipment
		end
		theEntity.Equipment = Get(this,"ItemToEquip"..this.SubType)		-- set sold vending equipment
		theEntity.Active = true											-- show entity holding equipment in hand, bug: NOT supported by Orderly and modded staffmembers
		this.SubType = 3												-- transparent sprite subtype
	--else
		-- this entity can't seem to hold equipment in the hand, so we don't hide and just show the original sold vending item
	end
	this.VendingActivated = true
end

function DeactivateVendingEquipment()
	if this.UseActiveFlag == true then
		theEntity.Equipment = 0											-- remove sold vending equipment
		if this.TmpEquipment ~= nil then
			for i = 0,1000 do
				theEntity.Equipment = i
				if theEntity.Equipment == this.TmpEquipment then		-- if restore entities previous equipment
					break
				end
			end
		end
		theEntity.Active = false										-- hides the entities hand
	end
end

function Exists(theObject)
	if theObject ~= nil and theObject.SubType ~= nil then
		return true
	else
		return false
	end
end
