
local Get = Object.GetProperty
local Set = Object.SetProperty
local Find = Object.GetNearbyObjects

local timeTot=0
local Amount = 0
local Current = 0
local FruitRow = 1
local FruitXY = {
		[1] = { X = 0,		 Y = -0.75 },
		[2] = { X = -0.5,	 Y = -0.35 },
		[3] = { X = 0,		 Y = -0.35 },
		[4] = { X = 0.5,	 Y = -0.35 },
		[5] = { X = -0.25,	 Y = 0.15 },
		[6] = { X = 0,		 Y = 0.15 },
		[7] = { X = 0.25,	 Y = 0.15 }
		}
local age = 0
local Stage1 = 0
local Stage2 = 0
local Stage3 = 0
local Stage4 = 0
local Stage5 = 0
local Completed2 = false
local Completed3 = false
local Completed4 = false
local Completed5 = false
local Flowers = false
local Tending = false

function Create()
	Set(this,"HomeUID",me["id-uniqueId"])
	Set(this,"Stage1Age", math.random(240,360) )
    Set(this,"Stage2Age", math.random(this.Stage1Age+240,this.Stage1Age+360) )
    Set(this,"Stage3Age", math.random(this.Stage2Age+240,this.Stage2Age+360) )
    Set(this,"Stage4Age", math.random(this.Stage3Age+240,this.Stage3Age+360) )
    Set(this,"Stage5Age", math.random(this.Stage4Age+240,this.Stage4Age+360) )
	Set(this,"Age", 0 )
	Set(this,"FlowersSpawned", false )
    Set(this,"NeedsTending", false )
    Set(this,"Stage2Complete", false )
    Set(this,"Stage3Complete", false )
    Set(this,"Stage4Complete", false )
    Set(this,"Stage5Complete", false )
	Set(this,"FruitType",string.sub(this.Type,12,-1))
end

function LoadFruit()
	AllFruit = {}
	local F = 0
	local MyFruit = Find(this,"VendingTreeFruit"..this.FruitType,2)
	for thatFruit, dist in pairs(MyFruit) do
		if thatFruit.HomeUID == this.HomeUID then
			F = F + 1
			AllFruit[F] = {}
			AllFruit[F] = thatFruit
			if FruitRow <=7 then
				if Amount <= 5 then
					Amount = Amount + 1
				else
					Amount = 0
					FruitRow = FruitRow + 1
				end
			end
		end
	end
	MyFruit = nil
end

function SpawnFruit()
	local newFruit = Object.Spawn( "VendingTreeFruit"..this.FruitType,this.Pos.x+FruitXY[FruitRow].X,this.Pos.y+FruitXY[FruitRow].Y )
	Set(newFruit, "SubType",0)
	Set(newFruit, "HomeUID",this.HomeUID)
	Set(newFruit, "Tooltip", "tooltip_VendingTreeStage1" )
	local velX = -0.5 + math.random()
	local velY = -0.5 + math.random()
	Object.ApplyVelocity(newFruit, velX, velY)
	table.insert(AllFruit,newFruit)
	timePerUpdate = (math.random(1,5)+math.random()+math.random()) / World.TimeWarpFactor
end

function UpdateFruit(num,newSubType)
	if newSubType < 13 then
		if math.random() > 0.33 then
			AllFruit[num].SubType = newSubType
			Set(AllFruit[num], "Tooltip", "tooltip_VendingTreeStage2" )
		else
			AllFruit[num].Delete()
			table.remove(AllFruit,num)
			Current = Current - 1
		end
	elseif newSubType == 13 then
		if math.random() > 0.66 then
			AllFruit[num].SubType = newSubType
			Set(AllFruit[num], "Tooltip", "tooltip_VendingTreeStage3" )
		else
			AllFruit[num].Delete()
			table.remove(AllFruit,num)
			Current = Current - 1
		end
	elseif newSubType == 14 then
		AllFruit[num].SubType = newSubType
		Set(AllFruit[num], "Tooltip", "tooltip_VendingTreeStage4" )
	end
	timePerUpdate = (math.random(1,5)+math.random()+math.random()) / World.TimeWarpFactor
end

function SpawnHarvestFruit(num)
	local newFruit = {}
	if math.random() > 0.85 then
		newFruit = Object.Spawn("VendingTreeFruitRotten"..this.FruitType, AllFruit[num].Pos.x, AllFruit[num].Pos.y )
	else
		newFruit = Object.Spawn("Vending"..this.FruitType,AllFruit[num].Pos.x,AllFruit[num].Pos.y)
	end
	
	AllFruit[num].Delete()
	table.remove(AllFruit,num)
	Current = Current - 1
	
	local velY = 1.75 + this.Pos.y - newFruit.Pos.y
	Object.ApplyVelocity(newFruit, 0, velY )
	timePerUpdate = (math.random(1,5)+math.random()+math.random()) / World.TimeWarpFactor
end

function Update( timePassed )
	if timePerUpdate == nil then
		LoadFruit()
		age = Get(this,"Age")
		Stage1 = Get(this,"Stage1Age")
		Stage2 = Get(this,"Stage2Age")
		Stage3 = Get(this,"Stage3Age")
		Stage4 = Get(this,"Stage4Age")
		Stage5 = Get(this,"Stage5Age")
		Completed2 = Get(this,"Stage2Complete")
		Completed3 = Get(this,"Stage3Complete")
		Completed4 = Get(this,"Stage4Complete")
		Completed5 = Get(this,"Stage5Complete")
		Flowers = Get(this,"FlowersSpawned")
		Tending = Get(this,"NeedsTending")
		this.Tooltip = { "tooltip_VendingTree",this.FruitType,"F" }
		timePerUpdate = (1+math.random()+math.random()) / World.TimeWarpFactor
	else

		timeTot=timeTot+timePassed
		if timeTot >= timePerUpdate then
			timeTot = 0
			
			if Tending == true then
				timePerUpdate = (25+math.random()+math.random()) / World.TimeWarpFactor
				Object.CreateJob(this,"TendVendingTree")
				this.Tooltip = { "tooltip_VendingTreeTending",this.FruitType,"F" }
				return
			end
			
			age = age + timePerUpdate
			this.Age = age
			
			if Flowers == false and age >= Stage1 then
				if FruitRow <=7 then
					if Amount <= 5 then
						SpawnFruit()
						Amount = Amount + 1
					else
						Amount = 0
						FruitRow = FruitRow + 1
					end
				else
					Amount = 0
					FruitRow = 1
					Current = 0
					Flowers = true
					timePerUpdate = (1+math.random()+math.random()) / World.TimeWarpFactor
					Set(this,"FlowersSpawned", true )
				end
			elseif age >= Stage2 and Completed2 == false then
				Current = Current + 1
				if Current <= #AllFruit then
					UpdateFruit(Current,math.random(1,12))
				else
					Current = 0
					Completed2 = true
					timePerUpdate = (1+math.random()+math.random()) / World.TimeWarpFactor
					Set(this,"Stage2Complete", true )
				end
			elseif age >= Stage3 and Completed3 == false then
				Current = Current + 1
				if Current <= #AllFruit then
					UpdateFruit(Current,13)
				else
					Current = 0
					Completed3 = true
					timePerUpdate = (1+math.random()+math.random()) / World.TimeWarpFactor
					Set(this,"Stage3Complete", true )
				end
			elseif age >= Stage4 and Completed4 == false then
				Current = Current + 1
				if Current <= #AllFruit then
					UpdateFruit(Current,14)
				else
					Current = 0
					Completed4 = true
					timePerUpdate = (1+math.random()+math.random()) / World.TimeWarpFactor
					Set(this,"Stage4Complete", true )
				end
			elseif age >= Stage5 and Completed5 == false then
				Current = Current + 1
				if Current <= #AllFruit then
					SpawnHarvestFruit(Current)
				else
					Current = 0
					Completed5 = true
					Tending = true
					Set(this,"Stage5Complete", true)
					Set(this,"NeedsTending", true)
					timePerUpdate = (1+math.random()+math.random()) / World.TimeWarpFactor
				end
			end
		end
	end
end

function JobComplete_TendVendingTree()
	Stage1 = math.random(240,360)
	Stage2 = math.random(Stage1+240,Stage1+360)
	Stage3 = math.random(Stage2+240,Stage2+360)
	Stage4 = math.random(Stage3+240,Stage3+360)
	Stage5 = math.random(Stage4+240,Stage4+360)
	Completed2 = false
	Completed3 = false
	Completed4 = false
	Completed5 = false
	Flowers = false
	Tending = false
	Set(this,"Stage1Age",Stage1)
    Set(this,"Stage2Age",Stage2)
    Set(this,"Stage3Age",Stage3)
    Set(this,"Stage4Age",Stage4)
    Set(this,"Stage5Age",Stage5)
	Set(this,"Age", 0 )
	Set(this,"FlowersSpawned", false )
    Set(this,"NeedsTending", false )
    Set(this,"Stage5Complete", false )
    Set(this,"Stage4Complete", false )
    Set(this,"Stage3Complete", false )
    Set(this,"Stage2Complete", false )
	timePerUpdate = (1+math.random()+math.random()) / World.TimeWarpFactor
	this.Tooltip = { "tooltip_VendingTree",this.FruitType,"F" }
end
