
local splashTimeLow = 2.0 		-- seconds
local splashTimeHigh = 3.0 		-- seconds

local fiddleChance = 0.7
local minDist = 0.5
local maxDist = 2

local maxSplashes = 3  -- 3
local coolDown = 0.5  -- 0.5
local numSplashes = math.random(0,3)

function rand(minVal, maxVal)
	if minVal == nil then
		return math.random()
	elseif maxVal == nil then
		return math.random(minVal)
	else
		return math.random(minVal,maxVal)
	end
end

local randomtable

function smallrand()
	if randomtable == nil then
		randomtable = {}
		for i = 1, 97 do
			randomtable[i] = rand()
		end
	end
	local x = rand()
	local i = 1 + math.floor(97*x)
	x, randomtable[i] = randomtable[i], x
	return x
end

function Create()
	this.startPosX = nil
	this.startPosY = nil
	this.Splashtimer = rand(splashTimeLow,splashTimeHigh)
	this.coolDown = 0
--	numSplashes = rand(maxSplashes)
end

function Update(dt)
	if this.Splashtimer == nil then this.Delete() end
	this.Tooltip = this.Splashtimer

	-- hook to set initial position
	if not this.startPosX then
		this.startPosX = this.Pos.x
		this.startPosY = this.Pos.y
	end

	-- wiggle
	this.Pos.y = this.startPosY + math.sin(Game.Time())*0.02

	-- create puddles of water
	if tonumber(this.coolDown) <= 0 and tonumber(numSplashes) > 0 then

		if rand() < fiddleChance then
			if rand() > 0.5 then
				dirX = -1
				dirY = 1
			else
				dirX = 1
				dirY = -1
			end

			if tonumber(this.Or.x) == 0 then
				thePuddle = Object.Spawn("VendingWaterPuddle", this.Pos.x + dirX * rand(maxDist) * smallrand() + minDist, this.Pos.y + this.Or.y * smallrand())
			else
				thePuddle = Object.Spawn("VendingWaterPuddle", this.Pos.x + this.Or.x * smallrand(), this.Pos.y + dirY * rand(maxDist) * smallrand() + minDist)
			end
			thePuddle.ApplyVelocity(rand(-1,1)*smallrand(),this.Or.y*rand(1,1)*smallrand(),true)

			numSplashes = numSplashes - 1
			this.coolDown = coolDown
		elseif tonumber(numSplashes) > 0 then
			this.coolDown = this.coolDown - dt
		end
	end

	-- check timer
	if tonumber(this.Splashtimer) > 0 then
		this.Splashtimer = this.Splashtimer - dt
	elseif tonumber(this.Splashtimer) < -1.5 then
		this.Delete()
	else
		this.Splashtimer = this.Splashtimer - dt
	end
	
end
