Potion_Health.sell_cost = 11
LevelRewards = {}
LevelUnlockedMaps = {MarketPlace_CircusArena = 26, ArenaPlatforms = 36}
LevelRewards[1] = {
  effects = {},
  loot_choice = {}
}
LevelRewards[2] = {
  effects = {
    "SA_Level_3_E1"
  },
  loot_choice = {
    "Card_Hope_2",
    "Card_TheWarrior_2",
    "Card_Strength_2"
  },
  display_name = T({
    548,
    "Destiny Cards"
  }),
  display_descr = T({
    549,
    "Congratulations! You can now equip Destiny Cards which grant various passive abilities! Each Destiny Card requires Destiny Points and a free Destiny Slot. Your slots and points will increase at certain levels."
  }),
  icon = "UI/Common/LevelUpDestinySlots.tga"
}
DefineClass.SA_Level_3_E1 = {
  __parents = {"SA_Health"},
  modifiers = {health = 500}
}
LevelRewards[3] = {
  effects = {
    "SA_Level_5_E1"
  },
  loot_choice = {
    "Card_TheArcher_2",
    "Card_TheRogue_2",
    "GiftBox3"
  },
  display_name = T({
    570,
    "+<number> Health",
    number = SA_Level_3_E1.modifiers.health
  }),
  display_descr = T({
    571,
    "Congratulations! Your Health pool has increased, allowing you to endure more damage."
  }),
  icon = "UI/Common/LevelUp_Health.tga"
}
DefineClass.SA_Level_4_E1 = {
  __parents = {"SA_Effect"},
  modifiers = {weapon_slots = 1}
}
LevelRewards[4] = {
  effects = {
    "SA_Level_4_E1"
  },
  loot_choice = {
    "Hammer_MonsterCrusher",
    "Sword_PlasmaBlade_red",
    "Shotgun_PartyStarter"
  },
  display_name = T({
    550,
    "Second Weapon"
  }),
  display_descr = T({
    551,
    "You can now equip a second weapon of your choice. In combat you can switch freely between your first and second weapon."
  }),
  icon = "UI/Common/LevelUp_SecondWeapon.tga"
}
DefineClass.SA_Level_5_E1 = {
  __parents = {
    "SA_DestinyPoints"
  },
  modifiers = {destiny_points = 4}
}
LevelRewards[5] = {
  effects = {
    "SA_Level_5_E1"
  },
  loot_choice = {
    "Card_TheGuardian_2",
    "Card_TheMoon_2",
    "GiftBox3"
  },
  display_name = T({
    566,
    "+<number> Destiny Points",
    number = SA_Level_5_E1.modifiers.destiny_points
  }),
  display_descr = T({
    567,
    "You can now equip more powerful Destiny Cards. The Destiny Points cost of all equipped cards cannot exceed your total DP."
  }),
  icon = "UI/Common/LevelUp_DestinyPoint.tga"
}
DefineClass.SA_Level_6_E1 = {
  __parents = {"SA_Effect"},
  modifiers = {consumable_slots = 1}
}
LevelRewards[6] = {
  effects = {
    "SA_Level_6_E1"
  },
  loot_choice = {
    function()
      return NewItem("Potion_GreaterMedKit", {stack = 1})
    end,
    function()
      return NewItem("Bomb_Fire", {stack = 99})
    end,
    function()
      return NewItem("GiftBox3", {stack = 1})
    end
  },
  display_name = T({
    552,
    "Second Consumable"
  }),
  display_descr = T({
    553,
    "You can now equip a second consumable item. Potions grant healing or buffs, while bombs hit all enemies around you."
  }),
  icon = "UI/Common/LevelUp_SecondConsumable.tga"
}
DefineClass.SA_Level_7_E1 = {
  __parents = {"SA_Health"},
  modifiers = {health = 500}
}
LevelRewards[7] = {
  effects = {
    "SA_Level_7_E1"
  },
  loot_choice = {
    function()
      return NewItem("Potion_LuckyRabbitsFoot", {stack = 1})
    end,
    function()
      return NewItem("Bomb_Souldrain", {stack = 99})
    end,
    function()
      return NewItem("GiftBox3", {stack = 1})
    end
  },
  display_name = T({
    570,
    "+<number> Health",
    number = SA_Level_7_E1.modifiers.health
  }),
  display_descr = T({
    571,
    "Congratulations! Your Health pool has increased, allowing you to endure more damage."
  }),
  icon = "UI/Common/LevelUp_Health.tga"
}
DefineClass.SA_Level_8_E1 = {
  __parents = {
    "SA_DestinyPoints"
  },
  modifiers = {max_overdrive_add = OverdriveBar}
}
LevelRewards[8] = {
  effects = {
    "SA_Level_8_E1"
  },
  loot_choice = {
    "Rune_Shockwave4",
    "Rune_Boomerang4",
    "Rune_Diamond4"
  },
  display_name = T({3577, "Overdrive"}),
  display_descr = T({
    3578,
    "Your overdrive maximum has increased. Overdrive allows you to activate demonic powers."
  }),
  icon = "UI/Common/LevelUp_Overdrive.tga"
}
DefineClass.SA_Level_9_E1 = {
  __parents = {
    "SA_DestinyPoints"
  },
  modifiers = {destiny_points = 4}
}
LevelRewards[9] = {
  effects = {
    "SA_Level_9_E1"
  },
  loot_choice = {
    "Card_TheSlayer_3",
    "Card_TheBishop_3",
    "GiftBox3"
  },
  display_name = T({
    566,
    "+<number> Destiny Points",
    number = SA_Level_9_E1.modifiers.destiny_points
  }),
  display_descr = T({
    567,
    "You can now equip more powerful Destiny Cards. The Destiny Points cost of all equipped cards cannot exceed your total DP."
  }),
  icon = "UI/Common/LevelUp_DestinyPoint.tga"
}
DefineClass.SA_Level_10_E1 = {
  __parents = {
    "SA_CardSlots"
  },
  modifiers = {destiny_slots = 2}
}
LevelRewards[10] = {
  effects = {
    "SA_Level_10_E1"
  },
  loot_choice = {
    function()
      return NewItem("LightningGun_Basic", {
        level = 10,
        damage_prc = 10,
        mod2 = "luck"
      })
    end,
    function()
      return NewItem("Sword_Basic", {
        level = 10,
        damage_prc = 10,
        mod1 = "piercing"
      })
    end,
    "GiftBox3"
  },
  display_name = T({
    568,
    "New Destiny Slot"
  }),
  display_descr = T({
    569,
    "You can now equip more Destiny Cards. The Destiny Points cost of all equipped cards cannot exceed your total DP."
  }),
  icon = "UI/Common/LevelUpDestinySlots.tga"
}
DefineClass.SA_Level_11_E1 = {
  __parents = {
    "SA_DestinyPoints"
  },
  modifiers = {destiny_points = 4}
}
LevelRewards[11] = {
  effects = {
    "SA_Level_11_E1"
  },
  loot_choice = {
    "Card_TheVampire_3",
    "Card_TheAlchemist_3",
    "GiftBox3"
  },
  display_name = T({
    566,
    "+<number> Destiny Points",
    number = SA_Level_11_E1.modifiers.destiny_points
  }),
  display_descr = T({
    567,
    "You can now equip more powerful Destiny Cards. The Destiny Points cost of all equipped cards cannot exceed your total DP."
  }),
  icon = "UI/Common/LevelUp_DestinyPoint.tga"
}
LevelRewards[12] = {
  effects = {"SA_Level_3_E1"},
  loot_choice = {
    function()
      return NewItem("PowerStone_Armor", {stack = 10})
    end,
    function()
      return NewItem("Bomb_Flash", {stack = 99})
    end,
    function()
      return NewItem("GiftBox3", {stack = 1})
    end
  },
  display_name = T({558, "Hexes"}),
  display_descr = T({
    559,
    "Hexes are special items that allow you to customize the game difficulty. Each Hex changes the gameplay in an unique way. If you seek a greater challenge, activate a Hex from your Inventory."
  }),
  hard_mode_display_descr = T({
    3607,
    "You are playing in Hard Mode. Your Hexes are always active."
  }),
  exec = AddHexItems,
  icon = "UI/Common/LevelUp_Hexes.tga"
}
DefineClass.SA_Level_13_E1 = {
  __parents = {"SA_Health"},
  modifiers = {health = 500}
}
LevelRewards[13] = {
  effects = {
    "SA_Level_13_E1"
  },
  loot_choice = {
    function()
      return CreateDestinyCard("Card_TheHunter_3", 25, "better_items", 100)
    end,
    function()
      return CreateDestinyCard("Card_TheBlademaster_3", 25, "penetration", 100)
    end,
    function()
      return CreateDestinyCard("Card_TheSmith_3", 25, "speed_on_kill", 100)
    end
  },
  display_name = T({
    570,
    "+<number> Health",
    number = SA_Level_13_E1.modifiers.health
  }),
  display_descr = T({
    571,
    "Congratulations! Your Health pool has increased, allowing you to endure more damage."
  }),
  icon = "UI/Common/LevelUp_Health.tga"
}
DefineClass.SA_Level_14_E1 = {
  __parents = {"SA_Effect"},
  modifiers = {rune_slots = 1}
}
LevelRewards[14] = {
  effects = {
    "SA_Level_14_E1"
  },
  loot_choice = {
    "Rune_DarkMist4",
    "Rune_GuardianAngel4",
    "Rune_Sunray4"
  },
  display_name = T({
    560,
    "Second Demon Power"
  }),
  display_descr = T({
    561,
    "You can now equip and use a second Demon Power. Demon Powers deplete your Overdrive on use. Deal damage to monsters to increase your Overdrive."
  }),
  icon = "UI/Common/LevelUP_SecondDemonPower.tga"
}
local GetUniqueItems = function(list, max_count)
  local result = {}
  for i = 1, #list do
    local name = list[i]
    if not HeroFindItem(name) then
      table.insert(result, NewItem(name))
      if max_count <= #result then
        break
      end
    end
  end
  return result
end
LevelRewards[15] = {
  effects = {"SA_Level_3_E1"},
  loot_choice = {
    function()
      local choices = {
        "Outfit_Hunter",
        "Outfit_Gentleman",
        "Outfit_Vigilante",
        "Outfit_BattleArmor"
      }
      local list = GetUniqueItems(choices, 3)
      if #list == 0 then
        table.insert(list, NewItem("Potion_Health", {stack = 99}))
        table.insert(list, NewItem("Bomb_Souldrain", {stack = 99}))
        table.insert(list, NewItem("GiftBox4", {stack = 5}))
      end
      return list
    end
  },
  display_name = T({562, "Outfits"}),
  display_descr = T({
    563,
    "Outfits affect the way you gain Overdrive and use Demon Powers. You can inspect the Outfits from your Inventory."
  }),
  icon = "UI/Common/LevelUp_Outfits.tga"
}
LevelRewards[16] = {
  effects = {"SA_Level_3_E1"},
  loot_choice = {
    function()
      return NewItem("PowerStone_DemonPower", {stack = 10})
    end,
    function()
      return NewItem("PowerStone_Armor", {stack = 10})
    end,
    function()
      return NewItem("PowerStone_Fervor", {stack = 10})
    end
  },
  display_name = T({
    3579,
    "Transmutation"
  }),
  display_descr = T({
    3580,
    "Transmutation allows you to upgrade your items or create new items by combining what you have. You can transmute your items in the Hub. Don't forget to check out the basic transmutation recipes in the Codex."
  }),
  icon = "UI/Common/LevelUP_Transmutation.tga"
}
DefineClass.SA_Level_17_E1 = {
  __parents = {
    "SA_DestinyPoints"
  },
  modifiers = {destiny_points = 2}
}
LevelRewards[17] = {
  effects = {
    "SA_Level_17_E1"
  },
  loot_choice = {
    function()
      return NewItem("Hammer_Basic", {
        level = 17,
        damage_prc = 100,
        mod2 = "vulture",
        mod1 = "bansheeSlayers"
      })
    end,
    function()
      return NewItem("HandMortar_Basic", {
        level = 17,
        damage_prc = 100,
        mod2 = "mauling",
        mod1 = "bansheeSlayers"
      })
    end,
    function()
      return NewItem("GiftBox3", {stack = 3})
    end
  },
  display_name = T({
    566,
    "+<number> Destiny Points",
    number = SA_Level_17_E1.modifiers.destiny_points
  }),
  display_descr = T({
    567,
    "You can now equip more powerful Destiny Cards. The Destiny Points cost of all equipped cards cannot exceed your total DP."
  }),
  icon = "UI/Common/LevelUp_DestinyPoint.tga"
}
DefineClass.SA_Level_18_E1 = {
  __parents = {"SA_Health"},
  modifiers = {health = 500}
}
LevelRewards[18] = {
  effects = {
    "SA_Level_18_E1"
  },
  loot_choice = {
    function()
      return NewItem("PowerStone_Divinity", {stack = 10})
    end,
    function()
      return NewItem("PowerStone_Wickedness", {stack = 10})
    end,
    function()
      return NewItem("GiftBox3", {stack = 1})
    end
  },
  display_name = T({
    570,
    "+<number> Health",
    number = SA_Level_18_E1.modifiers.health
  }),
  display_descr = T({
    571,
    "Congratulations! Your Health pool has increased, allowing you to endure more damage."
  }),
  icon = "UI/Common/LevelUp_Health.tga"
}
DefineClass.SA_Level_19_E1 = {
  __parents = {
    "SA_DestinyPoints"
  },
  modifiers = {destiny_points = 2}
}
LevelRewards[19] = {
  effects = {
    "SA_Level_19_E1"
  },
  loot_choice = {
    function()
      return NewItem("PowerStone_Damage", {stack = 20})
    end,
    function()
      return NewItem("PowerStone_Accuracy", {stack = 20})
    end,
    "GiftBox3"
  },
  display_name = T({
    566,
    "+<number> Destiny Points",
    number = SA_Level_19_E1.modifiers.destiny_points
  }),
  display_descr = T({
    567,
    "You can now equip more powerful Destiny Cards. The Destiny Points cost of all equipped cards cannot exceed your total DP."
  }),
  icon = "UI/Common/LevelUp_DestinyPoint.tga"
}
DefineClass.SA_Level_20_E1 = {
  __parents = {
    "SA_CardSlots"
  },
  modifiers = {destiny_slots = 2}
}
LevelRewards[20] = {
  effects = {
    "SA_Level_20_E1"
  },
  loot_choice = {
    "Card_TheBishop_3",
    "Card_Death_3",
    "GiftBox3"
  },
  display_name = T({
    568,
    "New Destiny Slot"
  }),
  display_descr = T({
    569,
    "You can now equip more Destiny Cards. The Destiny Points cost of all equipped cards cannot exceed your total DP."
  }),
  icon = "UI/Common/LevelUpDestinySlots.tga"
}
DefineClass.SA_Level_21_E1 = {
  __parents = {
    "SA_DestinyPoints"
  },
  modifiers = {destiny_points = 2}
}
LevelRewards[21] = {
  effects = {
    "SA_Level_21_E1"
  },
  loot_choice = {
    function()
      return NewItem("LightningGun_Basic", {
        level = 21,
        damage_prc = 55,
        mod2 = "piercing",
        mod1 = "gargoyleSlayers"
      })
    end,
    function()
      return NewItem("Scythe_Basic", {
        level = 21,
        damage_prc = 55,
        mod2 = "piercing",
        mod1 = "gargoyleSlayers"
      })
    end,
    function()
      return NewItem("GiftBox3", {stack = 2})
    end
  },
  display_name = T({
    566,
    "+<number> Destiny Points",
    number = SA_Level_21_E1.modifiers.destiny_points
  }),
  display_descr = T({
    567,
    "You can now equip more powerful Destiny Cards. The Destiny Points cost of all equipped cards cannot exceed your total DP."
  }),
  icon = "UI/Common/LevelUp_DestinyPoint.tga"
}
DefineClass.SA_Level_22_E1 = {
  __parents = {"SA_Health"},
  modifiers = {health = 500}
}
LevelRewards[22] = {
  effects = {
    "SA_Level_22_E1"
  },
  loot_choice = {
    function()
      return CreateDestinyCard("Card_TheReaper_3", 30, "speed_on_kill", 100)
    end,
    function()
      return CreateDestinyCard("Card_TheCannon_3", 80, "better_items", 100)
    end,
    "GiftBox3"
  },
  display_name = T({
    570,
    "+<number> Health",
    number = SA_Level_22_E1.modifiers.health
  }),
  display_descr = T({
    571,
    "Congratulations! Your Health pool has increased, allowing you to endure more damage."
  }),
  icon = "UI/Common/LevelUp_Health.tga"
}
DefineClass.SA_Level_23_E1 = {
  __parents = {
    "SA_DestinyPoints"
  },
  modifiers = {destiny_points = 2}
}
LevelRewards[23] = {
  effects = {
    "SA_Level_23_E1"
  },
  loot_choice = {
    function()
      return NewItem("PowerStone_Damage", {stack = 20})
    end,
    function()
      return NewItem("PowerStone_Accuracy", {stack = 20})
    end,
    function()
      return NewItem("GiftBox3", {stack = 3})
    end
  },
  display_name = T({
    566,
    "+<number> Destiny Points",
    number = SA_Level_23_E1.modifiers.destiny_points
  }),
  display_descr = T({
    567,
    "You can now equip more powerful Destiny Cards. The Destiny Points cost of all equipped cards cannot exceed your total DP."
  }),
  icon = "UI/Common/LevelUp_DestinyPoint.tga"
}
DefineClass.SA_Level_24_E1 = {
  __parents = {"SA_Health"},
  modifiers = {health = 500}
}
LevelRewards[24] = {
  effects = {
    "SA_Level_24_E1"
  },
  loot_choice = {
    function()
      return NewItem("PowerStone_Divinity", {stack = 10})
    end,
    function()
      return NewItem("PowerStone_Wickedness", {stack = 10})
    end,
    "GiftBox3"
  },
  display_name = T({
    570,
    "+<number> Health",
    number = SA_Level_24_E1.modifiers.health
  }),
  display_descr = T({
    571,
    "Congratulations! Your Health pool has increased, allowing you to endure more damage."
  }),
  icon = "UI/Common/LevelUp_Health.tga"
}
LevelRewards[25] = {
  effects = {"SA_Level_3_E1"},
  loot_choice = {
    function()
      local choices = {
        "Outfit_BattleArmor",
        "Outfit_Vanguard",
        "Outfit_Adventurer",
        "Outfit_Hunter",
        "Outfit_Gentleman",
        "Outfit_Vigilante"
      }
      local list = GetUniqueItems(choices, 3)
      if #list == 0 then
        table.insert(list, NewItem("Potion_Health", {stack = 99}))
        table.insert(list, NewItem("Bomb_Souldrain", {stack = 99}))
        table.insert(list, NewItem("GiftBox3", {stack = 1}))
      end
      return list
    end
  },
  display_name = T({562, "Outfits"}),
  display_descr = T({
    563,
    "Outfits affect the way you gain Overdrive and use Demon Powers. You can inspect the Outfits from your Inventory."
  }),
  icon = "UI/Common/LevelUp_Outfits.tga"
}
LevelRewards[26] = {
  effects = {"SA_Level_3_E1"},
  loot_choice = {
    function()
      return NewItem("Sword_Basic", {
        level = 26,
        damage_prc = 50,
        mod2 = "vulture",
        mod1 = "essenceSlayers"
      })
    end,
    function()
      return NewItem("Rapier_Basic", {
        level = 26,
        damage_prc = 50,
        mod2 = "leech",
        mod1 = "essenceSlayers"
      })
    end,
    "GiftBox3"
  },
  display_name = T({
    4192,
    "PvP Arena - The Freakshow"
  }),
  display_descr = T({
    4193,
    "Step right up! Enter the Freakshow Arena where you may resolve who is the top hunter - by a fight to the bitter end! You may now enter the Freakshow PvP Arena to duel your fellow hunters through the world map."
  }),
  icon = "UI/Common/LevelUp_SecondWeapon.tga"
}
DefineClass.SA_Level_27_E1 = {
  __parents = {
    "SA_DestinyPoints"
  },
  modifiers = {destiny_points = 2}
}
LevelRewards[27] = {
  effects = {
    "SA_Level_27_E1"
  },
  loot_choice = {
    "Card_TheSwashbuckler_3",
    "Card_TheHunter_3",
    "Card_TheBlademaster_3"
  },
  display_name = T({
    566,
    "+<number> Destiny Points",
    number = SA_Level_27_E1.modifiers.destiny_points
  }),
  display_descr = T({
    567,
    "You can now equip more powerful Destiny Cards. The Destiny Points cost of all equipped cards cannot exceed your total DP."
  }),
  icon = "UI/Common/LevelUp_DestinyPoint.tga"
}
DefineClass.SA_Level_28_E1 = {
  __parents = {"SA_Health"},
  modifiers = {health = 500}
}
LevelRewards[28] = {
  effects = {
    "SA_Level_28_E1"
  },
  loot_choice = {
    "Card_TheLightning_3",
    "Card_TheSwashbuckler_3",
    "Card_TheSeer_3"
  },
  display_name = T({
    570,
    "+<number> Health",
    number = SA_Level_28_E1.modifiers.health
  }),
  display_descr = T({
    571,
    "Congratulations! Your Health pool has increased, allowing you to endure more damage."
  }),
  icon = "UI/Common/LevelUp_Health.tga"
}
DefineClass.SA_Level_29_E1 = {
  __parents = {"SA_Health"},
  modifiers = {health = 500}
}
LevelRewards[29] = {
  effects = {
    "SA_Level_29_E1"
  },
  loot_choice = {
    "Card_TheReaper_3",
    "Card_TheBlademaster_3",
    function()
      return CreateDestinyCard("Card_TheBarbarian_2", 40, "regeneration", 100)
    end
  },
  display_name = T({
    570,
    "+<number> Health",
    number = SA_Level_29_E1.modifiers.health
  }),
  display_descr = T({
    571,
    "Congratulations! Your Health pool has increased, allowing you to endure more damage."
  }),
  icon = "UI/Common/LevelUp_Health.tga"
}
DefineClass.SA_Level_30_E1 = {
  __parents = {
    "SA_CardSlots"
  },
  modifiers = {destiny_slots = 2}
}
LevelRewards[30] = {
  effects = {
    "SA_Level_30_E1"
  },
  loot_choice = {
    function()
      return CreateDestinyCard("Card_Wildcard_3", 30, "better_items", 100)
    end,
    function()
      return CreateDestinyCard("Card_TheInventor_3", 30, "focus_on_overkill", 100)
    end,
    "GiftBox3"
  },
  display_name = T({
    568,
    "New Destiny Slot"
  }),
  display_descr = T({
    569,
    "You can now equip more Destiny Cards. The Destiny Points cost of all equipped cards cannot exceed your total DP."
  }),
  icon = "UI/Common/LevelUpDestinySlots.tga"
}
DefineClass.SA_Level_31_E1 = {
  __parents = {
    "SA_DestinyPoints"
  },
  modifiers = {destiny_points = 2}
}
LevelRewards[31] = {
  effects = {
    "SA_Level_31_E1"
  },
  loot_choice = {
    "Rune_PurgingFlames4",
    "Rune_Boomerang4",
    "GiftBox3"
  },
  display_name = T({
    566,
    "+<number> Destiny Points",
    number = SA_Level_31_E1.modifiers.destiny_points
  }),
  display_descr = T({
    567,
    "You can now equip more powerful Destiny Cards. The Destiny Points cost of all equipped cards cannot exceed your total DP."
  }),
  icon = "UI/Common/LevelUp_DestinyPoint.tga"
}
DefineClass.SA_Level_32_E1 = {
  __parents = {"SA_Health"},
  modifiers = {health = 500}
}
LevelRewards[32] = {
  effects = {
    "SA_Level_32_E1"
  },
  loot_choice = {
    function()
      return NewItem("PowerStone_Accuracy", {stack = 20})
    end,
    function()
      return NewItem("PowerStone_DemonPower", {stack = 20})
    end,
    "GiftBox3"
  },
  display_name = T({
    570,
    "+<number> Health",
    number = SA_Level_32_E1.modifiers.health
  }),
  display_descr = T({
    571,
    "Congratulations! Your Health pool has increased, allowing you to endure more damage."
  }),
  icon = "UI/Common/LevelUp_Health.tga"
}
DefineClass.SA_Level_33_E1 = {
  __parents = {"SA_Health"},
  modifiers = {health = 500}
}
LevelRewards[33] = {
  effects = {
    "SA_Level_33_E1"
  },
  loot_choice = {
    function()
      return NewItem("Potion_Ambrosia", {stack = 99})
    end,
    function()
      return NewItem("Bomb_Souldrain", {stack = 99})
    end,
    "GiftBox3"
  },
  display_name = T({
    570,
    "+<number> Health",
    number = SA_Level_33_E1.modifiers.health
  }),
  display_descr = T({
    571,
    "Congratulations! Your Health pool has increased, allowing you to endure more damage."
  }),
  icon = "UI/Common/LevelUp_Health.tga"
}
DefineClass.SA_Level_34_E1 = {
  __parents = {"SA_Health"},
  modifiers = {health = 500}
}
LevelRewards[34] = {
  effects = {
    "SA_Level_34_E1"
  },
  loot_choice = {
    "Hammer_MonsterCrusher",
    "Rapier_PowerFoil",
    "Scythe_Coldsnap"
  },
  display_name = T({
    570,
    "+<number> Health",
    number = SA_Level_34_E1.modifiers.health
  }),
  display_descr = T({
    571,
    "Congratulations! Your Health pool has increased, allowing you to endure more damage."
  }),
  icon = "UI/Common/LevelUp_Health.tga"
}
DefineClass.SA_Level_35_E1 = {
  __parents = {
    "SA_DestinyPoints"
  },
  modifiers = {destiny_points = 2}
}
LevelRewards[35] = {
  effects = {
    "SA_Level_35_E1"
  },
  loot_choice = {
    function()
      return NewItem("Hammer_Basic", {
        level = 35,
        damage_prc = 40,
        mod1 = "survivors",
        mod2 = "leech"
      })
    end,
    function()
      return NewItem("Shotgun_Basic", {
        level = 35,
        damage_prc = 40,
        mod1 = "survivors",
        mod2 = "assassin"
      })
    end,
    "GiftBox3"
  },
  display_name = T({
    566,
    "+<number> Destiny Points",
    number = SA_Level_35_E1.modifiers.destiny_points
  }),
  display_descr = T({
    567,
    "You can now equip more powerful Destiny Cards. The Destiny Points cost of all equipped cards cannot exceed your total DP."
  }),
  icon = "UI/Common/LevelUp_DestinyPoint.tga"
}
LevelRewards[36] = {
  effects = {"SA_Level_3_E1"},
  loot_choice = {
    function()
      return NewItem("Potion_Ambrosia", {stack = 99})
    end,
    function()
      return NewItem("Potion_Barkskin_3", {stack = 99})
    end,
    "GiftBox3"
  },
  display_name = T({
    4194,
    "Endless Battleground - Bottomless Pit"
  }),
  display_descr = T({
    4195,
    "The way down the Bottomless Pit has now been revealed to you - a loathsome journey into an unknown void consisting of demon infested arenas. No one knows the true origin and purpose of this ethereal place. Find it on the world map."
  }),
  icon = "UI/Common/LevelUP_SecondDemonPower.tga"
}
DefineClass.SA_Level_37_E1 = {
  __parents = {"SA_Health"},
  modifiers = {health = 500}
}
LevelRewards[37] = {
  effects = {
    "SA_Level_37_E1"
  },
  loot_choice = {
    function()
      return NewItem("PowerStone_Divinity", {stack = 10})
    end,
    function()
      return NewItem("PowerStone_Wickedness", {stack = 10})
    end,
    "GiftBox3"
  },
  display_name = T({
    570,
    "+<number> Health",
    number = SA_Level_37_E1.modifiers.health
  }),
  display_descr = T({
    571,
    "Congratulations! Your Health pool has increased, allowing you to endure more damage."
  }),
  icon = "UI/Common/LevelUp_Health.tga"
}
DefineClass.SA_Level_38_E1 = {
  __parents = {"SA_Health"},
  modifiers = {health = 500}
}
LevelRewards[38] = {
  effects = {
    "SA_Level_38_E1"
  },
  loot_choice = {
    "HandMortar_OilShooter",
    "LightningGun_RainbowGun",
    "Sword_Torch"
  },
  display_name = T({
    570,
    "+<number> Health",
    number = SA_Level_38_E1.modifiers.health
  }),
  display_descr = T({
    571,
    "Congratulations! Your Health pool has increased, allowing you to endure more damage."
  }),
  icon = "UI/Common/LevelUp_Health.tga"
}
DefineClass.SA_Level_39_E1 = {
  __parents = {"SA_Health"},
  modifiers = {health = 500}
}
LevelRewards[39] = {
  effects = {
    "SA_Level_39_E1"
  },
  loot_choice = {
    function()
      return NewItem("PowerStone_Divinity", {stack = 10})
    end,
    function()
      return NewItem("PowerStone_Wickedness", {stack = 10})
    end,
    "GiftBox3"
  },
  display_name = T({
    570,
    "+<number> Health",
    number = SA_Level_39_E1.modifiers.health
  }),
  display_descr = T({
    571,
    "Congratulations! Your Health pool has increased, allowing you to endure more damage."
  }),
  icon = "UI/Common/LevelUp_Health.tga"
}
DefineClass.SA_Level_40_E1 = {
  __parents = {
    "SA_DestinyPoints"
  },
  modifiers = {destiny_points = 2}
}
LevelRewards[40] = {
  effects = {
    "SA_Level_40_E1"
  },
  loot_choice = {
    function()
      return NewItem("Scythe_Basic", {
        level = 40,
        damage_prc = 30,
        mod1 = "vampireSlayers",
        mod2 = "wolf"
      })
    end,
    function()
      return NewItem("Sword_Basic", {
        level = 40,
        damage_prc = 30,
        mod1 = "vampireSlayers",
        mod2 = "vulture"
      })
    end,
    "GiftBox3"
  },
  display_name = T({
    566,
    "+<number> Destiny Points",
    number = SA_Level_40_E1.modifiers.destiny_points
  }),
  display_descr = T({
    567,
    "You can now equip more powerful Destiny Cards. The Destiny Points cost of all equipped cards cannot exceed your total DP."
  }),
  icon = "UI/Common/LevelUp_DestinyPoint.tga"
}
DefineClass.SA_Level_41_E1 = {
  __parents = {"SA_Health"},
  modifiers = {health = 500}
}
LevelRewards[41] = {
  effects = {
    "SA_Level_41_E1"
  },
  loot_choice = {
    function()
      return NewItem("PowerStone_Divinity", {stack = 10})
    end,
    function()
      return NewItem("PowerStone_Wickedness", {stack = 10})
    end,
    "GiftBox3"
  },
  display_name = T({
    570,
    "+<number> Health",
    number = SA_Level_41_E1.modifiers.health
  }),
  display_descr = T({
    571,
    "Congratulations! Your Health pool has increased, allowing you to endure more damage."
  }),
  icon = "UI/Common/LevelUp_Health.tga"
}
DefineClass.SA_Level_42_E1 = {
  __parents = {"SA_Health"},
  modifiers = {health = 500}
}
LevelRewards[42] = {
  effects = {
    "SA_Level_42_E1"
  },
  loot_choice = {
    function()
      return NewItem("PowerStone_Divinity", {stack = 10})
    end,
    function()
      return NewItem("PowerStone_Wickedness", {stack = 10})
    end,
    "GiftBox3"
  },
  display_name = T({
    570,
    "+<number> Health",
    number = SA_Level_42_E1.modifiers.health
  }),
  display_descr = T({
    571,
    "Congratulations! Your Health pool has increased, allowing you to endure more damage."
  }),
  icon = "UI/Common/LevelUp_Health.tga"
}
DefineClass.SA_Level_43_E1 = {
  __parents = {"SA_Health"},
  modifiers = {health = 500}
}
LevelRewards[43] = {
  effects = {
    "SA_Level_43_E1"
  },
  loot_choice = {
    function()
      return NewItem("PowerStone_Divinity", {stack = 10})
    end,
    function()
      return NewItem("PowerStone_Wickedness", {stack = 10})
    end,
    "GiftBox3"
  },
  display_name = T({
    570,
    "+<number> Health",
    number = SA_Level_43_E1.modifiers.health
  }),
  display_descr = T({
    571,
    "Congratulations! Your Health pool has increased, allowing you to endure more damage."
  }),
  icon = "UI/Common/LevelUp_Health.tga"
}
DefineClass.SA_Level_44_E1 = {
  __parents = {"SA_Health"},
  modifiers = {health = 500}
}
LevelRewards[44] = {
  effects = {
    "SA_Level_44_E1"
  },
  loot_choice = {
    "Rune_TimeBubble4",
    "Rune_Diamond4",
    "Rune_Shockwave4"
  },
  display_name = T({
    570,
    "+<number> Health",
    number = SA_Level_44_E1.modifiers.health
  }),
  display_descr = T({
    571,
    "Congratulations! Your Health pool has increased, allowing you to endure more damage."
  }),
  icon = "UI/Common/LevelUp_Health.tga"
}
DefineClass.SA_Level_45_E1 = {
  __parents = {
    "SA_DestinyPoints"
  },
  modifiers = {destiny_points = 2}
}
LevelRewards[45] = {
  effects = {
    "SA_Level_45_E1"
  },
  loot_choice = {
    function()
      return CreateDestinyCard("Card_TheSaint_3", 50, "negate_crit", 100)
    end,
    function()
      return CreateDestinyCard("Card_TheDevil_3", 50, "speed_on_kill", 100)
    end,
    "GiftBox3"
  },
  display_name = T({
    566,
    "+<number> Destiny Points",
    number = SA_Level_45_E1.modifiers.destiny_points
  }),
  display_descr = T({
    567,
    "You can now equip more powerful Destiny Cards. The Destiny Points cost of all equipped cards cannot exceed your total DP."
  }),
  icon = "UI/Common/LevelUp_DestinyPoint.tga"
}
DefineClass.SA_Level_46_E1 = {
  __parents = {"SA_Health"},
  modifiers = {health = 500}
}
LevelRewards[46] = {
  effects = {
    "SA_Level_46_E1"
  },
  loot_choice = {
    function()
      return NewItem("PowerStone_Wickedness", {stack = 10})
    end,
    function()
      return NewItem("PowerStone_Divinity", {stack = 10})
    end,
    "GiftBox3"
  },
  display_name = T({
    570,
    "+<number> Health",
    number = SA_Level_46_E1.modifiers.health
  }),
  display_descr = T({
    571,
    "Congratulations! Your Health pool has increased, allowing you to endure more damage."
  }),
  icon = "UI/Common/LevelUp_Health.tga"
}
DefineClass.SA_Level_47_E1 = {
  __parents = {"SA_Health"},
  modifiers = {health = 500}
}
LevelRewards[47] = {
  effects = {
    "SA_Level_47_E1"
  },
  loot_choice = {
    function()
      return NewItem("PowerStone_Divinity", {stack = 10})
    end,
    function()
      return NewItem("PowerStone_Wickedness", {stack = 10})
    end,
    "GiftBox3"
  },
  display_name = T({
    570,
    "+<number> Health",
    number = SA_Level_47_E1.modifiers.health
  }),
  display_descr = T({
    571,
    "Congratulations! Your Health pool has increased, allowing you to endure more damage."
  }),
  icon = "UI/Common/LevelUp_Health.tga"
}
DefineClass.SA_Level_48_E1 = {
  __parents = {"SA_Health"},
  modifiers = {health = 500}
}
LevelRewards[48] = {
  effects = {
    "SA_Level_48_E1"
  },
  loot_choice = {
    function()
      return NewItem("PowerStone_Divinity", {stack = 10})
    end,
    function()
      return NewItem("PowerStone_Wickedness", {stack = 10})
    end,
    "GiftBox3"
  },
  display_name = T({
    570,
    "+<number> Health",
    number = SA_Level_48_E1.modifiers.health
  }),
  display_descr = T({
    571,
    "Congratulations! Your Health pool has increased, allowing you to endure more damage."
  }),
  icon = "UI/Common/LevelUp_Health.tga"
}
DefineClass.SA_Level_49_E1 = {
  __parents = {"SA_Health"},
  modifiers = {health = 500}
}
LevelRewards[49] = {
  effects = {
    "SA_Level_49_E1"
  },
  loot_choice = {
    "Rune_Boomerang4",
    "Rune_Meteor4",
    "Rune_PurgingFlames4"
  },
  display_name = T({
    570,
    "+<number> Health",
    number = SA_Level_49_E1.modifiers.health
  }),
  display_descr = T({
    571,
    "Congratulations! Your Health pool has increased, allowing you to endure more damage."
  }),
  icon = "UI/Common/LevelUp_Health.tga"
}
DefineClass.SA_Level_50_E1 = {
  __parents = {
    "SA_DestinyPoints"
  },
  modifiers = {destiny_points = 2}
}
LevelRewards[50] = {
  effects = {
    "SA_Level_50_E1"
  },
  loot_choice = {
    function()
      return CreateDestinyCard("Card_TheSaint_3", 50, "regeneration", 100)
    end,
    function()
      return CreateDestinyCard("Card_TheDevil_3", 50, "overdrive_on_overkill", 100)
    end,
    function()
      return CreateDestinyCard("Card_TheSeer_3", 50, "brutality_on_overdrive_fill", 100)
    end
  },
  display_name = T({
    566,
    "+<number> Destiny Points",
    number = SA_Level_50_E1.modifiers.destiny_points
  }),
  display_descr = T({
    567,
    "You can now equip more powerful Destiny Cards. The Destiny Points cost of all equipped cards cannot exceed your total DP."
  }),
  icon = "UI/Common/LevelUp_DestinyPoint.tga"
}
function GetLevelLootChoices(level)
  local items = {}
  local loot = LevelRewards[level] and LevelRewards[level].loot_choice
  for i = 1, loot and table.maxn(loot) or 0 do
    local item
    local id = loot[i]
    if type(id) == "function" then
      item = id()
    elseif g_Classes[id] then
      item = NewItem(id)
    end
    if item then
      if ObjectClass(item) then
        table.insert(items, item)
      elseif type(item) == "table" then
        table.append(items, item)
      end
    end
  end
  return items
end
function HeroLevelUp(level, item_choice)
  level = Clamp(level or CharacterStorage.Level + 1, 1, MaxLevel)
  CharacterStorage.Level = level
  if hero then
    hero:SetLevel(level)
    CreateRealTimeThread(function()
      NetChangePlayerInfo({level = level})
      hero:Gossip("HeroLevelUp", CharacterStorage.Level, ValueToLuaCode(item_choice, nil, " "))
    end)
  end
  if item_choice then
    if item_choice:IsKindOf("Gold") then
      AddGold(item_choice.stack)
    elseif HeroCanLoot(item_choice.class) then
      if not hero:AutoEquip(item_choice) then
        AddToInventory(item_choice)
      end
      AddCodexEntry(item_choice, "show_notif")
    end
  end
  local exec = LevelRewards[level].exec
  if exec then
    exec(LevelRewards[level])
  end
  Msg("HeroLevel")
  SaveLocalCharacter(false, "level")
end
function ChooseEquipedTypeRewards(tbl)
  local function get_reward(reward_type)
    local reward = tbl[reward_type]
    if type(reward) == "function" then
      reward = reward()
    end
    if g_Classes[reward] then
      reward = g_Classes[reward]:new()
    end
    return reward
  end
  local weapon1 = GetItemEquipped(WeaponsIdx)
  local weapon2 = GetItemEquipped(WeaponsIdx + 1)
  local type1 = weapon1 and weapon1.weapon_type or tbl.defaults[1]
  local type2 = weapon2 and weapon2.weapon_type or tbl.defaults[2]
  local reward1 = get_reward(type1)
  if not reward1 and type1 ~= tbl.defaults[1] then
    type1 = tbl.defaults[1]
    reward1 = get_reward(type1)
  end
  local reward2 = type2 ~= type1 and get_reward(type2)
  if not reward2 then
    type2 = tbl.defaults[1]
    if type2 == type1 then
      type2 = tbl.defaults[2]
    end
    reward2 = get_reward(type2)
  end
  return {reward1, reward2}
end
local MapTypeSlot = {
  Consumable = "consumable_slots",
  Weapon = "weapon_slots",
  Rune = "rune_slots",
  DestinyCard = "destiny_slots"
}
function GetLevelSlotUnlock(item_type)
  local slot_type = MapTypeSlot[item_type]
  if not slot_type then
    return false
  end
  for i = 1, MaxLevel do
    local effects = LevelRewards[i].effects
    for j = 1, #effects do
      local cls_effect = g_Classes[effects[j]]
      local modifiers = cls_effect and cls_effect.modifiers
      if modifiers and modifiers[slot_type] then
        return i
      end
    end
  end
  return false
end
