﻿'################################################################################
'#  Form.bi                                                                     #
'#  This file is part of MyFBFramework                                          #
'#  Authors: Nastase Eodor, Xusinboy Bekchanov, Liu XiaLin                      #
'#  Based on:                                                                   #
'#   TForm.bi                                                                   #
'#   FreeBasic Windows GUI ToolKit                                              #
'#   Copyright (c) 2007-2008 Nastase Eodor                                      #
'#   Version 1.0.0                                                              #
'#  Updated and added cross-platform                                            #
'#  by Xusinboy Bekchanov (2018-2019), Liu XiaLin (2020)                        #
'################################################################################

#include once "Form.bi"
#ifdef __USE_WINAPI__
	#include once "win/uxtheme.bi"
#endif

Namespace My.Sys.Forms
	Private Function Form.ReadProperty(ByRef PropertyName As String) As Any Ptr
		FTempString = LCase(PropertyName)
		Select Case FTempString
		Case "activecontrol": Return FActiveControl
		Case "borderstyle": Return @FBorderStyle
		Case "cancelbutton": Return FCancelButton
		Case "caption": Return This.FText.vptr
		Case "defaultbutton": Return FDefaultButton
		Case "icon": Return @Icon
		Case "controlbox": Return @FControlBox
		Case "minimizebox": Return @FMinimizeBox
		Case "maximizebox": Return @FMaximizeBox
		Case "formstyle": Return @FFormStyle
		Case "menu": Return Menu
		Case "mainform": Return @FMainForm
		Case "modalresult": Return @ModalResult
		Case "opacity": Return @FOpacity
		Case "owner": Return FOwner
		Case "windowstate": Return @FWindowState
		Case "startposition": Return @FStartPosition
		Case "graphic": Return Cast(Any Ptr, @This.Graphic)
		Case Else: Return Base.ReadProperty(PropertyName)
		End Select
		Return 0
	End Function
	
	Private Function Form.WriteProperty(ByRef PropertyName As String, Value As Any Ptr) As Boolean
		If Value = 0 Then
			Select Case LCase(PropertyName)
			Case "activecontrol": This.ActiveControl = 0
			Case "menu": This.Menu = 0
			Case "cancelbutton": This.CancelButton = 0
			Case "defaultbutton": This.DefaultButton = 0
			Case "owner": This.Owner = 0
			Case Else: Return Base.WriteProperty(PropertyName, Value)
			End Select
		Else
			Select Case LCase(PropertyName)
			Case "activecontrol": This.ActiveControl = Cast(Control Ptr, Value)
			Case "borderstyle": This.BorderStyle = QInteger(Value)
			Case "cancelbutton": This.CancelButton = Cast(Control Ptr, Value)
			Case "caption": This.Caption = QWString(Value)
			Case "defaultbutton": This.DefaultButton = Cast(Control Ptr, Value)
			Case "formstyle": This.FormStyle = QInteger(Value)
			Case "controlbox": This.ControlBox = QBoolean(Value)
			Case "minimizebox": This.MinimizeBox = QBoolean(Value)
			Case "maximizebox": This.MaximizeBox = QBoolean(Value)
			Case "icon": This.Icon = QWString(Value)
			Case "mainform": This.MainForm = QBoolean(Value)
			Case "menu": This.Menu = Cast(MainMenu Ptr, Value)
			Case "modalresult": This.ModalResult = QInteger(Value)
			Case "opacity": This.Opacity = QInteger(Value)
			Case "owner": This.Owner = Cast(Form Ptr, Value)
				#ifdef __USE_GTK__
				Case "parentwidget": This.ParentWidget = Value
				#endif
			Case "text": This.Text = QWString(Value)
			Case "windowstate": This.WindowState = QInteger(Value)
			Case "startposition": This.StartPosition = QInteger(Value)
			Case "visible": This.Visible = QBoolean(Value)
			Case "graphic": This.Graphic = QWString(Value)
			Case Else: Return Base.WriteProperty(PropertyName, Value)
			End Select
		End If
		Return True
	End Function
	
	Private Property Form.ActiveControl As Control Ptr
		Return FActiveControl
	End Property
	
	Private Property Form.ActiveControl(Value As Control Ptr)
		FActiveControl = Value
		If FActiveControl Then FActiveControl->SetFocus
		If OnActiveControlChange Then OnActiveControlChange(This)
	End Property
	
	Private Property Form.Owner As Form Ptr
		Return Cast(Form Ptr, FOwner)
	End Property
	
	Private Property Form.Owner(Value As Form Ptr)
		If Value <> FOwner Then
			FOwner = Value
			#ifdef __USE_WINAPI__
				If Handle AndAlso FOwner AndAlso FOwner->Handle Then
					SetParent FOwner->Handle, Handle
				End If
			#endif
		End If
	End Property
	
	#ifdef __USE_GTK__
		Private Property Form.ParentWidget As GtkWidget Ptr
			Return FParentWidget
		End Property
		
		Private Property Form.ParentWidget(Value As GtkWidget Ptr)
			If Not GTK_IS_BOX(widget) Then
				g_object_ref(box)
				gtk_container_remove(gtk_container(WindowWidget), box)
				Widget = box
				gtk_widget_set_size_request(Widget, FWidth, FHeight)
				#ifdef __USE_GTK3__
					HeaderBarWidget = gtk_header_bar_new()
					gtk_widget_set_sensitive(HeaderBarWidget, False)
					gtk_header_bar_set_has_subtitle(gtk_header_bar(HeaderBarWidget), False)
					'gtk_widget_set_size_request(widget, FW, 1)
					gtk_header_bar_set_title(gtk_header_bar(HeaderBarWidget), ToUTF8(FText))
					'gtk_header_bar_set_show_close_button(gtk_header_bar(HeaderBarWidget), True)
				#else
					HeaderBarWidget = gtk_label_new(ToUTF8(FText))
					'Dim As GdkColor color1, color2
					'gdk_color_parse ("black", @color1)
					'gtk_widget_modify_bg(HeaderBarWidget, GTK_STATE_NORMAL, @color1)
					'gdk_color_parse ("white", @color2)
					'gtk_widget_modify_fg(HeaderBarWidget, GTK_STATE_NORMAL, @color2)
				#endif
				gtk_box_pack_start(Gtk_Box(widget), HeaderBarWidget, False, False, 0)
				Base.ParentWidget = Value
				BorderStyle = BorderStyle
			End If
		End Property
	#endif
	
	Private Property Form.DefaultButton As Control Ptr
		Return FDefaultButton
	End Property
	
	Private Property Form.DefaultButton(Value As Control Ptr)
		FDefaultButton = Value
		#ifdef __USE_GTK__
			If Value <> 0 Then
				gtk_widget_set_can_default(Value->Widget, True)
				If gtk_is_window(widget) Then
					gtk_window_set_default(gtk_window(Widget), Value->Widget)
				End If
				'gtk_widget_grab_default(Value->Widget)
			Else
				If gtk_is_window(widget) Then
					gtk_window_set_default(gtk_window(Widget), NULL)
				End If
			End If
		#endif
		If FDefaultButton AndAlso UCase(*FDefaultButton.ClassName) = "COMMANDBUTTON" Then
			
		End If
	End Property
	
	Private Property Form.CancelButton As Control Ptr
		Return FCancelButton
	End Property
	
	Private Property Form.CancelButton(Value As Control Ptr)
		FCancelButton = Value
	End Property
	
	Private Property Form.MainForm As Boolean
		Return FMainForm
	End Property
	
	Private Property Form.MainForm(Value As Boolean)
		If Value <> FMainForm Then
			FMainForm = Value
			If pApp <> 0 Then
				If pApp->MainForm <> 0 Then Cast(Form Ptr, pApp->MainForm)->MainForm = False
				#ifdef __USE_WINAPI__
					ChangeExStyle WS_EX_APPWINDOW, Value
				#elseif defined(__USE_GTK__)
					If GTK_IS_BOX(Widget) Then Exit Property
				#endif
				If FMainForm Then
					pApp->MainForm = @This
				Else
					pApp->MainForm = 0
				End If
			End If
		End If
	End Property
	
	Private Property Form.Menu As MainMenu Ptr
		Return FMenu
	End Property
	
	Private Property Form.Menu(Value As MainMenu Ptr)
		FMenu = Value
		If FMenu Then FMenu->ParentWindow = @This
	End Property
	
	Private Property Form.StartPosition As Integer
		Return FStartPosition
	End Property
	
	Private Property Form.StartPosition(Value As Integer)
		FStartPosition = Value
		#ifdef __USE_GTK__
			If gtk_is_window(widget) Then
				Select Case FStartPosition
				Case 0: gtk_window_set_position(gtk_window(widget), GTK_WIN_POS_NONE) ' Manual
				Case 1, 4 ' CenterScreen, CenterParent
					If FStartPosition = 4 AndAlso FParent Then ' CenterParent
						gtk_window_set_position(gtk_window(widget), GTK_WIN_POS_CENTER_ON_PARENT)
						With *Cast(Control Ptr, FParent)
							gtk_window_move(gtk_window(widget), .Left + (.Width - This.FWidth) \ 2, .Top + (.Height - This.FHeight) \ 2)
						End With
					Else ' CenterScreen
						gtk_window_set_position(gtk_window(widget), GTK_WIN_POS_CENTER)
						gtk_window_move(gtk_window(widget), (gdk_screen_width() - This.FWidth) \ 2, (gdk_screen_height() - This.FHeight) \ 2)
					End If
				Case 2: gtk_window_set_position(gtk_window(widget), GTK_WIN_POS_MOUSE) ' DefaultLocation
				Case 3: 'gtk_window_set_default_size(gtk_window(widget), -1, -1) ' DefaultBounds
					gtk_window_resize(gtk_window(widget), 1000, 600)
				End Select
			End If
		#endif
	End Property
	
	Private Property Form.Opacity As Integer
		Return FOpacity
	End Property
	
	Private Property Form.Opacity(Value As Integer)
		FOpacity = Value
		#ifdef __USE_GTK__
			#ifdef __USE_GTK3__
				gtk_widget_set_opacity(widget, Value / 255.0)
			#else
				If gtk_is_window(widget) Then
					gtk_window_set_opacity(gtk_window(widget), Value / 255.0)
				End If
			#endif
		#elseif defined(__USE_WINAPI__)
			ChangeExStyle WS_EX_LAYERED, Cast(Boolean, 255 - FOpacity)
			If FHandle Then
				SetLayeredWindowAttributes(FHandle, 0, FOpacity, LWA_ALPHA)
			End If
		#endif
	End Property
	
	Private Property Form.ControlBox As Boolean
		Return FControlBox
	End Property
	
	Private Property Form.ControlBox(Value As Boolean)
		FControlBox = Value
		#ifdef __USE_WINAPI__
			ChangeStyle WS_SYSMENU, Value
			SetWindowPos(FHandle, 0, 0, 0, 0, 0, SWP_NOMOVE Or SWP_NOSIZE Or SWP_DRAWFRAME)
		#endif
	End Property
	
	Private Property Form.MinimizeBox As Boolean
		Return FMinimizeBox
	End Property
	
	Private Property Form.MinimizeBox(Value As Boolean)
		FMinimizeBox = Value
		#ifdef __USE_WINAPI__
			ChangeStyle WS_MINIMIZEBOX, Value
			SetWindowPos(FHandle, 0, 0, 0, 0, 0, SWP_NOMOVE Or SWP_NOSIZE Or SWP_DRAWFRAME)
		#endif
	End Property
	
	Private Property Form.MaximizeBox As Boolean
		Return FMaximizeBox
	End Property
	
	Private Property Form.MaximizeBox(Value As Boolean)
		FMaximizeBox = Value
		#ifdef __USE_WINAPI__
			ChangeStyle WS_MAXIMIZEBOX, Value
			SetWindowPos(FHandle, 0, 0, 0, 0, 0, SWP_NOMOVE Or SWP_NOSIZE Or SWP_DRAWFRAME)
		#endif
	End Property
	
	Private Property Form.BorderStyle As Integer
		Return FBorderStyle
	End Property
	
	Private Property Form.BorderStyle(Value As Integer)
		FBorderStyle = Value
		#ifdef __USE_GTK__
			Select Case Value
			Case FormBorderStyle.None, FormBorderStyle.FixedToolWindow, FormBorderStyle.Fixed3D, FormBorderStyle.FixedSingle, FormBorderStyle.FixedDialog
				Dim As GdkGeometry hints
				hints.base_width = FWidth
				hints.base_height = FHeight
				hints.min_width = FWidth
				hints.min_height = FHeight
				hints.width_inc = 1
				hints.height_inc = 1
				If Gtk_Is_Window(Widget) Then
					gtk_window_set_geometry_hints(gtk_window(Widget), NULL, @hints, GDK_HINT_RESIZE_INC Or GDK_HINT_MIN_SIZE Or GDK_HINT_BASE_SIZE)
				End If
			Case FormBorderStyle.SizableToolWindow, FormBorderStyle.Sizable
				
			End Select
			Select Case Value
			Case FormBorderStyle.None
				If Gtk_Is_Window(Widget) Then
					gtk_window_set_decorated(gtk_window(widget), False)
					gtk_window_set_type_hint(gtk_window(widget), GDK_WINDOW_TYPE_HINT_SPLASHSCREEN)
					gtk_window_set_resizable(gtk_window(widget), False)
				Else
					gtk_widget_set_visible(HeaderBarWidget, False)
				End If
			Case FormBorderStyle.SizableToolWindow
				If Gtk_Is_Window(Widget) Then
					gtk_window_set_decorated(gtk_window(widget), True)
					gtk_window_set_type_hint(gtk_window(widget), GDK_WINDOW_TYPE_HINT_DOCK)
					gtk_window_set_resizable(gtk_window(widget), True)
				Else
					gtk_widget_set_visible(HeaderBarWidget, True)
				End If
			Case FormBorderStyle.FixedToolWindow
				If Gtk_Is_Window(Widget) Then
					gtk_window_set_decorated(gtk_window(widget), True)
					gtk_window_set_type_hint(gtk_window(widget), GDK_WINDOW_TYPE_HINT_DOCK)
					gtk_window_set_resizable(gtk_window(widget), False)
				Else
					gtk_widget_set_visible(HeaderBarWidget, True)
				End If
			Case FormBorderStyle.Sizable
				If Gtk_Is_Window(Widget) Then
					gtk_window_set_decorated(gtk_window(widget), True)
					gtk_window_set_type_hint(gtk_window(widget), GDK_WINDOW_TYPE_HINT_NORMAL)
					gtk_window_set_resizable(gtk_window(widget), True)
				Else
					gtk_widget_set_visible(HeaderBarWidget, True)
				End If
			Case FormBorderStyle.Fixed3D
				If Gtk_Is_Window(Widget) Then
					gtk_window_set_decorated(gtk_window(widget), True)
					gtk_window_set_type_hint(gtk_window(widget), GDK_WINDOW_TYPE_HINT_DIALOG)
					gtk_window_set_resizable(gtk_window(widget), False)
				Else
					gtk_widget_set_visible(HeaderBarWidget, True)
				End If
			Case FormBorderStyle.FixedSingle
				If Gtk_Is_Window(Widget) Then
					gtk_window_set_decorated(gtk_window(widget), True)
					gtk_window_set_type_hint(gtk_window(widget), GDK_WINDOW_TYPE_HINT_DIALOG)
					gtk_window_set_resizable(gtk_window(widget), False)
				Else
					gtk_widget_set_visible(HeaderBarWidget, True)
				End If
			Case FormBorderStyle.FixedDialog
				If Gtk_Is_Window(Widget) Then
					gtk_window_set_decorated(gtk_window(widget), True)
					gtk_window_set_type_hint(gtk_window(widget), GDK_WINDOW_TYPE_HINT_DIALOG)
					gtk_window_set_resizable(gtk_window(widget), False)
				Else
					gtk_widget_set_visible(HeaderBarWidget, True)
				End If
			End Select
		#elseif defined(__USE_WINAPI__)
			ChangeStyle WS_POPUP, False
			ChangeStyle WS_BORDER, False
			ChangeStyle WS_THICKFRAME, False
			ChangeStyle WS_DLGFRAME, False
			ChangeStyle DS_CONTROL, False
			ChangeExStyle WS_EX_TOOLWINDOW, False
			ChangeExStyle WS_EX_CLIENTEDGE, False
			ChangeExStyle WS_EX_WINDOWEDGE, False
			ChangeExStyle WS_EX_DLGMODALFRAME, False
			Select Case Value
			Case FormBorderStyle.None
				ChangeStyle WS_CAPTION, False
				ChangeStyle DS_CONTROL, True
				If Not FDesignMode Then ChangeStyle WS_POPUP, True
				ChangeExStyle WS_EX_CONTROLPARENT, True
			Case FormBorderStyle.SizableToolWindow
				ChangeStyle WS_BORDER, True
				ChangeStyle WS_THICKFRAME, True
				ChangeExStyle WS_EX_TOOLWINDOW, True
			Case FormBorderStyle.FixedToolWindow
				ChangeStyle WS_BORDER, True
				ChangeStyle WS_DLGFRAME, True
				ChangeExStyle WS_EX_TOOLWINDOW, True
			Case FormBorderStyle.Sizable
				ChangeStyle WS_THICKFRAME, True
				ChangeStyle WS_DLGFRAME, True
				ChangeStyle WS_BORDER, True
				ChangeExStyle WS_EX_WINDOWEDGE, True
			Case FormBorderStyle.Fixed3D
				ChangeStyle WS_DLGFRAME, True
				ChangeStyle WS_BORDER, True
				ChangeExStyle WS_EX_WINDOWEDGE, True
				ChangeExStyle WS_EX_CLIENTEDGE, True
			Case FormBorderStyle.FixedSingle
				ChangeStyle WS_DLGFRAME, True
				ChangeStyle WS_BORDER, True
				ChangeExStyle WS_EX_WINDOWEDGE, True
			Case FormBorderStyle.FixedDialog
				ChangeStyle WS_DLGFRAME, True
				ChangeStyle WS_BORDER, True
				ChangeExStyle WS_EX_DLGMODALFRAME, True
			End Select
			If FHandle Then SetWindowPos(FHandle, 0, 0, 0, 0, 0, SWP_NOMOVE Or SWP_NOSIZE Or SWP_DRAWFRAME)
		#endif
	End Property
	
	Private Property Form.FormStyle As Integer
		Return FFormStyle
	End Property
	
	#ifdef __USE_GTK__
		Private Function Form.Client_Draw(widget As GtkWidget Ptr, cr As cairo_t Ptr, data1 As Any Ptr) As Boolean
			If gtk_is_layout(widget) Then
				#ifdef __USE_GTK3__
					Dim As Integer AllocatedWidth = gtk_widget_get_allocated_width(widget), AllocatedHeight = gtk_widget_get_allocated_height(widget)
				#else
					Dim As Integer AllocatedWidth = widget->allocation.width, AllocatedHeight = widget->allocation.height
				#endif
				cairo_rectangle(cr, 0.0, 0.0, AllocatedWidth, AllocatedHeight)
				cairo_set_source_rgb(cr, 171 / 255.0, 171 / 255.0, 171 / 255.0)
				cairo_fill(cr)
			End If
			Return False
		End Function
		
		Private Function Form.Client_ExposeEvent(widget As GtkWidget Ptr, Event As GdkEventExpose Ptr, data1 As Any Ptr) As Boolean
			Dim As cairo_t Ptr cr = gdk_cairo_create(Event->window)
			Client_Draw(widget, cr, data1)
			cairo_destroy(cr)
			Return False
		End Function
	#endif
	
	Private Property Form.FormStyle(Value As Integer)
		If Value = FFormStyle Then Exit Property
		FFormStyle = Value
		Select Case FFormStyle
		Case 0 'fsNormal
			#ifdef __USE_GTK__
				If gtk_is_window(widget) Then
					gtk_window_set_keep_above (GTK_WINDOW(widget), False)
				End If
			#elseif defined(__USE_WINAPI__)
				If (ExStyle And WS_EX_TOPMOST) = WS_EX_TOPMOST Then
					ExStyle = ExStyle And Not WS_EX_TOPMOST
					SetWindowPos Handle,HWND_NOTOPMOST,0,0,0,0,SWP_NOMOVE Or SWP_NOACTIVATE Or SWP_NOSIZE
				End If
			#endif
		Case 1 'fsMDIForm
			#ifdef __USE_GTK__
				FClient = gtk_layout_new(null, null)
				#ifdef __USE_GTK3__
					g_signal_connect(FClient, "draw", G_CALLBACK(@Client_Draw), @This)
				#else
					g_signal_connect(FClient, "expose-event", G_CALLBACK(@Client_ExposeEvent), @This)
				#endif
				If gtk_is_widget(layoutwidget) Then gtk_container_add(GTK_CONTAINER(layoutwidget), FClient)
			#endif
		Case 2 'fsMDIChild
			#ifdef __USE_WINAPI__
				ChangeExStyle WS_EX_MDICHILD, True
				If FHandle Then RecreateWnd
			#endif
		Case 3 'fsStayOnTop
			#ifdef __USE_GTK__
				If gtk_is_window(widget) Then
					gtk_window_set_keep_above (GTK_WINDOW(widget), True)
				End If
			#elseif defined(__USE_WINAPI__)
				If (ExStyle And WS_EX_TOPMOST) <> WS_EX_TOPMOST Then
					ExStyle = ExStyle Or WS_EX_TOPMOST
					SetWindowPos Handle,HWND_TOPMOST,0,0,0,0,SWP_NOMOVE Or SWP_NOACTIVATE Or SWP_NOSIZE
				End If
			#endif
		End Select
	End Property
	
	Private Property Form.Parent As Control Ptr
		Return Cast(Control Ptr, @FParent)
	End Property
	
	Private Property Form.Parent(value As Control Ptr)
		#ifdef __USE_GTK__
			If FormStyle = fsMDIChild Then
				Base.FParent = value
			Else
				Base.Parent = value
			End If
		#else
			Base.Parent = value
		#endif
		If *value Is Form Then
			If Cast(Form Ptr, value)->FFormStyle = fsMDIForm Then
				#ifdef __USE_GTK__
					ParentWidget = Cast(Form Ptr, value)->FClient
				#elseif defined(__USE_WINAPI__)
					If IsWindow(FHandle) Then
						SetParent(FHandle, IIf(value, Cast(Form Ptr, value)->FClient, 0))
					End If
				#endif
			End If
		End If
	End Property
	
	Property Form.WindowState As Integer
		#ifdef __USE_GTK__
			If gtk_is_window(widget) Then
				If gdk_window_get_state(gtk_widget_get_window(widget)) And GDK_WINDOW_STATE_ICONIFIED = GDK_WINDOW_STATE_ICONIFIED Then
					FWindowState = WindowStates.wsMinimized
				ElseIf gdk_window_get_state(gtk_widget_get_window(widget)) And GDK_WINDOW_STATE_MAXIMIZED = GDK_WINDOW_STATE_MAXIMIZED Then
					FWindowState = WindowStates.wsMaximized
				Else
					FWindowState = WindowStates.wsNormal
				End If
			End If
		#elseif defined(__USE_WINAPI__)
			If Handle Then
				If IsIconic(Handle) Then
					FWindowState = WindowStates.wsMinimized
				ElseIf IsZoomed(Handle) Then
					FWindowState = WindowStates.wsMaximized
				Else
					FWindowState = WindowStates.wsNormal
				End If
			End If
		#endif
		Return FWindowState
	End Property
	
	Private Property Form.WindowState(Value As Integer)
		FWindowState = Value
		#ifdef __USE_GTK__
			If gtk_is_window(widget) Then
				gtk_window_deiconify(GTK_WINDOW(widget))
				gtk_window_unmaximize(GTK_WINDOW(widget))
				Select Case FWindowState
				Case WindowStates.wsMinimized:  gtk_window_iconify(GTK_WINDOW(widget))
				Case WindowStates.wsMaximized:  gtk_window_maximize(GTK_WINDOW(widget))
				Case WindowStates.wsNormal:
				Case WindowStates.wsHide:       gtk_widget_hide(widget)
				End Select
			End If
		#elseif defined(__USE_WINAPI__)
			If Handle Then
				If Not FDesignMode Then
					Dim nState As Long
					Select Case FWindowState
					Case WindowStates.wsMinimized:  nState = SW_SHOWMINIMIZED
					Case WindowStates.wsMaximized:  nState = SW_SHOWMAXIMIZED
					Case WindowStates.wsNormal:     nState = SW_SHOWNORMAL
					Case WindowStates.wsHide:       nState = SW_HIDE
					End Select
					ShowWindow(Handle, nState)
				End If
			Else
				ChangeStyle WS_MINIMIZE, False
				ChangeStyle WS_MAXIMIZE, False
				ChangeStyle WS_VISIBLE, True
				Select Case FWindowState
				Case WindowStates.wsMinimized:  ChangeStyle WS_MINIMIZE, True
				Case WindowStates.wsMaximized:  ChangeStyle WS_MAXIMIZE, True
				Case WindowStates.wsNormal:
				Case WindowStates.wsHide:       ChangeStyle WS_VISIBLE, False
				End Select
			End If
		#endif
	End Property
	
	Private Property Form.Caption ByRef As WString
		Return Text
	End Property
	
	Private Property Form.Caption(ByRef Value As WString)
		Text = Value
	End Property
	
	Private Property Form.Text ByRef As WString
		Return Base.Text
	End Property
	
	Private Property Form.Text(ByRef Value As WString)
		Base.Text = Value
		#ifdef __USE_GTK__
			If GTK_IS_WINDOW(widget) Then
				If Value = "" Then
					gtk_window_set_title(GTK_WINDOW(widget), !"\0")
				Else
					gtk_window_set_title(GTK_WINDOW(widget), ToUtf8(Value))
				End If
			ElseIf HeaderBarWidget Then
				#ifdef __USE_GTK3__
					If Value = "" Then
						gtk_header_bar_set_title(gtk_header_bar(HeaderBarWidget), !"\0")
					Else
						gtk_header_bar_set_title(gtk_header_bar(HeaderBarWidget), ToUTF8(Value))
					End If
				#else
					If Value = "" Then
						gtk_label_set_text(gtk_label(HeaderBarWidget), !"\0")
					Else
						gtk_label_set_text(gtk_label(HeaderBarWidget), ToUTF8(Value))
					End If
				#endif
			End If
		#elseif defined(__USE_JNI__)
			If FHandle Then
				(*env)->CallVoidMethod(env, FHandle, GetMethodID(*FClassAncestor, "setTitle", "(Ljava/lang/CharSequence;)V"), (*env)->NewStringUTF(env, ToUTF8(FText)))
			End If
		#endif
	End Property
	
	Private Property Form.Enabled As Boolean
		Return Base.Enabled
	End Property
	
	Private Property Form.Enabled(Value As Boolean)
		Base.Enabled = Value
	End Property
	
	Private Sub Form.ActiveControlChanged(ByRef Sender As Control)
		If Sender.Child Then
			With QForm(Sender.Child)
				If .OnActiveControlChange Then .OnActiveControlChange(QForm(Sender.Child))
			End With
		End If
	End Sub
	
	#ifdef __USE_WINAPI__
		Private Sub Form.WndProc(ByRef message As Message)
			
		End Sub
		
		Private Sub Form.HandleIsDestroyed(ByRef Sender As Control)
			If Sender.Child Then
				With QForm(Sender.Child)
					SetMenu .Handle, NULL
					DrawMenuBar .Handle
				End With
			End If
		End Sub
		
		'		Function GetAscKeyCode(HotKey As String) As Integer
		'	        Select Case HotKey
		'	        Case "Backspace", "Back": Return 08
		'	        Case "Tab": Return 09
		'	        Case "Enter", "Return": Return 13
		'	        Case "Escape", "Esc": Return 27
		'	        Case "Space": Return 32
		'	        Case "PageUp": Return 33
		'	        Case "PageDown": Return 34
		'	        Case "End": Return 35
		'	        Case "Home": Return 36
		'	        Case "Left": Return 37
		'	        Case "Up": Return 38
		'	        Case "Right": Return 39
		'	        Case "Down": Return 40
		'	        Case "Print": Return 42
		'	        Case "Insert", "Ins": Return 45
		'	        Case "Num0": Return 96
		'	        Case "Num1": Return 97
		'	        Case "Num2": Return 98
		'	        Case "Num3": Return 99
		'	        Case "Num4": Return 100
		'	        Case "Num5": Return 101
		'	        Case "Num6": Return 102
		'	        Case "Num7": Return 103
		'	        Case "Num8": Return 104
		'	        Case "Num9": Return 105
		'	        Case "F1": Return 112
		'	        Case "F2": Return 113
		'	        Case "F3": Return 114
		'	        Case "F4": Return 115
		'	        Case "F5": Return 116
		'	        Case "F6": Return 117
		'	        Case "F7": Return 118
		'	        Case "F8": Return 119
		'	        Case "F9": Return 120
		'	        Case "F10": Return 121
		'	        Case "F11": Return 122
		'	        Case "F12": Return 123
		'	        Case "Delete", "Del": : Return 127
		'	        Case Else: Return Asc(HotKey)
		'	        End Select
		'	    End Function
		
		Private Sub Form.HandleIsAllocated(ByRef Sender As Control)
			If Sender.Child Then
				Dim As HMENU NoNeedSysMenu
				With QForm(Sender.Child)
					SetClassLong(.Handle,GCL_STYLE,.FClassStyle(.BorderStyle))
					If .FBorderStyle = 2 Then
						SetClassLongPtr(.Handle,GCLP_HICON,NULL)
						SendMessage(.Handle, WM_SETICON, 1, NULL)
						NoNeedSysMenu = GetSystemMenu(.Handle, False)
						DeleteMenu(NoNeedSysMenu, SC_TASKLIST, MF_BYCOMMAND)
						DeleteMenu(NoNeedSysMenu, 7, MF_BYPOSITION)
						DeleteMenu(NoNeedSysMenu, 5, MF_BYPOSITION)
						DeleteMenu(NoNeedSysMenu, SC_MAXIMIZE, MF_BYCOMMAND)
						DeleteMenu(NoNeedSysMenu, SC_MINIMIZE, MF_BYCOMMAND)
						DeleteMenu(NoNeedSysMenu, SC_SIZE, MF_BYCOMMAND)
						DeleteMenu(NoNeedSysMenu, SC_RESTORE, MF_BYCOMMAND)
					Else
						SendMessage(.Handle, WM_SETICON, 1, CInt(.Icon.Handle))
						GetSystemMenu(.Handle, True)
						EnableMenuItem(NoNeedSysMenu, SC_MINIMIZE, MF_BYCOMMAND Or MF_GRAYED)
						EnableMenuItem(NoNeedSysMenu, SC_MAXIMIZE, MF_BYCOMMAND Or MF_GRAYED)
					End If
					If .Opacity <> 255 Then SetLayeredWindowAttributes(.Handle, 0, .Opacity, LWA_ALPHA)
					.ChangeTabIndex -2
					SendMessage(.Handle, WM_UPDATEUISTATE, MAKEWPARAM(UIS_CLEAR, UISF_HIDEFOCUS), NULL)
					If .Menu Then .Menu->ParentWindow = @Sender
					Select Case .FFormStyle
					Case fsMDIForm
						Dim FClientStruct As CLIENTCREATESTRUCT
						FClientStruct.hWindowMenu = 0 'GetSubMenu(GetMenu(.FHandle), WINDOWMENU)
						FClientStruct.idFirstChild = &H00FF
						.FClient = CreateWindowEx(0, "MDICLIENT", "", WS_CHILD Or WS_VISIBLE Or WS_VSCROLL Or WS_HSCROLL Or WS_CLIPSIBLINGS Or WS_CLIPCHILDREN, 0, 0, 0, 0, .FHandle, Cast(hmenu, &hcac), instance, @FClientStruct)
						ShowWindow(.FClient, SW_SHOW)
					Case fsMDIChild
						If .FParent Then
							If *.FParent Is Form Then
								If Cast(Form Ptr, .FParent)->FFormStyle = fsMDIForm Then
									SetParent(.FHandle, Cast(Form Ptr, .FParent)->FClient)
								End If
							End If
						End If
					End Select
					'					.GetMenuItems
					'					Dim As String mnuCaption, HotKey
					'					Dim As Integer Pos1, CountOfHotKeys = 0
					'					Dim As MenuItem Ptr mi
					'					ReDim accl(1) As ACCEL
					'					For i As Integer = 0 To .FMenuItems.Count - 1
					'						mi = .FMenuItems.Items[i]
					'						mnuCaption = mi->Caption
					'						Pos1 = InStr(mnuCaption, !"\t")
					'						If Pos1 > 0 Then
					'							CountOfHotKeys = CountOfHotKeys + 1
					'							HotKey = Mid(mnuCaption, Pos1 + 1)
					'							ReDim Preserve accl(CountOfHotKeys - 1) As ACCEL
					'							If InStr(HotKey, "Ctrl") > 0 Then accl(CountOfHotKeys - 1).fVirt = accl(CountOfHotKeys - 1).fVirt Or FCONTROL
					'							If InStr(HotKey, "Shift") > 0 Then accl(CountOfHotKeys - 1).fVirt = accl(CountOfHotKeys - 1).fVirt Or FSHIFT
					'							If InStr(HotKey, "Alt") > 0 Then accl(CountOfHotKeys - 1).fVirt = accl(CountOfHotKeys - 1).fVirt Or FALT
					'							accl(CountOfHotKeys - 1).fVirt = accl(CountOfHotKeys - 1).fVirt Or FVIRTKEY
					'							Pos1 = InStrRev(HotKey, "+")
					'							If Pos1 > 0 Then HotKey = Mid(HotKey, Pos1 + 1)
					'							accl(CountOfHotKeys - 1).key = GetAscKeyCode(HotKey)
					'							accl(CountOfHotKeys - 1).cmd = mi->Command
					'						End If
					'					Next i
					'					If .Accelerator <> 0 Then DestroyAcceleratorTable(.Accelerator)
					'					.Accelerator = CreateAcceleratorTable(Cast(LPACCEL, @accl(0)), CountOfHotKeys)
					'					Erase accl
				End With
			End If
		End Sub
	#elseif defined(__USE_GTK__)
		Private Function Form.deactivate_cb(ByVal user_data As gpointer) As gboolean
			pApp->FDeactivated = False
			If pApp->FActivated Then
				pApp->FActivated = False
			Else
				Dim As Form Ptr frm = user_data
				If frm->OnDeactivateApp Then frm->OnDeactivateApp(*frm)
			End If
			Return False
		End Function
	#endif
	
	#ifdef __USE_WINAPI__
		Private Sub Form.SetDark(Value As Boolean)
			Base.SetDark Value
			RefreshTitleBarThemeColor(FHandle)
			RedrawWindow FHandle, 0, 0, RDW_INVALIDATE Or RDW_ALLCHILDREN
		End Sub
	#endif
	
	Private Sub Form.ProcessMessage(ByRef msg As Message)
		Dim As Integer Action = 1
		#ifdef __USE_GTK__
			Select Case msg.event->Type
			Case GDK_DELETE
				If OnClose Then OnClose(This, Action)
				Select Case Action
				Case 0
					msg.Result = -1
				Case 1
					If MainForm Then
						#ifdef __USE_GTK__
							gtk_main_quit()
							'End 0
						#else
							PostQuitMessage 0
						#endif
					Else
						'#ifdef __USE_GTK3__
						
						'#else
						If gtk_is_window(widget) Then
							If gtk_window_get_modal (gtk_window(widget)) Then
								gtk_main_quit()
							End If
						End If
						gtk_widget_hide(widget)
						msg.Result = -1
						'#endif
					End If
				Case 2
					msg.Result = -1
				End Select
			Case GDK_FOCUS_CHANGE
				If Cast(GdkEventFocus Ptr, msg.event)->in Then
					If OnActivateApp OrElse OnDeactivateApp Then
						If pApp Then
							pApp->FActivated = True
							If OnActivateApp AndAlso CInt(pApp->FDeactivated = False) Then OnActivateApp(This)
						End If
					End If
					If OnActivate Then OnActivate(This)
				Else
					If OnDeactivate Then OnDeactivate(This)
					If OnActivateApp OrElse OnDeactivateApp Then
						If pApp Then
							pApp->FDeactivated = True
							g_timeout_add(500, Cast(GSourceFunc, @deactivate_cb), @This)
						End If
					End If
				End If
			Case GDK_WINDOW_STATE
				
			Case Else
				
			End Select
		#elseif defined(__USE_WINAPI__)
			Static As Boolean IsMenuItem
			Select Case msg.Msg
			Case WM_GETMINMAXINFO
				'David Change
				'不要为MDI子窗体处理此消息，因为它会干扰子窗体的最大化 - Do not process this message for MDI child forms, as it will interfere with the maximization of child forms
				If (GetWindowLongPtr(Handle, GWL_EXSTYLE) And WS_EX_MDICHILD) = WS_EX_MDICHILD Then
					'DefWindowProcW(Handle, Msg.Msg, Msg.wParam, Msg.lParam)
					Dim FLY_pMinMaxInfo As MINMAXINFO Ptr = Cast(MINMAXINFO Ptr, Msg.lParam)
					Msg.Result = 0
				End If
			Case WM_THEMECHANGED
				If (g_darkModeSupported) Then
					AllowDarkModeForWindow(Msg.hWnd, g_darkModeEnabled)
					RefreshTitleBarThemeColor(Msg.hWnd)
					UpdateWindow(Msg.hWnd)
				End If
			Case WM_UAHDRAWMENU
				If g_darkModeSupported AndAlso g_darkModeEnabled Then
					Dim As UAHMENU Ptr pUDM = Cast(UAHMENU Ptr, Msg.lParam)
					Dim As ..RECT rc = Type( 0 )
					
					' Get the menubar rect
					Dim As MENUBARINFO mbi = Type(  SizeOf(mbi) )
					GetMenuBarInfo(Msg.hWnd, OBJID_MENU, 0, @mbi)
					
					Dim As ..RECT rcWindow
					GetWindowRect(Msg.hWnd, @rcWindow)
					
					' the rcBar is offset by the window rect
					rc = mbi.rcBar
					OffsetRect(@rc, -rcWindow.left, -rcWindow.top)
					
					FillRect(pUDM->hdc, @rc, hbrBkgnd)
					
					Msg.Result = True
					Return
				End If
			Case WM_UAHDRAWMENUITEM
				If g_darkModeSupported AndAlso g_darkModeEnabled Then
					Dim As UAHDRAWMENUITEM Ptr pUDMI = Cast(UAHDRAWMENUITEM Ptr, Msg.lParam)
					
					Dim As HBRUSH Ptr pbrBackground = @hbrBkgnd
					
					' get the menu item string
					Dim As WString * 256 menuString
					Dim As MENUITEMINFO mii = Type( SizeOf(mii), MIIM_STRING )
					mii.dwTypeData = @menuString
					mii.cch = 256
					
					GetMenuItemInfo(pUDMI->um.hmenu, pUDMI->umi.iPosition, True, @mii)
					
					' get the item state for drawing
					
					Dim As DWORD dwFlags = DT_CENTER Or DT_SINGLELINE Or DT_VCENTER
					
					Enum POPUPITEMSTATES
						MPI_NORMAL = 1,
						MPI_HOT = 2,
						MPI_DISABLED = 3,
						MPI_DISABLEDHOT = 4,
					End Enum
					
					Dim As Integer iTextStateID = 0
					Dim As Integer iBackgroundStateID = 0
					If ((pUDMI->dis.itemState And ODS_INACTIVE) Or (pUDMI->dis.itemState And ODS_DEFAULT)) Then
						' normal display
						iTextStateID = MPI_NORMAL
						iBackgroundStateID = MPI_NORMAL
					End If
					If (pUDMI->dis.itemState And ODS_HOTLIGHT) Then
						' hot tracking
						iTextStateID = MPI_HOT
						iBackgroundStateID = MPI_HOT
						
						pbrBackground = @hbrHlBkgnd '@g_brItemBackgroundHot
					End If
					If (pUDMI->dis.itemState And ODS_SELECTED) Then
						' clicked -- MENU_POPUPITEM has no state for this, though MENU_BARITEM does
						iTextStateID = MPI_HOT
						iBackgroundStateID = MPI_HOT
						
						pbrBackground = @hbrHlBkgnd '@g_brItemBackgroundSelected
					End If
					If ((pUDMI->dis.itemState And ODS_GRAYED) Or (pUDMI->dis.itemState And ODS_DISABLED)) Then
						' disabled / grey text
						iTextStateID = MPI_DISABLED
						iBackgroundStateID = MPI_DISABLED
					End If
					If (pUDMI->dis.itemState And ODS_NOACCEL) Then
						dwFlags Or = DT_HIDEPREFIX
					End If
					
					If (g_menuTheme = 0) Then
						g_menuTheme = OpenThemeData(Msg.hWnd, "Menu")
					End If
					
					'Dim As DTTOPTS opts = Type( SizeOf(opts), DTT_TEXTCOLOR, IIf(iTextStateID <> MPI_DISABLED, RGB(&h00, &h00, &h20), RGB(&h40, &h40, &h40) )
					
					FillRect(pUDMI->um.hdc, @pUDMI->dis.rcItem, *pbrBackground)
					SetBKMode pUDMI->um.hdc, TRANSPARENT
					SetTextColor pUDMI->um.hdc, darkTextColor
					SetBKColor pUDMI->um.hdc, darkBkColor
					DrawText pUDMI->um.hdc, menuString, mii.cch, @pUDMI->dis.rcItem, dwFlags
					SetBKMode pUDMI->um.hdc, OPAQUE
					'DrawThemeTextEx(g_menuTheme, pUDMI->um.hdc, MENU_BARITEM, MBI_NORMAL, menuString, mii.cch, dwFlags, @pUDMI->dis.rcItem, @opts)
					
					Msg.Result = True
					Return
				End If
			Case WM_NCPAINT, WM_NCACTIVATE
				If g_darkModeSupported AndAlso g_darkModeEnabled Then
					DefWindowProc(Msg.hWnd, Msg.Msg, Msg.wParam, Msg.lParam)
					Dim As MENUBARINFO mbi = Type( SizeOf(mbi) )
					If (GetMenuBarInfo(Msg.hWnd, OBJID_MENU, 0, @mbi) = 0) Then
						Msg.Result = True
						Return
					End If
					
					Dim As RECT rcClient = Type( 0 )
					GetClientRect(Msg.hWnd, @rcClient)
					MapWindowPoints(Msg.hWnd, nullptr, Cast(Point Ptr, @rcClient), 2)
					
					Dim As RECT rcWindow = Type( 0 )
					GetWindowRect(Msg.hWnd, @rcWindow)
					
					OffsetRect(@rcClient, -rcWindow.left, -rcWindow.top)
					
					' the rcBar is offset by the window rect
					Dim As RECT rcAnnoyingLine = rcClient
					rcAnnoyingLine.bottom = rcAnnoyingLine.top
					rcAnnoyingLine.top -= 1
					
					Dim As HDC Dc = GetWindowDC(Msg.hWnd)
					FillRect(Dc, @rcAnnoyingLine, hbrBkgnd)
					ReleaseDC(Msg.hWnd, Dc)
					Msg.Result = True
					Return
				End If
			Case WM_PAINT, WM_ERASEBKGND
				Dim As HDC Dc, memDC
				Dim As HBITMAP Bmp
				Dim As PAINTSTRUCT Ps
				Canvas.HandleSetted = True
				If g_darkModeSupported AndAlso g_darkModeEnabled Then
					If Not FDarkMode Then
						SetDark True
'						FDarkMode = True
'						RefreshTitleBarThemeColor(FHandle)
'						If FDefaultBackColor = FBackColor Then
'							Brush.Handle = hbrBkgnd
'						End If
'						SendMessageW(FHandle, WM_THEMECHANGED, 0, 0)
'						RedrawWindow FHandle, 0, 0, RDW_INVALIDATE Or RDW_ALLCHILDREN
					End If
				Else
					If FDarkMode Then
						SetDark False
'						FDarkMode = False
'						RefreshTitleBarThemeColor(FHandle)
'						If FBackColor = -1 Then
'							Brush.Handle = 0
'						Else
'							Brush.Color = FBackColor
'						End If
'						SendMessageW(FHandle, WM_THEMECHANGED, 0, 0)
'						RedrawWindow FHandle, 0, 0, RDW_INVALIDATE Or RDW_ALLCHILDREN
					End If
				End If
				Dc = BeginPaint(Handle, @Ps)
				If DoubleBuffered Then
					MemDC = CreateCompatibleDC(DC)
					Bmp   = CreateCompatibleBitmap(DC,Ps.rcpaint.Right,Ps.rcpaint.Bottom)
					SelectObject(MemDc,Bmp)
					SendMessage(Handle, WM_ERASEBKGND, CInt(MemDC), CInt(MemDC))
					FillRect memDc,@Ps.rcpaint, Brush.Handle
					Canvas.Handle = memDC
					If Graphic.Bitmap.Handle <> 0 Then Canvas.Draw 0, 0, Graphic.Bitmap.Handle
					If OnPaint Then OnPaint(This, Canvas)
					BitBlt(DC, 0, 0, Ps.rcpaint.Right, Ps.rcpaint.Bottom, MemDC, 0, 0, SRCCOPY)
					DeleteObject(Bmp)
					DeleteDC(MemDC)
				Else
					FillRect Dc, @Ps.rcpaint, Brush.Handle
					Canvas.Handle = Dc
					If Graphic.Bitmap.Handle <> 0 Then Canvas.Draw 0, 0, Graphic.Bitmap.Handle
					If OnPaint Then OnPaint(This, Canvas)
				End If
				EndPaint Handle,@Ps
				msg.Result = 0
				Canvas.HandleSetted = False
				Return
			Case WM_SIZE
				If Not This.WindowState = wsMinimized Then
					RequestAlign
				End If
				If OnReSize Then OnReSize(This, This.Width, This.Height)
				Return
			Case WM_CLOSE
				If OnClose Then
					OnClose(This, Action)
				End If
				Select Case Action
				Case 0
					msg.Result = -1
				Case 1
					If MainForm Then
						'PostQuitMessage 0
						End 0
					Else
						ShowWindow Handle, SW_HIDE
						msg.Result = -1
					End If
				Case 2
					ShowWindow Handle,SW_MINIMIZE
					msg.Result = -1
				End Select
			Case WM_COMMAND
				GetMenuItems
				Dim As MenuItem Ptr mi
				For i As Integer = 0 To FMenuItems.Count -1
					mi = FMenuItems.Items[i]
					With *mi
						If .Command = msg.wParamLo Then
							If .OnClick Then .OnClick(*mi)
							msg.Result = -2
							msg.Msg = 0
							Exit For
						End If
					End With
				Next i
				IsMenuItem = False
			Case WM_MENUSELECT
				IsMenuItem = True
			Case WM_INITMENU
			Case WM_INITMENUPOPUP
				'			Case WM_TIMER
				'				If OnTimer Then OnTimer(This)
			Case WM_ACTIVATE
				Select Case msg.wParamLo
				Case WA_ACTIVE, WA_CLICKACTIVE
					pApp->ActiveForm = @This
					If OnActivate Then OnActivate(This)
				Case WA_INACTIVE
					If OnDeActivate Then OnDeActivate(This)
				End Select
			Case WM_ACTIVATEAPP
				Select Case msg.wParam
				Case 1
					If OnActivateApp Then OnActivateApp(This)
				Case 0
					If OnDeActivateApp Then OnDeActivateApp(This)
				End Select
			Case WM_DESTROY
				If Accelerator Then DestroyAcceleratorTable(Accelerator)
			Case WM_DRAWITEM
				Dim As DRAWITEMSTRUCT Ptr diStruct
				diStruct = Cast(DRAWITEMSTRUCT Ptr, msg.lParam)
				Select Case diStruct->CtlType
				Case ODT_MENU
					'If This.Menu AndAlso This.Menu->ImagesList AndAlso This.Menu->ImagesList->Handle AndAlso diStruct->itemData <> 0 Then
					'    ImageList_Draw(This.Menu->ImagesList->Handle, Cast(MenuItem Ptr, diStruct->itemData)->ImageIndex, diStruct->hDC, 2, 2, ILD_NORMAL)
					'End If
				End Select
			Case CM_HELP
				Dim As Point P
				Dim As HWND HControl
				Dim As Control Ptr Ctrl
				Dim As Integer ContextID,Id,i
				Dim As HELPINFO Ptr HIF
				HIF = Cast(HELPINFO Ptr, msg.lParam)
				If HIF->iContextType = HELPINFO_WINDOW Then
					HControl = HIF->hItemHandle
					Ctrl = Cast(Control Ptr, GetWindowLongPtr(HControl, GWLP_USERDATA))
					If Ctrl Then
						If Ctrl->HelpContext <> 0 Then
							ContextID = Ctrl->HelpContext
						Else
							If Ctrl->Parent Then
								Ctrl= Ctrl->Parent
								ContextID = Ctrl->HelpContext
							Else
								Exit Select
							End If
						End If
					End If
					Ctrl->ClientToScreen(P)
				Else  ' Message.HelpInfo.iContextType = HELPINFO_MENUITEM
					Id = 0
					If This.Menu Then
						For i = 0 To This.Menu->Count -1
							If This.Menu->Item(i)->Command = HIF->iCtrlID Then
								Id = i
								Exit For
							End If
						Next i
					End If
					'                 If Id Then ContextID = MainMenu.Item(Id)->HelpContext
					'                 If ContextID = 0 Then
					'                     For i = 0 to MainMenu.Count -1
					'                          If MainMenu.Items[i]->CommandID = HIF->iCtrlID Then
					'                              Id = i
					'                              Exit For
					'                          End If
					'                     Next i
					'                     If Id then ContextID = PopupMenu.Items[Id]->HelpContext
					'                 End If
					This.ClientToScreen(P)
				End If
				If (GetWindowLong(Handle,GWL_EXSTYLE) And WS_EX_CONTEXTHELP) = WS_EX_CONTEXTHELP Then
					pApp->HelpCommand(HELP_SETPOPUP_POS, CInt(@P))
					pApp->HelpCommand(HELP_CONTEXTPOPUP, ContextID)
				Else
					pApp->HelpContext(ContextID)
				End If
			End Select
		#endif
		Base.ProcessMessage(msg)
		#ifdef __USE_WINAPI__
			Select Case FFormStyle
			Case fsMDIChild
				Msg.Result = -3
			Case fsMDIForm
				Msg.hWnd = FClient
				Msg.Result = -4
			End Select
		#endif
	End Sub
	
	'David Change
	Private Sub Form.BringToFront
		#ifdef __USE_WINAPI__
			'If Handle Then BringWindowToTop Handle
			'Const HWND_TOPMOST = -1
			'Const HWND_NOTOPMOST = -2
			If Handle Then SetWindowPos(Handle, HWND_TOP,0, 0, 0, 0, SWP_NOMOVE Or SWP_NOSIZE)' This.Left, This.Top, This.Width, This.Height, 0)
		#endif
	End Sub
	
	Private Sub Form.SendToBack
		#ifdef __USE_WINAPI__
			If Handle Then SetWindowPos Handle, HWND_BOTTOM, 0, 0, 0, 0, SWP_NOMOVE Or SWP_NOSIZE
		#endif
	End Sub
	
	Private Property Form.Visible() As Boolean
		#ifdef __USE_WINAPI__
			If FHandle Then
				FVisible = IsWindowVisible(FHandle)
			End If
		#endif
		Return FVisible
	End Property
	
	Private Property Form.Visible(Value As Boolean)
		FVisible = Value
		If Value Then
			Show
		Else
			Hide
		End If
	End Property
	
	Private Sub Form.ShowItems(Ctrl As Control Ptr)
		#ifdef __USE_GTK__
			If CInt(Ctrl->FVisible) OrElse CInt(gtk_is_notebook(gtk_widget_get_parent(Ctrl->widget))) Then
				If Ctrl->box Then gtk_widget_show(Ctrl->box)
				If Ctrl->scrolledwidget Then gtk_widget_show(Ctrl->scrolledwidget)
				If Ctrl->eventboxwidget Then gtk_widget_show(Ctrl->eventboxwidget)
				If Ctrl->layoutwidget Then gtk_widget_show(Ctrl->layoutwidget)
				If Ctrl->widget Then If Not *Ctrl Is ContainerControl Then gtk_widget_show_all(Ctrl->widget) Else gtk_widget_show(Ctrl->widget)
			End If
			For i As Integer = 0 To Ctrl->ControlCount - 1
				ShowItems Ctrl->Controls[i]
			Next
		#endif
	End Sub
	
	Private Sub Form.HideItems(Ctrl As Control Ptr)
		#ifdef __USE_GTK__
			If Not (CInt(Ctrl->FVisible) OrElse CInt(gtk_is_notebook(gtk_widget_get_parent(Ctrl->widget)))) Then
				If Ctrl->box Then gtk_widget_hide(Ctrl->box)
				If Ctrl->scrolledwidget Then gtk_widget_hide(Ctrl->scrolledwidget)
				If Ctrl->eventboxwidget Then gtk_widget_hide(Ctrl->eventboxwidget)
				If Ctrl->layoutwidget Then gtk_widget_hide(Ctrl->layoutwidget)
				If Ctrl->widget Then gtk_widget_hide(Ctrl->widget)
			End If
			For i As Integer = 0 To Ctrl->ControlCount - 1
				HideItems Ctrl->Controls[i]
			Next
		#endif
	End Sub
	
	Private Sub Form.Show
		#ifdef __USE_GTK__
			RequestAlign
			If widget Then
				If Not FCreated Then
					If OnCreate Then OnCreate(This)
					FCreated = True
				End If
				If Not FFormCreated Then
					FFormCreated = True
					If FStartPosition <> 0 Then StartPosition = FStartPosition
					If Icon.ResName <> "" Then
						If gtk_is_window(widget) Then
							Dim As GList Ptr list1 = NULL
							Dim As GError Ptr gerr
							Dim As GdkPixbuf Ptr gtkicon
							If Icon.ResName <> "" Then
								gtkicon = gdk_pixbuf_new_from_file_at_size(ToUTF8(Icon.ResName), 16, 16, @gerr)
								If gtkicon <> 0 Then list1 = g_list_append(list1, gtkicon)
								gtkicon = gdk_pixbuf_new_from_file_at_size(ToUTF8(Icon.ResName), 48, 48, @gerr)
								If gtkicon <> 0 Then list1 = g_list_append(list1, gtkicon)
								gtk_window_set_icon_list(GTK_WINDOW(Widget), list1)
							End If
						End If
					End If
					If Gtk_Is_Window(Widget) Then
						Select Case FBorderStyle
						Case FormBorderStyle.None, FormBorderStyle.FixedToolWindow, FormBorderStyle.Fixed3D, FormBorderStyle.FixedSingle, FormBorderStyle.FixedDialog
							Dim As GdkGeometry hints
							hints.base_width = FWidth
							hints.base_height = FHeight
							hints.min_width = FWidth
							hints.min_height = FHeight
							hints.max_width = FWidth
							hints.max_height = FHeight
							hints.width_inc = 1
							hints.height_inc = 1
							gtk_window_set_geometry_hints(gtk_window(Widget), NULL, @hints, GDK_HINT_RESIZE_INC Or GDK_HINT_MIN_SIZE Or GDK_HINT_MAX_SIZE Or GDK_HINT_BASE_SIZE)
						Case FormBorderStyle.SizableToolWindow, FormBorderStyle.Sizable
							
						End Select
						If Constraints.Width <> 0 OrElse Constraints.Height <> 0 Then
							Dim As GdkGeometry hints
							If Constraints.Width <> 0 Then
								hints.base_width = Constraints.Width
								hints.min_width = Constraints.Width
								hints.max_width = Constraints.Width
								hints.width_inc = 1
							Else
								hints.base_width = FWidth
								hints.min_width = 0
								hints.max_width = gdk_screen_get_width(gtk_widget_get_screen(widget))
								hints.width_inc = 1
							End If
							If Constraints.Height <> 0 Then
								hints.base_height = Constraints.Height
								hints.min_height = Constraints.Height
								hints.max_height = Constraints.Height
								hints.height_inc = 1
							Else
								hints.base_height = FHeight
								hints.min_height = 0
								hints.max_height = gdk_screen_get_height(gtk_widget_get_screen(widget))
								hints.height_inc = 1
							End If
							gtk_window_set_geometry_hints(gtk_window(Widget), NULL, @hints, GDK_HINT_RESIZE_INC Or GDK_HINT_MIN_SIZE Or GDK_HINT_MAX_SIZE Or GDK_HINT_BASE_SIZE)
						End If
						Select Case FBorderStyle
						Case FormBorderStyle.None
							gtk_window_set_resizable(gtk_window(widget), False)
						Case FormBorderStyle.SizableToolWindow
							gtk_window_set_resizable(gtk_window(widget), True)
						Case FormBorderStyle.FixedToolWindow
							gtk_window_set_resizable(gtk_window(widget), False)
						Case FormBorderStyle.Sizable
							gtk_window_set_resizable(gtk_window(widget), True)
						Case FormBorderStyle.Fixed3D
							gtk_window_set_resizable(gtk_window(widget), False)
						Case FormBorderStyle.FixedSingle
							gtk_window_set_resizable(gtk_window(widget), False)
						Case FormBorderStyle.FixedDialog
							gtk_window_set_resizable(gtk_window(widget), False)
						End Select
					End If
				Else
					StartPosition = Manual
				End If
				'If Menu Then gtk_widget_show_all(Menu->widget)
				'				gtk_widget_show(ImageWidget)
				'				If box Then gtk_widget_show(box)
				'				If layoutwidget Then gtk_widget_show(layoutwidget)
				'				gtk_widget_show(widget)
				gtk_widget_show_all(widget)
				'ShowItems @This
				HideItems @This
				'Requests @This
			End If
		#elseif defined(__USE_WINAPI__)
			If IsIconic(Handle) Then
				ShowWindow Handle, SW_SHOWNORMAL
				'			ElseIf IsWindowVisible(Handle) Then
				'				This.SetFocus
			Else
				If Handle Then
					ShowWindow Handle, FCmdShow(FWindowState)
					If FParent Then Cast(Control Ptr, FParent)->RequestAlign
				Else
					CreateWnd
					Exit Sub
				End If
			End If
			SelectNextControl
		#endif
		If OnShow Then OnShow(This)
	End Sub
	
	Private Sub Form.Show(ByRef OwnerForm As Form)
		This.FParent = @OwnerForm
		#ifdef __USE_GTK__
			If gtk_is_window(widget) AndAlso gtk_is_window(OwnerForm.Widget) Then
				gtk_window_set_transient_for(gtk_window(widget), gtk_window(OwnerForm.Widget))
			End If
		#endif
		This.Show
	End Sub
	
	Private Function Form.ShowModal(ByRef OwnerForm As Form) As Integer
		This.FParent = @OwnerForm
		Return This.ShowModal()
	End Function
	
	Private Function Form.ShowModal() As Integer
		#ifdef __USE_GTK__
			If pApp AndAlso pApp->ActiveForm <> 0 Then gtk_window_set_transient_for(gtk_window(widget), gtk_window(pApp->ActiveForm->Widget))
			gtk_window_set_modal(gtk_window(widget), True)
			This.Show
			'If OnShow Then OnShow(This)
			gtk_main()
			gtk_window_set_modal(gtk_window(widget), False)
		#elseif defined(__USE_WINAPI__)
			Dim As Integer i
			Dim As Any Ptr Mtx
			FParentHandle = GetFocus()
			If IsWindowVisible(FHandle) Then
				This.SetFocus
				Exit Function
			End If
			If GetCapture <> 0 Then SendMessage(GetCapture,WM_CANCELMODE,0,0)
			'?"..." & GetCapture
			'ReleaseCapture
			For i = 0 To pApp->FormCount - 1
				pApp->Forms[i]->Enabled = False
			Next i
			Enabled = True
			Visible = True
			Dim As MSG msg
			Dim TranslateAndDispatch As Boolean
			While GetMessage(@msg, NULL, 0, 0)
				TranslateAndDispatch = True
				If Accelerator Then TranslateAndDispatch = TranslateAccelerator(FHandle, Accelerator, @msg) = 0
				If TranslateAndDispatch Then
					Select Case Msg.message
					Case WM_KEYDOWN
						Select Case Msg.wParam
						Case VK_TAB ', VK_LEFT, VK_UP, VK_DOWN, VK_RIGHT, VK_PRIOR, VK_NEXT
							If Not GetFocus() = Handle Then
								SelectNextControl(GetKeyState(VK_SHIFT) And 8000)
								TranslateAndDispatch = False
							ElseIf IsDialogMessage(Handle, @Msg) Then
								TranslateAndDispatch = False
							End If
						End Select
					End Select
				End If
				If TranslateAndDispatch Then
					TranslateMessage @msg
					DispatchMessage @msg
				End If
				If IsWindowVisible(FHandle) = 0 Then Exit While
			Wend
			Visible = False
			For i = 0 To pApp->FormCount - 1
				pApp->Forms[i]->Enabled = True
			Next i
			ReleaseCapture
			SetForegroundWindow FParentHandle
		#endif
		Function = ModalResult
	End Function
	
	Private Sub Form.Hide
		#ifdef __USE_GTK__
			If Widget Then
				#ifdef __USE_GTK3__
					If gtk_widget_is_visible(Widget) Then
				#else
					If gtk_widget_get_visible(Widget) Then
				#endif
					If OnHide Then OnHide(This)
					gtk_widget_hide(widget)
				End If
			End If
		#elseif defined(__USE_WINAPI__)
			If Handle Then
				If IsWindowVisible(Handle) Then
					If OnHide Then OnHide(This)
					ShowWindow Handle, SW_HIDE
				End If
			End If
		#endif
	End Sub
	
	Private Sub Form.Maximize
		#ifdef __USE_GTK__
			If gtk_is_window(widget) Then
				gtk_window_maximize(GTK_WINDOW(widget))
			End If
		#elseif defined(__USE_WINAPI__)
			If IsIconic(Handle) = 0 Then
				ShowWindow Handle, SW_MAXIMIZE
			End If
		#endif
	End Sub
	
	Private Sub Form.Minimize
		#ifdef __USE_GTK__
			If gtk_is_window(widget) Then
				gtk_window_iconify(GTK_WINDOW(widget))
			End If
		#elseif defined(__USE_WINAPI__)
			If IsIconic(Handle) = 0 Then
				ShowWindow Handle, SW_MINIMIZE
			End If
		#endif
	End Sub
	
	Private Sub Form.CloseForm
		#ifdef __USE_GTK__
			'#ifdef __USE_GTK3__
			'	gtk_window_close(Gtk_Window(widget))
			'#else
			Dim As Integer Action = 1
			If OnClose Then OnClose(This, Action)
			Select Case Action
			Case 0
			Case 1
				If MainForm Then
					If gtk_is_widget(widget) Then gtk_widget_destroy(widget)
					gtk_main_quit()
				Else
					If gtk_is_window(widget) Then
						If gtk_window_get_modal (gtk_window(widget)) Then
							gtk_main_quit()
						End If
					End If
					gtk_widget_hide(widget)
				End If
			Case 2
			End Select
			'#endif
		#elseif defined(__USE_WINAPI__)
			If Handle Then SendMessage(Handle, WM_CLOSE, 0, 0)
		#endif
	End Sub
	
	Private Sub Form.CenterToParent()
		If FParent Then
			With *Cast(Control Ptr, FParent)
				#ifdef __USE_GTK__
					If gtk_is_window(widget) Then
						gtk_window_set_position(gtk_window(widget), GTK_WIN_POS_CENTER)
						gtk_window_move(gtk_window(widget), .Left + (.Width - This.FWidth) \ 2, .Top + (.Height - This.FHeight) \ 2)
					End If
				#else
					This.Left = .Left + (.Width - This.Width) \ 2: This.Top  = .Top + (.Height - This.Height) \ 2
				#endif
			End With
		End If
	End Sub
	
	Private Sub Form.CenterToScreen()
		#ifdef __USE_GTK__
			If gtk_is_window(widget) Then
				gtk_window_move(gtk_window(widget), (gdk_screen_width() - This.FWidth) \ 2, (gdk_screen_height() - This.FHeight) \ 2)
			End If
			'gtk_window_set_position(gtk_window(widget), GTK_WIN_POS_CENTER) '_ALWAYS
		#elseif defined(__USE_WINAPI__)
			This.Left = (UnScaleX(GetSystemMetrics(SM_CXSCREEN)) - This.Width) \ 2
			This.Top  = (UnScaleY(GetSystemMetrics(SM_CYSCREEN)) - This.Height) \ 2
		#endif
	End Sub
	
	Private Function Form.EnumMenuItems(Item As MenuItem) As Boolean
		FMenuItems.Add Item
		For i As Integer = 0 To Item.Count -1
			EnumMenuItems *Item.Item(i)
		Next i
		Return True
	End Function
	
	Private Sub Form.GetMenuItems
		FMenuItems.Clear
		If This.Menu Then
			For i As Integer = 0 To This.Menu->Count -1
				EnumMenuItems *This.Menu->Item(i)
			Next i
		End If
	End Sub
	
	Private Sub Form.GraphicChange(ByRef Sender As My.Sys.Drawing.GraphicType, Image As Any Ptr, ImageType As Integer)
		With Sender
			If .Ctrl->Child Then
				#ifdef __USE_GTK__
					If gtk_is_image(QForm(.Ctrl->Child).ImageWidget) Then
						Select Case ImageType
						Case 0
							gtk_image_set_from_pixbuf(gtk_image(QForm(.Ctrl->Child).ImageWidget), .Bitmap.Handle)
						Case 1
							gtk_image_set_from_pixbuf(gtk_image(QForm(.Ctrl->Child).ImageWidget), .Icon.Handle)
						End Select
					End If
				#else
					'					Select Case ImageType
					'					Case 0
					'						QForm(.Ctrl->Child).ChangeStyle SS_BITMAP, True
					'						QForm(.Ctrl->Child).Perform(BM_SETIMAGE, ImageType, CInt(Sender.Bitmap.Handle))
					'					Case 1
					'						QForm(.Ctrl->Child).ChangeStyle SS_ICON, True
					'						QForm(.Ctrl->Child).Perform(BM_SETIMAGE, ImageType, CInt(Sender.Icon.Handle))
					'					Case 2
					'						QForm(.Ctrl->Child).ChangeStyle SS_ICON, True
					'						QForm(.Ctrl->Child).Perform(BM_SETIMAGE, ImageType, CInt(Sender.Icon.Handle))
					'					Case 3
					'						QForm(.Ctrl->Child).ChangeStyle SS_ENHMETAFILE, True
					'						QForm(.Ctrl->Child).Perform(BM_SETIMAGE, ImageType, CInt(0))
					'					End Select
					.Ctrl->Repaint
				#endif
			End If
		End With
	End Sub
	
	Private Operator Form.Cast As Control Ptr
		Return @This
	End Operator
	
	Private Sub Form.IconChanged(ByRef Sender As My.Sys.Drawing.Icon)
		With *Cast(Form Ptr, Sender.Graphic)
			#ifdef __USE_WINAPI__
				SendMessage(.Handle, WM_SETICON, 1, CInt(.Icon.Handle))
			#endif
		End With
	End Sub
	
	Private Constructor Form
		#ifdef __USE_GTK__
			ImageWidget = gtk_image_new()
			WindowWidget = gtk_window_new(GTK_WINDOW_TOPLEVEL)
			Widget = WindowWidget
			'gtk_window_set_policy(GTK_WINDOW(widget), true, false, false)
			This.RegisterClass "Form", @This
			If gtk_is_widget(layoutwidget) Then gtk_layout_put(GTK_LAYOUT(layoutwidget), ImageWidget, 0, 0)
		#elseif defined(__USE_WINAPI__)
			FMainStyle(0)  = 0
			FMainStyle(1)  = WS_EX_APPWINDOW
			FClassStyle(0) = CS_VREDRAW Or CS_HREDRAW Or CS_DBLCLKS
			FClassStyle(1) = CS_DBLCLKS
			FClassStyle(2) = CS_DBLCLKS Or CS_SAVEBITS Or CS_BYTEALIGNWINDOW
			FClassStyle(3) = CS_DBLCLKS
			FClassStyle(4) = CS_DBLCLKS
			FClassStyle(5) = CS_DBLCLKS
			FExStyle(0)    = WS_EX_CONTROLPARENT
			FExStyle(1)    = WS_EX_CONTROLPARENT
			FExStyle(2)    = WS_EX_CONTROLPARENT Or WS_EX_DLGMODALFRAME
			FExStyle(3)    = WS_EX_CONTROLPARENT
			FExStyle(4)    = WS_EX_CONTROLPARENT Or WS_EX_TOOLWINDOW
			FExStyle(5)    = WS_EX_CONTROLPARENT Or WS_EX_TOOLWINDOW
			FStyle(0)      = DS_CONTROL
			FStyle(1)      = WS_CAPTION Or WS_BORDER Or DS_CONTROL
			FStyle(2)      = WS_CAPTION Or WS_BORDER Or WS_SYSMENU
			FStyle(3)      = WS_OVERLAPPEDWINDOW
			FStyle(4)      = WS_CAPTION Or WS_BORDER Or WS_SYSMENU
			FStyle(5)      = WS_CAPTION Or WS_THICKFRAME Or WS_SYSMENU
			FChild(0) = 0
			FChild(1) = WS_CHILD
			FCmdShow(0) = SW_HIDE
			FCmdShow(1) = SW_SHOWNORMAL
			FCmdShow(2) = SW_SHOWMAXIMIZED
			FCmdShow(3) = SW_SHOWMINIMIZED
			This.RegisterClass "Form"
		#endif
		Text = "Form"
		FBorderStyle   = 3
		FWindowState   = 1
		FControlBox = True
		FMinimizeBox = True
		FMaximizeBox = True
		FOpacity = 255
		Canvas.Ctrl    = @This
		Graphic.Ctrl = @This
		Graphic.OnChange = @GraphicChange
		Icon.Graphic = @This
		Icon.Changed = @IconChanged
		With This
			.Child             = @This
			#ifdef __USE_WINAPI__
				.ChildProc         = @WndProc
			#endif
			WLet(FClassName, "Form")
			.OnActiveControlChanged = @ActiveControlChanged
			#ifdef __USE_WINAPI__
				.ExStyle           = WS_EX_CONTROLPARENT Or WS_EX_WINDOWEDGE 'FExStyle(FBorderStyle) OR FMainStyle(FMainForm)
				.Style             = WS_CAPTION Or WS_SYSMENU Or WS_MINIMIZEBOX Or WS_MAXIMIZEBOX Or WS_THICKFRAME Or WS_DLGFRAME Or WS_BORDER 'FStyle(FBorderStyle) Or FChild(Abs_(FIsChild))
				.BackColor             = GetSysColor(COLOR_BTNFACE)
				FDefaultBackColor = .BackColor
				.OnHandleIsAllocated = @HandleIsAllocated
				.Width             = 350 'CW_USEDEFAULT
				.Height            = 300 'CW_USEDEFAULT
				WLet(FClassAncestor, "")
			#elseif defined(__USE_JNI__)
				.Width             = 350
				.Height            = 300
				WLet(FClassAncestor, Replace(__FB_QUOTE__(Package), "_", "/") & "/mffActivity")
			#elseif defined(__USE_GTK__)
				.Width             = 350
				.Height            = 300
				WLet(FClassAncestor, "GtkWindow")
			#endif
			.StartPosition = DefaultLocation
		End With
		If pApp->MainForm = 0 Then
			pApp->MainForm = @This
			FMainForm = True
		End If
		#ifdef __AUTOMATE_CREATE_FORM__
			CreateWnd
		#endif
	End Constructor
	
	Private Destructor Form
		'		If OnFree Then OnFree(This)
		'		#ifndef __USE_GTK__
		'			If FHandle Then FreeWnd
		'		#endif
		FMenuItems.Clear
		#ifdef __USE_WINAPI__
			If Accelerator Then DestroyAcceleratorTable(Accelerator)
		#endif
		'UnregisterClass ClassName, GetModuleHandle(NULL)
	End Destructor
End Namespace

#ifdef __USE_JNI__
	Sub mffActivity_onCreate Alias AddToPackage(Package, mffActivity_onCreate) (ByVal env1 As JNIEnv Ptr, This_ As jobject, layout As jobject) Export
		If pApp Then
			If env = 0 Then
				env = env1
				Dim As jclass activityThread = (*env)->FindClass(env, "android/app/ActivityThread")
				Dim As jmethodID currentActivityThread = (*env)->GetStaticMethodID(env, activityThread, "currentActivityThread", "()Landroid/app/ActivityThread;")
				Dim As jobject at = (*env)->CallStaticObjectMethod(env, activityThread, currentActivityThread)
				Dim As jmethodID getApplication = (*env)->GetMethodID(env, activityThread, "getApplication", "()Landroid/app/Application;")
				pApp->Instance = (*env)->CallObjectMethod(env, at, getApplication)
				Dim As jobject res = CallObjectMethod(pApp->Instance, "android/content/Context", "getResources", "()Landroid/content/res/Resources;")
				Dim As jobject displaymetrics = CallObjectMethod(res, "android/content/res/Resources", "getDisplayMetrics", "()Landroid/util/DisplayMetrics;")
				Dim As jclass displaymetricsClass = (*env)->FindClass(env, "android/util/DisplayMetrics")
				Dim As jfieldID xdpiField = (*env)->GetFieldID(env, displaymetricsClass, "xdpi", "F")
				Dim As jfieldID ydpiField = (*env)->GetFieldID(env, displaymetricsClass, "ydpi", "F")
				xdpi = (*env)->GetFloatField(env, displaymetrics, xdpiField) / 100
				ydpi = (*env)->GetFloatField(env, displaymetrics, ydpiField) / 100
				If pApp->MainForm Then
					pApp->MainForm->Handle = This_
					'				Dim As jmethodID getWindow = (*env)->GetMethodID(env, activityClass, "getWindow", "()Landroid/view/Window;")
					'				Dim As jobject iWindow = (*env)->CallObjectMethod(env, This_, getWindow)
					'				Dim As jclass windowClass = (*env)->FindClass(env, "android/view/Window")
					'				Dim As jmethodID getDecorView = (*env)->GetMethodID(env, windowClass, "getDecorView", "()Landroid/view/View;")
					'				Dim As jobject decorView = (*env)->CallObjectMethod(env, iWindow, getDecorView)
					'				Dim As jclass viewgroupClass = (*env)->FindClass(env, "android/view/ViewGroup")
					'				Dim As jmethodID getChildAt = (*env)->GetMethodID(env, viewgroupClass, "getChildAt", "(I)Landroid/view/View;")
					'				Dim As jobject ViewGroup = (*env)->CallObjectMethod(env, decorView, getChildAt, 0)
					'Dim As jobject ViewGroup2 = (*env)->CallObjectMethod(env, ViewGroup, getChildAt, 0)
					pApp->MainForm->LayoutHandle = layout 'ViewGroup
					pApp->MainForm->CreateWnd
					pApp->MainForm->Text = pApp->MainForm->Text 'ViewGroup
				End If
			End If
		End If
	End Sub
#endif
