import bpy

from bpy.props import (IntProperty,
                       BoolProperty,
                       StringProperty,
                       CollectionProperty)

from bpy.types import (Operator,
                       Panel,
                       PropertyGroup,
                       UIList)

from .cp_props import CP_Props_Collections, ColListProp
from .main_properties import CP_Prefs


classes = (
    ColListProp, CP_Props_Collections, CP_Prefs
)


def register_addon_properties():
    from bpy.utils import register_class
    for cls in classes:
        register_class(cls)

    bpy.types.Scene.cpresets = bpy.props.PointerProperty(type= CP_Props_Collections)

        


def unregister_addon_properties():
    from bpy.utils import unregister_class
    for cls in reversed(classes):
        unregister_class(cls)

    del bpy.types.Scene.cpresets

       
 