import bpy

from bpy.props import (IntProperty,
                       BoolProperty,
                       StringProperty,
                       CollectionProperty)

from bpy.types import (Operator,
                       Panel,
                       PropertyGroup,
                       UIList)

class ColListProp(PropertyGroup):
    
    col_dict: StringProperty(default="") # the main information for each preset
    preset_id : IntProperty() 
    preset_name : StringProperty(name='Preset Name', description='Preset Name')
    preset_description : StringProperty(name='Preset Description', description='Preset Description')
    preset_icon : StringProperty(name='Preset Description', description='Preset icon')
    preset_mode : StringProperty(description='Preset Mode') # preset mode (collection, or object)
    preset_scope : StringProperty(description='Preset Scope') # all information or only viewport information
    preset_fav : BoolProperty(name='Favorite Preset', default=False, description='Add this to favorites') # show in the pie menu or not

class CP_Props_Collections(PropertyGroup):

    custom_index: IntProperty()  # custom id for active preset index

    action_mode: bpy.props.EnumProperty(
        name= 'Action Mode',
        description = 'Action Mode',
        items = [
            ('a2','Objects', 'In the objects action mode, the information in the preset will be only related to objects, not collections'),
            ('a1','Collections', 'In the Collections action mode, the information in the preset will be only related to collections, not objects'),
        ]        

    ) 

    preset_scope: bpy.props.EnumProperty(
        name= 'Viz Method',
        description = 'Select the visibility properties for the preset',
        items = [
            ('s1','Simple (Fast)', 'In the Simple mode, the preset will have only the viewport visibility information'),
            ('s2','Complete', 'In the complete mode, the preset will have all the visibility information of the object, including viewport, display, selection and render visibility information'),
        ]        

    )

    fav_presets : IntProperty(default=0) # to get the number of total itens for menu
    colprops_p : bpy.props.CollectionProperty(type= ColListProp) #creating a collection property in the properties list 
    last_preset : IntProperty(default=0) 
    preset_id: IntProperty(default=0) 

    