
import bpy

from ..utlity.addon import addon_name, get_prefs

from bpy.props import (IntProperty,
                       BoolProperty,
                       StringProperty,
                       CollectionProperty,
                       PointerProperty)

from bpy.types import (Operator,
                       Panel,
                       PropertyGroup,
                       UIList)

#from .preset_props import CUSTOM_objectCollection, CUSTOM_Collectionid
#from .preset_props import Tools_Props_Collectionid

class CP_Prefs(bpy.types.AddonPreferences):    
    bl_idname = addon_name

    teste_index: IntProperty()
    add_default_preset : BoolProperty(name=' Objects Default Preset (Show All Objects)', default=True, description='Always add a Default Preset when a new object preset is added. When selected, the default preset will show all objects in the scene')
    default_preset_scope: bpy.props.EnumProperty(
        name= '  Visibility Properties',
        description = 'Select the visibility properties of the Default Preset ',
        items = [
            ('s1','Simple (Fast)', 'In the Simple mode, the default preset will have only the viewport visibility information'),
            ('s2','Complete', 'In the complete mode, the default preset will have all the visibility information of the object, including viewport, display, selection and render visibility information'),
        ]        

    ) 
    add_default_preset_col : BoolProperty(name=' Collections Default Preset (Enable All Collections)', default=True, description='Always add a Default Preset when a new collection preset is added. When selected, the default preset will enable all collections in the scene')
    Hide_new_objects : BoolProperty(name=' Hide New Objects', default=True, description="Always hide new objects added to the scene when using a preset that was made before these new objects")


    def draw(self, context):

        prefs = get_prefs()
        layout = self.layout

        box = layout.box()

        box.label(text='Settings:')
        box.prop(prefs,'Hide_new_objects')

        box = layout.box()

        box.label(text='Default Presets:')
        box.prop(prefs,'add_default_preset')

        if prefs.add_default_preset:
            box.prop(prefs,'default_preset_scope')

        box.prop(prefs,'add_default_preset_col')


     