import bpy
from bpy.types import Menu

from ..utlity.addon import addon_name, get_prefs
from ..utlity.temp_variables import max_menu


from bpy.props import (IntProperty,
                       BoolProperty,
                       StringProperty,
                       CollectionProperty)

from bpy.types import (Operator,
                       Panel,
                       PropertyGroup,
                       UIList)

# UIList preset_fav

class Preset_UL_items(UIList):
    def draw_item(self, context, layout, data, item, icon, active_data, active_propname, index):

        scn = context.scene.cpresets

        layout.prop(item, 'preset_name', text='', icon = item.preset_icon, emboss=False, translate=False)   

        layout.label(text='',icon = 'LAYER_ACTIVE' if item.preset_id == scn.last_preset else 'BLANK1')   
        layout.prop(item, 'preset_fav', text='',emboss=False, translate=False, icon = 'SOLO_ON' if item.preset_fav == True else 'SOLO_OFF') 

        '''

        if item.preset_fav:
            layout.label(text='', icon='SOLO_OFF')
        else:          
            layout.label(text='', icon='BLANK1')

    
        

        if item.preset_scope == 's2':
            layout.label(text='', icon='PROP_ON')
        if item.preset_scope == 's1':
            layout.label(text='', icon='PROP_OFF')
        if item.preset_scope == 'aa':
            layout.label(text='', icon='PROP_OFF')
        if item.preset_scope == 'bb':
            layout.label(text='', icon='PROP_ON')
        if item.preset_scope == 'cc':
            layout.label(text='', icon='PROP_ON')     
        ''' 

    def invoke(self, context, event):
        pass   


class Presets_PT_PanelList(Panel):
    """Painel List with presets"""
    bl_idname = 'Presets_PT_PanelList'
    bl_space_type = 'VIEW_3D'
    bl_region_type = "UI"
    bl_label = "VizPresets"
    bl_category = "View"

    def draw(self, context):
        layout = self.layout
        scn = context.scene.cpresets
        idx = scn.custom_index
        scene = context.scene.cpresets

        try:
            item = scn.colprops_p[idx]
        except:
            item = None

        rows = 7
        row = layout.row()

        try:
            row.prop(scn.colprops_p[idx],'preset_name')
            #row = layout.row()
            #row.prop(scn.colprops_p[idx],'preset_description')
        except:
            pass

        # Ui List
        row = layout.row()
        row.template_list("Preset_UL_items", "", scene, "colprops_p", scene, "custom_index", rows=rows)

        # Side Buttons
        col = row.column(align=True)
        row = layout.row()
        #col.operator("cp.cp_piemenu_display", icon='SOLO_OFF', text="")
        col.operator("cp.cp_selectobjects", icon="RESTRICT_SELECT_OFF", text="")
        col.operator("cp.list_action", icon="X", text="").action = 'REMOVE'
        col.separator()
        col.operator("cp.list_action", icon='TRIA_UP', text="").action = 'UP'
        col.operator("cp.list_action", icon='TRIA_DOWN', text="").action = 'DOWN'
        col.separator()
        col.operator("cp.cp_clear_list", icon='TRASH', text="")

        # Action Mode
        #row = layout.row()
        row.prop(scn,'action_mode',expand=True)
        if scn.action_mode == 'a2':
            row = layout.row()
            #row = layout.row()
            row.prop(scn,'preset_scope')
        #row = layout.row()

        # Preset Actions
        row = layout.row()
        col = row.column(align=True)
        row = col.row(align=True) 

        split = col.split(align=True, factor=0.8)
  
        split.operator("cp.list_action", icon="ADD", text="Add Preset").action = 'ADD'  
        split.operator("cp.presetbyselection", icon="RESTRICT_SELECT_OFF", text="")
        split.operator("cp.overwritepreset", icon="FILE_REFRESH", text="")
        
        
        #row = col.row(align=True) 
        #row.operator("cp.cp_clear_list", icon='X', text="Clear all presets in the list")

        # Activate Presets 
        col.separator()
        if item:
            if item.preset_scope == 's1':
                row = col.row(align=True) 
                split = col.split(align=True, factor=0.8)
                split.scale_y = 1
                split.operator("cp.activate_preset", icon="VIS_SEL_11", text="Activate Preset")  
                split.operator("cp.showpresetobjects", icon="HIDE_OFF", text="").action = 'show' 
                split.operator("cp.showpresetobjects", icon="HIDE_ON", text="").action = 'hide'
            else:
                row = col.row(align=True) 
                split = col.split(align=True, factor=1)
                split.scale_y = 1
                split.operator("cp.activate_preset", icon="VIS_SEL_11", text="Activate Preset")  
        else:
            row = col.row(align=True) 
            split = col.split(align=True, factor=1)
            split.scale_y = 1
            split.operator("cp.activate_preset", icon="VIS_SEL_11", text="Activate Preset")  


        #if scn.colprops_p:
            #if scn.colprops_p[idx].preset_mode == 'a2':
               

class CPresets_MT_PIE_Menu(Menu):
    bl_idname = 'cpresets.pie_menu'
    bl_label = "Select Visibility Preset"
    

    def draw(self, context):
        
        layout = self.layout
        scn = context.scene.cpresets
        pie = layout.menu_pie()

        other = pie.column()
        gap = other.column()

        have_preset = False 

        ob_preset = False
        col_preset = False
        fav_preset = False

        for i in scn.colprops_p: 
            if i.preset_mode == 'a2':
                ob_preset = True
        
        if ob_preset:

            gap.scale_x = 1
            object_preset = other.box().column()
            object_preset.scale_y=1.2
            object_preset.scale_x=1

            object_preset.label(text='Object Presets:')
            
        
            max_pie = 0
        
            for i in scn.colprops_p:
    
                if i.preset_mode == 'a2':
                    have_preset = True            
                    prop = object_preset.operator("custom.select_items_pie", icon=i.preset_icon, text=i.preset_name)
                    prop.col_dict = i.col_dict
                    prop.preset_mode = i.preset_mode
                    prop.preset_scope = i.preset_scope
                    prop.preset_id = i.preset_id
                    max_pie += 1 

                    if max_pie >= max_menu: # Only if someway the user get more than 8 presets added to the pie 
                        break
 
        for i in scn.colprops_p: 
            if i.preset_mode == 'a1':
                col_preset = True
                
        
        if col_preset:

            other = pie.column()
            gap = other.column()

            gap.scale_x = 1
            collection_preset = other.box().column()
            collection_preset.scale_y=1.2
            collection_preset.scale_x=1

            collection_preset.label(text='Collection Presets:')

            max_pie = 0

            for i in scn.colprops_p:
           
                if i.preset_mode == 'a1':
                    have_preset = True            
                    prop = collection_preset.operator("custom.select_items_pie", icon=i.preset_icon, text=i.preset_name)
                    prop.col_dict = i.col_dict
                    prop.preset_mode = i.preset_mode
                    prop.preset_scope = i.preset_scope
                    prop.preset_id = i.preset_id
                    max_pie += 1 

                    if max_pie >= max_menu: # Only if someway the user get more than 8 presets added to the pie 
                        break

        for i in scn.colprops_p: 
            if i.preset_fav:
                fav_preset = True

        if fav_preset:
        
            other = pie.column()
            gap = other.column()

            gap.scale_x = 1
            favorite_preset = other.box().column()
            favorite_preset.scale_y=1.2
            favorite_preset.scale_x=1

            favorite_preset.label(text='Favorite Presets:')

            for i in scn.colprops_p:

                if i.preset_fav: # Show only favoreited presets 
    
                    have_preset = True            
                    prop = favorite_preset.operator("custom.select_items_pie", icon=i.preset_icon, text=i.preset_name)
                    prop.col_dict = i.col_dict
                    prop.preset_mode = i.preset_mode
                    prop.preset_scope = i.preset_scope
                    prop.preset_id = i.preset_id
                    max_pie += 1 

                    if max_pie >= max_menu: # Only if someway the user get more than 8 presets added to the pie 
                        break
                else:
                    continue
     
        if not have_preset:   # If that is no presets to show
            #pie.label(text="  No Presets Added to pie menu", icon='ERROR')
            other = pie.column()
            gap = other.column()

            gap.scale_x = 1
            no_preset = other.box().column()
            no_preset.scale_y=1.2
            no_preset.scale_x=1

            no_preset.label(text='No Presets Added to Pie Menu', icon="ERROR")


            


        

       
