import bpy
import ast

from ..utlity.addon import addon_name, get_prefs
from ..utlity.functions import add_default, select_default_preset, draw_update, update_preset, blender_version
from ..utlity.temp_variables import max_menu

from bpy.props import (IntProperty,
                       BoolProperty,
                       StringProperty,
                       CollectionProperty)

from bpy.types import (Operator,
                       Panel,
                       PropertyGroup,
                       UIList)



class ListAction_CP(Operator):
    """Add, Update, Move Up or Move Donw in list"""
    bl_idname = "cp.list_action"
    bl_label = "List Actions"
    bl_description = "Preset Manipulation"
    bl_options = {'REGISTER','UNDO'}

    action: bpy.props.EnumProperty(
        items=(
            ('UP', "Up", ""),
            ('DOWN', "Down", ""),
            ('REMOVE', "Remove", ""),
            ('ADD', "Add", ""),
            ('UPDATE', "update", "")))

    def invoke(self, context, event):

        scn = context.scene.cpresets
        idx = scn.custom_index

        prefs = get_prefs()


        try:
            item = scn.colprops_p[idx]
        except IndexError:
            pass

        action_mode = scn.action_mode

        # If Action is Move up Or Move Down

        if self.action == 'DOWN':

            if scn.custom_index < 0:
                self.report({'INFO'}, "Nothing selected in the list")
                return{'CANCELLED'}


            if not scn.colprops_p:
                self.report({'INFO'}, "Nothing selected in the list")
                return{'CANCELLED'}
            
            if scn.custom_index == (len(scn.colprops_p)-1):
                self.report({'INFO'}, "You cannot move this down")
                return{'CANCELLED'} 

            scn.colprops_p.move(idx, idx+1)
            scn.custom_index += 1

        elif self.action == 'UP':

            if scn.custom_index < 0:
                self.report({'INFO'}, "Nothing selected in the list")
                return{'CANCELLED'}

            if not scn.colprops_p:
                self.report({'INFO'}, "Nothing selected in the list")
                return{'CANCELLED'}

            if scn.custom_index == 0:
                self.report({'INFO'}, "You cannot move this up")
                return{'CANCELLED'}

            scn.colprops_p.move(idx, idx-1)
            scn.custom_index -= 1

        # Else, Make Action
        
        else:
          
            if self.action == 'ADD':

                dic = {}   # Empty List to get dictionary od properties

                if action_mode == 'a1':                     # if the preset mode is in collection mode  
                    preset_type = 'a1'
                    data_col = bpy.data.collections

                    for c in data_col:                        
                        dic[c.name] = {'render': c.hide_render, 'viewport':c.hide_viewport, 'select':c.hide_select }   # Getting Properties for Dictionary
                
                if action_mode == 'a2':           # if the preset moder is in objects mode
                    preset_type = 'a2'
                    data_col = bpy.data.objects

                    if scn.preset_scope == 's1':        # check if the information mode is simple
                        dic = list(dic)
                        for c in data_col:
                            if c.hide_get() == False:        # checking if is visible 
                                if c.visible_get() == True:    # checking if it  is enabled in the viewport                                   
                                    dic.append(c.name)           # after that, we have a list with objects that should be visible after activating the preset
            
                    if scn.preset_scope == 's2':
                        for c in data_col:                      
                            dic[c.name] = {'render': c.hide_render, 'viewport':c.hide_viewport, 'select':c.hide_select, 'viewlayer': c.hide_get()}
            
                dic = str(dic)  # Turning the Dict into a str because blender does not support dict porperties 

                add_default(prefs,scn,idx,preset_type)        
                
                col = scn.colprops_p.add()
                col.col_dict = dic

                #if scn.fav_presets < max_menu:  # Checking if theres more than 8 favorite presets added ##################################################################################
                #    col.preset_fav = True
                #    scn.fav_presets += 1  
                
                if action_mode == 'a2':
                    if scn.preset_scope == 's1':    # Visibility props information
                        col.preset_scope = 's1'  
                    if scn.preset_scope == 's2': 
                        col.preset_scope = 's2'

                if action_mode == 'a1':
                    col.preset_scope = 's2'
                        
                ex_names = []   

                for i_name in scn.colprops_p:
                    ex_names.append(i_name.preset_name)   # Getting existent names in the list
                
                new_name = 'Preset 1'
                new_num = 1

                while True:                                        # Creating new name basead on existent preset names
                    if new_name in ex_names:
                        new_num += 1
                        new_name = 'Preset ' + str(new_num)
                    else:
                        break

                # Adding the properties to the new list item that was added
                scn.preset_id += 1
                col.preset_name = new_name
                
                if action_mode == 'a1': 
                    if blender_version():
                        col.preset_icon = 'OUTLINER_COLLECTION'
                    else:
                        col.preset_icon = 'GROUP'

                if action_mode == 'a2': 
                    if col.preset_scope == 's1': 
                        col.preset_icon = 'MESH_CUBE'
                    if col.preset_scope == 's2': 
                        col.preset_icon = 'SNAP_VOLUME'
                    

                col.preset_name = new_name
                col.preset_mode = action_mode    # action mode, object or collections
                col.preset_description = ''
                col.preset_id = scn.preset_id 

                scn.last_preset = col.preset_id

                # Changing the active item in the list

                scn.custom_index = len(scn['colprops_p'])-1

                self.report({'INFO'}, "Preset Added to Preset list")
                return{'FINISHED'}
                          
            if self.action == 'REMOVE':

                if not scn.custom_index >= 0:
                    self.report({'INFO'}, "Nothing selected in the list")
                    return{'CANCELLED'}

                if scn.colprops_p:

                    if not scn.custom_index == 0:

                        try:
                            if scn.colprops_p[idx]['preset_fav'] == True:
                                scn.fav_presets -= 1
                        except:
                            pass
                        
                        scn.custom_index -= 1
                        scn.colprops_p.remove(idx)

                    else:

                        try:
                            if scn.colprops_p[idx]['preset_fav'] == True:
                                scn.fav_presets -= 1
                        except:
                            pass

                        #scn.custom_index -= 1
                        scn.colprops_p.remove(idx)


                else:
                    self.report({'INFO'}, "Nothing selected in the list")
                    return{'CANCELLED'}

                   
        return {"FINISHED"}

class Activate_Preset_CP(Operator):
    """Activate Preset"""
    bl_idname = "cp.activate_preset"
    bl_label = "Activate Preset"
    bl_description = "Activate Preset"
    bl_options = {'REGISTER', 'UNDO'}

    @classmethod
    def poll(cls, context):
        if bpy.context.mode == 'OBJECT':
            return  True
          

    def execute(self, context):
        scn = context.scene.cpresets
        idx = scn.custom_index

        prefs = get_prefs()

        try:
            item = scn.colprops_p[idx]
        except IndexError:
            self.report({'INFO'}, "Nothing selected in the list")
            return{'CANCELLED'}
        
        if item.preset_scope != 'aa' and item.preset_scope != 'bb':   
            scn.last_preset = item.preset_id
        
        action_mode = scn.action_mode

        if select_default_preset(item.preset_scope): # uses the function in the function file
    
            return{'FINISHED'}

        if item.preset_scope == 's1':

            new_list = item.col_dict.strip('][').split(', ')  # turning the string list into true string

        
            bpy.ops.object.select_all(action='DESELECT')  # deselecting all objects
            bpy.ops.object.hide_view_set(unselected=True)  # hiding unselected objects (all)
     
            for ob_uh in new_list:     # getting itens in the new list 

                ob_uh = ob_uh[1:-1]   # after the converting, it was necessary to remove the ' in the star, and in the end of each string

                try:
                        bpy.data.objects[ob_uh].hide_set(False)   # after turning all objects off, now turning on, only objects in the new list
                except:
                    pass
                   
            return{'FINISHED'}


        
        if item.preset_scope == 's2': # if is heavy mode

            new_dict = ast.literal_eval(item.col_dict)  # turning the string into a dictionary
            action_mode = scn.action_mode # getting the action mode (object or collection)

            if action_mode == 'a1':   # if collection mode 
                for col in new_dict: 
                    try:              
                        bpy.data.collections[col].hide_render = new_dict[col]['render']
                        bpy.data.collections[col].hide_select = new_dict[col]['select']
                        bpy.data.collections[col].hide_viewport = new_dict[col]['viewport']
                    except:
                        pass

            
            
            if action_mode == 'a2':

                if prefs.Hide_new_objects:

                    for ob in bpy.data.objects:
                        try:
                            bpy.data.objects[ob.name].hide_set(True) 
                        except:
                            pass

                for col in new_dict:
                    try:
                    
                        bpy.data.objects[col].hide_render = new_dict[col]['render']
                        bpy.data.objects[col].hide_select = new_dict[col]['select']
                        bpy.data.objects[col].hide_viewport = new_dict[col]['viewport']
                        bpy.data.objects[col].hide_set(new_dict[col]['viewlayer']) 
                    except:
                        pass


            return{'FINISHED'}

class Activate_Preset_Pie_Menu_CP(Operator):
    """Activate Selected Preset"""
    bl_idname = "custom.select_items_pie"
    bl_label = "Activate Selected Preset"
    bl_description = "Set Presets in Pie"
    bl_options = {'REGISTER', 'UNDO'}

    col_dict: StringProperty() 
    preset_mode: StringProperty()
    preset_scope: StringProperty()
    preset_id: IntProperty()

    @classmethod
    def poll(cls, context):
        if bpy.context.mode == 'OBJECT':
            return  True
        
    
    def execute(self, context):

        prefs = get_prefs()
        scn = context.scene.cpresets

        # Getting the information need in the end of the property, after the dictionary

        str_dict = self.col_dict  # dictionary    
        preset_mode = self.preset_mode  # preset mode
        scope_mode = self.preset_scope # visibility props

        if scope_mode != 'aa' and scope_mode != 'bb':    
            scn.last_preset = self.preset_id



        if select_default_preset(scope_mode):

            return{'FINISHED'}  

        if preset_mode == 'a1':

            new_dict = ast.literal_eval(str_dict)

            for col in new_dict: 

                try:              
                    bpy.data.collections[col].hide_render = new_dict[col]['render']
                    bpy.data.collections[col].hide_select = new_dict[col]['select']
                    bpy.data.collections[col].hide_viewport = new_dict[col]['viewport']
                except:
                    pass

            return{'FINISHED'}    

        if preset_mode == 'a2':

            if scope_mode == 's1':

                new_list = str_dict.strip('][').split(', ') 

                for ob_h in bpy.data.objects:
                    try:
                            bpy.data.objects[ob_h.name].hide_set(True) 
                    except:
                        pass

                bpy.ops.object.select_all(action='DESELECT')
                bpy.ops.object.hide_view_set(unselected=True)

                
                for ob_uh in new_list:

                    ob_uh = ob_uh[1:-1]

                    try:
                            bpy.data.objects[ob_uh].hide_set(False) 
                    except:
                        pass
                    
                return{'FINISHED'}

        
            if scope_mode == 's2':

                new_dict = ast.literal_eval(str_dict)

                if prefs.Hide_new_objects:

                    for ob in bpy.data.objects:              
                        try:
                            bpy.data.objects[ob.name].hide_set(True) 
                        except:
                            pass

                for col in new_dict:
                    try:               
                        bpy.data.objects[col].hide_render = new_dict[col]['render']
                        bpy.data.objects[col].hide_select = new_dict[col]['select']
                        bpy.data.objects[col].hide_viewport = new_dict[col]['viewport']
                        bpy.data.objects[col].hide_set(new_dict[col]['viewlayer']) 
                    except:
                        pass

                return{'FINISHED'}

class Add_Item_Cpreset(bpy.types.Operator):  # it was necessary to create another class to add presets because this one should pop up a window

    bl_idname = "cp.add_item"
    bl_label = "Preset Action"
    bl_options = {'REGISTER','UNDO'}

    action_preset: bpy.props.EnumProperty(
        items=(
            ('ap1', "New Preset", ""),
            ('ap2', "Update Active Preset", ""),   

            ))

    Preset_Name: bpy.props.StringProperty()

    preset_method: bpy.props.EnumProperty(
        items=(
            ('m1', "Objects in View", ""),
            ('m2', "Seleted Objects", ""),
            
            ))

    update_method: bpy.props.EnumProperty(
        items=(
            ('m1', "Add Selected Objects", "This option will add all selected objects to the selected preset (Works only in simple object presets)"),
            ('m2', "Overwrite Preset", "This option will overwrite the selected preset with a new one based on the selected options"),       
            ))

    add_method: bpy.props.EnumProperty(
        items=(
            ('s1', "Selected Objects", "This option will add all selected objects to the selected preset (Works only in simple object presets)"),
            ('s2', "Objects in View", "This option will add all objects in the view to the selected preset (Works only in simple object presets)"),       
            ))

    pie:bpy.props.BoolProperty()
    

    @classmethod
    def poll(cls, context):
        return True

    def execute(self, context):

        scn = context.scene.cpresets
        idx = scn.custom_index

        prefs = get_prefs()

        self.pie = True
        
        if not self.pie:   
            try:
                item = scn.colprops_p[idx]
            except IndexError:
                pass

        else:
            for p in scn.colprops_p:
                if p.preset_id == scn.last_preset:
                    item = p
                    break
                else:
                    try:
                        item = scn.colprops_p[idx]
                    except:
                        self.report({'INFO'}, "No Active Preset in the Preset List")
                        return {'FINISHED'}

        if self.action_preset == 'ap2':
            if scn.colprops_p:
                if scn.custom_index < 0:
                    self.report({'WARNING'}, "No Active Preset in the Preset list")
                    return{'CANCELLED'}

                if item.preset_scope != 's1':
                    self.report({'WARNING'}, "You cannot update this preset in the pie menu")
                    return{'CANCELLED'}
            else:
                self.report({'WARNING'}, "No Active Preset in the Preset List")
                return{'CANCELLED'}

        if self.action_preset == 'ap1':

            if self.Preset_Name == "":
                self.report({'WARNING'}, "Invalid Preset Name")
                return{'CANCELLED'}

            dic = {}   # Empty List to get dictionary od properties
            data_col = bpy.data.objects


            if self.preset_method == 'm1':

                dic = list(dic)
                for c in data_col:
                    if c.hide_get() == False: 
                        if c.visible_get() == True:                                     
                            dic.append(c.name)
            
            if self.preset_method == 'm2':

                dic = list(dic)
                for c in data_col:
                    if c.select_get() == True: 
                        if c.visible_get() == True:                                     
                            dic.append(c.name)


            dic = str(dic)  # Turning the Dict into a str because blender does not support dict porperties 
            add_default(prefs,scn,idx,"a2")      
            col = scn.colprops_p.add()

            col.col_dict = dic      
            col.preset_scope = 's1' 

            #if scn.fav_presets < max_menu:  # Checking if theres more than 8 favorite presets added ##############################################
            #   col.preset_fav = True
            #    scn.fav_presets += 1  
                
            ex_names = []   

            for i_name in scn.colprops_p:
                ex_names.append(i_name.preset_name)   # Getting existent names in the list
            
            new_name = 'Preset 1'
            new_num = 1

            while True:                                        # Creating new name basead on existent preset names
                if new_name in ex_names:
                    new_num += 1
                    new_name = 'Preset ' + str(new_num)
                else:
                    break

            # Adding the properties to the new list item that was added
        
            col.preset_icon = 'MESH_CUBE'
            col.preset_name = self.Preset_Name
            col.preset_mode = 'a2'
            col.preset_description = ''
            scn.preset_id += 1
            col.preset_id = scn.preset_id 

            scn.last_preset = col.preset_id

            # Changing the active item in the list

            scn.custom_index = len(bpy.context.scene.cpresets['colprops_p'])-1

            self.report({'INFO'}, "Preset Added to Preset list")

            return {'FINISHED'}
        
        if self.action_preset == 'ap2' and item.preset_scope == 's1':

            update_preset(self, context)

            return {'FINISHED'}


    def invoke(self, context, event):
        return context.window_manager.invoke_props_dialog(self)

    def draw(self, context):
        
        scn = context.scene.cpresets
        idx = scn.custom_index

        self.pie = True
        
        if not self.pie:   
            try:
                item = scn.colprops_p[idx]
            except IndexError:
                pass

        else:
            for p in scn.colprops_p:
                if p.preset_id == scn.last_preset:
                    item = p
                    break
                else:
                    try:
                        item = scn.colprops_p[idx]
                    except:
                        self.report({'INFO'}, "No Active Preset in the Preset List")
                        return {'FINISHED'}
          
        layout = self.layout
        row = layout.row()
        row.prop(self,"action_preset", expand=True)
 
        if self.action_preset == 'ap1':
            row = layout.row()
            row.label(text="New Preset Method:")
            row = layout.row()
            row.prop(self,"preset_method", text="Update Preset", expand=True)
            row = layout.row()
            row = layout.row()
            #row.operator("cp.overwritepreset", text="",icon="FILE_REFRESH")
            row.prop(self, "Preset_Name", text="Preset Name")
            row = layout.row()
        
        if scn.colprops_p and scn.custom_index >= 0:
        
            if self.action_preset == 'ap2' and item.preset_scope == 's1':

                self.pie = True

                draw_update(self, context)

            if self.action_preset == 'ap2' and item.preset_scope != 's1':
                row = layout.row()
                row.label(text="You cannot update this type of preset in the pie menu:")

                box = layout.box()
                box.label(text=item.preset_name, icon=item.preset_icon)
        else:
            if self.action_preset == 'ap2':
                row = layout.row()
                row.label(text="No Active Preset in the Preset List")

class Cpresets_OT_clearList(Operator):

    """Clear all presets in the list"""
    bl_idname = "cp.cp_clear_list"
    bl_label = "Clear List"
    bl_description = "Clear all presets in the list"
    bl_options = {'INTERNAL'}

    @classmethod
    def poll(cls, context):
        return bool(context.scene.cpresets.colprops_p)

    def invoke(self, context, event):
        return context.window_manager.invoke_confirm(self, event)

    def execute(self, context):
        scn = context.scene.cpresets

        if bool(context.scene.cpresets):
            scn.colprops_p.clear()
            scn.fav_presets = 0
            self.report({'INFO'}, "All items removed")
        else:
            self.report({'INFO'}, "Nothing to remove")
        return{'FINISHED'}

class Cpresets_OT_ToggleFavorite(Operator):
    """Toggle Pie Menu Display"""
    bl_idname = "cp.cp_piemenu_display"
    bl_label = "Toggle Pie Menu Display"
    bl_description = "When Pie Menu Display is enabled, the preset will be easily acessible through the presets pie menu, you can acess by pressing the presets pie menu shortcut (the default shortcut is ctr + shift + D)"
    bl_options = {'INTERNAL'}

    def execute(self, context):
        scn = context.scene.cpresets
        idx = scn.custom_index

        try:
            item = scn.colprops_p[idx]
        except IndexError:
            pass

        if scn.colprops_p:
            if item.preset_fav == True:
                scn.fav_presets -= 1
                item.preset_fav = False
            else:
                if scn.fav_presets < max_menu: #####################################################
                    scn.fav_presets += 1
                    item.preset_fav = True
                else:
                    self.report({'INFO'}, "Cannot add to the pie menu more than 8 Presets")
                    return{'CANCELLED'}

        else:
            self.report({'INFO'}, "Nothing selected in the list")
            return{'CANCELLED'}


        return{'FINISHED'}

class Cpresets_OT_SelectObjects(Operator):
    """Select Preset Objects"""
    bl_idname = "cp.cp_selectobjects"
    bl_label = "Select Objects"
    bl_description = "Select objects in this preset"
    bl_options = {'INTERNAL'}

 
    def execute(self, context):
        scn = context.scene.cpresets
        idx = scn.custom_index

        if scn.colprops_p:

            try:
                item = scn.colprops_p[idx]
            except IndexError:
                pass

            if item.preset_mode == 'a1':

                self.report({'INFO'}, "You cannot use this option with collections presets")
                return{'FINISHED'}

            if item.preset_scope == 'aa':

                self.report({'INFO'}, "You cannot use this option with the default preset")
                return{'FINISHED'}

            # Start Operator

            if item.preset_mode == 'a2':

                if item.preset_scope == 's1':

                    new_list = (item.col_dict).strip('][').split(', ')

                    for i in new_list:

                        list_i = i[1:-1]

                        try:
                            bpy.data.objects[list_i].select_set(True)
                        except:
                            pass

                if item.preset_scope == 's2':

                    new_dict = ast.literal_eval(item.col_dict)

                    for i in new_dict:

                        try:
                            bpy.data.objects[i].select_set(True)
                        except:
                            pass

            return{'FINISHED'}
            
        else:
            self.report({'INFO'}, "Nothing selected in the list")
            return{'CANCELLED'}

class Hide_Show_Preset_OT_CP(Operator):

    bl_idname = "cp.showpresetobjects"
    bl_label = "Show/Hide Preset Objects"
    bl_description = "Show/Hide Preset Objects"
    bl_options = {'REGISTER','UNDO'}

    action: bpy.props.EnumProperty(
        items=(
            ('show', "show", ""),
            ('hide', "hide", ""),
            ))

    def invoke(self, context, event):

        scn = context.scene.cpresets
        idx = scn.custom_index

        #prefs = get_prefs()


        try:
            item = scn.colprops_p[idx]
        except IndexError:
            pass

        if scn.colprops_p:
            if item.preset_mode == 'a2':
                if item.preset_scope == 's1':

                    ob_list = item.col_dict.strip('][').split(', ')

                    if self.action == 'show':
                        for o in ob_list:
                            o = o[1:-1]
                            bpy.data.objects[o].hide_set(False)
                    if self.action == 'hide':
                        for o in ob_list:
                            o = o[1:-1]
                            bpy.data.objects[o].hide_set(True)
                        
                elif item.preset_scope == 's2':

                    ob_list = ast.literal_eval(item.col_dict)

                    if self.action == 'show':
                        for o in ob_list:
   
                            bpy.data.objects[o].hide_set(False)
                    if self.action == 'hide':
                        for o in ob_list:
                            bpy.data.objects[o].hide_set(True)
                
                else:
                    self.report({'INFO'}, "You cannot use this action with this preset")
                    return{'CANCELLED'}

            else:
                self.report({'INFO'}, "This action only works with object presets")
                return{'CANCELLED'}
       
        else:
            self.report({'INFO'}, "Nothing selected in the list")
            return{'CANCELLED'}
        
        return{'FINISHED'}

class PresetBySelection_CP(Operator):
    """Create a new Object Preset with selected Objects"""
    bl_idname = "cp.presetbyselection"
    bl_label = "Selection Preset"
    bl_description = "Create a new Object Preset with selected Objects"
    bl_options = {'REGISTER','UNDO'}

    def invoke(self, context, event):

        if len(bpy.context.selected_objects) > 0:
            pass
        else:
            self.report({'INFO'}, "No Objects Selected")
            return{'CANCELLED'}


        scn = context.scene.cpresets
        idx = scn.custom_index

        prefs = get_prefs()


        try:
            item = scn.colprops_p[idx]
        except IndexError:
            pass

 
        data_col = bpy.data.objects
        dic = {} 

        dic = list(dic)
        for c in data_col:
            if c.select_get() == True:        # checking if is visible 
                if c.visible_get() == True:    # checking if it  is enabled in the viewport                                   
                    dic.append(c.name)           # after that, we have a list with objects that should be visible after activating the preset
    
        dic = str(dic)  # Turning the Dict into a str because blender does not support dict porperties 

        add_default(prefs,scn,idx,"a2")        
        
        col = scn.colprops_p.add()
        col.col_dict = dic

        #if scn.fav_presets < max_menu:  # Checking if theres more than 8 favorite presets added ##################################################################################
        #    col.preset_fav = True
        #    scn.fav_presets += 1  
        
 
        col.preset_scope = 's1'  
                    
        ex_names = []   

        for i_name in scn.colprops_p:
            ex_names.append(i_name.preset_name)   # Getting existent names in the list
        
        new_name = 'Preset 1'
        new_num = 1

        while True:                                        # Creating new name basead on existent preset names
            if new_name in ex_names:
                new_num += 1
                new_name = 'Preset ' + str(new_num)
            else:
                break

        # Adding the properties to the new list item that was added
    
        col.preset_name = new_name
        
        col.preset_icon = 'MESH_CUBE'

        col.preset_name = new_name
        col.preset_mode = 'a2'    # action mode, object or collections
        col.preset_description = ''

        scn.preset_id += 1 
        col.preset_id = scn.preset_id

        scn.last_preset = col.preset_id

        # Changing the active item in the list

        scn.custom_index = len(scn['colprops_p'])-1

        self.report({'INFO'}, "Preset Added to Preset list")
        return{'FINISHED'}

class OverwritePreset_CP(Operator):
    """Overwrite Selected Preset"""
    bl_idname = "cp.overwritepreset"
    bl_label = "Update Preset"
    bl_description = "Update Selected Preset"
    bl_options = {'REGISTER','UNDO'}

    update_method: bpy.props.EnumProperty(
        items=(
            ('m1', "Add Selected Objects", "This option will add all selected objects to the selected preset (Works only in simple object presets)"),
            ('m2', "Overwrite Preset", "This option will overwrite the selected preset with a new one based on the selected options"),       
            ))

    add_method: bpy.props.EnumProperty(
        items=(
            ('s1', "Selected Objects", "This option will add all selected objects to the selected preset (Works only in simple object presets)"),
            ('s2', "Objects in View", "This option will add all objects in the view to the selected preset (Works only in simple object presets)"),       
            ))

    pie: bpy.props.BoolProperty()

    @classmethod
    def poll(cls, context):
        return True

    def execute(self, context):

        self.pie = False

        update_preset(self, context)

        return{'FINISHED'}

    def invoke(self, context, event):
        return context.window_manager.invoke_props_dialog(self)

    def draw(self, context):

        draw_update(self, context)
    