# add default preset
import bpy
import copy

# Add a default preset 

def add_default(prefs,scn,idx,preset_type):

    if scn.colprops_p: 

        last_idx = len(scn['colprops_p']) 
    else:

        last_idx = 0


    if preset_type == 'a2':

        if prefs.add_default_preset:

            if prefs.default_preset_scope == 's1':

                have_obj = False

                try:
                    for i in scn.colprops_p:
                        if i.preset_mode:
                            if i.preset_mode == 'a2':
                                have_obj = True
                    
                    if not have_obj:

                        coll = scn.colprops_p.add()
                        coll.preset_scope = 'aa'
                        coll.preset_name = 'Show All Objects'
                        coll.preset_mode = 'a2'
                        coll.preset_description = ''
                        coll.preset_icon = 'SCENE_DATA'
                        coll.col_dict = ''
                        coll.preset_fav = True                  
                        scn.fav_presets += 1 
                        scn.colprops_p.move(last_idx, 0)

                        scn.preset_id += 1
                        coll.preset_id = scn.preset_id
                        #coll.last_preset = coll.preset_id
                except:

                    coll = scn.colprops_p.add()
                    coll.preset_scope = 'cc'
                    coll.preset_name = 'Show All Objects'
                    coll.preset_mode = 'a2'
                    coll.preset_description = ''
                    coll.preset_icon = 'SCENE_DATA'
                    coll.col_dict = ''
                    coll.preset_fav = True                  
                    scn.fav_presets += 1 
                    scn.colprops_p.move(last_idx, 0)

                    scn.preset_id += 1
                    coll.preset_id = scn.preset_id

                    #coll.last_preset = coll.preset_id
            
            if prefs.default_preset_scope == 's2':

                have_obj = False

                try:
                    for i in scn.colprops_p:
                        if i.preset_mode:
                            if i.preset_mode == 'a2':
                                have_obj = True
                    
                    if not have_obj:

                        coll = scn.colprops_p.add()

                        coll.preset_scope = 'cc'
                        coll.preset_name = 'Show All Objects'
                        coll.preset_mode = 'a2'
                        coll.preset_description = ''
                        coll.preset_icon = 'SCENE_DATA'
                        coll.col_dict = ''
                        coll.preset_fav = True                  
                        scn.fav_presets += 1 
                        scn.colprops_p.move(last_idx, 0)

                        scn.preset_id += 1
                        coll.preset_id = scn.preset_id
                        #coll.last_preset = coll.preset_id
                except:

                    coll = scn.colprops_p.add()

                    coll.preset_scope = 'cc'
                    coll.preset_name = 'Show All Objects'
                    coll.preset_mode = 'a2'
                    coll.preset_description = ''
                    coll.preset_icon = 'SCENE_DATA'
                    coll.col_dict = ''
                    coll.preset_fav = True                  
                    scn.fav_presets += 1 
                    scn.colprops_p.move(last_idx, 0)

                    scn.preset_id += 1
                    coll.preset_id = scn.preset_id
                    #coll.last_preset = coll.preset_id
              
    if preset_type == 'a1':

        if prefs.add_default_preset_col:

            have_col = False

            try:
                for i in scn.colprops_p:
                    if i.preset_mode:
                        if i.preset_mode == 'a1':
                            have_col = True
                
                if not have_col:

                    coll = scn.colprops_p.add()

                    coll.preset_scope = 'bb'
                    coll.preset_name = 'Enable All Collections'
                    coll.preset_mode = 'a1'
                    coll.preset_description = ''
                    coll.preset_icon = 'SCENE_DATA'
                    coll.col_dict = ''
                    coll.preset_fav = True                  
                    scn.fav_presets += 1 
                    scn.colprops_p.move(last_idx, 0)

                    scn.preset_id += 1
                    coll.preset_id = scn.preset_id
                    #coll.last_preset = coll.preset_id
            except:

                coll = scn.colprops_p.add()

                coll.preset_scope = 'bb'
                coll.preset_name = 'Enable All Collections'
                coll.preset_mode = 'a1'
                coll.preset_description = ''
                coll.preset_icon = 'SCENE_DATA'
                coll.col_dict = ''
                coll.preset_fav = True                  
                scn.fav_presets += 1 
                scn.colprops_p.move(last_idx, 0)

                scn.preset_id += 1
                coll.preset_id = scn.preset_id
                #coll.last_preset = coll.preset_id

def select_default_preset(preset_scope):

    if preset_scope == 'aa': # AA is a object default preset, setted to simple scope

        bpy.ops.object.hide_view_clear()

        return True
        
    if preset_scope == 'bb': # bb is a default collection preset

        for col in bpy.data.collections:
            
            bpy.data.collections[col.name].hide_render = False
            bpy.data.collections[col.name].hide_select = False
            bpy.data.collections[col.name].hide_viewport = False

        return True
    
    if preset_scope == 'cc': # bb is a object default preset, setted to complete scope

        for col in bpy.data.objects:
            
            bpy.data.objects[col.name].hide_render = False
            bpy.data.objects[col.name].hide_select = False
            bpy.data.objects[col.name].hide_viewport = False
            bpy.data.objects[col.name].hide_set(False)

        return True

def draw_update(self, context):

    scn = context.scene.cpresets
    idx = scn.custom_index

    layout = self.layout
    row = layout.row()

    #obs = bpy.context.selected_objects 

    if scn.colprops_p:
        if scn.custom_index >= 0:

            if not self.pie: 
                
                try:
                    item = scn.colprops_p[idx]
                except IndexError:
                    pass

            else:

                for p in scn.colprops_p:
                    if p.preset_id == scn.last_preset:
                        item = p
                        break
                    else:
                        try:
                            item = scn.colprops_p[idx]
                        except:
                            self.report({'INFO'}, "No Active Preset in the Preset List")
                            return {'FINISHED'}

            icon_s = item.preset_icon
                
            if item.preset_scope == 's1': 

                if self.pie == False:

                    row.label(text="Update Method:")
                    row = layout.row()

                    row.prop(self,"update_method", text="Update Method:", expand=True)
                    row = layout.row()
                else:
                    self.update_method == 'm1'

                if self.update_method == 'm2':
                    row.label(text="You are about to overwrite the settings of this preset:")
                    box=layout.box()
                    box.label(text=item.preset_name, icon=icon_s)

                if self.update_method == 'm1':
                    row = layout.row()
                    row.label(text="Objects to add:")
                    row = layout.row()
                    row.prop(self,"add_method", text="Objects to add:", expand=True)
                    row = layout.row()


                    if self.add_method == 's1':
                        obs = bpy.context.selected_objects 

                        if len(obs) == 1: 
                            row.label(text=f"You are about to add {len(obs)} object to this preset:")

                        elif len(obs) < 1:
                            row.label(text="No Selected Objects.")
                            row = layout.row()
                            row.label(text="No Objects will be added to this preset:")

                        else:
                            row.label(text=f"You are about to add {len(obs)} objects to this preset:")

                    if self.add_method == 's2':
                        obs =[ob for ob in bpy.context.view_layer.objects if ob.visible_get()]

                        if len(obs) == 1: 
                            row.label(text=f"You are about to add {len(obs)} object to this preset:")
                        else:
                            row.label(text=f"You are about to add {len(obs)} objects to this preset:")
            
                    box=layout.box()
                    box.label(text=item.preset_name, icon=icon_s)

            else:
                row.label(text="You are about to overwrite the settings of this preset:")
                box=layout.box()
                box.label(text=item.preset_name, icon=icon_s)
        else:
            row.label(text="Nothing selected in the list")

    else:
      
        row.label(text="No Presets in the list")

def update_preset(self, context):

    scn = context.scene.cpresets
    idx = scn.custom_index

    if not scn.colprops_p:
        self.report({'INFO'}, "No Presets in the list")
        return{'CANCELLED'}
    
    if not scn.custom_index >= 0:
        self.report({'INFO'}, "Nothing Selected in the list")
        return{'CANCELLED'}

    if not self.pie:
    
        try:
            item = scn.colprops_p[idx]
        except IndexError:
            pass

    else:
        for p in scn.colprops_p:
            if p.preset_id == scn.last_preset:
                item = p
                break
            else:
                try:
                    item = scn.colprops_p[idx]
                except:
                    self.report({'INFO'}, "No Active Preset in the Preset List")
                    return {'FINISHED'}

    update_method = self.update_method
    add_method = self.add_method

    if scn.colprops_p[idx]['preset_scope'] == 'aa' or scn.colprops_p[idx]['preset_scope'] == 'bb':
        self.report({'INFO'}, "You cannot update a default preset")
        return{'FINISHED'}

    #if item.preset_scope == 's1': 
    #    update_method = 'm1'
    if item.preset_scope == 's2':
        update_method = 'm2'

    if update_method == 'm2':
        

        action_mode = scn.action_mode

        if scn.colprops_p: 

            idx = scn.custom_index                              
            replace_n = scn.colprops_p[idx]['preset_name']                    # getting information of previsious props of the preset
            replace_d = scn.colprops_p[idx]['preset_description']
            replace_id = scn.colprops_p[idx]['preset_id']

            try:
                replace_fav = scn.colprops_p[idx]['preset_fav']
            except:
                replace_fav = False

            scn.custom_index -= 1
            scn.colprops_p.remove(idx)

            dic = {}   # Empty List to get dictionary od properties

            if action_mode == 'a1':  
                data_col = bpy.data.collections

                for c in data_col:                        
                    dic[c.name] = {'render': c.hide_render, 'viewport':c.hide_viewport, 'select':c.hide_select }   # Getting Properties for Dictionary
            
            if action_mode == 'a2':

                data_col = bpy.data.objects

                if scn.preset_scope == 's1':
                    dic = list(dic)
                    for c in data_col:
                        if c.hide_get() == False: 
                            if c.visible_get() == True:                                     
                                dic.append(c.name)
        
                if scn.preset_scope == 's2':
                    for c in data_col:                      
                        dic[c.name] = {'render': c.hide_render, 'viewport':c.hide_viewport, 'select':c.hide_select, 'viewlayer': c.hide_get()}
        
            dic = str(dic)  # Turning the Dict into a str because blender does not support dict porperties 
            
            col = scn.colprops_p.add()
            col.col_dict = dic

            if action_mode == 'a2':
                if scn.preset_scope == 's1':   
                    col.preset_scope = 's1'  
                if scn.preset_scope == 's2': 
                    col.preset_scope = 's2'
                
            if action_mode == 'a1':
                col.preset_scope = 's2'

            new_name = replace_n

            if action_mode == 'a1': 
                if blender_version():
                        col.preset_icon = 'OUTLINER_COLLECTION'
                else:
                    col.preset_icon = 'GROUP'

            if action_mode == 'a2': 
                if col.preset_scope == 's1': 
                    col.preset_icon = 'MESH_CUBE'
                if col.preset_scope == 's2': 
                    col.preset_icon = 'SNAP_VOLUME'

            col.preset_name = new_name
            col.preset_mode = action_mode
            col.preset_description = replace_d
            col.preset_id = replace_id
            scn.custom_index = idx

            scn.last_preset = col.preset_id
           
            col.preset_fav = replace_fav

            scn.colprops_p.move(len(scn['colprops_p'])-1, idx)
            
            self.report({'INFO'}, "Collection Updated")
            return{'FINISHED'}
        
        else:
            self.report({'INFO'}, "Nothing selected in the list")
        return{'CANCELLED'}
    
    if update_method == 'm1':
        if add_method == 's1':

            s_objects = bpy.context.selected_objects

            new_obs = []

            for ob in s_objects:
                new_obs.append(ob.name)

            old_list = item.col_dict.strip('][').split(', ')

            new_list = [i[1:-1] for i in old_list]
            
            for ob in new_obs:
                if not ob in new_list:
                    new_list.append(ob)
            
            item.col_dict = str(new_list)         

            return{'FINISHED'}

        if add_method == 's2':

            s_objects = [ob for ob in bpy.context.view_layer.objects if ob.visible_get()]

            new_obs = []

            for ob in s_objects:
                new_obs.append(ob.name)

            old_list = item.col_dict.strip('][').split(', ')

            new_list = [i[1:-1] for i in old_list]
            
            for ob in new_obs:
                if not ob in new_list:
                    new_list.append(ob)
            
            item.col_dict = str(new_list)         

            return{'FINISHED'}



    

  

    #item.preset_name = 'uw'

def blender_version():
    if bpy.app.version >= (2, 91, 0):
        print("Maior")
        return True
    else:
        return False 