vec2 pcss(vec3 position, vec3 noise, float bias){
    atmosphere_constant ac = atmosphere_s();
    shadow_settings s = shadow_s();

    float angle = (sunAngle < 0.5 ? ac.sun_angular_radius : ac.moon_angular_radius) * 7.0;
    float max_radius = (24.0 * abs(shadowProjectionInverse[2].z)) * tan(angle) * shadowProjection[0].x; 
    float max_spread = min(0.5 * shadowProjection[0].x, max_radius);

    vec2 blocker_depth = vec2(0.0);

    for(int i = 0; i < s.steps1; i++){
        vec2 offset = sample_disk(i, noise.x, s.steps1);

        vec3 shadow_position = vec3(offset, -bias) * max_spread + position;
             shadow_position = shadow_distortion(s, shadow_position) * 0.5 + 0.5;
             shadow_position -= bias;

        float depth0 = texture2(shadowtex0, shadow_position.xy).x;
        float depth1 = texture2(shadowtex1, shadow_position.xy).x;

        blocker_depth.x = max(blocker_depth.x, shadow_position.z - depth0);
        blocker_depth.y = max(blocker_depth.y, shadow_position.z - depth1);
    }

    return min(blocker_depth * angle , vec2(max_spread));
}