#if defined SHADERS_VERTEX
    out vec2 vertex_coord;

    void main(){
        vertex_coord = layout_texcoord.xy;
        gl_Position = vec4(layout_position.xy * 2.0 - 1.0, 0.0, 1.0);
    }
#elif defined SHADERS_FRAGMENT
    in vec2 vertex_coord;

    /* RENDERTARGETS:0,1,2 */
    layout (location = 0) out vec3 buffers0;
    layout (location = 1) out vec3 buffers1;
    layout (location = 2) out vec3 buffers2;

    #include "/program/shaders1/common/atmosphere/atmosphere.glsl"

    void main(){
        #if defined END_WORLD
            discard;
        #endif

        const float lod = ATMOSPHERE_LOD;

        vec2 coord = vertex_coord * lod;
        vec2 tile = (min(floor(texel.x * 0.5) / 1.5, floor(texel.y * 0.5)) * exp2(-lod)) * vec2(3.0, 2.0);

        if(saturate(coord) == coord){
            gbuffers g = gbuffers_data(coord);
            space_position sp = position(coord, g.depth, false);     

            vec3 transmittance = vec3(1.0);
            vec3 scattering = atmospheric_scattering(sp.inverse_vector1, sp.sun_vector, sp.moon_vector, 16, transmittance);

            buffers0 = scattering;
        }

        if(gl_FragCoord.x < tile.x && gl_FragCoord.y < tile.y){
            gbuffers g = gbuffers_data(gl_FragCoord.xy * inverse_texel);
            space_position sp = position(gl_FragCoord.xy * inverse_texel, g.depth, false);

            vec3 position = unproject_sphere(gl_FragCoord.xy * inverse_texel);
                 position = normalize(position);

            vec3 transmittance = vec3(1.0);
            vec3 scattering = atmospheric_scattering(position, sp.sun_vector, sp.moon_vector, 16, transmittance);

            buffers1 = scattering;
            buffers2 = transmittance;
        }

        buffers0 = saturate_16(buffers0);
        buffers1 = saturate_16(buffers1);
        buffers2 = saturate_16(buffers2);
    }
#endif