const bool colortex10MipmapEnabled = true;
const bool colortex11MipmapEnabled = true;

#if defined SHADERS_VERTEX
    out vec2 vertex_coord;

    void main(){
        vertex_coord = layout_texcoord.xy;
        gl_Position = vec4(layout_position.xy * 2.0 - 1.0, 0.0, 1.0);
    }
#elif defined SHADERS_FRAGMENT
    in vec2 vertex_coord;

    /* RENDERTARGETS:11,15 */
    layout (location = 0) out vec4 buffers0;
    layout (location = 1) out vec4 buffers1;

    float remap(float value, float old_low, float old_high, float new_low, float new_high) {
        return  new_low + (value - old_low) * (new_high - new_low) / (old_high - old_low);
    }

    #include "/program/shaders1/common/atmosphere/atmosphere.glsl"
    #include "/program/shaders1/common/volumetric/clouds_3D.glsl"

    float clouds_shadowmap(vec2 coord, vec3 direction, float noise){
        atmosphere_constant ac = atmosphere_s();
        clouds_3D_settings vc = s_clouds3D();

        const int steps = CLOUDS_SHADOW_QUALITY;

        vec2 resolution = texel / vc.resolution;
        vec2 shadow_coord = coord * resolution;

        float transmittance = 0.0;
        float fade = smoothstep(0.125, 0.075, direction.y);

        if(saturate(shadow_coord) == shadow_coord){
            vec3 shadow_position = vec3(saturate(shadow_coord), 0.0) * 2.0 - 1.0;
                 shadow_position.xy *= vc.distance;
                 shadow_position = mat3(shadowModelViewInverse) * shadow_position;
                 
                 shadow_position += cameraPosition;
                 //shadow_position += direction * (vc.altitude_min - shadow_position.y) / direction.y;

            vec3 view_position = shadow_position + vec3(0.0, ac.planet_radius, 0.0);

            vec2 sphere_min = ray_sphere_intersection(view_position, direction, ac.planet_radius + vc.altitude_min);
            vec2 sphere_max = ray_sphere_intersection(view_position, direction, ac.planet_radius + vc.altitude_max);

            float dist0 = eyeAltitude > vc.altitude_max ? sphere_max.x : sphere_min.y;
            float dist1 = eyeAltitude > vc.altitude_max ? sphere_min.x : sphere_max.y;

            float s_length = (dist1 - dist0) / steps;

            vec3 ray_increment = direction * s_length;
            vec3 ray_position = direction * (dist0 + s_length * 0.5) + shadow_position;

            for(int i = 0; i < steps; i++, ray_position += ray_increment){
                transmittance += volumetric_clouds_density(vc, ray_position);
            }

            #if defined VOLUMETRIC_CLOUD && defined CLOUDS_SHADOW && defined OVER_WORLD
                return exp2(-transmittance * s_length) * (1.0 - fade) + fade;
            #else
                return 1.0;
            #endif
        } else {
            return 1.0;
        }
    }

    void main(){
        const float lod = INDIRECT_LOD;

        gbuffers g = gbuffers_data(vertex_coord);
        specular s = specular_data(g.spec, g.albedo, g.id);
        space_position sp = position(vertex_coord, g.depth, false);
        materials m = material(g.depth, g.id);

        vec2 offset = vertex_coord * texel;
        vec3 noise = rand3(offset + sin(frame_16));

        vec2 s_position = screen_velocity(sp.view_position0);
        vec2 velocity = vertex_coord - s_position;

        float depth0 = projection_depth(g.depth.y);
        float depth1 = texture2(colortex15, velocity).x;
            
        vec4 current = texture2(colortex10, vertex_coord / lod);
        vec4 previous = texture2(colortex11, velocity);
		
		float lum0 = luminance(current.xyz);
        float lum1 = luminance(previous.xyz);

        float weight = saturate(velocity) != velocity ? 0.0 : 0.95;
              weight *= exp2(-abs(depth0 - depth1) / depth0 * 12.0);
			  weight /= 1.0 - saturate(abs(lum0 - lum1) / lum0 * 12.0) * 0.1;
              weight = saturate(weight);

        buffers0 = mix(current, previous, weight);

        buffers1.x = depth0;
        buffers1.y = clouds_shadowmap(vertex_coord, sp.light_vector, noise.x);
        buffers1.zw = texture2(colortex15, vertex_coord).zw;

        buffers0 = saturate_16(buffers0);
        buffers1 = saturate_16(buffers1);
    }
#endif