#if defined SHADERS_VERTEX
    out vec2 vertex_coord;

    void main(){
        vertex_coord = layout_texcoord.xy;
        gl_Position = vec4(layout_position.xy * 2.0 - 1.0, 0.0, 1.0);

    }
#elif defined SHADERS_FRAGMENT
    in vec2 vertex_coord;

    /* RENDERTARGETS:3,4,5 */
    layout (location = 0) out vec3 buffers0;
    layout (location = 1) out vec3 buffers1;
    layout (location = 2) out vec4 buffers2;

    float volumetric_clouds_shadow(vec3 position){
        clouds_3D_settings vc = s_clouds3D();

        vec3 shadow_position = mat3(shadowModelView) * position;
            shadow_position /= vc.distance;
            shadow_position *= 0.5 + 0.5;

        return texture2(colortex15, shadow_position.xy / vc.resolution).y;
    }

    float remap(float value, float old_low, float old_high, float new_low, float new_high) {
        return  new_low + (value - old_low) * (new_high - new_low) / (old_high - old_low);
    }
    
    float hg_phase(float c, float g){
        return ((1.0 - g * g) / pow(1.0 + g * g - 2.0 * g * c, 1.5)) / (4.0 * pi);
    }

    #include "/program/shaders1/common/atmosphere/atmosphere.glsl"
    #include "/program/shaders1/common/atmosphere/object.glsl"
    #include "/program/shaders1/common/atmosphere/planet.glsl"

    #include "/program/shaders1/common/volumetric/volumetric_shadow.glsl"
    #include "/program/shaders1/common/volumetric/volumetric_light.glsl"
    #include "/program/shaders1/common/volumetric/volumetric_fog.glsl"
    #include "/program/shaders1/common/volumetric/volumetric_waterfog.glsl"

    void main(){    
        vec2 coord = vertex_coord * VL_LOD;

        if(saturate(coord) == coord){
            gbuffers g = gbuffers_data(coord);
            specular s = specular_data(g.spec, g.albedo, g.id);
            space_position sp = position(coord, g.depth, true);
            materials m = material(g.depth, g.id);

            vec2 offset = coord * texel / VL_LOD;
            vec3 noise = rand3(offset + sin(frame_16));

            if(m.water || isEyeInWater == 1){
                vec3 water_position0 = isEyeInWater == 1 ? vec3(0.0) : sp.inverse_position0;
                vec3 water_position1 = isEyeInWater == 1 ? sp.inverse_position0 : sp.inverse_position1;
                vec3 water_vector = isEyeInWater == 1 ? sp.inverse_vector0 : sp.inverse_vector1;
                
                vec3 water_transmittance = vec3(1.0);
                vec3 water_scattering = water_fog(water_position0, water_position1, water_vector, sp.light_vector, sp.sun_vector, sp.moon_vector, noise, g.lightmap.y, m.atmosphere, water_transmittance);

                buffers0 = water_scattering;
                buffers1 = water_transmittance;
            } else {
                buffers0 = vec3(0.0);
                buffers1 = vec3(1.0);
            }

            if(isEyeInWater == 0){
                vec4 light = vec4(0.0, 0.0, 0.0, 1.0);

                vec3 position0 = gbufferModelViewInverse[3].xyz;
                vec3 position1 = sp.inverse_position0;

                if(m.atmosphere){
                    position1 = position0 + sp.inverse_vector0 * far;
                }

                #ifdef VOLUMETRIC_FOG
                    vec4 vf = volumetric_fog(position0, position1, sp.inverse_vector0, sp.light_vector, sp.sun_vector, sp.moon_vector, noise, m.atmosphere);

                    light.xyz += vf.xyz;
                    light.w *= vf.w;
                #endif

                #ifdef VOLUMETRIC_LIGHT
                    vec4 vl = volumetric_light(position0, position1, sp.inverse_vector0, sp.light_vector, sp.sun_vector, sp.moon_vector, noise, m.atmosphere);

                    light.xyz += vl.xyz * light.w;
                    light.w *= vl.w;
                #endif

                #if defined OVER_WORLD
                    buffers2 = light;
                #else
                    buffers2 = vec4(0.0, 0.0, 0.0, 1.0);
                #endif
            } else {
                buffers2 = vec4(0.0, 0.0, 0.0, 1.0);
            }
        } else {
            buffers0 = vec3(0.0);
            buffers1 = vec3(1.0);
            buffers2 = vec4(0.0, 0.0, 0.0, 1.0);
        }

        buffers0 = saturate_16(buffers0);
        buffers1 = saturate_16(buffers1);
        buffers2 = saturate_16(buffers2);
    }
#endif