#if defined SHADERS_VERTEX
    out vec2 vertex_coord;

    void main(){
        vertex_coord = layout_texcoord.xy;
        gl_Position = vec4(layout_position.xy * 2.0 - 1.0, 0.0, 1.0);
    }
#elif defined SHADERS_FRAGMENT
    in vec2 vertex_coord;

    /* RENDERTARGETS:8 */
    layout (location = 0) out vec4 buffers0;

    #include "/program/shaders2/common/taa.glsl"

    void main(){
        temporal_settings ts = temporal_s();

        vec3 view_position = closest_fragment_3x3(depthtex0, vertex_coord, inverse_texel);

        vec2 position = screen_velocity(view_position);
        vec2 velocity = view_position.z < 0.7 ? vertex_coord : vertex_coord - position;    

        vec3 color = texture2(colortex8, vertex_coord).xyz;
        vec3 motion_blur = motion_blur(ts, vertex_coord, position, view_position.z);
        //Wissembourg
        float motion_treshold = length(position * texel) - ts.velocity_full;
              motion_treshold = clamp(motion_treshold, 0, ts.velocity_span);
              motion_treshold = 1 - motion_treshold / ts.velocity_span;

        #ifdef MOTION_BLUR
            buffers0.xyz = mix(motion_blur, color, motion_treshold);
        #else     
            buffers0.xyz = color;
        #endif

        buffers0.w = texture2(colortex8, vertex_coord).w;
    }
#endif