/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl;

import chrriis.common.Utils;
import chrriis.dj.nativeswing.swtimpl.Message;

public abstract class CommandMessage
extends Message {
    private Object[] args;
    private static final Object[] EMPTY_ARGS = new Object[0];

    void setArgs(Object ... args) {
        if (args.length == 0) {
            args = null;
        }
        this.args = args;
    }

    public void asyncExec(boolean isTargetNativeSide, Object ... args) {
        this.setArgs(args);
        this.asyncSend(isTargetNativeSide);
    }

    public Object syncExec(boolean isTargetNativeSide, Object ... args) {
        this.setArgs(args);
        return this.syncSend(isTargetNativeSide);
    }

    protected Object runCommand() throws Exception {
        return this.run(this.args == null ? EMPTY_ARGS : this.args);
    }

    public abstract Object run(Object[] var1) throws Exception;

    public String toString() {
        String s = super.toString();
        if (this.args == null || this.args.length == 0) {
            return String.valueOf(s) + "()";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(s).append('(');
        int i = 0;
        while (i < this.args.length) {
            Object arg = this.args[i];
            if (i > 0) {
                sb.append(", ");
            }
            if (arg != null && arg.getClass().isArray()) {
                sb.append(Utils.arrayDeepToString(arg));
            } else {
                sb.append(arg);
            }
            ++i;
        }
        sb.append(')');
        return sb.toString();
    }
}

