/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.components;

import chrriis.common.Utils;
import chrriis.common.WebServer;
import chrriis.dj.nativeswing.NSOption;
import chrriis.dj.nativeswing.swtimpl.NSPanelComponent;
import chrriis.dj.nativeswing.swtimpl.WebBrowserObject;
import chrriis.dj.nativeswing.swtimpl.components.DefaultVLCPlayerDecorator;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import chrriis.dj.nativeswing.swtimpl.components.VLCAudio;
import chrriis.dj.nativeswing.swtimpl.components.VLCInput;
import chrriis.dj.nativeswing.swtimpl.components.VLCPlayerDecorator;
import chrriis.dj.nativeswing.swtimpl.components.VLCPlaylist;
import chrriis.dj.nativeswing.swtimpl.components.VLCPluginOptions;
import chrriis.dj.nativeswing.swtimpl.components.VLCVideo;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JVLCPlayer
extends NSPanelComponent {
    private static VLCPlayerDecoratorFactory vlcPlayerDecoratorFactory;
    private VLCPlayerDecorator vlcPlayerDecorator;
    private JWebBrowser webBrowser;
    private WebBrowserObject webBrowserObject;
    private volatile VLCPluginOptions options;
    private VLCAudio vlcAudio;
    private VLCInput vlcInput;
    private VLCPlaylist vlcPlaylist;
    private VLCVideo vlcVideo;
    private List<ClassLoader> referenceClassLoaderList = new ArrayList<ClassLoader>(1);

    public static void setVLCPlayerDecoratorFactory(VLCPlayerDecoratorFactory vlcPlayerDecoratorFactory) {
        JVLCPlayer.vlcPlayerDecoratorFactory = vlcPlayerDecoratorFactory;
    }

    VLCPlayerDecorator getVLCPlayerDecorator() {
        return this.vlcPlayerDecorator;
    }

    protected VLCPlayerDecorator createVLCPlayerDecorator(Component renderingComponent) {
        VLCPlayerDecorator vlcPlayerDecorator;
        if (vlcPlayerDecoratorFactory != null && (vlcPlayerDecorator = vlcPlayerDecoratorFactory.createVLCPlayerDecorator(this, renderingComponent)) != null) {
            return vlcPlayerDecorator;
        }
        return new DefaultVLCPlayerDecorator(this, renderingComponent);
    }

    WebBrowserObject getWebBrowserObject() {
        return this.webBrowserObject;
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.cleanup();
    }

    public JVLCPlayer(NSOption ... options) {
        this.webBrowser = new JWebBrowser(options);
        this.initialize(this.webBrowser.getNativeComponent());
        this.webBrowserObject = new NWebBrowserObject(this);
        this.vlcAudio = new VLCAudio(this);
        this.vlcInput = new VLCInput(this);
        this.vlcPlaylist = new VLCPlaylist(this);
        this.vlcVideo = new VLCVideo(this);
        this.vlcPlayerDecorator = this.createVLCPlayerDecorator(this.webBrowser);
        this.add((Component)this.vlcPlayerDecorator, "Center");
    }

    public JWebBrowser getWebBrowser() {
        return this.webBrowser;
    }

    public void load() {
        this.load((VLCPluginOptions)null);
    }

    public void load(String resourceLocation) {
        this.load(resourceLocation, null);
    }

    public void load(VLCPluginOptions options) {
        this.load_("", options);
    }

    public void load(Class<?> clazz, String resourcePath) {
        this.load(clazz, resourcePath, null);
    }

    public void load(Class<?> clazz, String resourcePath, VLCPluginOptions options) {
        this.addReferenceClassLoader(clazz.getClassLoader());
        this.load(WebServer.getDefaultWebServer().getClassPathResourceURL(clazz.getName(), resourcePath), options);
    }

    public void load(String resourceLocation, VLCPluginOptions options) {
        if ("".equals(resourceLocation)) {
            resourceLocation = null;
        }
        this.load_(resourceLocation, options);
    }

    private void load_(String resourceLocation, VLCPluginOptions options) {
        if (options == null) {
            options = new VLCPluginOptions();
        }
        this.options = options;
        this.webBrowserObject.load(resourceLocation);
        VLCPlaylist playlist = this.getVLCPlaylist();
        if (resourceLocation != null && !"".equals(resourceLocation)) {
            playlist.stop();
            playlist.clear();
            playlist.addItem(resourceLocation);
            playlist.play();
        }
    }

    public boolean isControlBarVisible() {
        return this.vlcPlayerDecorator.isControlBarVisible();
    }

    public void setControlBarVisible(boolean isControlBarVisible) {
        this.vlcPlayerDecorator.setControlBarVisible(isControlBarVisible);
    }

    public VLCAudio getVLCAudio() {
        return this.vlcAudio;
    }

    public VLCInput getVLCInput() {
        return this.vlcInput;
    }

    public VLCPlaylist getVLCPlaylist() {
        return this.vlcPlaylist;
    }

    public VLCVideo getVLCVideo() {
        return this.vlcVideo;
    }

    void addReferenceClassLoader(ClassLoader referenceClassLoader) {
        if (referenceClassLoader == null || referenceClassLoader == this.getClass().getClassLoader() || this.referenceClassLoaderList.contains(referenceClassLoader)) {
            return;
        }
        this.referenceClassLoaderList.add(referenceClassLoader);
        WebServer.getDefaultWebServer().addReferenceClassLoader(referenceClassLoader);
    }

    protected void finalize() throws Throwable {
        for (ClassLoader referenceClassLoader : this.referenceClassLoaderList) {
            WebServer.getDefaultWebServer().removeReferenceClassLoader(referenceClassLoader);
        }
        this.referenceClassLoaderList.clear();
        super.finalize();
    }

    @Override
    public void disposeNativePeer() {
        super.disposeNativePeer();
        this.cleanup();
    }

    private void cleanup() {
        if (this.isNativePeerDisposed()) {
            this.webBrowserObject.load(null);
        }
    }

    private static class NWebBrowserObject
    extends WebBrowserObject {
        private final JVLCPlayer vlcPlayer;

        public NWebBrowserObject(JVLCPlayer vlcPlayer) {
            super(vlcPlayer.webBrowser);
            this.vlcPlayer = vlcPlayer;
        }

        protected WebBrowserObject.ObjectHTMLConfiguration getObjectHtmlConfiguration() {
            WebBrowserObject.ObjectHTMLConfiguration objectHTMLConfiguration = new WebBrowserObject.ObjectHTMLConfiguration();
            if (this.vlcPlayer.options != null) {
                objectHTMLConfiguration.setHTMLParameters(this.vlcPlayer.options.getParameters());
            }
            objectHTMLConfiguration.setWindowsClassID("9BE31822-FDAD-461B-AD51-BE1D1C159921");
            objectHTMLConfiguration.setWindowsInstallationURL("http://downloads.videolan.org/pub/videolan/vlc/latest/win32/axvlc.cab");
            objectHTMLConfiguration.setMimeType("application/x-vlc-plugin");
            objectHTMLConfiguration.setInstallationURL("http://www.videolan.org");
            objectHTMLConfiguration.setVersion("VideoLAN.VLCPlugin.2");
            return objectHTMLConfiguration;
        }

        public String getLocalFileURL(File localFile) {
            String s;
            block3: {
                String absolutePath = localFile.getAbsolutePath();
                if (absolutePath.startsWith("\\\\")) {
                    return absolutePath;
                }
                try {
                    s = "file://" + localFile.toURI().toURL().toString().substring("file:".length());
                }
                catch (Exception e) {
                    s = "file:///" + absolutePath;
                    if (!Utils.IS_WINDOWS) break block3;
                    s = s.replace('\\', '/');
                }
            }
            return this.encodeSpecialCharacters(s);
        }

        private String encodeSpecialCharacters(String s) {
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < s.length()) {
                char c = s.charAt(i);
                boolean isToEncode = false;
                if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9')) {
                    switch (c) {
                        case '%': 
                        case '*': 
                        case '+': 
                        case '-': 
                        case '.': 
                        case '/': 
                        case ':': 
                        case '_': {
                            break;
                        }
                        default: {
                            isToEncode = true;
                        }
                    }
                }
                if (isToEncode) {
                    sb.append(Utils.encodeURL(String.valueOf(c)));
                } else {
                    sb.append(c);
                }
                ++i;
            }
            return sb.toString();
        }
    }

    public static interface VLCPlayerDecoratorFactory {
        public VLCPlayerDecorator createVLCPlayerDecorator(JVLCPlayer var1, Component var2);
    }
}

