/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.core;

import chrriis.common.ObjectRegistry;
import chrriis.dj.nativeswing.swtimpl.CommandMessage;
import chrriis.dj.nativeswing.swtimpl.Message;
import chrriis.dj.nativeswing.swtimpl.NSSystemPropertySWT;
import chrriis.dj.nativeswing.swtimpl.core.SWTNativeInterface;
import java.awt.AWTEvent;
import java.awt.EventQueue;
import java.awt.Toolkit;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.SWT;

abstract class MessagingInterface {
    protected static final boolean IS_DEBUGGING_MESSAGES = Boolean.parseBoolean(NSSystemPropertySWT.INTERFACE_DEBUG_PRINTMESSAGES.get());
    private int pid;
    private volatile boolean isAlive;
    private Object RECEIVER_LOCK = new Object();
    private final boolean isNativeSide;
    private List<Message> receivedMessageList = new LinkedList<Message>();
    private boolean isWaitingResponse;
    private ObjectRegistry syncThreadRegistry = new ObjectRegistry();
    private final Object LOCK = new Object();

    public MessagingInterface(boolean isNativeSide, int pid) {
        this.isNativeSide = isNativeSide;
        this.pid = pid;
    }

    public abstract void destroy();

    public abstract boolean isUIThread();

    protected void setAlive(boolean isAlive) {
        this.isAlive = isAlive;
    }

    public boolean isAlive() {
        return this.isAlive;
    }

    protected void initialize(boolean exitOnEndOfStream) {
        this.setAlive(true);
        this.openChannel();
        this.createReceiverThread(exitOnEndOfStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CommandResultMessage processReceivedMessages() {
        while (true) {
            Message message;
            Object object = this.RECEIVER_LOCK;
            synchronized (object) {
                block6: {
                    if (!this.receivedMessageList.isEmpty()) break block6;
                    return null;
                }
                message = this.receivedMessageList.remove(0);
            }
            if (message instanceof CommandResultMessage) {
                return (CommandResultMessage)message;
            }
            this.runMessage(message);
        }
    }

    private CommandResultMessage runMessage(Message message) {
        CommandResultMessage commandResultMessage;
        if (IS_DEBUGGING_MESSAGES) {
            System.err.println(">RUN: " + SWTNativeInterface.getMessageID(message) + ", " + message);
        }
        if (message instanceof CommandMessage) {
            CommandMessage commandMessage = (CommandMessage)message;
            Object result = null;
            Throwable throwable = null;
            if (SWTNativeInterface.isMessageValid(message)) {
                try {
                    result = SWTNativeInterface.runMessageCommand(commandMessage);
                }
                catch (Throwable t) {
                    throwable = t;
                }
            }
            if (SWTNativeInterface.isMessageSyncExec(commandMessage)) {
                commandResultMessage = new CommandResultMessage(SWTNativeInterface.getMessageID(commandMessage), result, throwable);
                this.asyncSend(commandResultMessage);
            } else {
                if (throwable != null) {
                    throwable.printStackTrace();
                }
                commandResultMessage = new CommandResultMessage(SWTNativeInterface.getMessageID(message), result, throwable);
            }
        } else {
            commandResultMessage = new CommandResultMessage(SWTNativeInterface.getMessageID(message), null, null);
            if (SWTNativeInterface.isMessageSyncExec(message)) {
                this.asyncSend(commandResultMessage);
            }
        }
        if (IS_DEBUGGING_MESSAGES) {
            System.err.println("<RUN: " + SWTNativeInterface.getMessageID(message));
        }
        return commandResultMessage;
    }

    protected abstract void asyncUIExec(Runnable var1);

    protected boolean isNativeSide() {
        return this.isNativeSide;
    }

    public void checkUIThread() {
        if (!this.isUIThread()) {
            if (this.isNativeSide()) {
                SWT.error(22);
                return;
            }
            throw new IllegalStateException("This call must happen in the AWT Event Dispatch Thread! Please refer to http://java.sun.com/docs/books/tutorial/uiswing/concurrency/index.html and http://java.sun.com/javase/6/docs/api/javax/swing/SwingUtilities.html#invokeLater(java.lang.Runnable)");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object nonUISyncExec(Message message) {
        ThreadLock threadLock = new ThreadLock();
        int instanceID = this.syncThreadRegistry.add(threadLock);
        CM_asyncExec asyncExec = new CM_asyncExec();
        SWTNativeInterface.setMessageArgs(asyncExec, instanceID, message, this.isNativeSide());
        this.asyncSend(asyncExec);
        ThreadLock threadLock2 = threadLock;
        synchronized (threadLock2) {
            do {
                if (!(this.syncThreadRegistry.get(instanceID) instanceof ThreadLock)) {
                    CommandResultMessage commandResultMessage = (CommandResultMessage)this.syncThreadRegistry.get(instanceID);
                    this.syncThreadRegistry.remove(instanceID);
                    return this.processCommandResult(commandResultMessage);
                }
                try {
                    threadLock.wait();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            } while (this.isAlive());
            this.syncThreadRegistry.remove(instanceID);
            this.printFailedInvocation(message);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object syncSend(Message message) {
        SWTNativeInterface.computeMessageID(message, !this.isNativeSide());
        if (!this.isUIThread()) {
            return this.nonUISyncExec(message);
        }
        Object object = this.LOCK;
        synchronized (object) {
            SWTNativeInterface.setMessageUI(message, true);
            SWTNativeInterface.setMessageSyncExec(message, true);
            if (!this.isAlive()) {
                this.printFailedInvocation(message);
                return null;
            }
            CommandResultMessage commandResultMessage = null;
            try {
                Object object2;
                ArrayList<CommandResultMessage> commandResultMessageList;
                block32: {
                    this.writeMessage(message);
                    commandResultMessageList = new ArrayList<CommandResultMessage>();
                    block11: do {
                        if ((commandResultMessage = this.processReceivedMessages()) != null) {
                            if (commandResultMessage.getOriginalID() != SWTNativeInterface.getMessageID(message)) {
                                commandResultMessageList.add(commandResultMessage);
                                commandResultMessage = null;
                                continue;
                            }
                            break block32;
                        }
                        object2 = this.RECEIVER_LOCK;
                        synchronized (object2) {
                            boolean isFirst = true;
                            while (true) {
                                String timeout;
                                if (!this.receivedMessageList.isEmpty()) {
                                    continue block11;
                                }
                                if (!this.isAlive()) {
                                    this.printFailedInvocation(message);
                                    return null;
                                }
                                if (!isFirst) {
                                    isFirst = true;
                                    if (this.isNativeSide()) {
                                        SWTNativeInterface.getInstance().getDisplay().readAndDispatch();
                                    } else {
                                        EventQueue eventQueue = Toolkit.getDefaultToolkit().getSystemEventQueue();
                                        AWTEvent nextEvent = eventQueue.peekEvent();
                                        if (nextEvent != null && (nextEvent = eventQueue.getNextEvent()) != null) {
                                            Method dispatchMethod = EventQueue.class.getDeclaredMethod("dispatchEvent", AWTEvent.class);
                                            dispatchMethod.setAccessible(true);
                                            dispatchMethod.invoke((Object)eventQueue, nextEvent);
                                        }
                                    }
                                }
                                isFirst = false;
                                this.isWaitingResponse = true;
                                if (this.isNativeSide()) {
                                    timeout = NSSystemPropertySWT.INTERFACE_SYNCSEND_NATIVE_TIMEOUT.get();
                                    if (timeout != null) {
                                        this.RECEIVER_LOCK.wait(Long.parseLong(timeout));
                                    } else {
                                        this.RECEIVER_LOCK.wait(500L);
                                    }
                                } else {
                                    timeout = NSSystemPropertySWT.INTERFACE_SYNCSEND_LOCAL_TIMEOUT.get();
                                    if (timeout != null) {
                                        this.RECEIVER_LOCK.wait(Long.parseLong(timeout));
                                    } else {
                                        this.RECEIVER_LOCK.wait(5000L);
                                    }
                                }
                                this.isWaitingResponse = false;
                            }
                        }
                    } while (this.isAlive());
                    this.printFailedInvocation(message);
                    return null;
                }
                object2 = this.RECEIVER_LOCK;
                synchronized (object2) {
                    if (!commandResultMessageList.isEmpty()) {
                        this.receivedMessageList.addAll(0, commandResultMessageList);
                    } else if (!this.receivedMessageList.isEmpty()) {
                        this.asyncUIExec(new Runnable(){

                            public void run() {
                                MessagingInterface.this.processReceivedMessages();
                            }
                        });
                    }
                }
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            return this.processCommandResult(commandResultMessage);
        }
    }

    private Object processCommandResult(CommandResultMessage commandResultMessage) {
        Throwable exception;
        if (IS_DEBUGGING_MESSAGES) {
            System.err.println("<USE: " + SWTNativeInterface.getMessageID(commandResultMessage));
        }
        if ((exception = commandResultMessage.getException()) != null) {
            throw new RuntimeException(exception);
        }
        return commandResultMessage.getResult();
    }

    public void asyncSend(Message message) {
        SWTNativeInterface.computeMessageID(message, !this.isNativeSide());
        SWTNativeInterface.setMessageUI(message, this.isUIThread());
        SWTNativeInterface.setMessageSyncExec(message, false);
        try {
            this.writeMessage(message);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private void writeMessage(Message message) throws IOException {
        if (!this.isAlive()) {
            this.printFailedInvocation(message);
            return;
        }
        if (IS_DEBUGGING_MESSAGES) {
            System.err.println(String.valueOf(SWTNativeInterface.isMessageSyncExec(message) ? "SENDS" : "SENDA") + ": " + SWTNativeInterface.getMessageID(message) + ", " + message);
        }
        this.writeMessageToChannel(message);
    }

    protected abstract void writeMessageToChannel(Message var1) throws IOException;

    protected abstract Message readMessageFromChannel() throws IOException, ClassNotFoundException;

    private void printFailedInvocation(Message message) {
        System.err.println("Failed messaging: " + message);
    }

    protected void terminate() {
        System.exit(0);
    }

    protected int getPID() {
        return this.pid;
    }

    private void createReceiverThread(final boolean exitOnEndOfStream) {
        Thread receiverThread = new Thread("NativeSwing[" + this.pid + "] " + (this.isNativeSide() ? "SWT" : "Swing") + " Receiver"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public void run() {
                while (MessagingInterface.this.isAlive()) {
                    block23: {
                        message = null;
                        try {
                            message = MessagingInterface.this.readMessageFromChannel();
                            break block23;
                        }
                        catch (Exception e) {
                            isRespawned = false;
                            if (MessagingInterface.this.isAlive()) {
                                MessagingInterface.this.setAlive(false);
                                if (exitOnEndOfStream) {
                                    MessagingInterface.this.terminate();
                                    return;
                                }
                                e.printStackTrace();
                                try {
                                    isRespawned = SWTNativeInterface.getInstance().notifyKilled();
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                            ex = MessagingInterface.access$3(MessagingInterface.this);
                            synchronized (ex) {
                                MessagingInterface.access$4(MessagingInterface.this).clear();
                                MessagingInterface.access$3(MessagingInterface.this).notify();
                            }
                            var7_10 = MessagingInterface.access$0(MessagingInterface.this).getInstanceIDs();
                            var6_9 = var7_10.length;
                            var5_8 = 0;
                            ** while (var5_8 < var6_9)
                        }
lbl-1000:
                        // 1 sources

                        {
                            instanceID = var7_10[var5_8];
                            o = MessagingInterface.access$0(MessagingInterface.this).get(instanceID);
                            if (o instanceof ThreadLock) {
                                var9_12 = o;
                                synchronized (var9_12) {
                                    o.notify();
                                }
                            }
                            ++var5_8;
                            continue;
                        }
lbl43:
                        // 1 sources

                        if (isRespawned) {
                            SWTNativeInterface.getInstance().notifyRespawned();
                        }
                    }
                    if (message == null) continue;
                    if (!SWTNativeInterface.isMessageUI(message)) {
                        message_ = message;
                        new Thread("NativeSwing[" + MessagingInterface.this.getPID() + "] Non-UI Message [" + SWTNativeInterface.getMessageID(message) + "] Executor"){

                            public void run() {
                                MessagingInterface.this.runMessage(message_);
                            }
                        }.start();
                        continue;
                    }
                    var2_2 = MessagingInterface.access$3(MessagingInterface.this);
                    synchronized (var2_2) {
                        MessagingInterface.access$4(MessagingInterface.this).add(message);
                        if (MessagingInterface.access$5(MessagingInterface.this)) {
                            MessagingInterface.access$3(MessagingInterface.this).notify();
                        } else if (MessagingInterface.access$4(MessagingInterface.this).size() == 1) {
                            MessagingInterface.this.asyncUIExec(new Runnable(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                public void run() {
                                    CommandResultMessage commandResultMessage = MessagingInterface.this.processReceivedMessages();
                                    if (commandResultMessage != null) {
                                        Object object = MessagingInterface.this.RECEIVER_LOCK;
                                        synchronized (object) {
                                            MessagingInterface.this.receivedMessageList.add(0, commandResultMessage);
                                        }
                                    }
                                }
                            });
                        }
                    }
                }
                MessagingInterface.this.closeChannel();
            }
        };
        receiverThread.setDaemon(true);
        receiverThread.start();
    }

    protected abstract void openChannel();

    protected abstract void closeChannel();

    static /* synthetic */ boolean access$5(MessagingInterface messagingInterface) {
        return messagingInterface.isWaitingResponse;
    }

    private static class CM_asyncExec
    extends CommandMessage {
        private CM_asyncExec() {
        }

        public Object run(Object[] args) {
            Message message = (Message)args[1];
            boolean isOriginatorNativeSide = (Boolean)args[2];
            SWTNativeInterface.setMessageSyncExec(message, false);
            MessagingInterface messagingInterface = SWTNativeInterface.getInstance().getMessagingInterface(!isOriginatorNativeSide);
            CM_asyncExecResponse asyncExecResponse = new CM_asyncExecResponse();
            SWTNativeInterface.setMessageArgs(asyncExecResponse, args[0], messagingInterface.runMessage(message), messagingInterface.isNativeSide());
            messagingInterface.asyncSend(asyncExecResponse);
            return null;
        }
    }

    private static class CM_asyncExecResponse
    extends CommandMessage {
        private CM_asyncExecResponse() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run(Object[] args) {
            int instanceID = (Integer)args[0];
            boolean isOriginatorNativeSide = (Boolean)args[2];
            MessagingInterface messagingInterface = SWTNativeInterface.getInstance().getMessagingInterface(!isOriginatorNativeSide);
            ThreadLock threadLock = (ThreadLock)messagingInterface.syncThreadRegistry.get(instanceID);
            messagingInterface.syncThreadRegistry.remove(instanceID);
            if (threadLock == null) {
                return null;
            }
            ThreadLock threadLock2 = threadLock;
            synchronized (threadLock2) {
                messagingInterface.syncThreadRegistry.add(args[1], instanceID);
                threadLock.notify();
            }
            return null;
        }
    }

    private static class CommandResultMessage
    extends Message {
        private final int originalID;
        private final Object result;
        private final Throwable exception;

        CommandResultMessage(int originalID, Object result, Throwable exception) {
            this.originalID = originalID;
            this.result = result;
            this.exception = exception;
        }

        int getOriginalID() {
            return this.originalID;
        }

        public Object getResult() {
            return this.result;
        }

        public Throwable getException() {
            return this.exception;
        }

        public String toString() {
            return String.valueOf(super.toString()) + "(" + this.originalID + ")";
        }
    }

    private static class ThreadLock {
        private ThreadLock() {
        }
    }
}

