/*
 * Decompiled with CFR 0.152.
 */
package chrriis.dj.nativeswing.swtimpl.core;

import chrriis.common.ObjectRegistry;
import chrriis.common.Utils;
import chrriis.dj.nativeswing.NativeComponentWrapper;
import chrriis.dj.nativeswing.swtimpl.CommandMessage;
import chrriis.dj.nativeswing.swtimpl.LocalMessage;
import chrriis.dj.nativeswing.swtimpl.Message;
import chrriis.dj.nativeswing.swtimpl.NSSystemPropertySWT;
import chrriis.dj.nativeswing.swtimpl.NativeComponent;
import chrriis.dj.nativeswing.swtimpl.NativeInterface;
import chrriis.dj.nativeswing.swtimpl.NativeInterfaceAdapter;
import chrriis.dj.nativeswing.swtimpl.NativeInterfaceListener;
import chrriis.dj.nativeswing.swtimpl.core.ControlCommandMessage;
import chrriis.dj.nativeswing.swtimpl.core.NoSerializationTestMessage;
import chrriis.dj.nativeswing.swtimpl.core.SWTNativeInterface;
import chrriis.dj.nativeswing.swtimpl.core.SWTUtils;
import com.sun.jna.Native;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.MenuComponent;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DropTarget;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.peer.ComponentPeer;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import org.eclipse.swt.SWT;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SWTNativeComponent
extends NativeComponent {
    private static final boolean IS_PRINTING_FAILED_MESSAGES = Boolean.parseBoolean(NSSystemPropertySWT.COMPONENTS_DEBUG_PRINTFAILEDMESSAGES.get());
    private NativeComponentWrapper nativeComponentWrapper = new NativeComponentWrapper(this){

        protected String getComponentDescription() {
            return SWTNativeComponent.this.getComponentDescription();
        }

        protected void paintNativeComponent(BufferedImage image, Rectangle[] rectangles) {
            SWTNativeComponent.this.paintComponent(image, rectangles);
        }

        protected void setNativeComponentEnabled(boolean isEnabled) {
            SWTNativeComponent.this.setControlParentEnabled(isEnabled, Utils.IS_MAC && isEnabled && SWTNativeComponent.this.isShowing());
        }

        protected boolean isNativeComponentEnabled() {
            return SWTNativeComponent.this.isControlParentEnabled();
        }

        protected void storeInHiddenParent() {
            if (Boolean.parseBoolean(NSSystemPropertySWT.COMPONENTS_DISABLEHIDDENPARENTREPARENTING.get())) {
                throw new IllegalStateException("Storing to a hidden parent is not supported!");
            }
            SWTNativeComponent.this.storeInHiddenParent();
        }

        protected void restoreFromHiddenParent() {
            SWTNativeComponent.this.restoreFromHiddenParent();
        }
    };
    private volatile List<CommandMessage> initializationCommandMessageList = new ArrayList<CommandMessage>();
    private int componentID;
    private volatile Thread resizeThread;
    private volatile Thread repaintThread;
    private int additionCount;
    private boolean isForcingInitialization;
    private Method getAWTHandleMethod;
    private NativeInterfaceListener nativeInterfaceListener;
    private boolean isNativePeerValid;
    private String invalidNativePeerText;
    private boolean isNativePeerInitialized;
    private boolean isNativePeerDisposed;
    private boolean isControlParentEnabled = true;
    private boolean isStoredInHiddenParent;
    protected EventListenerList listenerList = new EventListenerList();

    protected static ObjectRegistry getControlRegistry() {
        return NativeComponent.getControlRegistry();
    }

    protected static ObjectRegistry getNativeComponentRegistry() {
        return NativeComponent.getNativeComponentRegistry();
    }

    @Override
    public void runInSequence(Runnable runnable) {
        this.runSync(new CMLocal_runInSequence(), runnable);
    }

    @Override
    public Object runSync(CommandMessage commandMessage, Object ... args) {
        SWTNativeInterface nativeInterface = SWTNativeInterface.getInstance();
        if (nativeInterface.isAlive()) {
            nativeInterface.checkUIThread(false);
        }
        if (commandMessage instanceof ControlCommandMessage) {
            ((ControlCommandMessage)commandMessage).setNativeComponent(this);
        }
        if (this.initializationCommandMessageList != null) {
            SWTNativeInterface.setMessageSyncExec(commandMessage, true);
            SWTNativeInterface.setMessageArgs(commandMessage, args);
            this.initializationCommandMessageList.add(commandMessage);
            return null;
        }
        if (!this.isNativePeerValid()) {
            SWTNativeInterface.setMessageArgs(commandMessage, args);
            this.printFailedInvocation(commandMessage);
            return null;
        }
        try {
            return commandMessage.syncExec(true, args);
        }
        catch (RuntimeException e) {
            this.processFailedMessageException(e, commandMessage);
            return null;
        }
    }

    @Override
    public void runAsync(CommandMessage commandMessage, Object ... args) {
        SWTNativeInterface nativeInterface = SWTNativeInterface.getInstance();
        if (nativeInterface.isAlive()) {
            nativeInterface.checkUIThread(false);
        }
        if (commandMessage instanceof ControlCommandMessage) {
            ((ControlCommandMessage)commandMessage).setNativeComponent(this);
        }
        if (this.initializationCommandMessageList != null) {
            SWTNativeInterface.setMessageSyncExec(commandMessage, false);
            SWTNativeInterface.setMessageArgs(commandMessage, args);
            this.initializationCommandMessageList.add(commandMessage);
        } else if (!this.isNativePeerValid()) {
            SWTNativeInterface.setMessageArgs(commandMessage, args);
            this.printFailedInvocation(commandMessage);
        } else {
            commandMessage.asyncExec(true, args);
        }
    }

    private void printFailedInvocation(Message message) {
        if (IS_PRINTING_FAILED_MESSAGES) {
            System.err.println("Failed message to " + this.getComponentDescription() + ": " + message);
        }
    }

    static Control[] getControls() {
        ArrayList<Control> controlList = new ArrayList<Control>();
        ObjectRegistry controlRegistry = SWTNativeComponent.getControlRegistry();
        int[] nArray = controlRegistry.getInstanceIDs();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int instanceID = nArray[n2];
            Control nativeComponent = (Control)controlRegistry.get(instanceID);
            if (nativeComponent != null) {
                controlList.add(nativeComponent);
            }
            ++n2;
        }
        return controlList.toArray(new Control[0]);
    }

    @Override
    protected int getComponentID() {
        return this.componentID;
    }

    public SWTNativeComponent() {
        DnDHandler.activateDragAndDrop();
        this.componentID = SWTNativeComponent.getNativeComponentRegistry().add(this);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                if (SWTNativeComponent.this.isNativePeerValid() && !SWTNativeComponent.this.isNativePeerDisposed()) {
                    SWTNativeComponent.this.runSync(new CMN_transferFocus(), new Object[0]);
                }
            }
        });
        this.enableEvents(8L);
        this.setFocusable(true);
    }

    @Override
    protected void processKeyEvent(java.awt.event.KeyEvent e) {
        java.awt.event.KeyEvent ke = e;
        if (!(ke instanceof CKeyEvent)) {
            ComponentPeer peer = this.getPeer();
            if (peer != null) {
                peer.handleEvent(e);
            }
            e.consume();
            return;
        }
        super.processKeyEvent(ke);
    }

    @Override
    public void reshape(int x, int y, int width, int height) {
        if (this.resizeThread == null && (width != this.getWidth() || height != this.getHeight())) {
            this.resizeThread = new Thread("NativeSwing Resize"){

                public void run() {
                    try {
                        3.sleep(50L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    SWTNativeComponent.this.applyPendingReshape();
                }
            };
            this.resizeThread.start();
        }
        super.reshape(x, y, width, height);
    }

    private void applyPendingReshape() {
        if (this.resizeThread == null) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SWTNativeComponent.this.applyPendingReshape();
                }
            });
            return;
        }
        if (this.resizeThread == null) {
            return;
        }
        this.resizeThread = null;
        if (this.isNativePeerValid()) {
            new CMN_reshape().asyncExec(this, this.getWidth(), this.getHeight());
        }
    }

    private void repaintNativeComponent() {
        if (this.repaintThread == null && this.getWidth() > 0 && this.getHeight() > 0) {
            this.repaintThread = new Thread("NativeSwing Repaint"){

                public void run() {
                    try {
                        5.sleep(50L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    SWTNativeComponent.this.applyPendingRepaint();
                }
            };
            this.repaintThread.start();
        }
    }

    private void applyPendingRepaint() {
        if (this.repaintThread == null) {
            return;
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SWTNativeComponent.this.applyPendingRepaint();
                }
            });
            return;
        }
        if (this.repaintThread == null) {
            return;
        }
        this.repaintThread = null;
        if (this.isNativePeerValid()) {
            new CMN_redraw().asyncExec(this, new Object[0]);
        }
    }

    @Override
    public void repaint() {
        super.repaint();
        this.repaintNativeComponent();
    }

    private static Object[] getKeyEventArgs(KeyEvent keyEvent, int keyEventType) {
        return new Object[]{keyEventType, keyEvent.stateMask, Character.valueOf(keyEvent.character), keyEvent.keyCode};
    }

    private static Object[] getMouseEventArgs(Control control, org.eclipse.swt.events.MouseEvent e, int mouseEventType) {
        Integer lastEventType;
        org.eclipse.swt.events.MouseEvent lastEvent = (org.eclipse.swt.events.MouseEvent)control.getData("NS_LastMouseEvent");
        if (lastEvent != null && (lastEventType = (Integer)control.getData("NS_LastMouseEventType")) == mouseEventType && mouseEventType != 507 && lastEvent.x == e.x && lastEvent.y == e.y && lastEvent.button == e.button && lastEvent.count == e.count && lastEvent.stateMask == e.stateMask) {
            return null;
        }
        control.setData("NS_LastMouseEvent", e);
        control.setData("NS_LastMouseEventType", mouseEventType);
        lastEvent = e;
        return new Object[]{mouseEventType, e.x, e.y, e.button, e.count, e.stateMask, e.display.getCursorLocation()};
    }

    private static void configureControl(final Control control, int componentID) {
        control.setData("NS_ID", componentID);
        control.setData("NS_EnabledEventsMask", 0L);
        control.addMouseListener(new MouseAdapter(){

            public void mouseDown(org.eclipse.swt.events.MouseEvent e) {
                Object[] mouseEventArgs = SWTNativeComponent.getMouseEventArgs(control, e, 501);
                if (mouseEventArgs != null) {
                    new CMJ_dispatchMouseEvent().asyncExec(control, mouseEventArgs);
                }
            }

            public void mouseUp(org.eclipse.swt.events.MouseEvent e) {
                Object[] mouseEventArgs = SWTNativeComponent.getMouseEventArgs(control, e, 502);
                if (mouseEventArgs != null) {
                    new CMJ_dispatchMouseEvent().asyncExec(control, mouseEventArgs);
                }
            }
        });
        control.addMouseTrackListener(new MouseTrackAdapter(){

            public void mouseEnter(org.eclipse.swt.events.MouseEvent e) {
                Object[] mouseEventArgs = SWTNativeComponent.getMouseEventArgs(control, e, 504);
                if (mouseEventArgs != null) {
                    new CMJ_dispatchMouseEvent().asyncExec(control, mouseEventArgs);
                }
            }

            public void mouseExit(org.eclipse.swt.events.MouseEvent e) {
                Object[] mouseEventArgs = SWTNativeComponent.getMouseEventArgs(control, e, 505);
                if (mouseEventArgs != null) {
                    new CMJ_dispatchMouseEvent().asyncExec(control, mouseEventArgs);
                }
            }
        });
        control.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(org.eclipse.swt.events.MouseEvent e) {
                Object[] mouseEventArgs;
                if (((Long)e.widget.getData("NS_EnabledEventsMask") & 0x20L) != 0L && (mouseEventArgs = SWTNativeComponent.getMouseEventArgs(control, e, 503)) != null) {
                    new CMJ_dispatchMouseEvent().asyncExec(control, mouseEventArgs);
                }
            }
        });
        control.addMouseWheelListener(new org.eclipse.swt.events.MouseWheelListener(){

            public void mouseScrolled(org.eclipse.swt.events.MouseEvent e) {
                Object[] mouseEventArgs = SWTNativeComponent.getMouseEventArgs(control, e, 507);
                if (mouseEventArgs != null) {
                    new CMJ_dispatchMouseEvent().asyncExec(control, mouseEventArgs);
                }
            }
        });
        control.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if ((e.stateMask & 0x40000) != 0 && e.keyCode == 9) {
                    e.doit = false;
                }
                new CMJ_dispatchKeyEvent().asyncExec(control, SWTNativeComponent.getKeyEventArgs(e, 401));
            }

            public void keyReleased(KeyEvent e) {
                new CMJ_dispatchKeyEvent().asyncExec(control, SWTNativeComponent.getKeyEventArgs(e, 402));
                new CMJ_dispatchKeyEvent().asyncExec(control, SWTNativeComponent.getKeyEventArgs(e, 400));
            }
        });
    }

    @Override
    public synchronized void addMouseMotionListener(MouseMotionListener listener) {
        if (this.getMouseMotionListeners().length == 0 && listener != null) {
            this.runAsync(new CMN_setEventsEnabled(), 32L, true);
        }
        super.addMouseMotionListener(listener);
    }

    @Override
    public synchronized void removeMouseMotionListener(MouseMotionListener listener) {
        super.removeMouseMotionListener(listener);
        if (this.getMouseMotionListeners().length == 0) {
            this.runAsync(new CMN_setEventsEnabled(), 32L, false);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (!this.isNativePeerValid()) {
            String text = this.invalidNativePeerText;
            if (text == null) {
                text = "Invalid " + this.getComponentDescription();
            }
            FontMetrics fm = g.getFontMetrics();
            BufferedReader r = new BufferedReader(new StringReader(text));
            int lineHeight = fm.getHeight();
            int ascent = fm.getAscent();
            try {
                String line;
                int i = 0;
                while ((line = r.readLine()) != null) {
                    g.drawString(line, 5, ascent + 5 + lineHeight * i);
                    ++i;
                }
            }
            catch (Exception exception) {}
        } else {
            this.nativeComponentWrapper.paintBackBuffer(g, false);
        }
    }

    @Override
    public void print(Graphics g) {
        BufferedImage image = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        this.paintComponent(image);
        g.drawImage(image, 0, 0, null);
        g.dispose();
        image.flush();
    }

    private void throwDuplicateCreationException() {
        this.isNativePeerValid = false;
        this.invalidNativePeerText = "Failed to create " + this.getComponentDescription() + "\n\nReason:\nThe native component cannot be removed then re-added to a component hierarchy.";
        this.repaint();
        throw new IllegalStateException("The native component cannot be removed then re-added to a component hierarchy! To allow such reparenting, the component must be created with the \"destroyOnFinalization\" constructor option.");
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.isStoredInHiddenParent) {
            return;
        }
        if (this.isForcingInitialization) {
            return;
        }
        if (this.isNativePeerDisposed) {
            this.throwDuplicateCreationException();
        }
        ++this.additionCount;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (SWTNativeComponent.this.isNativePeerDisposed && SWTNativeComponent.this.additionCount > 1) {
                    SWTNativeComponent.this.throwDuplicateCreationException();
                }
                if (!SWTNativeComponent.this.isNativePeerInitialized) {
                    SWTNativeComponent.this.createNativePeer();
                }
            }
        });
    }

    @Override
    public void initializeNativePeer() {
        Window windowAncestor;
        SWTNativeInterface nativeInterface = SWTNativeInterface.getInstance();
        if (nativeInterface.isAlive()) {
            nativeInterface.checkUIThread(false);
        }
        if ((windowAncestor = SwingUtilities.getWindowAncestor(this)) == null) {
            throw new IllegalStateException("This method can only be called when the component has a Window ancestor!");
        }
        if (this.isNativePeerDisposed) {
            this.throwDuplicateCreationException();
        }
        if (!this.isNativePeerInitialized) {
            this.isForcingInitialization = true;
            try {
                if (Utils.IS_MAC) {
                    class MacWindowInitMessage
                    extends CommandMessage
                    implements NoSerializationTestMessage {
                        private final /* synthetic */ Window val$windowAncestor;

                        MacWindowInitMessage(Window window) {
                            this.val$windowAncestor = window;
                        }

                        public Object run(Object[] args) throws Exception {
                            this.val$windowAncestor.addNotify();
                            return null;
                        }
                    }
                    new MacWindowInitMessage(windowAncestor).syncSend(true);
                } else {
                    windowAncestor.addNotify();
                }
                this.createNativePeer();
            }
            finally {
                this.isForcingInitialization = false;
            }
        }
    }

    private Object getHandle() {
        if (SWTNativeInterface.getInstance().isInProcess_()) {
            return this;
        }
        try {
            if (this.getAWTHandleMethod == null) {
                Method loadLibraryMethod = SWT_AWT.class.getDeclaredMethod("loadLibrary", new Class[0]);
                loadLibraryMethod.setAccessible(true);
                loadLibraryMethod.invoke(null, new Object[0]);
                this.getAWTHandleMethod = SWT_AWT.class.getDeclaredMethod("getAWTHandle", Canvas.class);
                this.getAWTHandleMethod.setAccessible(true);
            }
            return this.getAWTHandleMethod.invoke(null, this);
        }
        catch (Exception e) {
            try {
                if (this.isDisplayable()) {
                    return Native.getComponentID((Component)this);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return 0;
        }
    }

    @Override
    protected Object[] getNativePeerCreationParameters() {
        return null;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void createNativePeer() {
        nativeInterface = SWTNativeInterface.getInstance();
        isInterfaceAlive = nativeInterface.isAlive();
        if (isInterfaceAlive) {
            nativeInterface.checkUIThread(false);
        }
        if (this.initializationCommandMessageList == null) {
            this.throwDuplicateCreationException();
        }
        initializationCommandMessageList_ = this.initializationCommandMessageList;
        this.initializationCommandMessageList = null;
        this.isNativePeerInitialized = true;
        if (isInterfaceAlive) {
            block12: {
                this.nativeInterfaceListener = new NNativeInterfaceListener(this);
                NativeInterface.addNativeInterfaceListener(this.nativeInterfaceListener);
                this.isNativePeerValid = true;
                try {
                    this.runSync(new CMN_createControl(), new Object[]{this.componentID, this.getHandle(), this.getClass().getName(), this.getNativePeerCreationParameters()});
                    break block12;
                }
                catch (Exception e) {
                    this.isNativePeerValid = false;
                    sb = new StringBuilder();
                    t /* !! */  = e;
                    ** while (t /* !! */  != null)
                }
lbl-1000:
                // 1 sources

                {
                    sb.append("    " + t /* !! */ .toString() + "\n");
                    t /* !! */  = t /* !! */ .getCause();
                    continue;
                }
lbl27:
                // 1 sources

                this.invalidNativePeerText = "Failed to create " + this.getComponentDescription() + "\n\nReason:\n" + sb.toString();
                e.printStackTrace();
            }
            new CMN_reshape().asyncExec(this, new Object[]{this.getWidth(), this.getHeight()});
        } else {
            this.invalidNativePeerText = "Failed to create " + this.getComponentDescription() + "\n\nReason:\nThe native interface is not open!";
        }
        for (CommandMessage initCommandMessage : initializationCommandMessageList_) {
            if (!this.isNativePeerValid()) {
                this.printFailedInvocation(initCommandMessage);
                continue;
            }
            if (SWTNativeInterface.isMessageSyncExec(initCommandMessage)) {
                try {
                    initCommandMessage.syncSend(true);
                }
                catch (RuntimeException e) {
                    this.processFailedMessageException(e, initCommandMessage);
                }
                continue;
            }
            initCommandMessage.asyncSend(true);
        }
    }

    private void processFailedMessageException(RuntimeException e, CommandMessage commandMessage) {
        boolean isCatchingException = false;
        Throwable ex = e;
        while (ex != null) {
            if (ex instanceof ControlCommandMessage.DisposedControlException) {
                isCatchingException = true;
                break;
            }
            ex = ex.getCause();
        }
        if (!isCatchingException && Boolean.parseBoolean(NSSystemPropertySWT.COMPONENTS_SWALLOWRUNTIMEEXCEPTIONS.get())) {
            e.printStackTrace();
            isCatchingException = true;
        }
        if (!isCatchingException) {
            throw e;
        }
        this.printFailedInvocation(commandMessage);
    }

    @Override
    public void removeNotify() {
        if (this.isStoredInHiddenParent) {
            super.removeNotify();
            return;
        }
        this.disposeNativePeer();
        super.removeNotify();
    }

    @Override
    protected void disposeNativePeer() {
        if (!this.isNativePeerDisposed) {
            this.isNativePeerDisposed = true;
            if (this.isNativePeerInitialized) {
                NativeInterface.removeNativeInterfaceListener(this.nativeInterfaceListener);
                if (this.isNativePeerValid()) {
                    this.runSync(new CMN_destroyControl(), new Object[0]);
                }
            }
            this.invalidateNativePeer("The native component was disposed.");
            SWTNativeComponent.getNativeComponentRegistry().remove(this.componentID);
            this.nativeComponentWrapper.disposeNativeComponent();
        }
    }

    @Override
    public boolean isNativePeerDisposed() {
        return this.isNativePeerDisposed;
    }

    @Override
    public boolean isNativePeerInitialized() {
        return this.isNativePeerInitialized;
    }

    @Override
    public boolean isNativePeerValid() {
        return this.isNativePeerValid && SWTNativeInterface.getInstance().isAlive();
    }

    private void invalidateNativePeer(String invalidNativePeerText) {
        if (this.isNativePeerValid) {
            this.isNativePeerValid = false;
            this.invalidNativePeerText = "Invalid " + this.getComponentDescription() + "\n\nReason:\n" + invalidNativePeerText;
            this.repaint();
        }
    }

    private String getComponentDescription() {
        return String.valueOf(this.getClass().getName()) + "[" + this.getComponentID() + "," + this.hashCode() + "]";
    }

    @Override
    public String toString() {
        return this.getComponentDescription();
    }

    @Override
    protected Component createEmbeddableComponent(Map<Object, Object> optionMap) {
        return this.nativeComponentWrapper.createEmbeddableComponent(optionMap);
    }

    private boolean isControlParentEnabled() {
        return this.isControlParentEnabled;
    }

    private void setControlParentEnabled(boolean isEnabled, boolean isForcingRepaint) {
        if (isEnabled == this.isControlParentEnabled) {
            return;
        }
        this.isControlParentEnabled = isEnabled;
        if (!this.isNativePeerInitialized() || this.isNativePeerValid()) {
            this.runAsync(new CMN_setControlParentEnabled(), isEnabled, isForcingRepaint);
        }
    }

    @Override
    public void setEnabled(boolean isEnabled) {
        super.setEnabled(isEnabled);
        this.runAsync(new CMN_setEnabled(), isEnabled);
    }

    @Override
    public boolean hasFocus() {
        boolean hasFocus = super.hasFocus();
        if (!hasFocus && this.isNativePeerValid() && !this.isNativePeerDisposed) {
            return Boolean.TRUE.equals(new CMN_hasFocus().syncExec(this, new Object[0]));
        }
        return hasFocus;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension result = null;
        if (this.isNativePeerValid() && !this.isNativePeerDisposed) {
            result = (Dimension)new CMN_getPreferredSize().syncExec(this, new Object[0]);
        }
        if (result == null) {
            result = super.getPreferredSize();
        }
        return result;
    }

    @Override
    public void paintComponent(BufferedImage image) {
        this.paintComponent(image, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(BufferedImage image, Rectangle[] rectangles) {
        if (image == null || !this.isNativePeerValid() || this.isNativePeerDisposed) {
            return;
        }
        this.applyPendingReshape();
        int width = Math.min(this.getWidth(), image.getWidth());
        int height = Math.min(this.getHeight(), image.getHeight());
        if (width <= 0 || height <= 0) {
            return;
        }
        if (rectangles == null) {
            rectangles = new Rectangle[]{new Rectangle(width, height)};
        }
        Rectangle bounds = new Rectangle(width, height);
        ArrayList<Rectangle> rectangleList = new ArrayList<Rectangle>();
        Rectangle[] rectangleArray = rectangles;
        int n = rectangles.length;
        int n2 = 0;
        while (n2 < n) {
            Rectangle rectangle = rectangleArray[n2];
            if (rectangle.intersects(bounds)) {
                rectangleList.add(rectangle.intersection(bounds));
            }
            ++n2;
        }
        if (rectangleList.isEmpty()) {
            return;
        }
        rectangles = rectangleList.toArray(new Rectangle[0]);
        try {
            final ServerSocket serverSocket = new ServerSocket();
            serverSocket.setReuseAddress(false);
            String localHostAddress = Utils.getLocalHostAddress();
            if (localHostAddress == null) {
                localHostAddress = "127.0.0.1";
            }
            serverSocket.bind(new InetSocketAddress(InetAddress.getByName(localHostAddress), 0));
            NativeInterfaceAdapter nativeInterfaceListener = new NativeInterfaceAdapter(){

                public void nativeInterfaceClosed() {
                    NativeInterface.removeNativeInterfaceListener(this);
                    try {
                        serverSocket.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            };
            CMN_getComponentImage getComponentImage = new CMN_getComponentImage();
            NativeInterface.addNativeInterfaceListener(nativeInterfaceListener);
            final AtomicReference<Boolean> isServerSocketToBeClosed = new AtomicReference<Boolean>(true);
            if (Boolean.parseBoolean(NSSystemPropertySWT.COMPONENTS_USECOMPONENTIMAGECLOSINGTHREAD.get())) {
                new Thread("NativeSwing[" + SWTNativeInterface.getInstance().getInterfaceID(false) + "] Component Image Socket Closing"){

                    public void run() {
                        int i = 0;
                        while (i < 50) {
                            if (!((Boolean)isServerSocketToBeClosed.get()).booleanValue()) {
                                return;
                            }
                            try {
                                14.sleep(100L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            ++i;
                        }
                        if (((Boolean)isServerSocketToBeClosed.get()).booleanValue()) {
                            try {
                                serverSocket.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                }.start();
            }
            getComponentImage.asyncExec(this, serverSocket.getLocalPort(), rectangles, localHostAddress);
            Socket socket = serverSocket.accept();
            isServerSocketToBeClosed.set(false);
            byte[] bytes = new byte[3072];
            int count = 0;
            int readCount = 0;
            try {
                BufferedInputStream in = new BufferedInputStream(socket.getInputStream());
                BufferedImage bufferedImage = image;
                synchronized (bufferedImage) {
                    Rectangle[] rectangleArray2 = rectangles;
                    int n3 = rectangles.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Rectangle rectangle = rectangleArray2[n4];
                        int[] pixels = new int[rectangle.width];
                        int y = 0;
                        while (y < rectangle.height && readCount != -1) {
                            int x = 0;
                            while (x < rectangle.width && readCount != -1) {
                                int itCount = 0;
                                while (readCount != -1 && (readCount == 0 || readCount % 3 != 0)) {
                                    int c;
                                    if (itCount++ == 1000) {
                                        readCount = -1;
                                    }
                                    if ((c = in.read(bytes, readCount, bytes.length - readCount)) == -1) {
                                        readCount = -1;
                                        continue;
                                    }
                                    readCount += c;
                                }
                                if (readCount == -1) break;
                                pixels[x] = 0xFF000000 | (0xFF & bytes[count]) << 16 | (0xFF & bytes[count + 1]) << 8 | 0xFF & bytes[count + 2];
                                if ((count += 3) == readCount) {
                                    count = 0;
                                    readCount = 0;
                                }
                                ++x;
                            }
                            if (readCount != -1) {
                                image.setRGB(rectangle.x, rectangle.y + y, rectangle.width, 1, pixels, 0, rectangle.width);
                            }
                            ++y;
                        }
                        if (readCount == -1) break;
                        ++n4;
                    }
                }
                NativeInterface.removeNativeInterfaceListener(nativeInterfaceListener);
                in.close();
                socket.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            serverSocket.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void storeInHiddenParent() {
        this.isStoredInHiddenParent = true;
        this.runSync(new CMN_reparentToHiddenShell(), this.componentID, this.getHandle());
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void restoreFromHiddenParent() {
        block4: {
            if (!this.isDisplayable()) {
                this.isStoredInHiddenParent = false;
                return;
            }
            try {
                this.runSync(new CMN_createControl(), new Object[]{this.componentID, this.getHandle()});
                new CMN_reshape().asyncExec(this, new Object[]{this.getWidth(), this.getHeight()});
                break block4;
            }
            catch (Exception e) {
                sb = new StringBuilder();
                t /* !! */  = e;
                ** while (t /* !! */  != null)
            }
lbl-1000:
            // 1 sources

            {
                sb.append("    " + t /* !! */ .toString() + "\n");
                t /* !! */  = t /* !! */ .getCause();
                continue;
            }
lbl17:
            // 1 sources

            this.invalidateNativePeer("Failed to reparent " + this.getComponentDescription() + "\n\nReason:\n" + sb.toString());
            e.printStackTrace();
        }
        this.isStoredInHiddenParent = false;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(0, 0);
    }

    @Override
    public void createBackBuffer() {
        this.nativeComponentWrapper.createBackBuffer();
    }

    @Override
    public boolean hasBackBuffer() {
        return this.nativeComponentWrapper.hasBackBuffer();
    }

    @Override
    public void updateBackBufferOnVisibleTranslucentAreas() {
        this.nativeComponentWrapper.updateBackBufferOnVisibleTranslucentAreas();
    }

    @Override
    public void updateBackBuffer(Rectangle[] rectangles) {
        this.nativeComponentWrapper.updateBackBuffer(rectangles);
    }

    @Override
    public void destroyBackBuffer() {
        this.nativeComponentWrapper.destroyBackBuffer();
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        EventListener[] result = this.listenerList.getListeners(listenerType);
        if (result.length == 0) {
            return super.getListeners(listenerType);
        }
        return result;
    }

    @Override
    public java.awt.Point getLocationOnScreen() {
        Container parent = this.getParent();
        if (parent != null) {
            java.awt.Point locationOnScreen = parent.getLocationOnScreen();
            locationOnScreen.x += this.getX();
            locationOnScreen.y += this.getY();
            return locationOnScreen;
        }
        return super.getLocationOnScreen();
    }

    private static class CKeyEvent
    extends java.awt.event.KeyEvent {
        public CKeyEvent(Component source, int id, long when, int modifiers, int keyCode, char keyChar) {
            super(source, id, when, modifiers, keyCode, keyChar);
        }

        public String toString() {
            String srcName = null;
            if (this.source instanceof Component) {
                srcName = ((Component)this.source).getName();
            } else if (this.source instanceof MenuComponent) {
                srcName = ((MenuComponent)this.source).getName();
            }
            return String.valueOf(java.awt.event.KeyEvent.class.getName()) + "[" + this.paramString() + "] on " + (srcName != null ? srcName : this.source);
        }
    }

    private static class CMJ_dispatchKeyEvent
    extends ControlCommandMessage {
        private CMJ_dispatchKeyEvent() {
        }

        public Object run(Object[] args) {
            int keyCode;
            NativeComponent nativeComponent = this.getNativeComponent();
            if (nativeComponent == null || !nativeComponent.isShowing()) {
                return null;
            }
            int type = (Integer)args[0];
            int e_stateMask = (Integer)args[1];
            char e_character = ((Character)args[2]).charValue();
            int e_keyCode = (Integer)args[3];
            if (e_keyCode == 9) {
                if (type == 401 && (e_stateMask & 0x40000) != 0) {
                    boolean isForward = (e_stateMask & 0x20000) == 0;
                    ((SWTNativeComponent)nativeComponent).nativeComponentWrapper.transferFocus(!isForward);
                }
                return null;
            }
            char character = e_character;
            if (type == 400) {
                if (character == '\u0000') {
                    return null;
                }
                keyCode = 0;
            } else {
                keyCode = SWTUtils.translateSWTKeyCode(e_keyCode);
            }
            CKeyEvent ke = new CKeyEvent(nativeComponent, type, System.currentTimeMillis(), SWTUtils.translateSWTModifiers(e_stateMask), keyCode, character);
            nativeComponent.dispatchEvent(ke);
            return null;
        }
    }

    private static class CMJ_dispatchMouseEvent
    extends ControlCommandMessage {
        private static int buttonPressedCount;

        private CMJ_dispatchMouseEvent() {
        }

        public Object run(Object[] args) {
            boolean isPopupTrigger;
            MouseEvent me;
            NativeComponent nativeComponent = this.getNativeComponent();
            if (nativeComponent == null || !nativeComponent.isShowing()) {
                return null;
            }
            int type = (Integer)args[0];
            int e_x = (Integer)args[1];
            int e_y = (Integer)args[2];
            int e_button = (Integer)args[3];
            int e_count = (Integer)args[4];
            int e_stateMask = (Integer)args[5];
            Point e_cursorLocation = (Point)args[6];
            switch (type) {
                case 501: {
                    ++buttonPressedCount;
                    break;
                }
                case 502: {
                    if (--buttonPressedCount >= 0) break;
                    buttonPressedCount = 0;
                    break;
                }
            }
            int button = SWTUtils.translateSWTMouseButton(e_button);
            if (button == 0) {
                switch (type) {
                    case 500: 
                    case 501: 
                    case 502: {
                        return null;
                    }
                }
            }
            if (buttonPressedCount != 0 && type == 503) {
                type = 506;
            }
            if (Utils.IS_JAVA_6_OR_GREATER) {
                if (type == 507) {
                    me = new MouseWheelEvent(nativeComponent, type, System.currentTimeMillis(), SWTUtils.translateSWTModifiers(e_stateMask), e_x, e_y, e_cursorLocation.x, e_cursorLocation.y, 0, false, 0, Math.abs(e_count), e_count < 0 ? 1 : -1);
                } else {
                    isPopupTrigger = type == 502 && button == 3;
                    me = new MouseEvent(nativeComponent, type, System.currentTimeMillis(), SWTUtils.translateSWTModifiers(e_stateMask), e_x, e_y, e_cursorLocation.x, e_cursorLocation.y, e_count, isPopupTrigger, button);
                }
            } else if (type == 507) {
                me = new MouseWheelEvent((Component)nativeComponent, type, System.currentTimeMillis(), SWTUtils.translateSWTModifiers(e_stateMask), e_x, e_y, 0, false, 0, Math.abs(e_count), e_count < 0 ? 1 : -1);
            } else {
                isPopupTrigger = type == 502 && button == 3;
                me = new MouseEvent(nativeComponent, type, System.currentTimeMillis(), SWTUtils.translateSWTModifiers(e_stateMask), e_x, e_y, e_count, isPopupTrigger, button);
            }
            switch (me.getID()) {
                case 501: {
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                    MouseListener[] mouseListenerArray = nativeComponent.getMouseListeners();
                    int n = mouseListenerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MouseListener mouseListener = mouseListenerArray[n2];
                        mouseListener.mousePressed(me);
                        ++n2;
                    }
                    break;
                }
                case 502: {
                    MouseListener[] mouseListenerArray = nativeComponent.getMouseListeners();
                    int n = mouseListenerArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        MouseListener mouseListener = mouseListenerArray[n3];
                        mouseListener.mouseReleased(me);
                        ++n3;
                    }
                    break;
                }
                case 500: {
                    MouseListener[] mouseListenerArray = nativeComponent.getMouseListeners();
                    int n = mouseListenerArray.length;
                    int n4 = 0;
                    while (n4 < n) {
                        MouseListener mouseListener = mouseListenerArray[n4];
                        mouseListener.mouseClicked(me);
                        ++n4;
                    }
                    break;
                }
                case 504: {
                    MouseListener[] mouseListenerArray = nativeComponent.getMouseListeners();
                    int n = mouseListenerArray.length;
                    int n5 = 0;
                    while (n5 < n) {
                        MouseListener mouseListener = mouseListenerArray[n5];
                        mouseListener.mouseEntered(me);
                        ++n5;
                    }
                    break;
                }
                case 505: {
                    MouseListener[] mouseListenerArray = nativeComponent.getMouseListeners();
                    int n = mouseListenerArray.length;
                    int n6 = 0;
                    while (n6 < n) {
                        MouseListener mouseListener = mouseListenerArray[n6];
                        mouseListener.mouseExited(me);
                        ++n6;
                    }
                    break;
                }
                case 503: {
                    MouseMotionListener[] mouseMotionListenerArray = nativeComponent.getMouseMotionListeners();
                    int n = mouseMotionListenerArray.length;
                    int n7 = 0;
                    while (n7 < n) {
                        MouseMotionListener mouseListener = mouseMotionListenerArray[n7];
                        mouseListener.mouseMoved(me);
                        ++n7;
                    }
                    break;
                }
                case 506: {
                    MouseMotionListener[] mouseMotionListenerArray = nativeComponent.getMouseMotionListeners();
                    int n = mouseMotionListenerArray.length;
                    int n8 = 0;
                    while (n8 < n) {
                        MouseMotionListener mouseListener = mouseMotionListenerArray[n8];
                        mouseListener.mouseDragged(me);
                        ++n8;
                    }
                    break;
                }
                case 507: {
                    MouseWheelListener[] mouseWheelListenerArray = nativeComponent.getMouseWheelListeners();
                    int n = mouseWheelListenerArray.length;
                    int n9 = 0;
                    while (n9 < n) {
                        MouseWheelListener mouseListener = mouseWheelListenerArray[n9];
                        mouseListener.mouseWheelMoved((MouseWheelEvent)me);
                        ++n9;
                    }
                    break;
                }
            }
            return null;
        }
    }

    private class CMLocal_runInSequence
    extends LocalMessage {
        private CMLocal_runInSequence() {
        }

        public Object run(Object[] args) {
            ((Runnable)args[0]).run();
            return null;
        }
    }

    private static class CMN_createControl
    extends CommandMessage
    implements NoSerializationTestMessage {
        private CMN_createControl() {
        }

        private static Shell createShell(Object handle) throws Exception {
            SWTNativeInterface nativeInterface = SWTNativeInterface.getInstance();
            Display display = nativeInterface.getDisplay();
            if (nativeInterface.isInProcess_()) {
                ComponentListener componentListener;
                Canvas canvas = (Canvas)handle;
                ComponentListener[] componentListeners = canvas.getComponentListeners();
                Shell shell = SWT_AWT.new_Shell(display, canvas);
                ComponentListener[] componentListenerArray = canvas.getComponentListeners();
                int n = componentListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    componentListener = componentListenerArray[n2];
                    canvas.removeComponentListener(componentListener);
                    ++n2;
                }
                componentListenerArray = componentListeners;
                n = componentListeners.length;
                n2 = 0;
                while (n2 < n) {
                    componentListener = componentListenerArray[n2];
                    canvas.addComponentListener(componentListener);
                    ++n2;
                }
                return shell;
            }
            Method shellCreationMethod = null;
            try {
                shellCreationMethod = Shell.class.getMethod(String.valueOf(SWT.getPlatform()) + "_new", Display.class, Integer.TYPE);
            }
            catch (Exception componentListeners) {
                // empty catch block
            }
            if (shellCreationMethod != null) {
                return (Shell)shellCreationMethod.invoke(null, display, ((Number)handle).intValue());
            }
            try {
                shellCreationMethod = Shell.class.getMethod(String.valueOf(SWT.getPlatform()) + "_new", Display.class, Long.TYPE);
            }
            catch (Exception componentListeners) {
                // empty catch block
            }
            if (shellCreationMethod != null) {
                return (Shell)shellCreationMethod.invoke(null, display, ((Number)handle).longValue());
            }
            Constructor shellConstructor = null;
            try {
                shellConstructor = Shell.class.getConstructor(Display.class, Shell.class, Integer.TYPE, Integer.TYPE);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (shellConstructor != null) {
                shellConstructor.setAccessible(true);
                return (Shell)shellConstructor.newInstance(display, null, 8, ((Number)handle).intValue());
            }
            try {
                shellConstructor = Shell.class.getConstructor(Display.class, Shell.class, Integer.TYPE, Long.TYPE);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (shellConstructor != null) {
                shellConstructor.setAccessible(true);
                return (Shell)shellConstructor.newInstance(display, null, 8, ((Number)handle).longValue());
            }
            throw new IllegalStateException("Failed to create a Shell!");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object run(Object[] args) throws Exception {
            ObjectRegistry controlRegistry;
            ObjectRegistry objectRegistry = controlRegistry = SWTNativeComponent.getControlRegistry();
            synchronized (objectRegistry) {
                final int componentID = (Integer)args[0];
                Object canvasHandle = args[1];
                final Shell shell = CMN_createControl.createShell(canvasHandle);
                shell.addControlListener(new ControlAdapter(){
                    private boolean isAdjusting;

                    public void controlMoved(ControlEvent e) {
                        if (this.isAdjusting) {
                            return;
                        }
                        Shell shell = (Shell)e.widget;
                        Point location = shell.getLocation();
                        if (location.x != 0 || location.y != 0) {
                            this.isAdjusting = true;
                            shell.setLocation(0, 0);
                            this.isAdjusting = false;
                        }
                    }
                });
                shell.setLayout(new FillLayout());
                Composite controlComposite = new Composite(shell, 0);
                controlComposite.setLayout(new FillLayout());
                Control control = (Control)controlRegistry.get(componentID);
                if (control != null) {
                    Shell oldShell = control.getShell();
                    control.setParent(controlComposite);
                    oldShell.dispose();
                } else {
                    String nativeComponentClassName = (String)args[2];
                    Object nativePeerCreationParameters = args[3];
                    Method createControlMethod = Class.forName(nativeComponentClassName).getDeclaredMethod("createControl", Composite.class, Object[].class);
                    createControlMethod.setAccessible(true);
                    control = (Control)createControlMethod.invoke(null, controlComposite, nativePeerCreationParameters);
                    if (Boolean.parseBoolean(NSSystemPropertySWT.COMPONENTS_DEBUG_PRINTCREATION.get())) {
                        System.err.println("Created control: " + componentID);
                    }
                    control.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            if (Boolean.parseBoolean(NSSystemPropertySWT.COMPONENTS_DEBUG_PRINTDISPOSAL.get())) {
                                System.err.println("Disposed control: " + componentID);
                            }
                        }
                    });
                    controlRegistry.add(control, componentID);
                    SWTNativeComponent.configureControl(control, componentID);
                }
                shell.setVisible(true);
                shell.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        if (!shell.isDisposed()) {
                            shell.setLocation(0, 0);
                        }
                    }
                });
            }
            return null;
        }
    }

    private static class CMN_destroyControl
    extends ControlCommandMessage {
        private CMN_destroyControl() {
        }

        public Object run(Object[] args) {
            Control control = this.getControl();
            SWTNativeComponent.getControlRegistry().remove(this.getComponentID());
            if (control != null) {
                Shell shell = control.getShell();
                if (shell != null) {
                    shell.dispose();
                }
                control.dispose();
            }
            return null;
        }
    }

    private static class CMN_getComponentImage
    extends ControlCommandMessage {
        private CMN_getComponentImage() {
        }

        protected boolean isValid() {
            return true;
        }

        private static boolean printRemoveClip(Control control, GC gc) {
            boolean isFocusControl = control.isFocusControl();
            org.eclipse.swt.graphics.Rectangle bounds = control.getBounds();
            Display display = control.getDisplay();
            Composite oldParent = control.getParent();
            Shell tmpHiddenParentShell = new Shell(786440);
            Shell tmpParentShell = new Shell(tmpHiddenParentShell, 786440);
            Point location = display.map(control, null, control.getLocation());
            tmpParentShell.setLocation(location);
            tmpParentShell.setSize(bounds.width, bounds.height);
            org.eclipse.swt.widgets.Canvas screenshotCanvas = new org.eclipse.swt.widgets.Canvas(tmpParentShell, 262144);
            screenshotCanvas.setSize(bounds.width, bounds.height);
            GC displayGC = new GC((Drawable)display);
            final Image screenshot = new Image((Device)display, bounds.width, bounds.height);
            displayGC.copyArea(screenshot, location.x, location.y);
            displayGC.dispose();
            PaintListener paintListener = new PaintListener(){

                public void paintControl(PaintEvent e) {
                    e.gc.drawImage(screenshot, 0, 0);
                }
            };
            tmpParentShell.addPaintListener(paintListener);
            screenshotCanvas.addPaintListener(paintListener);
            oldParent.addPaintListener(paintListener);
            org.eclipse.swt.widgets.Canvas controlReplacementCanvas = new org.eclipse.swt.widgets.Canvas(oldParent, 262144);
            controlReplacementCanvas.setSize(bounds.width, bounds.height);
            controlReplacementCanvas.addPaintListener(paintListener);
            control.setRedraw(false);
            oldParent.setRedraw(false);
            control.setParent(tmpParentShell);
            control.setLocation(0, 0);
            control.moveBelow(screenshotCanvas);
            tmpParentShell.setVisible(true);
            boolean result = control.print(gc);
            if (oldParent.isDisposed()) {
                control.dispose();
            } else {
                control.setParent(oldParent);
                if (isFocusControl && !control.isFocusControl()) {
                    control.setFocus();
                }
                control.setLocation(bounds.x, bounds.y);
                control.moveAbove(controlReplacementCanvas);
                controlReplacementCanvas.dispose();
                oldParent.removePaintListener(paintListener);
                tmpParentShell.dispose();
                tmpHiddenParentShell.dispose();
                oldParent.setRedraw(true);
                control.setRedraw(true);
                control.redraw();
                control.update();
                screenshot.dispose();
            }
            return result;
        }

        private ImageData getImageData(Control control, Region region) {
            if (control.isDisposed()) {
                return null;
            }
            Point size = control.getSize();
            if (size.x <= 0 || size.y <= 0) {
                return null;
            }
            org.eclipse.swt.graphics.Rectangle regionBounds = region.getBounds();
            Display display = control.getDisplay();
            Image image = new Image((Device)display, regionBounds.x + regionBounds.width, regionBounds.y + regionBounds.height);
            GC gc = new GC(image);
            gc.setClipping(region);
            if (Boolean.parseBoolean(NSSystemPropertySWT.COMPONENTS_PRINTINGHACK.get())) {
                CMN_getComponentImage.printRemoveClip(control, gc);
            } else if (Utils.IS_WINDOWS) {
                org.eclipse.swt.graphics.Rectangle bounds = control.getBounds();
                boolean isFocusControl = control.isFocusControl();
                Composite oldParent = control.getParent();
                control.setRedraw(false);
                oldParent.setRedraw(false);
                control.print(gc);
                if (isFocusControl && !control.isFocusControl()) {
                    control.setFocus();
                }
                control.setLocation(bounds.x, bounds.y);
                oldParent.setRedraw(true);
                control.setRedraw(true);
                control.redraw(0, 0, bounds.width, bounds.height, true);
                control.update();
            } else {
                control.print(gc);
            }
            gc.dispose();
            ImageData imageData = image.getImageData();
            image.dispose();
            return imageData;
        }

        public Object run(Object[] args) throws Exception {
            ImageData imageData;
            final int port = (Integer)args[0];
            Rectangle[] rectangles = (Rectangle[])args[1];
            final String hostAddress = (String)args[2];
            final Control control = this.getControl();
            final Region region = new Region();
            Rectangle[] rectangleArray = rectangles;
            int n = rectangles.length;
            int n2 = 0;
            while (n2 < n) {
                Rectangle rectangle = rectangleArray[n2];
                region.add(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                ++n2;
            }
            if (!NativeInterface.isUIThread(true)) {
                final AtomicReference exception = new AtomicReference();
                final AtomicReference result = new AtomicReference();
                if (control == null || control.isDisposed()) {
                    new Socket(hostAddress, port).close();
                    return null;
                }
                final AtomicReference<Boolean> isSocketClosed = new AtomicReference<Boolean>(false);
                control.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        if (control.isDisposed()) {
                            try {
                                new Socket(hostAddress, port).close();
                                isSocketClosed.set(true);
                            }
                            catch (Exception exception2) {
                                // empty catch block
                            }
                            return;
                        }
                        try {
                            result.set(CMN_getComponentImage.this.getImageData(control, region));
                        }
                        catch (Exception e) {
                            exception.set(e);
                        }
                    }
                });
                if (!isSocketClosed.get().booleanValue() && control.isDisposed()) {
                    new Socket(hostAddress, port).close();
                    return null;
                }
                if (exception.get() != null) {
                    new Socket(hostAddress, port).close();
                    throw (Exception)exception.get();
                }
                imageData = (ImageData)result.get();
            } else {
                imageData = this.getImageData(control, region);
            }
            region.dispose();
            if (imageData == null) {
                new Socket(hostAddress, port).close();
                return null;
            }
            this.sendImageData(hostAddress, port, imageData, rectangles);
            return null;
        }

        private void sendImageData(final String hostAddress, final int port, final ImageData imageData, final Rectangle[] rectangles) {
            if (NativeInterface.isUIThread(true)) {
                new Thread("NativeSwing[" + SWTNativeInterface.getInstance().getInterfaceID(true) + "] Component Image Data Transfer"){

                    public void run() {
                        CMN_getComponentImage.this.sendImageData(hostAddress, port, imageData, rectangles);
                    }
                }.start();
                return;
            }
            int cursor = 0;
            byte[] bytes = new byte[3072];
            PaletteData palette = imageData.palette;
            Socket socket = null;
            FilterOutputStream out = null;
            int width = imageData.width;
            int height = imageData.height;
            try {
                socket = new Socket(hostAddress, port);
                out = new BufferedOutputStream(socket.getOutputStream());
                Rectangle[] rectangleArray = rectangles;
                int n = rectangles.length;
                int n2 = 0;
                while (n2 < n) {
                    Rectangle rectangle = rectangleArray[n2];
                    int j = 0;
                    while (j < rectangle.height) {
                        int y = rectangle.y + j;
                        int i = 0;
                        while (i < rectangle.width) {
                            int x = rectangle.x + i;
                            if (x < width && y < height) {
                                int pixel = imageData.getPixel(x, y);
                                if (palette.isDirect) {
                                    int red = pixel & palette.redMask;
                                    bytes[cursor++] = (byte)(palette.redShift < 0 ? red >>> -palette.redShift : red << palette.redShift);
                                    int green = pixel & palette.greenMask;
                                    bytes[cursor++] = (byte)(palette.greenShift < 0 ? green >>> -palette.greenShift : green << palette.greenShift);
                                    int blue = pixel & palette.blueMask;
                                    bytes[cursor++] = (byte)(palette.blueShift < 0 ? blue >>> -palette.blueShift : blue << palette.blueShift);
                                } else {
                                    RGB rgb = palette.colors[pixel];
                                    bytes[cursor++] = (byte)rgb.red;
                                    bytes[cursor++] = (byte)rgb.green;
                                    bytes[cursor++] = (byte)rgb.blue;
                                }
                            } else {
                                cursor += 3;
                            }
                            if (cursor == bytes.length) {
                                out.write(bytes);
                                cursor = 0;
                            }
                            ++i;
                        }
                        ++j;
                    }
                    ++n2;
                }
                ((BufferedOutputStream)out).write(bytes, 0, cursor);
                ((BufferedOutputStream)out).flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (socket != null) {
                    socket.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class CMN_getPreferredSize
    extends ControlCommandMessage {
        private CMN_getPreferredSize() {
        }

        public Object run(Object[] args) {
            Control control = this.getControl();
            if (control.isDisposed()) {
                return null;
            }
            Point cSize = control.computeSize(-1, -1);
            return new Dimension(cSize.x, cSize.y);
        }
    }

    private static class CMN_hasFocus
    extends ControlCommandMessage {
        private CMN_hasFocus() {
        }

        public Object run(Object[] args) {
            final Control control = this.getControl();
            if (control.isDisposed()) {
                return false;
            }
            if (!NativeInterface.isUIThread(true)) {
                final AtomicBoolean result = new AtomicBoolean();
                control.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        result.set(control.isDisposed() ? false : control.isFocusControl());
                    }
                });
                return result.get();
            }
            return control.isFocusControl();
        }
    }

    private static class CMN_redraw
    extends ControlCommandMessage {
        private CMN_redraw() {
        }

        public Object run(Object[] args) {
            Control control = this.getControl();
            if (control.isDisposed()) {
                return null;
            }
            Point size = control.getSize();
            control.redraw(0, 0, size.x, size.y, true);
            return null;
        }
    }

    private static class CMN_reparentToHiddenShell
    extends ControlCommandMessage {
        private CMN_reparentToHiddenShell() {
        }

        public Object run(Object[] args) {
            Control control = this.getControl();
            Shell shell = control.getShell();
            Shell newShell = new Shell(control.getDisplay(), 0);
            control.getParent().setParent(newShell);
            shell.dispose();
            return null;
        }
    }

    private static class CMN_reshape
    extends ControlCommandMessage {
        private CMN_reshape() {
        }

        public Object run(Object[] args) {
            Shell shell = this.getControl().getShell();
            if (!shell.isDisposed()) {
                shell.setSize((Integer)args[0], (Integer)args[1]);
            }
            return null;
        }
    }

    private static class CMN_setControlParentEnabled
    extends ControlCommandMessage {
        private CMN_setControlParentEnabled() {
        }

        public Object run(Object[] args) {
            final Control control = this.getControl();
            if (control == null || control.isDisposed()) {
                return null;
            }
            control.getShell().setEnabled((Boolean)args[0]);
            if (((Boolean)args[1]).booleanValue()) {
                Point size = control.getParent().getSize();
                --size.y;
                control.setSize(size);
                Thread t = new Thread("Native Swing Repaint fix"){

                    public void run() {
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (control.isDisposed()) {
                            return;
                        }
                        control.getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                if (control.isDisposed()) {
                                    return;
                                }
                                control.setSize(control.getParent().getSize());
                            }
                        });
                    }
                };
                t.setDaemon(true);
                t.start();
            }
            return null;
        }
    }

    private static class CMN_setEnabled
    extends ControlCommandMessage {
        private CMN_setEnabled() {
        }

        public Object run(Object[] args) {
            this.getControl().setEnabled((Boolean)args[0]);
            return null;
        }
    }

    private static class CMN_setEventsEnabled
    extends ControlCommandMessage {
        private CMN_setEventsEnabled() {
        }

        public Object run(Object[] args) {
            long eventMask = (Long)args[0];
            boolean isEnabled = (Boolean)args[1];
            long events = (Long)this.getControl().getData("NS_EnabledEventsMask");
            events = isEnabled ? (events |= eventMask) : (events &= eventMask ^ 0xFFFFFFFFFFFFFFFFL);
            this.getControl().setData("NS_EnabledEventsMask", events);
            return null;
        }
    }

    private static class CMN_transferFocus
    extends ControlCommandMessage {
        private CMN_transferFocus() {
        }

        public Object run(Object[] args) {
            this.getControl().traverse(16);
            return null;
        }
    }

    private static class DnDHandler {
        private static boolean isDnDActive;
        private static DnDHandler dndHandler;
        private SWTNativeComponent[] nativeComponents;
        private boolean[] wereEnabled;

        private DnDHandler() {
        }

        private static void activateDragAndDrop() {
            if (isDnDActive) {
                return;
            }
            isDnDActive = true;
            DragSource dragSource = DragSource.getDefaultDragSource();
            DragSourceAdapter dragSourceListener = new DragSourceAdapter(){

                public void dragEnter(DragSourceDragEvent dsde) {
                    this.processDragSourceEvent(dsde);
                }

                public void dragMouseMoved(DragSourceDragEvent dsde) {
                    this.processDragSourceEvent(dsde);
                }

                private void processDragSourceEvent(DragSourceDragEvent dsde) {
                    if (dndHandler != null) {
                        return;
                    }
                    dndHandler = new DnDHandler();
                    ArrayList<NativeComponent> nativeComponentList = new ArrayList<NativeComponent>();
                    NativeComponent[] nativeComponentArray = SWTNativeComponent.getNativeComponents();
                    int n = nativeComponentArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        NativeComponent nativeComponent = nativeComponentArray[n2];
                        DropTarget dropTarget = nativeComponent.getDropTarget();
                        if (dropTarget != null && dropTarget.isActive()) {
                            nativeComponentList.add(nativeComponent);
                        }
                        ++n2;
                    }
                    SWTNativeComponent[] nativeComponents = nativeComponentList.toArray(new SWTNativeComponent[0]);
                    boolean[] wereEnabled = new boolean[nativeComponents.length];
                    int i = 0;
                    while (i < nativeComponents.length) {
                        SWTNativeComponent nativeComponent = nativeComponents[i];
                        wereEnabled[i] = nativeComponent.isControlParentEnabled;
                        nativeComponent.setControlParentEnabled(false, false);
                        ++i;
                    }
                    dndHandler.nativeComponents = nativeComponents;
                    dndHandler.wereEnabled = wereEnabled;
                }

                public void dragDropEnd(DragSourceDropEvent dsde) {
                    SWTNativeComponent[] nativeComponents = dndHandler.nativeComponents;
                    boolean[] wereEnabled = dndHandler.wereEnabled;
                    int i = 0;
                    while (i < nativeComponents.length) {
                        SWTNativeComponent nativeComponent = nativeComponents[i];
                        if (wereEnabled[i]) {
                            nativeComponent.setControlParentEnabled(true, false);
                        }
                        ++i;
                    }
                    dndHandler = null;
                }
            };
            dragSource.addDragSourceMotionListener(dragSourceListener);
            dragSource.addDragSourceListener(dragSourceListener);
        }
    }

    private static class NNativeInterfaceListener
    extends NativeInterfaceAdapter {
        protected Reference<SWTNativeComponent> nativeComponent;

        protected NNativeInterfaceListener(SWTNativeComponent nativeComponent) {
            this.nativeComponent = new WeakReference<SWTNativeComponent>(nativeComponent);
        }

        public void nativeInterfaceClosed() {
            NativeInterface.removeNativeInterfaceListener(this);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SWTNativeComponent nativeComponent = NNativeInterfaceListener.this.nativeComponent.get();
                    if (nativeComponent == null) {
                        return;
                    }
                    nativeComponent.invalidateNativePeer("The native peer died unexpectedly.");
                    nativeComponent.repaint();
                }
            });
        }
    }
}

