/*
 * Decompiled with CFR 0.152.
 */
package com.Weibo;

import com.Weibo.AccessTokenDao;
import com.Weibo.Oauth2Code;
import com.Weibo.WeiboConstants;
import com.Weibo.WeiboPanel;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import weibo4j.Favorite;
import weibo4j.Timeline;
import weibo4j.model.Paging;
import weibo4j.model.Status;
import weibo4j.model.StatusWapper;
import weibo4j.model.WeiboException;

public class AutoFun
extends WeiboPanel {
    private static final long serialVersionUID = 4495383955936263400L;
    private static JButton start;
    private JTextPane textPane;
    private JTextPane statusCOUNT;
    private static JTextField CategoryKey;
    private static JTextField TagsKey;
    private static JTextField SummaryKey;
    private static JRadioButton Category;
    private static JRadioButton Tags;
    private static JRadioButton Summary;
    private static int SELECTED;
    private int locX;
    private int locY;
    private Timer timer;
    private Date minTime = null;
    private int currentCOUNT = 0;
    private int totalCOUNT = 0;
    private int COUNT = 0;
    private boolean isRunning = false;
    Timeline tl = new Timeline();
    StatusWapper statusWapper = null;

    static {
        SELECTED = 1;
    }

    public AutoFun() {
        this.setLayout(null);
        this.setBackground(new Color(240, 240, 240));
        this.tl.client.setToken(AccessTokenDao.read());
        this.initTextPane();
        this.initRadioButton();
        this.initButtonAndText();
    }

    @Override
    public void run() {
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (SELECTED == 1) {
                    AutoFun.this.RepostAndFav(CategoryKey.getText(), "Category");
                } else if (SELECTED == 2) {
                    AutoFun.this.RepostAndFav(TagsKey.getText(), "Tags");
                } else if (SELECTED == 3) {
                    AutoFun.this.RepostAndFav(SummaryKey.getText(), "Summary");
                }
            }
        }, 0L, 20000L);
    }

    private void initTextPane() {
        this.textPane = new JTextPane();
        this.textPane.setText("\u81ea\u52a8\u6536\u85cf\u4e0e\u8f6c\u53d1\u529f\u80fd\n\t\u9009\u5b9a\u7c7b\u522b\u5e76\u8f93\u5165\u5173\u952e\u5b57\uff0c\u70b9\u51fb\u786e\u5b9a\u5f00\u59cb\u76d1\u63a7\n\t\u7cfb\u7edf\u4f1a\u81ea\u52a8\u4e3a\u60a8\u8f6c\u53d1\u5e76\u6536\u85cf\u7b26\u5408\u6761\u4ef6\u7684Web API\u76f8\u5173\u5fae\u535a");
        this.textPane.setLocation(0, 0);
        this.textPane.setEditable(false);
        this.textPane.setFont(WeiboConstants.DEFAULT_FONT);
        this.textPane.setSize(485, this.textPane.getPreferredSize().height);
        this.locY = (int)this.textPane.getPreferredSize().getHeight() + 10;
        this.add(this.textPane);
    }

    private void initRadioButton() {
        Category = new JRadioButton("Category", true);
        Category.setLocation(40, this.locY);
        Category.setSize(Category.getPreferredSize());
        this.add(Category);
        JLabel KeyLabel1 = new JLabel("\u5173\u952e\u5b57:");
        KeyLabel1.setFont(WeiboConstants.DEFAULT_FONT);
        KeyLabel1.setLocation(170, this.locY);
        KeyLabel1.setSize(KeyLabel1.getPreferredSize());
        this.add(KeyLabel1);
        this.locX = 170 + (int)KeyLabel1.getPreferredSize().getWidth();
        CategoryKey = new JTextField();
        CategoryKey.setToolTipText("\u8f93\u5165\u5173\u952e\u5b57");
        CategoryKey.setBounds(this.locX, this.locY - 4, 80, 30);
        this.add(CategoryKey);
        this.locY += (int)Category.getPreferredSize().getHeight() + 10;
        Tags = new JRadioButton("Tags");
        Tags.setLocation(40, this.locY);
        Tags.setSize(Tags.getPreferredSize());
        this.add(Tags);
        JLabel KeyLabel2 = new JLabel("\u5173\u952e\u5b57:");
        KeyLabel2.setFont(WeiboConstants.DEFAULT_FONT);
        KeyLabel2.setLocation(170, this.locY);
        KeyLabel2.setSize(KeyLabel2.getPreferredSize());
        this.add(KeyLabel2);
        TagsKey = new JTextField();
        TagsKey.setToolTipText("\u8f93\u5165\u5173\u952e\u5b57");
        TagsKey.setEditable(false);
        TagsKey.setBounds(this.locX, this.locY - 4, 80, 30);
        this.add(TagsKey);
        this.locY += (int)Tags.getPreferredSize().getHeight() + 10;
        Summary = new JRadioButton("Summary");
        Summary.setLocation(40, this.locY);
        Summary.setSize(Summary.getPreferredSize());
        this.add(Summary);
        JLabel KeyLabel3 = new JLabel("\u5173\u952e\u5b57:");
        KeyLabel3.setFont(WeiboConstants.DEFAULT_FONT);
        KeyLabel3.setLocation(170, this.locY);
        KeyLabel3.setSize(KeyLabel3.getPreferredSize());
        this.add(KeyLabel3);
        SummaryKey = new JTextField();
        SummaryKey.setToolTipText("\u8f93\u5165\u5173\u952e\u5b57");
        SummaryKey.setEditable(false);
        SummaryKey.setBounds(this.locX, this.locY - 4, 80, 30);
        this.add(SummaryKey);
        ButtonGroup group = new ButtonGroup();
        group.add(Category);
        group.add(Tags);
        group.add(Summary);
        Category.addItemListener(new RadioHandle());
        Tags.addItemListener(new RadioHandle());
        Summary.addItemListener(new RadioHandle());
        Category.addMouseListener(new MouseHandle());
        Tags.addMouseListener(new MouseHandle());
        Summary.addMouseListener(new MouseHandle());
    }

    private void initButtonAndText() {
        start = new JButton("\u5f00\u59cb\u76d1\u63a7");
        start.setFont(WeiboConstants.DEFAULT_FONT);
        start.setBounds(280, 180, 100, 40);
        this.add(start);
        this.statusCOUNT = new JTextPane();
        this.statusCOUNT.setText("\u7d2f\u8ba1\u4e3a\u60a8\u6536\u85cf\u5e76\u8f6c\u53d1\u4e86" + this.COUNT + "\u6761\u5fae\u535a");
        this.statusCOUNT.setFont(WeiboConstants.DEFAULT_FONT);
        this.statusCOUNT.setLocation(250, 230);
        this.statusCOUNT.setEditable(false);
        this.statusCOUNT.setSize(this.statusCOUNT.getPreferredSize());
        this.add(this.statusCOUNT);
        start.addActionListener(new ActionListener(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                if (AutoFun.this.isRunning) {
                    if (!AutoFun.this.isRunning) return;
                    AutoFun.this.isRunning = false;
                    start.setText("\u5f00\u59cb\u76d1\u63a7");
                    AutoFun.this.timer.cancel();
                    JOptionPane.showMessageDialog(Oauth2Code.getMainDialog(), "\u672c\u6b21\u76d1\u63a7\u4e3a\u60a8\u68c0\u7d22\u4e86" + AutoFun.this.currentCOUNT + "\u6761\u5fae\u535a,\n" + "\u5176\u4e2d\u6709" + AutoFun.this.totalCOUNT + "\u6761\u5fae\u535a\u7b26\u5408\u6761\u4ef6");
                    AutoFun.this.currentCOUNT = 0;
                    AutoFun.this.totalCOUNT = 0;
                    return;
                }
                if (SELECTED == 1 && CategoryKey.getText().trim().length() > 0 || SELECTED == 2 && TagsKey.getText().trim().length() > 0 || SELECTED == 3 && SummaryKey.getText().trim().length() > 0) {
                    AutoFun.this.minTime = new Date();
                    AutoFun.this.addList();
                    AutoFun.this.isRunning = true;
                    start.setText("\u505c\u6b62\u76d1\u63a7");
                    return;
                }
                JOptionPane.showMessageDialog(Oauth2Code.getMainDialog(), "\u5173\u952e\u5b57\u4e0d\u80fd\u4e3a\u7a7a", "\u9519\u8bef", 0);
            }
        });
        start.addMouseListener(new MouseHandle());
    }

    private void RepostAndFav(String text, String key) {
        try {
            this.statusWapper = this.tl.getFriendsTimeline((Integer)0, (Integer)0, new Paging(1));
        }
        catch (WeiboException e) {
            e.printStackTrace();
        }
        List<Status> list = this.statusWapper.getStatuses();
        int i = 0;
        while (i < list.size()) {
            Status status = list.get(i);
            if (this.minTime == null || !this.minTime.after(status.getCreatedAt()) || status.getUser() == Oauth2Code.getUser()) {
                System.out.println(i);
                ++this.currentCOUNT;
                if (status.getText().indexOf("Summary") >= 0) {
                    int SummaryLen = status.getText().indexOf("Category");
                    int indexOfTags = status.getText().indexOf("Tags");
                    String content = "";
                    if (key == "Summary") {
                        content = status.getText().substring(0, SummaryLen);
                    } else if (key == "Category") {
                        content = status.getText().substring(SummaryLen, indexOfTags);
                    } else if (key == "Tags") {
                        content = status.getText().substring(indexOfTags);
                    }
                    if (content.indexOf(text) != -1) {
                        this.repostAndSave(status);
                    }
                }
            }
            ++i;
        }
        this.minTime = list.get(0).getCreatedAt();
    }

    private void repostAndSave(Status status) {
        Favorite fv = new Favorite();
        fv.client.setToken(AccessTokenDao.read());
        Timeline tl = new Timeline();
        tl.client.setToken(AccessTokenDao.read());
        try {
            tl.Repost(status.getId());
            fv.createFavorites(status.getId());
            ++this.totalCOUNT;
            ++this.COUNT;
            this.statusCOUNT.setText("\u7d2f\u8ba1\u4e3a\u60a8\u6536\u85cf\u5e76\u8f6c\u53d1\u4e86" + this.COUNT + "\u6761\u5fae\u535a");
        }
        catch (WeiboException e) {
            e.printStackTrace();
        }
    }

    public static class MouseHandle
    implements MouseListener {
        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            e.getComponent().repaint();
            e.getComponent().setCursor(new Cursor(12));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            e.getComponent().repaint();
            e.getComponent().setCursor(new Cursor(0));
        }
    }

    static class RadioHandle
    implements ItemListener {
        RadioHandle() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == Category) {
                CategoryKey.setEditable(true);
                TagsKey.setEditable(false);
                SummaryKey.setEditable(false);
                SELECTED = 1;
            } else if (e.getSource() == Tags) {
                CategoryKey.setEditable(false);
                TagsKey.setEditable(true);
                SummaryKey.setEditable(false);
                SELECTED = 2;
            } else if (e.getSource() == Summary) {
                CategoryKey.setEditable(false);
                TagsKey.setEditable(false);
                SummaryKey.setEditable(true);
                SELECTED = 3;
            }
        }
    }
}

