/*
 * Decompiled with CFR 0.152.
 */
package com.Weibo;

import com.Weibo.AccessTokenDao;
import com.Weibo.OneComment;
import com.Weibo.WeiboPanel;
import java.awt.Component;
import java.util.List;
import javax.swing.JComboBox;
import weibo4j.Comments;
import weibo4j.model.Comment;
import weibo4j.model.CommentWapper;

public abstract class CommentPanel
extends WeiboPanel {
    private static final long serialVersionUID = -5705843038920688992L;
    protected static final String COMMENT = "\u6240\u6709\u7684\u8bc4\u8bba";
    protected static final String COMMENT_TO_ME = "\u6536\u5230\u7684\u8bc4\u8bba";
    protected static final String COMMENT_BY_ME = "\u53d1\u51fa\u7684\u8bc4\u8bba";
    protected Comments comments = new Comments();
    protected OneComment.CommentType type;
    protected JComboBox comboBox;
    protected Thread thread;

    protected CommentPanel() {
        this.comments.client.setToken(AccessTokenDao.read());
    }

    @Override
    public void run() {
        this.setLoading(true);
        if (this.page == 0) {
            this.page = 1;
        }
        if (this.page == 1 && this.type.equals((Object)OneComment.CommentType.MY_COMMENTS)) {
            if (this.comboBox == null) {
                this.initComboBox();
            }
            this.add((Component)this.comboBox, this.gbc);
            ++this.gbc.gridy;
        }
        List<Comment> list = this.getCommentWapper().getComments();
        int statusCount = list.size();
        int i = 0;
        while (i < statusCount) {
            Comment comment = list.get(i);
            long id = comment.getId();
            if (id != this.lastId) {
                this.lastId = id;
                OneComment onecomment = new OneComment(comment, this.type);
                this.add((Component)onecomment, this.gbc);
                this.getParent().validate();
                ++this.gbc.gridy;
            }
            ++i;
        }
        ++this.page;
        this.loading = false;
    }

    protected abstract CommentWapper getCommentWapper();

    protected void initComboBox() {
    }
}

