/*
 * Decompiled with CFR 0.152.
 */
package com.Weibo;

import com.Weibo.BMPLoader;
import java.awt.Image;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.imageio.ImageIO;

public class FileOperation {
    public static Image getImageByFile(File file) {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        return FileOperation.getImageByInputStream(in, FileOperation.getFileExtension(file.getName()));
    }

    public static String getFileExtension(String filename) {
        return filename.substring(filename.lastIndexOf(".") + 1).toLowerCase();
    }

    public static Image getImageByInputStream(FileInputStream fis, String fileExtension) {
        Image image = null;
        if (fileExtension.equals("bmp")) {
            image = BMPLoader.read(fis);
        } else {
            try {
                image = ImageIO.read(fis);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return image;
    }

    public static boolean isImageFile(String filename) {
        String[] imageExtension = new String[]{"bmp", "gif", "jpg", "jpeg", "png"};
        String fileExtension = FileOperation.getFileExtension(filename);
        int i = 0;
        while (i < imageExtension.length) {
            if (imageExtension[i].equals(fileExtension)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

