/*
 * Decompiled with CFR 0.152.
 */
package com.Weibo;

import com.Weibo.AutoFun;
import com.Weibo.FriendTimeline;
import com.Weibo.FriendsOrFollowers;
import com.Weibo.Mentions;
import com.Weibo.MyComment;
import com.Weibo.MyFavorites;
import com.Weibo.MyScrollPane;
import com.Weibo.Oauth2Code;
import com.Weibo.OneUser;
import com.Weibo.PersonInform;
import com.Weibo.SearchUserORStatus;
import com.Weibo.UserTimeline;
import java.awt.Color;
import java.awt.Font;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import weibo4j.model.User;

public class MainDialog
extends JFrame {
    private static final long serialVersionUID = 7499795673151870114L;
    private static final String OPEN = "Open";
    private static final String EXIT = "Exit";
    private static final String ABOUT = "About";
    private static final String LOGOUT = "Logout";
    private static final boolean[] arrayOfTab;
    private JTabbedPane tabbedPane;
    public PersonInform personal;

    static {
        boolean[] blArray = new boolean[9];
        blArray[0] = true;
        arrayOfTab = blArray;
    }

    public MainDialog(User user) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setTitle("WebApi\u5fae\u7ba1\u5bb6");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage("images/logo.png"));
        this.setDefaultCloseOperation(2);
        this.setLayout(null);
        this.setSize(500, 610);
        this.getContentPane().setBackground(new Color(240, 240, 240));
        this.initPersonInform(user);
        this.initTabbedPanel();
        this.setVisible(true);
        this.initSystemTray();
    }

    void initPersonInform(User user) {
        this.personal = new PersonInform(user);
        this.personal.setBounds(0, 0, 485, 95);
        this.add(this.personal);
        this.personal.repaint();
    }

    private void initTabbedPanel() {
        this.tabbedPane = new JTabbedPane(1);
        this.tabbedPane.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 11));
        this.add(this.tabbedPane);
        this.tabbedPane.addTab("\u9996\u9875", null, new MyScrollPane(new FriendTimeline()), "\u9996\u9875");
        this.tabbedPane.addTab("\u8bc4\u8bba", null, new MyScrollPane(), "\u8bc4\u8bba");
        this.tabbedPane.addTab("@\u6211", null, new MyScrollPane(), "@\u6211");
        this.tabbedPane.addTab("\u6536\u85cf", null, new MyScrollPane(), "\u6536\u85cf");
        this.tabbedPane.addTab("\u5173\u6ce8", null, new MyScrollPane(), "\u5173\u6ce8");
        this.tabbedPane.addTab("\u7c89\u4e1d", null, new MyScrollPane(), "\u7c89\u4e1d");
        this.tabbedPane.addTab("\u5fae\u535a", null, new MyScrollPane(), "\u5fae\u535a");
        this.tabbedPane.addTab("\u6269\u5c55", null, new MyScrollPane(), "\u6269\u5c55");
        this.tabbedPane.addTab("\u641c\u7d22", null, new MyScrollPane(), "\u641c\u7d22");
        this.tabbedPane.setBounds(0, 96, 485, 475);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                int index = MainDialog.this.tabbedPane.getSelectedIndex();
                if (arrayOfTab[index]) {
                    return;
                }
                FirstClick thread = new FirstClick((MyScrollPane)MainDialog.this.tabbedPane.getSelectedComponent(), index);
                thread.start();
            }
        });
        this.tabbedPane.addMouseListener(new AutoFun.MouseHandle());
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    private void initSystemTray() {
        if (!SystemTray.isSupported()) {
            return;
        }
        try {
            String title = "\u65b0\u6d6a\u5fae\u535a\u5185\u5bb9\u7ba1\u7406\u5de5\u5177 \nWeb API\u53d1\u73b0\u5de5\u5177 ";
            SystemTray sysTray = SystemTray.getSystemTray();
            Image image = Toolkit.getDefaultToolkit().getImage("images/logo.png");
            TrayIcon trayIcon = new TrayIcon(image, title, this.createMenu());
            trayIcon.setImageAutoSize(true);
            trayIcon.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainDialog.this.setVisible(true);
                    MainDialog.this.toFront();
                }
            });
            sysTray.add(trayIcon);
            trayIcon.displayMessage("\u65b0\u6d6a\u5fae\u535a\u5185\u5bb9\u7ba1\u7406\u5de5\u5177", "WebAPI\u53d1\u73b0\u5de5\u5177", TrayIcon.MessageType.INFO);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private PopupMenu createMenu() {
        PopupMenu menu = new PopupMenu();
        MenuItem openItem = new MenuItem(OPEN);
        openItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!MainDialog.this.isVisible()) {
                    MainDialog.this.setVisible(true);
                    MainDialog.this.toFront();
                } else {
                    MainDialog.this.toFront();
                }
            }
        });
        MenuItem logoffItem = new MenuItem(LOGOUT);
        logoffItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int result = JOptionPane.showConfirmDialog(Oauth2Code.getMainDialog(), "\u662f\u5426\u6ce8\u9500", "\u786e\u8ba4", 2);
                if (result == 0) {
                    try {
                        FileOutputStream fos = new FileOutputStream("data/users.wb");
                        fos.write(0);
                    }
                    catch (FileNotFoundException e1) {
                        e1.printStackTrace();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    MainDialog.this.dispose();
                    System.exit(0);
                }
            }
        });
        MenuItem aboutItem = new MenuItem(ABOUT);
        aboutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(Oauth2Code.getMainDialog(), "\u65b0\u6d6a\u5fae\u535a\u5185\u5bb9\u7ba1\u7406\u5de5\u5177\nWebAPI\u53d1\u73b0\u5de5\u5177");
            }
        });
        MenuItem exitItem = new MenuItem(EXIT);
        exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainDialog.this.dispose();
                System.exit(0);
            }
        });
        menu.add(openItem);
        menu.addSeparator();
        menu.add(logoffItem);
        menu.addSeparator();
        menu.add(aboutItem);
        menu.addSeparator();
        menu.add(exitItem);
        return menu;
    }

    public void setLoading(boolean flag) {
        this.personal.setLoading(flag);
    }

    private class FirstClick
    extends Thread {
        private static final int MYCOMMENT = 1;
        private static final int METIONS = 2;
        private static final int FAVORITES = 3;
        private static final int FRIENDS = 4;
        private static final int FOLLOWERS = 5;
        private static final int MYSTATUS = 6;
        private static final int AUTOFUN = 7;
        private static final int SEARCH = 8;
        private MyScrollPane msp;
        private int index;

        public FirstClick(MyScrollPane msp, int index) {
            this.msp = msp;
            this.index = index;
            arrayOfTab[index] = true;
        }

        @Override
        public void run() {
            if (this.index == 1) {
                this.msp.setViewportView(new MyComment());
            } else if (this.index == 2) {
                this.msp.setViewportView(new Mentions());
            } else if (this.index == 3) {
                this.msp.setViewportView(new MyFavorites());
            } else if (this.index == 4) {
                this.msp.setViewportView(new FriendsOrFollowers(Oauth2Code.getUser(), OneUser.UserType.MY_FRIENDS));
            } else if (this.index == 5) {
                this.msp.setViewportView(new FriendsOrFollowers(Oauth2Code.getUser(), OneUser.UserType.MY_FOLLOWERS));
            } else if (this.index == 6) {
                this.msp.setViewportView(new UserTimeline(Oauth2Code.getUser()));
            } else if (this.index == 7) {
                this.msp.setViewportView(new AutoFun());
            } else if (this.index == 8) {
                this.msp.setViewportView(new SearchUserORStatus());
            }
        }
    }
}

