/*
 * Decompiled with CFR 0.152.
 */
package com.Weibo;

import com.Weibo.AccessTokenDao;
import com.Weibo.MyScrollPane;
import com.Weibo.Oauth2Code;
import com.Weibo.WeiboPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import weibo4j.Comments;
import weibo4j.Timeline;
import weibo4j.model.Comment;
import weibo4j.model.WeiboException;

public class MyDialog
extends JDialog {
    private static final long serialVersionUID = 9006335079833019302L;
    public static final String UPDATE_STATUS = "\u6709\u4ec0\u4e48\u65b0\u9c9c\u4e8b\u60f3\u544a\u8bc9\u5927\u5bb6";
    public static final String REPLY_COMMENT = "\u56de\u590d\u8bc4\u8bba";
    private JTextArea textArea;
    private JLabel tip;
    private String type;
    private Comment replyComment;

    public MyDialog(String type, Comment comment) {
        this.setTitle(type);
        this.type = type;
        this.replyComment = comment;
        this.init();
    }

    public MyDialog(String type) {
        this.setTitle(type);
        this.type = type;
        this.init();
    }

    private void init() {
        this.setModalityType(JDialog.DEFAULT_MODALITY_TYPE);
        this.setLayout(new BorderLayout());
        this.setSize(500, 200);
        this.setLocationRelativeTo(Oauth2Code.getMainDialog());
        this.setResizable(false);
        this.setDefaultCloseOperation(2);
        this.tip = new JLabel("(\u4f60\u8fd8\u53ef\u8f93\u5165140\u4e2a\u5b57\u3002)");
        this.initTextAera();
        this.add(this.getScrollPane(), "Center");
        this.add(this.getDownPanel(), "South");
        this.setVisible(true);
    }

    private Component getDownPanel() {
        JPanel downPanel = new JPanel(new FlowLayout());
        this.tip.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, 14));
        downPanel.add(this.tip);
        if (this.type.equals(UPDATE_STATUS)) {
            JButton sendPic = new JButton("\u53d1\u56fe");
            sendPic.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                }
            });
            downPanel.add(sendPic);
        }
        JButton submit = new JButton("\u53d1\u5e03");
        submit.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String content = MyDialog.this.textArea.getText();
                if (content.equals("")) {
                    JOptionPane.showMessageDialog(Oauth2Code.getMainDialog(), "\u5c1a\u672a\u8f93\u5165", "\u9519\u8bef", 0);
                    return;
                }
                boolean isSuccessUpd = false;
                boolean isSuccessRep = false;
                if (MyDialog.this.type.equals(MyDialog.REPLY_COMMENT)) {
                    isSuccessRep = MyDialog.this.reply(content);
                } else if (MyDialog.this.type.equals(MyDialog.UPDATE_STATUS)) {
                    isSuccessUpd = MyDialog.this.update(content);
                }
                if (isSuccessRep) {
                    MyDialog.this.refresh();
                } else if (isSuccessUpd) {
                    MyDialog.this.refresh(0);
                } else {
                    JOptionPane.showMessageDialog(Oauth2Code.getMainDialog(), "\u64cd\u4f5c\u5931\u8d25,\u8bf7\u7a0d\u540e\u518d\u8bd5", "\u9519\u8bef", 0);
                }
                MyDialog.this.dispose();
            }
        });
        downPanel.add(submit);
        return downPanel;
    }

    private Component getScrollPane() {
        JScrollPane jsp = new JScrollPane(this.textArea);
        jsp.setVerticalScrollBarPolicy(20);
        jsp.setHorizontalScrollBarPolicy(30);
        this.add((Component)jsp, "Center");
        return jsp;
    }

    private void initTextAera() {
        this.textArea = new JTextArea();
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                MyDialog.this.invoke();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                MyDialog.this.invoke();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                MyDialog.this.invoke();
            }
        });
        if (this.type.equals(REPLY_COMMENT)) {
            String text = "\u56de\u590d@" + this.replyComment.getUser().getName() + ":";
            this.textArea.setText(text);
            this.textArea.setCaretPosition(text.length());
        }
    }

    private void invoke() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int num = MyDialog.this.textArea.getText().length();
                MyDialog.this.tip.setText("\u4f60\u8fd8\u53ef\u4ee5\u8f93\u5165" + (140 - num) + "\u4e2a\u5b57");
                MyDialog.this.tip.validate();
            }
        });
    }

    private boolean update(String content) {
        Timeline tl = new Timeline();
        tl.client.setToken(AccessTokenDao.read());
        try {
            return tl.UpdateStatus(content) != null;
        }
        catch (WeiboException e) {
            e.printStackTrace();
            return false;
        }
    }

    private boolean reply(String content) {
        Comments cm = new Comments();
        cm.client.setToken(AccessTokenDao.read());
        Comment result = null;
        try {
            result = cm.replyComment(this.replyComment.getIdstr(), this.replyComment.getStatus().getId(), content);
        }
        catch (WeiboException e) {
            e.printStackTrace();
        }
        this.replyComment = null;
        return result != null;
    }

    private void refresh() {
        int i = Oauth2Code.getMainDialog().getTabbedPane().getSelectedIndex();
        Oauth2Code.getMainDialog().getTabbedPane().setSelectedIndex(i);
        MyScrollPane jsp = (MyScrollPane)Oauth2Code.getMainDialog().getTabbedPane().getSelectedComponent();
        WeiboPanel weiboPanel = (WeiboPanel)jsp.getViewport().getView();
        if (weiboPanel != null) {
            weiboPanel.refresh();
        }
    }

    private void refresh(int i) {
        Oauth2Code.getMainDialog().getTabbedPane().setSelectedIndex(i);
        MyScrollPane jsp = (MyScrollPane)Oauth2Code.getMainDialog().getTabbedPane().getSelectedComponent();
        WeiboPanel weiboPanel = (WeiboPanel)jsp.getViewport().getView();
        if (weiboPanel != null) {
            weiboPanel.refresh();
        }
    }
}

