/*
 * Decompiled with CFR 0.152.
 */
package com.Weibo;

import com.Weibo.AccessTokenDao;
import com.Weibo.Editor;
import com.Weibo.MyDialog;
import com.Weibo.MyScrollPane;
import com.Weibo.Oauth2Code;
import com.Weibo.OneComment;
import com.Weibo.OneUser;
import com.Weibo.SendImage;
import com.Weibo.WeiboFrame;
import com.Weibo.WeiboPanel;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import weibo4j.Comments;
import weibo4j.Favorite;
import weibo4j.Friendships;
import weibo4j.Timeline;
import weibo4j.model.Comment;
import weibo4j.model.Status;
import weibo4j.model.User;
import weibo4j.model.WeiboException;

public class MyLabel
extends JLabel
implements MouseListener {
    private static final long serialVersionUID = 3357216073939753082L;
    private static final String fontName = "\u5fae\u8f6f\u96c5\u9ed1";
    public static final String REPOST = "\u8f6c\u53d1";
    public static final String COMMENT = "\u8bc4\u8bba";
    public static final String DELETE = "\u5220\u9664";
    public static final String UN_FAVORITE = "\u53d6\u6d88\u6536\u85cf";
    public static final String FAVORITE = "\u6536\u85cf";
    public static final String ORIGINAL_REPOST = "\u539f\u6587\u8f6c\u53d1";
    public static final String ORIGINAL_COMMENT = "\u539f\u6587\u8bc4\u8bba";
    public static final String REFRESH = "\u5237\u65b0";
    public static final String UPDATE_STATUS = "\u53d1\u5fae\u535a";
    public static final String REPLY = "\u56de\u590d";
    public static final String FOLLOW = "+\u5173\u6ce8";
    public static final String UNFOLLOW = "\u53d6\u6d88\u5173\u6ce8";
    public static final String SEND_IMAGE = "\u53d1\u56fe";
    private static final String followLabelExited = "images/guanzhu2.jpg";
    private static final String followLabelEnter = "images/guanzhu.jpg";
    private static final String editorLabelExited = "images/editor2.jpg";
    private static final String editorLabelEnter = "images/editor.jpg";
    private static final String infoEnter = "images/info2.jpg";
    private static final String infoExited = "images/info.jpg";
    private static final String saveEnter = "images/save2.jpg";
    private static final String saveExited = "images/save.jpg";
    public static final String EDITOR = "\u7f16\u8f91\u8d44\u6599";
    public static final String INFO = "\u7f16\u8f91";
    public static final String SAVE = "\u4fdd\u5b58";
    private int size = 14;
    private Status status;
    private Comment comment;
    private OneComment.CommentType type;
    private String text;
    private User user;

    public MyLabel(String text) {
        super(text);
        this.text = text;
        this.init();
    }

    public MyLabel(String text, Icon icon) {
        super(icon);
        this.text = text;
        this.init();
    }

    public MyLabel(String text, int size) {
        super(text);
        this.text = text;
        this.init();
    }

    public MyLabel(String text, Status status) {
        super(text);
        this.text = text;
        this.status = status;
        this.init();
    }

    public MyLabel(String text, Comment comment) {
        super(text);
        this.text = text;
        this.comment = comment;
        this.init();
    }

    public MyLabel(String text, Comment comment, OneComment.CommentType type) {
        super(text);
        this.text = text;
        this.comment = comment;
        this.type = type;
        this.init();
    }

    public MyLabel(String text, User user) {
        super(text);
        this.text = text;
        this.user = user;
        this.init();
    }

    public MyLabel(String text, Icon icon, User user) {
        super(icon);
        this.text = text;
        this.user = user;
        this.init();
    }

    private void init() {
        this.setFont(new Font(fontName, 0, this.size));
        this.setSize(this.getPreferredSize());
        this.addMouseListener(this);
    }

    @Override
    public void setText(String text) {
        super.setText(text);
        this.text = text;
    }

    public void setTextAndIcon(String text, Icon Icon2) {
        super.setText("");
        super.setIcon(Icon2);
        this.text = text;
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.repaint();
        this.setCursor(new Cursor(12));
        this.setForeground(Color.blue);
        if (this.text.equals(FOLLOW)) {
            this.setIcon(new ImageIcon(followLabelEnter));
        } else if (this.text.equals(EDITOR)) {
            this.setIcon(new ImageIcon(editorLabelEnter));
        } else if (this.text.equals(INFO)) {
            this.setIcon(new ImageIcon(infoEnter));
        } else if (this.text.equals(SAVE)) {
            this.setIcon(new ImageIcon(saveEnter));
        }
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.repaint();
        this.setForeground(Color.black);
        if (this.text.equals(FOLLOW)) {
            this.setIcon(new ImageIcon(followLabelExited));
        } else if (this.text.equals(EDITOR)) {
            this.setIcon(new ImageIcon(editorLabelExited));
        } else if (this.text.equals(INFO)) {
            this.setIcon(new ImageIcon(infoExited));
        } else if (this.text.equals(SAVE)) {
            this.setIcon(new ImageIcon(saveExited));
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        new Thread(){

            @Override
            public void run() {
                if (MyLabel.this.text.startsWith(MyLabel.REPOST) || MyLabel.this.text.startsWith(MyLabel.COMMENT) || MyLabel.this.text.startsWith(MyLabel.ORIGINAL_REPOST) || MyLabel.this.text.startsWith(MyLabel.ORIGINAL_COMMENT)) {
                    WeiboFrame.getInstance(MyLabel.this.status, MyLabel.this.text);
                } else if (MyLabel.this.text.equals(MyLabel.REFRESH)) {
                    if (Oauth2Code.getMainDialog().getTabbedPane().getSelectedIndex() < 7) {
                        MyLabel.this.refresh();
                    }
                } else if (MyLabel.this.text.equals(MyLabel.UPDATE_STATUS)) {
                    new MyDialog(MyLabel.UPDATE_STATUS);
                } else if (MyLabel.this.text.equals(MyLabel.DELETE)) {
                    MyLabel.this.delete();
                } else if (MyLabel.this.text.equals(MyLabel.REPLY)) {
                    MyLabel.this.reply();
                } else if (MyLabel.this.text.equals(MyLabel.FAVORITE)) {
                    MyLabel.this.createFavorite();
                } else if (MyLabel.this.text.equals(MyLabel.UN_FAVORITE)) {
                    MyLabel.this.unFavorite();
                } else if (MyLabel.this.text.equals(MyLabel.FOLLOW)) {
                    MyLabel.this.follow();
                } else if (MyLabel.this.text.equals(MyLabel.UNFOLLOW)) {
                    MyLabel.this.unfollow();
                } else if (MyLabel.this.text.equals(MyLabel.SEND_IMAGE)) {
                    new SendImage();
                } else if (MyLabel.this.text.equals(MyLabel.EDITOR)) {
                    new Editor();
                } else if (MyLabel.this.text.equals(MyLabel.SAVE)) {
                    Editor.save();
                }
            }
        }.start();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    private void refresh() {
        MyScrollPane jsp = (MyScrollPane)Oauth2Code.getMainDialog().getTabbedPane().getSelectedComponent();
        WeiboPanel weiboPanel = (WeiboPanel)jsp.getViewport().getView();
        if (weiboPanel != null) {
            weiboPanel.refresh();
        }
    }

    private void delete() {
        String text = null;
        if (this.status != null) {
            text = "\u5fae\u535a";
        } else if (this.comment != null) {
            text = COMMENT;
        }
        int result = JOptionPane.showConfirmDialog(Oauth2Code.getMainDialog(), "\u786e\u5b9a\u8981\u5220\u9664\u8fd9\u6761" + text + "?", DELETE, 2);
        if (result == 0) {
            boolean isSuccessed = false;
            if (this.status != null) {
                isSuccessed = this.destroyStatus(this.status);
            } else if (this.comment != null) {
                isSuccessed = this.destroyComment(this.comment);
            }
            if (isSuccessed) {
                this.refresh();
            } else {
                JOptionPane.showMessageDialog(Oauth2Code.getMainDialog(), "\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5", "\u9519\u8bef", 0);
            }
        }
    }

    private boolean destroyStatus(Status status) {
        Timeline tl = new Timeline();
        tl.client.setToken(AccessTokenDao.read());
        Status result = null;
        try {
            result = tl.Destroy(status.getId());
        }
        catch (WeiboException e) {
            e.printStackTrace();
        }
        return result != null;
    }

    private boolean destroyComment(Comment comment) {
        Comments cm = new Comments();
        cm.client.setToken(AccessTokenDao.read());
        Comment result = null;
        try {
            result = cm.destroyComment(comment.getIdstr());
        }
        catch (WeiboException e) {
            e.printStackTrace();
        }
        return result != null;
    }

    private void reply() {
        if (this.type.equals((Object)OneComment.CommentType.COMMENT_BY_ID)) {
            WeiboFrame weiboFrame = WeiboFrame.getInstance();
            JTextArea textArea = weiboFrame.getTextArea(REPLY);
            weiboFrame.setReplyComment(this.comment);
            String text = "\u56de\u590d@" + this.comment.getUser().getName() + ":";
            textArea.setText(text);
            textArea.setCaretPosition(text.length());
        } else if (this.type.equals((Object)OneComment.CommentType.MY_COMMENTS)) {
            new MyDialog("\u56de\u590d\u8bc4\u8bba", this.comment);
        }
    }

    private void createFavorite() {
        boolean isSuccessed = false;
        Favorite fv = new Favorite();
        fv.client.setToken(AccessTokenDao.read());
        try {
            isSuccessed = fv.createFavorites(this.status.getId()) != null;
        }
        catch (WeiboException e) {
            e.printStackTrace();
        }
        if (isSuccessed) {
            this.setText(UN_FAVORITE);
        } else {
            JOptionPane.showMessageDialog(Oauth2Code.getMainDialog(), "\u64cd\u4f5c\u5931\u8d25\uff01\u8bf7\u7a0d\u540e\u518d\u8bd5", "\u9519\u8bef", 0);
        }
    }

    private void unFavorite() {
        int result = JOptionPane.showConfirmDialog(Oauth2Code.getMainDialog(), "\u786e\u5b9a\u8981\u53d6\u6d88\u8fd9\u6761\u6536\u85cf\uff1f", "\u5220\u9664\uff1f", 2);
        if (result == 0) {
            boolean isSuccessed = false;
            Favorite fv = new Favorite();
            fv.client.setToken(AccessTokenDao.read());
            try {
                isSuccessed = fv.destroyFavoritesBatch(this.status.getId()) != null;
            }
            catch (WeiboException e) {
                e.printStackTrace();
            }
            if (isSuccessed) {
                this.setText(FAVORITE);
            } else {
                JOptionPane.showMessageDialog(Oauth2Code.getMainDialog(), "\u64cd\u4f5c\u5931\u8d25\uff01\u8bf7\u7a0d\u540e\u518d\u8bd5", "\u9519\u8bef", 0);
            }
        }
    }

    private void follow() {
        Friendships fs = new Friendships();
        fs.client.setToken(AccessTokenDao.read());
        User u = null;
        try {
            u = fs.createFriendshipsById(this.user.getId());
        }
        catch (WeiboException e) {
            if (e.getErrorCode() == 20506) {
                JOptionPane.showMessageDialog(Oauth2Code.getMainDialog(), "\u5df2\u7ecf\u5173\u6ce8\u6b64\u7528\u6237\u3002", "\u9519\u8bef", 0);
            }
            e.printStackTrace();
        }
        if (u != null) {
            this.setText(UNFOLLOW);
            this.setIcon(null);
            if (this.user.isfollowMe()) {
                OneUser oneUser = (OneUser)this.getParent().getParent().getParent();
                oneUser.setMutualVisible(true);
            }
        } else {
            JOptionPane.showMessageDialog(Oauth2Code.getMainDialog(), "\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", "\u9519\u8bef", 0);
        }
    }

    private void unfollow() {
        int result = JOptionPane.showConfirmDialog(Oauth2Code.getMainDialog(), "\u786e\u5b9a\u8981\u53d6\u6d88\u5173\u6ce8" + this.user.getName() + "\uff1f", "\u53d6\u6d88\u5173\u6ce8\uff1f", 2);
        if (result != 0) {
            return;
        }
        Friendships fs = new Friendships();
        fs.client.setToken(AccessTokenDao.read());
        User u = null;
        try {
            u = fs.destroyFriendshipsDestroyById(this.user.getId());
        }
        catch (WeiboException e) {
            e.printStackTrace();
        }
        if (u != null) {
            this.setTextAndIcon(FOLLOW, new ImageIcon(followLabelExited));
            OneUser oneUser = (OneUser)this.getParent().getParent().getParent();
            if (oneUser.isMutualVisible()) {
                oneUser.setMutualVisible(false);
            }
        } else {
            JOptionPane.showConfirmDialog(Oauth2Code.getMainDialog(), "\u64cd\u4f5c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002", "\u9519\u8bef", 0);
        }
    }
}

