/*
 * Decompiled with CFR 0.152.
 */
package com.Weibo;

import chrriis.dj.nativeswing.NSOption;
import chrriis.dj.nativeswing.swtimpl.components.JWebBrowser;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserAdapter;
import chrriis.dj.nativeswing.swtimpl.components.WebBrowserNavigationEvent;
import com.Weibo.AccessTokenDao;
import com.Weibo.MainDialog;
import java.awt.Component;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import weibo4j.Account;
import weibo4j.Oauth;
import weibo4j.Users;
import weibo4j.Weibo;
import weibo4j.examples.oauth2.Log;
import weibo4j.http.AccessToken;
import weibo4j.model.User;
import weibo4j.model.WeiboException;
import weibo4j.org.json.JSONException;

public class Oauth2Code {
    private static final String CODE = "?code=";
    private static MainDialog test;
    private Oauth oauth = new Oauth();
    private String lastURL;
    private static User user;
    private JDialog dialog;

    public Oauth2Code() {
        Log.logInfo("\u6b63\u5728\u6253\u5f00\u6388\u6743\u754c\u9762");
        this.dialog = new JDialog(){
            private static final long serialVersionUID = 8755626793359433023L;

            @Override
            protected void processWindowEvent(WindowEvent e) {
                super.processWindowEvent(e);
                if (e.getID() == 201) {
                    Oauth2Code.this.dialog.dispose();
                    System.exit(0);
                }
            }
        };
        this.dialog.setTitle("\u6388\u6743");
        this.dialog.setResizable(false);
        this.dialog.setBounds(30, 30, 608, 522);
        this.dialog.add((Component)this.getWebBrowser(), "Center");
        this.dialog.setVisible(true);
        this.dialog.setDefaultCloseOperation(2);
    }

    public Oauth2Code(String accessToken) throws WeiboException {
        this.init(accessToken);
    }

    private JWebBrowser getWebBrowser() {
        JWebBrowser webBrowser = new JWebBrowser(new NSOption[0]);
        webBrowser.setBarsVisible(false);
        webBrowser.setButtonBarVisible(false);
        webBrowser.setDefaultPopupMenuRegistered(false);
        try {
            this.lastURL = this.oauth.authorize("code");
            webBrowser.navigate(this.lastURL);
        }
        catch (WeiboException e) {
            e.printStackTrace();
        }
        webBrowser.addWebBrowserListener(new WebBrowserAdapter(){

            @Override
            public void locationChanged(WebBrowserNavigationEvent e) {
                String site = e.getWebBrowser().getResourceLocation();
                if (site == null || Oauth2Code.this.lastURL.equals(site) || site.indexOf(Oauth2Code.CODE) == -1) {
                    return;
                }
                Oauth2Code.this.lastURL = site;
                Oauth2Code.this.dialog.dispose();
                String code = site.substring(site.lastIndexOf("code=") + 5);
                String accessToken = Oauth2Code.this.getAccessTokenByCode(code);
                if (accessToken == null) {
                    return;
                }
                AccessTokenDao.write(accessToken);
                Log.logInfo("\u6388\u6743\u6210\u529f");
                try {
                    Oauth2Code.this.init(accessToken);
                }
                catch (WeiboException e1) {
                    e1.printStackTrace();
                }
            }
        });
        return webBrowser;
    }

    private void init(String accessToken) throws WeiboException {
        Log.logInfo("\u6b63\u5728\u6253\u5f00\u4e3b\u754c\u9762");
        Weibo weibo = new Weibo();
        weibo.client.setToken(accessToken);
        Account ac = new Account();
        ac.client.setToken(accessToken);
        String uid = null;
        try {
            uid = ac.getUid().get("uid").toString();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (uid == null) {
            return;
        }
        Users um = new Users();
        um.client.setToken(accessToken);
        user = um.showUserById(uid);
        test = new MainDialog(user);
    }

    private String getAccessTokenByCode(String code) {
        Log.logInfo("code:" + code);
        AccessToken accessToken = null;
        try {
            accessToken = this.oauth.getAccessTokenByCode(code);
        }
        catch (WeiboException e) {
            if (401 == e.getStatusCode()) {
                Log.logInfo("Unable to get the access token.");
            } else {
                e.printStackTrace();
            }
            return null;
        }
        return accessToken.getAccessToken();
    }

    public static MainDialog getMainDialog() {
        return test;
    }

    public static User getUser() {
        return user;
    }
}

