/*
 * Decompiled with CFR 0.152.
 */
package com.Weibo;

import com.Weibo.MyLabel;
import com.Weibo.Oauth2Code;
import com.Weibo.OnePanel;
import com.Weibo.OneStatus;
import com.Weibo.UserHeadImg;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import weibo4j.model.Comment;

public class OneComment
extends OnePanel {
    private static final long serialVersionUID = -5686965045113883441L;
    private CommentType type;

    public OneComment(Comment comment, CommentType type) {
        this.type = type;
        this.setLayout(new BorderLayout());
        JPanel inner = new JPanel();
        inner.setLayout(null);
        inner.setBackground(Color.white);
        inner.setBorder(border);
        UserHeadImg userHead = new UserHeadImg(comment.getUser());
        userHead.setBounds(this.locX + 5, this.locY + 5, this.headImgWidth, this.headImgHeight);
        this.add(userHead);
        this.locX += this.headImgWidth + 15;
        int width = this.allWidth - this.locX - 5;
        JTextPane textPane = this.getCommentTextPane(comment, this.locX, this.locY, width);
        inner.add(textPane);
        Dimension dm = textPane.getPreferredSize();
        this.locY = (int)((double)this.locY + dm.getHeight());
        inner.add(this.initLabels(comment, this.allWidth, this.locY));
        int n = this.locY = this.locY > 60 ? this.locY + 5 : 60;
        if (!type.equals((Object)CommentType.COMMENT_BY_ID)) {
            OneStatus statusPanel = new OneStatus(comment.getStatus(), OneStatus.StatusType.STATUS_IN_COMMENT);
            statusPanel.setLocation(this.locX - this.headImgWidth, this.locY);
            statusPanel.setBackground(Color.white);
            dm = statusPanel.getPreferredSize();
            statusPanel.setSize(dm);
            inner.add(statusPanel);
            this.locY = (int)((double)this.locY + dm.getHeight());
        }
        this.add(inner);
        this.allHeight = this.locY > 60 ? this.locY + 5 : 60;
        this.setPreferredSize(new Dimension(this.allWidth, this.allHeight));
    }

    private JTextPane getCommentTextPane(Comment comment, int locX, int locY, int width) {
        JTextPane textPane = this.initTextPanel();
        String usernameAndText = this.getNameAndText(comment);
        String dateAndSource = this.getDateAndSource(comment);
        textPane.setText(this.setForms(String.valueOf(usernameAndText) + dateAndSource));
        textPane.setSize(width, textPane.getPreferredSize().height);
        int textPaneHeight = textPane.getPreferredSize().height;
        textPane.setBounds(locX, locY, width, textPaneHeight);
        textPane.setPreferredSize(new Dimension(width, textPaneHeight));
        return textPane;
    }

    private String getNameAndText(Comment comment) {
        String samePart = "<font face=\u5fae\u8f6f\u96c5\u9ed1 size=4><a href=\"@" + comment.getUser().getName() + "\">";
        String usernameAndText = String.valueOf(samePart) + comment.getUser().getName() + "</a>" + "\uff1a" + comment.getText();
        return usernameAndText;
    }

    private String getDateAndSource(Comment comment) {
        String dateAndSource = "<br/>" + OneComment.getCreateDate(comment.getCreatedAt()) + "  \u901a\u8fc7";
        String source = comment.getSource();
        dateAndSource = String.valueOf(dateAndSource) + source + "</font></b>";
        return dateAndSource;
    }

    private JPanel initLabels(Comment comment, int locX, int templocY) {
        JPanel panel = new JPanel(new FlowLayout());
        panel.setBackground(Color.white);
        if (this.type.equals((Object)CommentType.MY_COMMENTS)) {
            panel.add(new MyLabel("\u5220\u9664", comment));
        }
        if (!comment.getUser().equals(Oauth2Code.getUser())) {
            panel.add(new MyLabel("\u56de\u590d", comment, this.type));
        }
        Dimension dm = panel.getPreferredSize();
        panel.setSize(dm);
        panel.setLocation(locX - dm.width - 10, templocY);
        this.locY += dm.height;
        return panel;
    }

    protected static enum CommentType {
        MY_COMMENTS("\u8bc4\u8bba"),
        COMMENT_BY_ID("\u5168\u90e8\u8bc4\u8bba");

        private String name;

        private CommentType(String name) {
            this.name = name;
        }

        public String gettypeName() {
            return this.name;
        }
    }
}

