/*
 * Decompiled with CFR 0.152.
 */
package com.Weibo;

import com.Weibo.MyLabel;
import com.Weibo.Oauth2Code;
import com.Weibo.OnePanel;
import com.Weibo.UserHeadImg;
import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import weibo4j.model.Favorites;
import weibo4j.model.Source;
import weibo4j.model.Status;
import weibo4j.model.User;

public class OneStatus
extends OnePanel {
    private static final long serialVersionUID = 3780654904127024184L;
    private int imgHeight;
    private StatusType type;

    public OneStatus(Status status, StatusType type) {
        this.type = type;
        if (type.equals((Object)StatusType.STATUS_IN_COMMENT)) {
            this.allWidth = 425;
        }
        this.init(status);
    }

    public OneStatus(Favorites favorite, StatusType type) {
        this.type = type;
        this.init(favorite.getStatus());
    }

    private void init(Status status) {
        this.setLayout(null);
        this.setBackground(new Color(240, 240, 240));
        JPanel inner = this.getInner(status);
        this.setSize(this.allWidth, this.allHeight);
        this.setPreferredSize(new Dimension(this.allWidth, this.allHeight + 12));
        this.add(inner);
    }

    private JPanel getInner(Status status) {
        JPanel innerPanel = new JPanel();
        innerPanel.setBackground(Color.white);
        innerPanel.setLayout(null);
        innerPanel.setBorder(border);
        int headImgWidth = 0;
        if (!this.type.equals((Object)StatusType.STATUS_IN_COMMENT) && !this.type.equals((Object)StatusType.USER_TIMELINE)) {
            User user = status.getUser();
            UserHeadImg HImg = new UserHeadImg(user);
            HImg.setLocation(2, 2);
            innerPanel.add(HImg);
            Dimension HImgDms = HImg.getPreferredSize();
            headImgWidth = (int)HImgDms.getWidth();
        }
        this.locX += headImgWidth;
        int statusWidth = this.allWidth - headImgWidth - 10;
        innerPanel.add(this.getTextPane(status, this.locX, this.locY, statusWidth, false));
        if (!this.type.equals((Object)StatusType.STATUS_IN_COMMENT) && !this.type.equals((Object)StatusType.USER_TIMELINE)) {
            this.allHeight = this.allHeight > 55 ? this.allHeight : 55;
        } else {
            this.locX += 10;
            statusWidth -= 10;
        }
        if (!this.type.equals((Object)StatusType.REPOST_TIMELINE) && status.getRetweetedStatus() != null) {
            Status retweetedStatus = status.getRetweetedStatus();
            innerPanel.add(this.getTextPane(retweetedStatus, this.locX - headImgWidth, this.locY + this.allHeight, statusWidth += headImgWidth, true));
            if (!this.type.equals((Object)StatusType.STATUS_TEXT)) {
                innerPanel.add(this.initLabels(retweetedStatus, this.locX - headImgWidth, this.allHeight + 3, true));
            }
        }
        if (!this.type.equals((Object)StatusType.STATUS_TEXT)) {
            innerPanel.add(this.initLabels(status, this.allWidth, this.allHeight + 3, false));
        }
        innerPanel.setBounds(0, 0, this.allWidth, this.allHeight + 5);
        return innerPanel;
    }

    private JPanel initLabels(Status status, int x, int y, boolean isRetweeted) {
        String text;
        JPanel panel = new JPanel(new FlowLayout());
        panel.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        panel.setBackground(Color.white);
        String repost_Text = "\u8f6c\u53d1";
        String comment_Text = "\u8bc4\u8bba";
        if (isRetweeted) {
            repost_Text = "\u539f\u6587\u8f6c\u53d1";
            comment_Text = "\u539f\u6587\u8bc4\u8bba";
            text = this.getLabelText(comment_Text, status.getCommentsCount());
            panel.add(new MyLabel(text, status));
            text = this.getLabelText(repost_Text, status.getRepostsCount());
            panel.add(new MyLabel(text, status));
        } else {
            text = this.getLabelText(repost_Text, status.getCommentsCount());
            panel.add(new MyLabel(text, status));
            text = this.getLabelText(comment_Text, status.getRepostsCount());
            panel.add(new MyLabel(text, status));
            if (status.isFavorited()) {
                panel.add(new MyLabel("\u53d6\u6d88\u6536\u85cf", status));
            } else {
                panel.add(new MyLabel("\u6536\u85cf", status));
            }
            if (status.getUser() != null && status.getUser().equals(Oauth2Code.getUser())) {
                panel.add(new MyLabel("\u5220\u9664", status));
            }
            if (!status.isFavorited()) {
                panel.add(new JLabel("        "));
            }
        }
        Dimension dm = panel.getPreferredSize();
        panel.setSize(dm);
        if (!isRetweeted) {
            panel.setLocation(x - dm.width - 10, y);
            this.allHeight += dm.height;
        } else {
            panel.setLocation(x, y);
            panel.setBorder(border);
        }
        return panel;
    }

    private String getLabelText(String content, int count) {
        StringBuffer text = new StringBuffer(content);
        if (count != 0) {
            text.append("(" + count + ")");
        }
        return text.toString();
    }

    private JTextPane getTextPane(Status status, int x, int y, int width, boolean isRetWeeted) {
        JTextPane textPane = this.initTextPanel();
        if (status.getUser() == null) {
            return this.getErrorTextPanel(textPane, x, y, width);
        }
        String usernameAndText = this.getnameAndText(status, isRetWeeted);
        String imgURL = this.getImg(status);
        String dateAndSource = this.getDateAndSource(status);
        textPane.setText(String.valueOf(usernameAndText) + dateAndSource);
        textPane.setSize(width, textPane.getPreferredSize().height + this.imgHeight);
        int textPaneHeight = textPane.getPreferredSize().height + this.imgHeight;
        this.allHeight += textPaneHeight;
        textPane.setText(this.setForms(String.valueOf(usernameAndText) + imgURL + dateAndSource));
        textPane.setBounds(x, y, width, textPaneHeight);
        return textPane;
    }

    private String getDateAndSource(Status status) {
        String dateAndSource = "<br />" + OneStatus.getCreateDate(status.getCreatedAt()) + " \u6765\u81ea";
        Source source = status.getSource();
        dateAndSource = String.valueOf(dateAndSource) + "<a href=\"" + source.getUrl() + "\">" + source.getName() + "</font></b>";
        return dateAndSource;
    }

    private String getImg(Status status) {
        String imgUrl = "";
        if (!"".equals(status.getThumbnailPic())) {
            this.imgHeight = this.getImgHeight(status.getThumbnailPic()) + 23;
            imgUrl = "<br /><br /><a href=\"" + status.getBmiddlePic() + "\"><img border=\"0\" src=" + status.getThumbnailPic() + " /></a>";
        }
        return imgUrl;
    }

    private String getnameAndText(Status status, boolean isRetWeeted) {
        String samePart = "<font face=\u5fae\u8f6f\u96c5\u9ed1 size=4><a href=\"@" + status.getUser().getName() + "\">";
        String usernameAndText = "";
        usernameAndText = isRetWeeted ? String.valueOf(samePart) + "@" + status.getUser().getName() + "</a>" + ": " + status.getText() : (this.type.equals((Object)StatusType.USER_TIMELINE) ? "<font face=\u5fae\u8f6f\u96c5\u9ed1 size=4>" + status.getText() : String.valueOf(samePart) + status.getUser().getName() + "</a>" + ": " + status.getText());
        return usernameAndText;
    }

    private JTextPane getErrorTextPanel(JTextPane textPane, int x, int y, int width) {
        String sorry = "\u62b1\u6b49\uff0c\u6b64\u5fae\u535a\u5df2\u88ab\u539f\u4f5c\u8005\u5220\u9664\u3002\u5982\u9700\u5e2e\u52a9\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d\u3002http://help.weibo.com/self/query?typeid=1034";
        textPane.setText(sorry);
        textPane.setSize(width, textPane.getPreferredSize().height);
        int textPaneHeight = textPane.getPreferredSize().height;
        textPane.setBounds(x, y, width, textPaneHeight);
        this.allHeight += textPaneHeight;
        return textPane;
    }

    protected static enum StatusType {
        FRIEND_TIMELINE("\u9996\u9875"),
        REPOST_TIMELINE("\u5168\u90e8\u8f6c\u53d1"),
        STATUS_TEXT("\u5fae\u535a\u6b63\u6587"),
        STATUS_IN_COMMENT("\u8bc4\u8bba\u7684\u5fae\u535a"),
        FAVORITE("\u6536\u85cf\u7684\u5fae\u535a"),
        USER_TIMELINE("\u6211\u7684\u5fae\u535a");

        private String name;

        private StatusType(String name) {
            this.name = name;
        }

        public String gettypeName() {
            return this.name;
        }
    }
}

