/*
 * Decompiled with CFR 0.152.
 */
package com.Weibo;

import com.Weibo.MyLabel;
import com.Weibo.Oauth2Code;
import com.Weibo.UserHeadImg;
import java.awt.Color;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import weibo4j.model.User;

public class PersonInform
extends JPanel {
    private static final long serialVersionUID = 3939557814478630981L;
    private static final String LOADING = "images/loading.gif";
    private static final String editorLabelExited = "images/editor2.jpg";
    private static final JLabel LOADING_LABEL = new JLabel(new ImageIcon("images/loading.gif"));

    public PersonInform(User user) {
        this.setLayout(null);
        this.setBackground(new Color(240, 240, 240));
        this.init(user);
    }

    private void init(User user) {
        UserHeadImg userHead = new UserHeadImg(user);
        userHead.setLocation(8, 8);
        userHead.setHorizontalAlignment(2);
        this.add(userHead);
        this.add(this.getLabel(user.getName(), 70, 8));
        JLabel locationLabel = this.getLabel(user.getLocation(), 14, 72, 30);
        this.add(locationLabel);
        int locLabelWidth = (int)locationLabel.getPreferredSize().getWidth();
        String gender = this.getGender(user.getGender());
        this.add(this.getLabel(gender, 80 + locLabelWidth, 30));
        int locX = 8;
        JLabel friendsLabel = this.getLabel("\u5173\u6ce8 " + Integer.toString(user.getFriendsCount()), locX, 70);
        this.add(friendsLabel);
        locX = (int)((double)locX + (friendsLabel.getPreferredSize().getWidth() + 15.0));
        JLabel followersLabel = this.getLabel("\u7c89\u4e1d " + Integer.toString(user.getFollowersCount()), locX, 70);
        this.add(followersLabel);
        locX = (int)((double)locX + (followersLabel.getPreferredSize().getWidth() + 15.0));
        JLabel statusLabel = this.getLabel("\u5fae\u535a " + String.valueOf(user.getStatusesCount()), locX, 70);
        this.add(statusLabel);
        if (user.equals(Oauth2Code.getUser())) {
            LOADING_LABEL.setSize(LOADING_LABEL.getPreferredSize());
            LOADING_LABEL.setLocation(430, 20);
            this.add(LOADING_LABEL);
            MyLabel refreshLabel = new MyLabel("\u5237\u65b0");
            refreshLabel.setLocation(440, 70);
            this.add(refreshLabel);
            MyLabel update = new MyLabel("\u53d1\u5fae\u535a");
            update.setLocation(370, 70);
            this.add(update);
            MyLabel sendImage = new MyLabel("\u53d1\u56fe");
            sendImage.setLocation(310, 70);
            this.add(sendImage);
            MyLabel editorLabel = new MyLabel("\u7f16\u8f91\u8d44\u6599", new ImageIcon(editorLabelExited));
            editorLabel.setLocation(200, 30);
            this.add(editorLabel);
        }
        this.validate();
        this.repaint();
    }

    private JLabel getLabel(String name, int fontSize, int locX, int locY) {
        JLabel label = new JLabel(name);
        label.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 0, fontSize));
        label.setSize(label.getPreferredSize());
        label.setLocation(locX, locY);
        return label;
    }

    private JLabel getLabel(String name, int locX, int locY) {
        return this.getLabel(name, 14, locX, locY);
    }

    private String getGender(String gender) {
        String tmp = "";
        if (gender.equals("f")) {
            tmp = "\u5973";
        } else if (gender.equals("m")) {
            tmp = "\u7537";
        }
        return tmp;
    }

    public void setLoading(boolean flag) {
        LOADING_LABEL.setVisible(flag);
    }
}

