/*
 * Decompiled with CFR 0.152.
 */
package com.Weibo;

import com.Weibo.AccessTokenDao;
import com.Weibo.AutoFun;
import com.Weibo.Oauth2Code;
import com.Weibo.OneUser;
import com.Weibo.WeiboConstants;
import com.Weibo.WeiboPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import weibo4j.Search;
import weibo4j.Users;
import weibo4j.model.User;
import weibo4j.model.WeiboException;
import weibo4j.org.json.JSONArray;
import weibo4j.org.json.JSONException;

public class SearchUserORStatus
extends WeiboPanel {
    private static final long serialVersionUID = 664528205568856096L;
    Search search = new Search();
    private JTextField textField;
    private Users um = new Users();
    private String uid = null;
    private static JRadioButton searchStatus;
    private static JRadioButton searchUsers;
    private static int SELECTED;

    static {
        SELECTED = 1;
    }

    protected SearchUserORStatus() {
        this.setBackground(new Color(240, 240, 240));
        this.setLayout(this.gridbag);
        this.gbc = new GridBagConstraints();
        this.gbc.insets = new Insets(5, 10, 5, 10);
        this.gbc.gridy = 0;
        this.page = 1;
        this.search.client.setToken(AccessTokenDao.read());
        this.um.client.setToken(AccessTokenDao.read());
        this.initTextAndButton(SELECTED);
    }

    @Override
    public void run() {
        this.lastId = Long.MAX_VALUE;
        this.setLoading(true);
        if (SELECTED == 1) {
            this.searchStatus();
        } else if (SELECTED == 2) {
            this.searchUser();
        }
        this.setLoading(false);
    }

    private void searchStatus() {
        JOptionPane.showMessageDialog(Oauth2Code.getMainDialog(), "\u6682\u4e0d\u652f\u6301\u5fae\u535a\u641c\u7d22\u529f\u80fd");
    }

    private void searchUser() {
        if (this.textField.getText().trim().length() > 0) {
            try {
                JSONArray array = this.search.searchSuggestionsUsers(this.textField.getText(), 20);
                if (array.length() == 0) {
                    JOptionPane.showMessageDialog(Oauth2Code.getMainDialog(), "\u627e\u4e0d\u5230\u76f8\u5173\u7528\u6237", "\u9519\u8bef", 0);
                }
                this.removeAll();
                this.initTextAndButton(SELECTED);
                this.repaint();
                int i = 0;
                while (i < array.length()) {
                    block10: {
                        this.uid = array.getJSONObject(i).get("uid").toString();
                        long id = Long.parseLong(this.uid);
                        if (this.lastId != id) {
                            this.lastId = id;
                            System.out.println(id);
                            User user = null;
                            try {
                                user = this.um.showUserById(this.uid);
                            }
                            catch (WeiboException e) {
                                break block10;
                            }
                            OneUser oneUser = null;
                            oneUser = new OneUser(user);
                            this.add((Component)oneUser, this.gbc);
                            this.getParent().validate();
                            ++this.gbc.gridy;
                        }
                    }
                    ++i;
                }
            }
            catch (WeiboException e1) {
                e1.printStackTrace();
            }
            catch (JSONException e1) {
                e1.printStackTrace();
            }
        } else {
            JOptionPane.showMessageDialog(Oauth2Code.getMainDialog(), "\u641c\u7d22\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a", "\u9519\u8bef", 0);
        }
    }

    private void initTextAndButton(int selected) {
        JPanel panel = new JPanel(new BorderLayout());
        this.textField = new JTextField();
        panel.add("Center", this.textField);
        JButton button = new JButton("\u641c\u7d22");
        button.setFont(WeiboConstants.DEFAULT_FONT);
        panel.add("East", button);
        if (selected == 1) {
            searchStatus = new JRadioButton("\u5fae\u535a", true);
            searchUsers = new JRadioButton("\u627e\u4eba");
        } else if (selected == 2) {
            searchStatus = new JRadioButton("\u5fae\u535a");
            searchUsers = new JRadioButton("\u627e\u4eba", true);
        }
        searchStatus.setFont(WeiboConstants.DEFAULT_FONT);
        searchUsers.setFont(WeiboConstants.DEFAULT_FONT);
        ButtonGroup group = new ButtonGroup();
        group.add(searchStatus);
        group.add(searchUsers);
        searchStatus.addItemListener(new RadioHandle());
        searchUsers.addItemListener(new RadioHandle());
        searchStatus.addMouseListener(new AutoFun.MouseHandle());
        searchUsers.addMouseListener(new AutoFun.MouseHandle());
        JPanel panel2 = new JPanel();
        panel2.add(searchStatus);
        panel2.add(searchUsers);
        panel.add("South", panel2);
        this.gbc.fill = 2;
        this.gbc.weightx = 100.0;
        this.add((Component)panel, this.gbc);
        ++this.gbc.gridy;
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchUserORStatus.this.addList();
            }
        });
        button.addMouseListener(new AutoFun.MouseHandle());
    }

    static class RadioHandle
    implements ItemListener {
        RadioHandle() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getSource() == searchStatus) {
                SELECTED = 1;
            } else if (e.getSource() == searchUsers) {
                SELECTED = 2;
            }
        }
    }
}

