/*
 * Decompiled with CFR 0.152.
 */
package com.Weibo;

import com.Weibo.Oauth2Code;
import com.Weibo.WeiboConstants;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import weibo4j.util.BareBonesBrowserLaunch;

public class ShowImage
extends JDialog {
    private static final long serialVersionUID = 8868861360956323777L;
    public static final String FILE = "File";
    public static final String URL_SITE = "Url";
    private int imgWidth;
    private int imgHeight;
    private String imgSite;
    private BufferedImage bi;
    private JLabel tip;
    private ShowImageThread showThread;
    private String type;

    public ShowImage(String imgSite, String type) {
        this.setLayout(null);
        this.setUndecorated(true);
        this.setSize(250, 150);
        this.setLocationRelativeTo(this.getOwner());
        this.imgSite = imgSite;
        this.type = type;
        this.tip = new JLabel("\u6b63\u5728\u8f7d\u5165\u56fe\u7247...\u9000\u51fa\u8bf7\u6309 Esc");
        this.tip.setFont(WeiboConstants.DEFAULT_FONT);
        this.tip.setBounds(35, 76, 180, 150);
        this.add(this.tip);
        this.setVisible(true);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    if (ShowImage.this.showThread != null && ShowImage.this.showThread.isAlive()) {
                        ShowImage.this.showThread.interrupt();
                    }
                    ShowImage.this.dispose();
                }
            }
        });
        DragPicListener listener = new DragPicListener(this);
        this.addMouseListener(listener);
        this.addMouseMotionListener(listener);
        this.showThread = new ShowImageThread();
        this.showThread.start();
    }

    private JPopupMenu createMenu() {
        final JFileChooser saveDialog = new JFileChooser();
        saveDialog.setDialogTitle("\u9009\u62e9\u5b58\u653e\u8def\u5f84");
        final String fileExtendsion = this.imgSite.substring(this.imgSite.lastIndexOf(".") + 1);
        FileNameExtensionFilter filter = new FileNameExtensionFilter("\u56fe\u7247\u6587\u4ef6(" + fileExtendsion + ")", fileExtendsion);
        saveDialog.setFileFilter(filter);
        File file = new File("\u5fae\u535a\u56fe\u7247." + fileExtendsion);
        saveDialog.setSelectedFile(file);
        JPopupMenu popupMenu = new JPopupMenu();
        popupMenu.setFont(new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 12));
        JMenuItem saveItem = new JMenuItem("\u4fdd\u5b58");
        saveItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int result = saveDialog.showSaveDialog(null);
                if (result == 0) {
                    try {
                        int yesNo;
                        if (saveDialog.getSelectedFile().exists() && (yesNo = JOptionPane.showConfirmDialog(Oauth2Code.getMainDialog(), "\u6b64\u4f4d\u7f6e\u5df2\u5305\u542b\u540c\u540d\u6587\u4ef6\uff01\u662f\u5426\u66ff\u6362\u6b64\u6587\u4ef6\uff1f", "\u9009\u62e9", 1)) != 0) {
                            return;
                        }
                        if (ImageIO.write((RenderedImage)ShowImage.this.bi, fileExtendsion, saveDialog.getSelectedFile())) {
                            JOptionPane.showMessageDialog(Oauth2Code.getMainDialog(), "\u6210\u529f\u4fdd\u5b58\u56fe\u7247");
                        } else {
                            JOptionPane.showMessageDialog(Oauth2Code.getMainDialog(), "\u4fdd\u5b58\u56fe\u7247\u5931\u8d25\uff01", "\u9519\u8bef\uff01", 0);
                        }
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        });
        JMenuItem originalItem = new JMenuItem("\u539f\u56fe");
        originalItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BareBonesBrowserLaunch.openURL(ShowImage.this.imgSite.replace("bmiddle", "large"));
                ShowImage.this.dispose();
            }
        });
        JMenuItem exitItem = new JMenuItem("\u5173\u95ed");
        exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowImage.this.dispose();
            }
        });
        popupMenu.add(saveItem);
        popupMenu.addSeparator();
        popupMenu.add(originalItem);
        popupMenu.addSeparator();
        popupMenu.add(exitItem);
        return popupMenu;
    }

    private class DragPicListener
    implements MouseInputListener {
        private JDialog dialog;
        Point point = new Point(0, 0);

        public DragPicListener(JDialog dialog) {
            this.dialog = dialog;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.point = SwingUtilities.convertPoint(this.dialog, e.getPoint(), this.dialog.getParent());
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            Point newPoint = SwingUtilities.convertPoint(this.dialog, e.getPoint(), ShowImage.this.getParent());
            ShowImage.this.setLocation(ShowImage.this.getX() + (newPoint.x - this.point.x), ShowImage.this.getY() + (newPoint.y - this.point.y));
            this.point = newPoint;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }
    }

    private class ShowImageThread
    extends Thread {
        private ShowImageThread() {
        }

        @Override
        public void run() {
            try {
                if (ShowImage.this.type.equals(ShowImage.URL_SITE)) {
                    ShowImage.this.bi = ImageIO.read(new URL(ShowImage.this.imgSite));
                } else if (ShowImage.this.type.equals(ShowImage.FILE)) {
                    ShowImage.this.bi = ImageIO.read(new File(ShowImage.this.imgSite));
                }
            }
            catch (IOException e) {
                ShowImage.this.tip.setText("\u8f7d\u5165\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
                e.printStackTrace();
            }
            if (ShowImage.this.bi == null) {
                ShowImage.this.tip.setText("\u8f7d\u5165\u5931\u8d25\uff01\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002");
                return;
            }
            ShowImage.this.imgHeight = ShowImage.this.bi.getHeight();
            ShowImage.this.imgWidth = ShowImage.this.bi.getWidth();
            JPanel imgPanel = new JPanel(){
                private static final long serialVersionUID = -8567736225217559745L;

                @Override
                public void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    Graphics2D g2d = (Graphics2D)g;
                    if (ShowImage.this.bi != null) {
                        g2d.drawImage((Image)ShowImage.this.bi, 0, 0, this);
                    }
                }
            };
            if (ShowImage.this.tip != null) {
                ShowImage.this.remove(ShowImage.this.tip);
            }
            imgPanel.setSize(ShowImage.this.imgWidth, ShowImage.this.imgHeight);
            ShowImage.this.setSize(ShowImage.this.imgWidth, ShowImage.this.imgHeight);
            Dimension dm = Toolkit.getDefaultToolkit().getScreenSize();
            if (ShowImage.this.imgHeight > dm.height) {
                ShowImage.this.setLocation((dm.width - ShowImage.this.imgWidth) / 2, 0);
            } else {
                ShowImage.this.setLocationRelativeTo(ShowImage.this.getOwner());
            }
            ShowImage.this.add(imgPanel);
            ShowImage.this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    this.triggerEvent(e);
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.triggerEvent(e);
                }

                private void triggerEvent(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        JPopupMenu popupMenu = ShowImage.this.createMenu();
                        popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            });
        }
    }
}

